# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbNodeSnapshotArgs', 'DbNodeSnapshot']

@pulumi.input_type
class DbNodeSnapshotArgs:
    def __init__(__self__, *,
                 dbnode_snapshot_id: pulumi.Input[_builtins.str],
                 mount_dbnode_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DbNodeSnapshot resource.
        :param pulumi.Input[_builtins.str] dbnode_snapshot_id: The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] mount_dbnode_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node to which the snapshot will be mounted. Set `mount_dbnode_id` to `"null"` (string, not `null`) to unmount the Db Node Snapshot.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dbnode_snapshot_id", dbnode_snapshot_id)
        pulumi.set(__self__, "mount_dbnode_id", mount_dbnode_id)

    @_builtins.property
    @pulumi.getter(name="dbnodeSnapshotId")
    def dbnode_snapshot_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "dbnode_snapshot_id")

    @dbnode_snapshot_id.setter
    def dbnode_snapshot_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dbnode_snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="mountDbnodeId")
    def mount_dbnode_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node to which the snapshot will be mounted. Set `mount_dbnode_id` to `"null"` (string, not `null`) to unmount the Db Node Snapshot.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "mount_dbnode_id")

    @mount_dbnode_id.setter
    def mount_dbnode_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mount_dbnode_id", value)


@pulumi.input_type
class _DbNodeSnapshotState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbnode_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_dbnode_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_points: Optional[pulumi.Input[Sequence[pulumi.Input['DbNodeSnapshotMountPointArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_dbnode_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['DbNodeSnapshotVolumeArgs']]]] = None):
        """
        Input properties used for looking up and filtering DbNodeSnapshot resources.
        :param pulumi.Input[_builtins.str] cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] dbnode_snapshot_id: The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the Exadata Database Node Snapshot.
        :param pulumi.Input[_builtins.str] mount_dbnode_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node to which the snapshot will be mounted. Set `mount_dbnode_id` to `"null"` (string, not `null`) to unmount the Db Node Snapshot.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['DbNodeSnapshotMountPointArgs']]] mount_points: Details of the mount points
        :param pulumi.Input[_builtins.str] name: Volume Name
        :param pulumi.Input[_builtins.str] source_dbnode_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node.
        :param pulumi.Input[_builtins.str] state: The current state of the Exadata Database Node Snapshot.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] time_created: The date and time that the Exadata Database Node Snapshot was created.
        :param pulumi.Input[Sequence[pulumi.Input['DbNodeSnapshotVolumeArgs']]] volumes: Details of the volumes
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if dbnode_snapshot_id is not None:
            pulumi.set(__self__, "dbnode_snapshot_id", dbnode_snapshot_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if mount_dbnode_id is not None:
            pulumi.set(__self__, "mount_dbnode_id", mount_dbnode_id)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_dbnode_id is not None:
            pulumi.set(__self__, "source_dbnode_id", source_dbnode_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbnodeSnapshotId")
    def dbnode_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "dbnode_snapshot_id")

    @dbnode_snapshot_id.setter
    def dbnode_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbnode_snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state of the Exadata Database Node Snapshot.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="mountDbnodeId")
    def mount_dbnode_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node to which the snapshot will be mounted. Set `mount_dbnode_id` to `"null"` (string, not `null`) to unmount the Db Node Snapshot.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "mount_dbnode_id")

    @mount_dbnode_id.setter
    def mount_dbnode_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_dbnode_id", value)

    @_builtins.property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbNodeSnapshotMountPointArgs']]]]:
        """
        Details of the mount points
        """
        return pulumi.get(self, "mount_points")

    @mount_points.setter
    def mount_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbNodeSnapshotMountPointArgs']]]]):
        pulumi.set(self, "mount_points", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sourceDbnodeId")
    def source_dbnode_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node.
        """
        return pulumi.get(self, "source_dbnode_id")

    @source_dbnode_id.setter
    def source_dbnode_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_dbnode_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Exadata Database Node Snapshot.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the Exadata Database Node Snapshot was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbNodeSnapshotVolumeArgs']]]]:
        """
        Details of the volumes
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbNodeSnapshotVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.type_token("oci:Database/dbNodeSnapshot:DbNodeSnapshot")
class DbNodeSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dbnode_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_dbnode_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Db Node Snapshot resource in Oracle Cloud Infrastructure Database service.

        Manage the specified Db Node Snapshot in the Exadb VM cluster.

        ## Example Usage

        Unmount the specified Db Node Snapshot
        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_node_snapshot = oci.database.DbNodeSnapshot("test_db_node_snapshot",
            dbnode_snapshot_id=test_db_node_snapshot_management["snapshots"][0]["id"],
            mount_dbnode_id="null")
        ```

        Mount the specified Db Node Snapshot to the specified Db Node
        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_node_snapshot = oci.database.DbNodeSnapshot("test_db_node_snapshot",
            dbnode_snapshot_id=test_db_node_snapshot_management["snapshots"][0]["id"],
            mount_dbnode_id=test_db_node_snapshot_management["snapshots"][0]["sourceDbnodeId"])
        ```

        ## Import

        DbNodeSnapshots can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbNodeSnapshot:DbNodeSnapshot test_db_node_snapshot "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dbnode_snapshot_id: The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] mount_dbnode_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node to which the snapshot will be mounted. Set `mount_dbnode_id` to `"null"` (string, not `null`) to unmount the Db Node Snapshot.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbNodeSnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db Node Snapshot resource in Oracle Cloud Infrastructure Database service.

        Manage the specified Db Node Snapshot in the Exadb VM cluster.

        ## Example Usage

        Unmount the specified Db Node Snapshot
        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_node_snapshot = oci.database.DbNodeSnapshot("test_db_node_snapshot",
            dbnode_snapshot_id=test_db_node_snapshot_management["snapshots"][0]["id"],
            mount_dbnode_id="null")
        ```

        Mount the specified Db Node Snapshot to the specified Db Node
        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_node_snapshot = oci.database.DbNodeSnapshot("test_db_node_snapshot",
            dbnode_snapshot_id=test_db_node_snapshot_management["snapshots"][0]["id"],
            mount_dbnode_id=test_db_node_snapshot_management["snapshots"][0]["sourceDbnodeId"])
        ```

        ## Import

        DbNodeSnapshots can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbNodeSnapshot:DbNodeSnapshot test_db_node_snapshot "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbNodeSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbNodeSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dbnode_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_dbnode_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbNodeSnapshotArgs.__new__(DbNodeSnapshotArgs)

            if dbnode_snapshot_id is None and not opts.urn:
                raise TypeError("Missing required property 'dbnode_snapshot_id'")
            __props__.__dict__["dbnode_snapshot_id"] = dbnode_snapshot_id
            if mount_dbnode_id is None and not opts.urn:
                raise TypeError("Missing required property 'mount_dbnode_id'")
            __props__.__dict__["mount_dbnode_id"] = mount_dbnode_id
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["mount_points"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["source_dbnode_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["volumes"] = None
        super(DbNodeSnapshot, __self__).__init__(
            'oci:Database/dbNodeSnapshot:DbNodeSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            dbnode_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            mount_dbnode_id: Optional[pulumi.Input[_builtins.str]] = None,
            mount_points: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbNodeSnapshotMountPointArgs', 'DbNodeSnapshotMountPointArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            source_dbnode_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbNodeSnapshotVolumeArgs', 'DbNodeSnapshotVolumeArgsDict']]]]] = None) -> 'DbNodeSnapshot':
        """
        Get an existing DbNodeSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] dbnode_snapshot_id: The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the Exadata Database Node Snapshot.
        :param pulumi.Input[_builtins.str] mount_dbnode_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node to which the snapshot will be mounted. Set `mount_dbnode_id` to `"null"` (string, not `null`) to unmount the Db Node Snapshot.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbNodeSnapshotMountPointArgs', 'DbNodeSnapshotMountPointArgsDict']]]] mount_points: Details of the mount points
        :param pulumi.Input[_builtins.str] name: Volume Name
        :param pulumi.Input[_builtins.str] source_dbnode_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node.
        :param pulumi.Input[_builtins.str] state: The current state of the Exadata Database Node Snapshot.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] time_created: The date and time that the Exadata Database Node Snapshot was created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbNodeSnapshotVolumeArgs', 'DbNodeSnapshotVolumeArgsDict']]]] volumes: Details of the volumes
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbNodeSnapshotState.__new__(_DbNodeSnapshotState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["dbnode_snapshot_id"] = dbnode_snapshot_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["mount_dbnode_id"] = mount_dbnode_id
        __props__.__dict__["mount_points"] = mount_points
        __props__.__dict__["name"] = name
        __props__.__dict__["source_dbnode_id"] = source_dbnode_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["volumes"] = volumes
        return DbNodeSnapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbnodeSnapshotId")
    def dbnode_snapshot_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "dbnode_snapshot_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state of the Exadata Database Node Snapshot.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="mountDbnodeId")
    def mount_dbnode_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node to which the snapshot will be mounted. Set `mount_dbnode_id` to `"null"` (string, not `null`) to unmount the Db Node Snapshot.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "mount_dbnode_id")

    @_builtins.property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> pulumi.Output[Sequence['outputs.DbNodeSnapshotMountPoint']]:
        """
        Details of the mount points
        """
        return pulumi.get(self, "mount_points")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Volume Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceDbnodeId")
    def source_dbnode_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node.
        """
        return pulumi.get(self, "source_dbnode_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Exadata Database Node Snapshot.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the Exadata Database Node Snapshot was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence['outputs.DbNodeSnapshotVolume']]:
        """
        Details of the volumes
        """
        return pulumi.get(self, "volumes")

