# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExternalNonContainerDatabaseManagementArgs', 'ExternalNonContainerDatabaseManagement']

@pulumi.input_type
class ExternalNonContainerDatabaseManagementArgs:
    def __init__(__self__, *,
                 enable_management: pulumi.Input[_builtins.bool],
                 external_database_connector_id: pulumi.Input[_builtins.str],
                 external_non_container_database_id: pulumi.Input[_builtins.str],
                 license_model: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExternalNonContainerDatabaseManagement resource.
        :param pulumi.Input[_builtins.str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[_builtins.str] external_non_container_database_id: The external non-container database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the external database. Required only for enabling database management.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "enable_management", enable_management)
        pulumi.set(__self__, "external_database_connector_id", external_database_connector_id)
        pulumi.set(__self__, "external_non_container_database_id", external_non_container_database_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)

    @_builtins.property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> pulumi.Input[_builtins.bool]:
        return pulumi.get(self, "enable_management")

    @enable_management.setter
    def enable_management(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_management", value)

    @_builtins.property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @external_database_connector_id.setter
    def external_database_connector_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_database_connector_id", value)

    @_builtins.property
    @pulumi.getter(name="externalNonContainerDatabaseId")
    def external_non_container_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The external non-container database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_non_container_database_id")

    @external_non_container_database_id.setter
    def external_non_container_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_non_container_database_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle license model that applies to the external database. Required only for enabling database management.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)


@pulumi.input_type
class _ExternalNonContainerDatabaseManagementState:
    def __init__(__self__, *,
                 enable_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_database_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_non_container_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalNonContainerDatabaseManagement resources.
        :param pulumi.Input[_builtins.str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[_builtins.str] external_non_container_database_id: The external non-container database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the external database. Required only for enabling database management.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if enable_management is not None:
            pulumi.set(__self__, "enable_management", enable_management)
        if external_database_connector_id is not None:
            pulumi.set(__self__, "external_database_connector_id", external_database_connector_id)
        if external_non_container_database_id is not None:
            pulumi.set(__self__, "external_non_container_database_id", external_non_container_database_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)

    @_builtins.property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_management")

    @enable_management.setter
    def enable_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_management", value)

    @_builtins.property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @external_database_connector_id.setter
    def external_database_connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_database_connector_id", value)

    @_builtins.property
    @pulumi.getter(name="externalNonContainerDatabaseId")
    def external_non_container_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external non-container database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_non_container_database_id")

    @external_non_container_database_id.setter
    def external_non_container_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_non_container_database_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle license model that applies to the external database. Required only for enabling database management.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)


@pulumi.type_token("oci:Database/externalNonContainerDatabaseManagement:ExternalNonContainerDatabaseManagement")
class ExternalNonContainerDatabaseManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_database_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_non_container_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_non_container_database_management = oci.database.ExternalNonContainerDatabaseManagement("test_external_non_container_database_management",
            external_database_connector_id=test_external_database_connector["id"],
            external_non_container_database_id=test_external_non_container_database["id"],
            license_mode=external_non_container_database_management_license_model)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[_builtins.str] external_non_container_database_id: The external non-container database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the external database. Required only for enabling database management.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalNonContainerDatabaseManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_non_container_database_management = oci.database.ExternalNonContainerDatabaseManagement("test_external_non_container_database_management",
            external_database_connector_id=test_external_database_connector["id"],
            external_non_container_database_id=test_external_non_container_database["id"],
            license_mode=external_non_container_database_management_license_model)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ExternalNonContainerDatabaseManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalNonContainerDatabaseManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_database_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_non_container_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalNonContainerDatabaseManagementArgs.__new__(ExternalNonContainerDatabaseManagementArgs)

            if enable_management is None and not opts.urn:
                raise TypeError("Missing required property 'enable_management'")
            __props__.__dict__["enable_management"] = enable_management
            if external_database_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_database_connector_id'")
            __props__.__dict__["external_database_connector_id"] = external_database_connector_id
            if external_non_container_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_non_container_database_id'")
            __props__.__dict__["external_non_container_database_id"] = external_non_container_database_id
            __props__.__dict__["license_model"] = license_model
        super(ExternalNonContainerDatabaseManagement, __self__).__init__(
            'oci:Database/externalNonContainerDatabaseManagement:ExternalNonContainerDatabaseManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_management: Optional[pulumi.Input[_builtins.bool]] = None,
            external_database_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_non_container_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            license_model: Optional[pulumi.Input[_builtins.str]] = None) -> 'ExternalNonContainerDatabaseManagement':
        """
        Get an existing ExternalNonContainerDatabaseManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[_builtins.str] external_non_container_database_id: The external non-container database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the external database. Required only for enabling database management.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalNonContainerDatabaseManagementState.__new__(_ExternalNonContainerDatabaseManagementState)

        __props__.__dict__["enable_management"] = enable_management
        __props__.__dict__["external_database_connector_id"] = external_database_connector_id
        __props__.__dict__["external_non_container_database_id"] = external_non_container_database_id
        __props__.__dict__["license_model"] = license_model
        return ExternalNonContainerDatabaseManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "enable_management")

    @_builtins.property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @_builtins.property
    @pulumi.getter(name="externalNonContainerDatabaseId")
    def external_non_container_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The external non-container database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_non_container_database_id")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle license model that applies to the external database. Required only for enabling database management.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_model")

