# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutonomousContainerDatabaseResult',
    'AwaitableGetAutonomousContainerDatabaseResult',
    'get_autonomous_container_database',
    'get_autonomous_container_database_output',
]

@pulumi.output_type
class GetAutonomousContainerDatabaseResult:
    """
    A collection of values returned by getAutonomousContainerDatabase.
    """
    def __init__(__self__, associated_backup_configuration_details=None, autonomous_container_database_backup_id=None, autonomous_container_database_id=None, autonomous_exadata_infrastructure_id=None, autonomous_vm_cluster_id=None, availability_domain=None, available_cpus=None, backup_configs=None, backup_destination_properties_lists=None, cloud_autonomous_vm_cluster_id=None, compartment_id=None, compute_model=None, customer_contacts=None, database_software_image_id=None, dataguard_group_members=None, dataguards=None, db_name=None, db_split_threshold=None, db_unique_name=None, db_version=None, defined_tags=None, display_name=None, distribution_affinity=None, dst_file_version=None, failover_trigger=None, fast_start_fail_over_lag_limit_in_seconds=None, freeform_tags=None, id=None, infrastructure_type=None, is_automatic_failover_enabled=None, is_data_guard_enabled=None, is_dst_file_update_enabled=None, is_multiple_standby=None, key_history_entries=None, key_store_id=None, key_store_wallet_name=None, key_version_id=None, kms_key_id=None, kms_key_version_id=None, largest_provisionable_autonomous_database_in_cpus=None, last_maintenance_run_id=None, lifecycle_details=None, list_one_off_patches=None, maintenance_window_details=None, maintenance_windows=None, memory_per_compute_unit_in_gbs=None, memory_per_oracle_compute_unit_in_gbs=None, net_services_architecture=None, next_maintenance_run_id=None, okv_end_point_group_name=None, patch_id=None, patch_model=None, peer_autonomous_container_database_backup_configs=None, peer_autonomous_container_database_compartment_id=None, peer_autonomous_container_database_display_name=None, peer_autonomous_exadata_infrastructure_id=None, peer_autonomous_vm_cluster_id=None, peer_cloud_autonomous_vm_cluster_id=None, peer_db_unique_name=None, protection_mode=None, provisionable_cpuses=None, provisioned_cpus=None, reclaimable_cpus=None, recovery_appliance_details=None, reinstate_trigger=None, reserved_cpus=None, role=None, rotate_key_trigger=None, service_level_agreement_type=None, source=None, standby_maintenance_buffer_in_days=None, state=None, switchover_trigger=None, system_tags=None, time_created=None, time_of_last_backup=None, time_snapshot_standby_revert=None, total_cpus=None, vault_id=None, version_preference=None, vm_failover_reservation=None):
        if associated_backup_configuration_details and not isinstance(associated_backup_configuration_details, list):
            raise TypeError("Expected argument 'associated_backup_configuration_details' to be a list")
        pulumi.set(__self__, "associated_backup_configuration_details", associated_backup_configuration_details)
        if autonomous_container_database_backup_id and not isinstance(autonomous_container_database_backup_id, str):
            raise TypeError("Expected argument 'autonomous_container_database_backup_id' to be a str")
        pulumi.set(__self__, "autonomous_container_database_backup_id", autonomous_container_database_backup_id)
        if autonomous_container_database_id and not isinstance(autonomous_container_database_id, str):
            raise TypeError("Expected argument 'autonomous_container_database_id' to be a str")
        pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if autonomous_exadata_infrastructure_id and not isinstance(autonomous_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'autonomous_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "autonomous_exadata_infrastructure_id", autonomous_exadata_infrastructure_id)
        if autonomous_vm_cluster_id and not isinstance(autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "autonomous_vm_cluster_id", autonomous_vm_cluster_id)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if available_cpus and not isinstance(available_cpus, float):
            raise TypeError("Expected argument 'available_cpus' to be a float")
        pulumi.set(__self__, "available_cpus", available_cpus)
        if backup_configs and not isinstance(backup_configs, list):
            raise TypeError("Expected argument 'backup_configs' to be a list")
        pulumi.set(__self__, "backup_configs", backup_configs)
        if backup_destination_properties_lists and not isinstance(backup_destination_properties_lists, list):
            raise TypeError("Expected argument 'backup_destination_properties_lists' to be a list")
        pulumi.set(__self__, "backup_destination_properties_lists", backup_destination_properties_lists)
        if cloud_autonomous_vm_cluster_id and not isinstance(cloud_autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_model and not isinstance(compute_model, str):
            raise TypeError("Expected argument 'compute_model' to be a str")
        pulumi.set(__self__, "compute_model", compute_model)
        if customer_contacts and not isinstance(customer_contacts, list):
            raise TypeError("Expected argument 'customer_contacts' to be a list")
        pulumi.set(__self__, "customer_contacts", customer_contacts)
        if database_software_image_id and not isinstance(database_software_image_id, str):
            raise TypeError("Expected argument 'database_software_image_id' to be a str")
        pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if dataguard_group_members and not isinstance(dataguard_group_members, list):
            raise TypeError("Expected argument 'dataguard_group_members' to be a list")
        pulumi.set(__self__, "dataguard_group_members", dataguard_group_members)
        if dataguards and not isinstance(dataguards, list):
            raise TypeError("Expected argument 'dataguards' to be a list")
        pulumi.set(__self__, "dataguards", dataguards)
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if db_split_threshold and not isinstance(db_split_threshold, int):
            raise TypeError("Expected argument 'db_split_threshold' to be a int")
        pulumi.set(__self__, "db_split_threshold", db_split_threshold)
        if db_unique_name and not isinstance(db_unique_name, str):
            raise TypeError("Expected argument 'db_unique_name' to be a str")
        pulumi.set(__self__, "db_unique_name", db_unique_name)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if distribution_affinity and not isinstance(distribution_affinity, str):
            raise TypeError("Expected argument 'distribution_affinity' to be a str")
        pulumi.set(__self__, "distribution_affinity", distribution_affinity)
        if dst_file_version and not isinstance(dst_file_version, str):
            raise TypeError("Expected argument 'dst_file_version' to be a str")
        pulumi.set(__self__, "dst_file_version", dst_file_version)
        if failover_trigger and not isinstance(failover_trigger, int):
            raise TypeError("Expected argument 'failover_trigger' to be a int")
        pulumi.set(__self__, "failover_trigger", failover_trigger)
        if fast_start_fail_over_lag_limit_in_seconds and not isinstance(fast_start_fail_over_lag_limit_in_seconds, int):
            raise TypeError("Expected argument 'fast_start_fail_over_lag_limit_in_seconds' to be a int")
        pulumi.set(__self__, "fast_start_fail_over_lag_limit_in_seconds", fast_start_fail_over_lag_limit_in_seconds)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure_type and not isinstance(infrastructure_type, str):
            raise TypeError("Expected argument 'infrastructure_type' to be a str")
        pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        if is_automatic_failover_enabled and not isinstance(is_automatic_failover_enabled, bool):
            raise TypeError("Expected argument 'is_automatic_failover_enabled' to be a bool")
        pulumi.set(__self__, "is_automatic_failover_enabled", is_automatic_failover_enabled)
        if is_data_guard_enabled and not isinstance(is_data_guard_enabled, bool):
            raise TypeError("Expected argument 'is_data_guard_enabled' to be a bool")
        pulumi.set(__self__, "is_data_guard_enabled", is_data_guard_enabled)
        if is_dst_file_update_enabled and not isinstance(is_dst_file_update_enabled, bool):
            raise TypeError("Expected argument 'is_dst_file_update_enabled' to be a bool")
        pulumi.set(__self__, "is_dst_file_update_enabled", is_dst_file_update_enabled)
        if is_multiple_standby and not isinstance(is_multiple_standby, bool):
            raise TypeError("Expected argument 'is_multiple_standby' to be a bool")
        pulumi.set(__self__, "is_multiple_standby", is_multiple_standby)
        if key_history_entries and not isinstance(key_history_entries, list):
            raise TypeError("Expected argument 'key_history_entries' to be a list")
        pulumi.set(__self__, "key_history_entries", key_history_entries)
        if key_store_id and not isinstance(key_store_id, str):
            raise TypeError("Expected argument 'key_store_id' to be a str")
        pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name and not isinstance(key_store_wallet_name, str):
            raise TypeError("Expected argument 'key_store_wallet_name' to be a str")
        pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if key_version_id and not isinstance(key_version_id, str):
            raise TypeError("Expected argument 'key_version_id' to be a str")
        pulumi.set(__self__, "key_version_id", key_version_id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id and not isinstance(kms_key_version_id, str):
            raise TypeError("Expected argument 'kms_key_version_id' to be a str")
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if largest_provisionable_autonomous_database_in_cpus and not isinstance(largest_provisionable_autonomous_database_in_cpus, float):
            raise TypeError("Expected argument 'largest_provisionable_autonomous_database_in_cpus' to be a float")
        pulumi.set(__self__, "largest_provisionable_autonomous_database_in_cpus", largest_provisionable_autonomous_database_in_cpus)
        if last_maintenance_run_id and not isinstance(last_maintenance_run_id, str):
            raise TypeError("Expected argument 'last_maintenance_run_id' to be a str")
        pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if list_one_off_patches and not isinstance(list_one_off_patches, list):
            raise TypeError("Expected argument 'list_one_off_patches' to be a list")
        pulumi.set(__self__, "list_one_off_patches", list_one_off_patches)
        if maintenance_window_details and not isinstance(maintenance_window_details, list):
            raise TypeError("Expected argument 'maintenance_window_details' to be a list")
        pulumi.set(__self__, "maintenance_window_details", maintenance_window_details)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if memory_per_compute_unit_in_gbs and not isinstance(memory_per_compute_unit_in_gbs, float):
            raise TypeError("Expected argument 'memory_per_compute_unit_in_gbs' to be a float")
        pulumi.set(__self__, "memory_per_compute_unit_in_gbs", memory_per_compute_unit_in_gbs)
        if memory_per_oracle_compute_unit_in_gbs and not isinstance(memory_per_oracle_compute_unit_in_gbs, int):
            raise TypeError("Expected argument 'memory_per_oracle_compute_unit_in_gbs' to be a int")
        pulumi.set(__self__, "memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if net_services_architecture and not isinstance(net_services_architecture, str):
            raise TypeError("Expected argument 'net_services_architecture' to be a str")
        pulumi.set(__self__, "net_services_architecture", net_services_architecture)
        if next_maintenance_run_id and not isinstance(next_maintenance_run_id, str):
            raise TypeError("Expected argument 'next_maintenance_run_id' to be a str")
        pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if okv_end_point_group_name and not isinstance(okv_end_point_group_name, str):
            raise TypeError("Expected argument 'okv_end_point_group_name' to be a str")
        pulumi.set(__self__, "okv_end_point_group_name", okv_end_point_group_name)
        if patch_id and not isinstance(patch_id, str):
            raise TypeError("Expected argument 'patch_id' to be a str")
        pulumi.set(__self__, "patch_id", patch_id)
        if patch_model and not isinstance(patch_model, str):
            raise TypeError("Expected argument 'patch_model' to be a str")
        pulumi.set(__self__, "patch_model", patch_model)
        if peer_autonomous_container_database_backup_configs and not isinstance(peer_autonomous_container_database_backup_configs, list):
            raise TypeError("Expected argument 'peer_autonomous_container_database_backup_configs' to be a list")
        pulumi.set(__self__, "peer_autonomous_container_database_backup_configs", peer_autonomous_container_database_backup_configs)
        if peer_autonomous_container_database_compartment_id and not isinstance(peer_autonomous_container_database_compartment_id, str):
            raise TypeError("Expected argument 'peer_autonomous_container_database_compartment_id' to be a str")
        pulumi.set(__self__, "peer_autonomous_container_database_compartment_id", peer_autonomous_container_database_compartment_id)
        if peer_autonomous_container_database_display_name and not isinstance(peer_autonomous_container_database_display_name, str):
            raise TypeError("Expected argument 'peer_autonomous_container_database_display_name' to be a str")
        pulumi.set(__self__, "peer_autonomous_container_database_display_name", peer_autonomous_container_database_display_name)
        if peer_autonomous_exadata_infrastructure_id and not isinstance(peer_autonomous_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'peer_autonomous_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "peer_autonomous_exadata_infrastructure_id", peer_autonomous_exadata_infrastructure_id)
        if peer_autonomous_vm_cluster_id and not isinstance(peer_autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'peer_autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "peer_autonomous_vm_cluster_id", peer_autonomous_vm_cluster_id)
        if peer_cloud_autonomous_vm_cluster_id and not isinstance(peer_cloud_autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'peer_cloud_autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if peer_db_unique_name and not isinstance(peer_db_unique_name, str):
            raise TypeError("Expected argument 'peer_db_unique_name' to be a str")
        pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if protection_mode and not isinstance(protection_mode, str):
            raise TypeError("Expected argument 'protection_mode' to be a str")
        pulumi.set(__self__, "protection_mode", protection_mode)
        if provisionable_cpuses and not isinstance(provisionable_cpuses, list):
            raise TypeError("Expected argument 'provisionable_cpuses' to be a list")
        pulumi.set(__self__, "provisionable_cpuses", provisionable_cpuses)
        if provisioned_cpus and not isinstance(provisioned_cpus, float):
            raise TypeError("Expected argument 'provisioned_cpus' to be a float")
        pulumi.set(__self__, "provisioned_cpus", provisioned_cpus)
        if reclaimable_cpus and not isinstance(reclaimable_cpus, float):
            raise TypeError("Expected argument 'reclaimable_cpus' to be a float")
        pulumi.set(__self__, "reclaimable_cpus", reclaimable_cpus)
        if recovery_appliance_details and not isinstance(recovery_appliance_details, list):
            raise TypeError("Expected argument 'recovery_appliance_details' to be a list")
        pulumi.set(__self__, "recovery_appliance_details", recovery_appliance_details)
        if reinstate_trigger and not isinstance(reinstate_trigger, int):
            raise TypeError("Expected argument 'reinstate_trigger' to be a int")
        pulumi.set(__self__, "reinstate_trigger", reinstate_trigger)
        if reserved_cpus and not isinstance(reserved_cpus, float):
            raise TypeError("Expected argument 'reserved_cpus' to be a float")
        pulumi.set(__self__, "reserved_cpus", reserved_cpus)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if rotate_key_trigger and not isinstance(rotate_key_trigger, bool):
            raise TypeError("Expected argument 'rotate_key_trigger' to be a bool")
        pulumi.set(__self__, "rotate_key_trigger", rotate_key_trigger)
        if service_level_agreement_type and not isinstance(service_level_agreement_type, str):
            raise TypeError("Expected argument 'service_level_agreement_type' to be a str")
        pulumi.set(__self__, "service_level_agreement_type", service_level_agreement_type)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if standby_maintenance_buffer_in_days and not isinstance(standby_maintenance_buffer_in_days, int):
            raise TypeError("Expected argument 'standby_maintenance_buffer_in_days' to be a int")
        pulumi.set(__self__, "standby_maintenance_buffer_in_days", standby_maintenance_buffer_in_days)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if switchover_trigger and not isinstance(switchover_trigger, int):
            raise TypeError("Expected argument 'switchover_trigger' to be a int")
        pulumi.set(__self__, "switchover_trigger", switchover_trigger)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_last_backup and not isinstance(time_of_last_backup, str):
            raise TypeError("Expected argument 'time_of_last_backup' to be a str")
        pulumi.set(__self__, "time_of_last_backup", time_of_last_backup)
        if time_snapshot_standby_revert and not isinstance(time_snapshot_standby_revert, str):
            raise TypeError("Expected argument 'time_snapshot_standby_revert' to be a str")
        pulumi.set(__self__, "time_snapshot_standby_revert", time_snapshot_standby_revert)
        if total_cpus and not isinstance(total_cpus, int):
            raise TypeError("Expected argument 'total_cpus' to be a int")
        pulumi.set(__self__, "total_cpus", total_cpus)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)
        if version_preference and not isinstance(version_preference, str):
            raise TypeError("Expected argument 'version_preference' to be a str")
        pulumi.set(__self__, "version_preference", version_preference)
        if vm_failover_reservation and not isinstance(vm_failover_reservation, int):
            raise TypeError("Expected argument 'vm_failover_reservation' to be a int")
        pulumi.set(__self__, "vm_failover_reservation", vm_failover_reservation)

    @_builtins.property
    @pulumi.getter(name="associatedBackupConfigurationDetails")
    def associated_backup_configuration_details(self) -> Sequence['outputs.GetAutonomousContainerDatabaseAssociatedBackupConfigurationDetailResult']:
        """
        A backup config object holds information about preferred backup destinations only. This object holds information about the associated backup destinations, such as secondary backup destinations created for local backups or remote replicated backups.
        """
        return pulumi.get(self, "associated_backup_configuration_details")

    @_builtins.property
    @pulumi.getter(name="autonomousContainerDatabaseBackupId")
    def autonomous_container_database_backup_id(self) -> _builtins.str:
        return pulumi.get(self, "autonomous_container_database_backup_id")

    @_builtins.property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Container Database that has a relationship with the peer Autonomous Container Database. Used only by Autonomous AI Database on Dedicated Exadata Infrastructure.
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @_builtins.property
    @pulumi.getter(name="autonomousExadataInfrastructureId")
    def autonomous_exadata_infrastructure_id(self) -> _builtins.str:
        """
        **No longer used.** For Autonomous AI Database on dedicated Exadata infrastructure, the container database is created within a specified `cloudAutonomousVmCluster`.
        """
        return pulumi.get(self, "autonomous_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> _builtins.str:
        """
        The OCID of the Autonomous VM Cluster.
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The domain of the Autonomous Container Database
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> _builtins.float:
        """
        Sum of CPUs available on the Autonomous VM Cluster + Sum of reclaimable CPUs available in the Autonomous Container Database.
        """
        return pulumi.get(self, "available_cpus")

    @_builtins.property
    @pulumi.getter(name="backupConfigs")
    def backup_configs(self) -> Sequence['outputs.GetAutonomousContainerDatabaseBackupConfigResult']:
        """
        Backup options for the Autonomous Container Database.
        """
        return pulumi.get(self, "backup_configs")

    @_builtins.property
    @pulumi.getter(name="backupDestinationPropertiesLists")
    def backup_destination_properties_lists(self) -> Sequence['outputs.GetAutonomousContainerDatabaseBackupDestinationPropertiesListResult']:
        """
        This list describes the backup destination properties associated with the Autonomous Container Database (ACD) 's preferred backup destination. The object at a given index is associated with the destination present at the same index in the backup destination details list of the ACD Backup Configuration.
        """
        return pulumi.get(self, "backup_destination_properties_lists")

    @_builtins.property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> _builtins.str:
        """
        The compute model of the Autonomous Container Database. For Autonomous AI Database on Dedicated Exadata Infrastructure, the CPU type (ECPUs or OCPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model. ECPU compute model is the recommended model and OCPU compute model is legacy. See [Compute Models in Autonomous AI Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Sequence['outputs.GetAutonomousContainerDatabaseCustomerContactResult']:
        """
        Customer Contacts. Setting this to an empty list removes all customer contacts.
        """
        return pulumi.get(self, "customer_contacts")

    @_builtins.property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> _builtins.str:
        return pulumi.get(self, "database_software_image_id")

    @_builtins.property
    @pulumi.getter(name="dataguardGroupMembers")
    def dataguard_group_members(self) -> Sequence['outputs.GetAutonomousContainerDatabaseDataguardGroupMemberResult']:
        """
        Array of Dg associations.
        """
        return pulumi.get(self, "dataguard_group_members")

    @_builtins.property
    @pulumi.getter
    def dataguards(self) -> Sequence['outputs.GetAutonomousContainerDatabaseDataguardResult']:
        """
        The properties that define Autonomous Container Databases Dataguard.
        """
        return pulumi.get(self, "dataguards")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> _builtins.str:
        """
        The Database name for the Autonomous Container Database. The name must be unique within the Cloud Autonomous VM Cluster, starting with an alphabetic character, followed by 1 to 7 alphanumeric characters.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="dbSplitThreshold")
    def db_split_threshold(self) -> _builtins.int:
        """
        The CPU value beyond which an Autonomous AI Database will be opened across multiple nodes. The default value of this attribute is 16 for OCPUs and 64 for ECPUs.
        """
        return pulumi.get(self, "db_split_threshold")

    @_builtins.property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> _builtins.str:
        return pulumi.get(self, "db_unique_name")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> _builtins.str:
        """
        Oracle AI Database version of the Autonomous Container Database.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-provided name for the Autonomous Container Database.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="distributionAffinity")
    def distribution_affinity(self) -> _builtins.str:
        """
        Determines whether an Autonomous AI Database must be opened across the maximum number of nodes or the least number of nodes. By default, Minimum nodes is selected.
        """
        return pulumi.get(self, "distribution_affinity")

    @_builtins.property
    @pulumi.getter(name="dstFileVersion")
    def dst_file_version(self) -> _builtins.str:
        """
        DST Time-Zone File version of the Autonomous Container Database.
        """
        return pulumi.get(self, "dst_file_version")

    @_builtins.property
    @pulumi.getter(name="failoverTrigger")
    def failover_trigger(self) -> _builtins.int:
        return pulumi.get(self, "failover_trigger")

    @_builtins.property
    @pulumi.getter(name="fastStartFailOverLagLimitInSeconds")
    def fast_start_fail_over_lag_limit_in_seconds(self) -> _builtins.int:
        """
        The lag time for my preference based on data loss tolerance in seconds.
        """
        return pulumi.get(self, "fast_start_fail_over_lag_limit_in_seconds")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Autonomous AI Database [Vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts) service key management history entry.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> _builtins.str:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @_builtins.property
    @pulumi.getter(name="isAutomaticFailoverEnabled")
    def is_automatic_failover_enabled(self) -> _builtins.bool:
        """
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association
        """
        return pulumi.get(self, "is_automatic_failover_enabled")

    @_builtins.property
    @pulumi.getter(name="isDataGuardEnabled")
    def is_data_guard_enabled(self) -> _builtins.bool:
        """
        **Deprecated.** Indicates whether the Autonomous AI Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous AI Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_data_guard_enabled")

    @_builtins.property
    @pulumi.getter(name="isDstFileUpdateEnabled")
    def is_dst_file_update_enabled(self) -> _builtins.bool:
        """
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        """
        return pulumi.get(self, "is_dst_file_update_enabled")

    @_builtins.property
    @pulumi.getter(name="isMultipleStandby")
    def is_multiple_standby(self) -> _builtins.bool:
        """
        Indicates if it is multiple standby Autonomous Dataguard
        """
        return pulumi.get(self, "is_multiple_standby")

    @_builtins.property
    @pulumi.getter(name="keyHistoryEntries")
    def key_history_entries(self) -> Sequence['outputs.GetAutonomousContainerDatabaseKeyHistoryEntryResult']:
        """
        Key History Entry.
        """
        return pulumi.get(self, "key_history_entries")

    @_builtins.property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @_builtins.property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> _builtins.str:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @_builtins.property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> _builtins.str:
        return pulumi.get(self, "key_version_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> _builtins.str:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous AI Database Serverless does not use key versions, hence is not applicable for Autonomous AI Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @_builtins.property
    @pulumi.getter(name="largestProvisionableAutonomousDatabaseInCpus")
    def largest_provisionable_autonomous_database_in_cpus(self) -> _builtins.float:
        """
        The largest Autonomous AI Database (CPU) that can be created in a new Autonomous Container Database.
        """
        return pulumi.get(self, "largest_provisionable_autonomous_database_in_cpus")

    @_builtins.property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="listOneOffPatches")
    def list_one_off_patches(self) -> Sequence[_builtins.str]:
        """
        List of One-Off patches that has been successfully applied to Autonomous Container Database
        """
        return pulumi.get(self, "list_one_off_patches")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Sequence['outputs.GetAutonomousContainerDatabaseMaintenanceWindowDetailResult']:
        return pulumi.get(self, "maintenance_window_details")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetAutonomousContainerDatabaseMaintenanceWindowResult']:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter(name="memoryPerComputeUnitInGbs")
    def memory_per_compute_unit_in_gbs(self) -> _builtins.float:
        """
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        """
        return pulumi.get(self, "memory_per_compute_unit_in_gbs")

    @_builtins.property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> _builtins.int:
        """
        The amount of memory (in GBs, rounded off to nearest integer value) enabled per ECPU or OCPU in the Autonomous VM Cluster. This is deprecated. Please refer to memoryPerComputeUnitInGBs for accurate value.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @_builtins.property
    @pulumi.getter(name="netServicesArchitecture")
    def net_services_architecture(self) -> _builtins.str:
        """
        Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        """
        return pulumi.get(self, "net_services_architecture")

    @_builtins.property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @_builtins.property
    @pulumi.getter(name="okvEndPointGroupName")
    def okv_end_point_group_name(self) -> _builtins.str:
        """
        The OKV End Point Group name for the Autonomous Container Database.
        """
        return pulumi.get(self, "okv_end_point_group_name")

    @_builtins.property
    @pulumi.getter(name="patchId")
    def patch_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch applied on the system.
        """
        return pulumi.get(self, "patch_id")

    @_builtins.property
    @pulumi.getter(name="patchModel")
    def patch_model(self) -> _builtins.str:
        """
        Database patch model preference.
        """
        return pulumi.get(self, "patch_model")

    @_builtins.property
    @pulumi.getter(name="peerAutonomousContainerDatabaseBackupConfigs")
    def peer_autonomous_container_database_backup_configs(self) -> Sequence['outputs.GetAutonomousContainerDatabasePeerAutonomousContainerDatabaseBackupConfigResult']:
        return pulumi.get(self, "peer_autonomous_container_database_backup_configs")

    @_builtins.property
    @pulumi.getter(name="peerAutonomousContainerDatabaseCompartmentId")
    def peer_autonomous_container_database_compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "peer_autonomous_container_database_compartment_id")

    @_builtins.property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDisplayName")
    def peer_autonomous_container_database_display_name(self) -> _builtins.str:
        return pulumi.get(self, "peer_autonomous_container_database_display_name")

    @_builtins.property
    @pulumi.getter(name="peerAutonomousExadataInfrastructureId")
    def peer_autonomous_exadata_infrastructure_id(self) -> _builtins.str:
        return pulumi.get(self, "peer_autonomous_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="peerAutonomousVmClusterId")
    def peer_autonomous_vm_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "peer_autonomous_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> _builtins.str:
        return pulumi.get(self, "peer_db_unique_name")

    @_builtins.property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> _builtins.str:
        """
        The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @_builtins.property
    @pulumi.getter(name="provisionableCpuses")
    def provisionable_cpuses(self) -> Sequence[_builtins.float]:
        """
        An array of CPU values that can be used to successfully provision a single Autonomous AI Database.
        """
        return pulumi.get(self, "provisionable_cpuses")

    @_builtins.property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> _builtins.float:
        """
        The number of CPUs provisioned in an Autonomous Container Database.
        """
        return pulumi.get(self, "provisioned_cpus")

    @_builtins.property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> _builtins.float:
        """
        CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous AI Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @_builtins.property
    @pulumi.getter(name="recoveryApplianceDetails")
    def recovery_appliance_details(self) -> Sequence['outputs.GetAutonomousContainerDatabaseRecoveryApplianceDetailResult']:
        """
        Information about the recovery appliance configuration associated with the Autonomous Container Database.
        """
        return pulumi.get(self, "recovery_appliance_details")

    @_builtins.property
    @pulumi.getter(name="reinstateTrigger")
    def reinstate_trigger(self) -> _builtins.int:
        return pulumi.get(self, "reinstate_trigger")

    @_builtins.property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> _builtins.float:
        """
        The number of CPUs reserved in an Autonomous Container Database.
        """
        return pulumi.get(self, "reserved_cpus")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous AI Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="rotateKeyTrigger")
    def rotate_key_trigger(self) -> _builtins.bool:
        return pulumi.get(self, "rotate_key_trigger")

    @_builtins.property
    @pulumi.getter(name="serviceLevelAgreementType")
    def service_level_agreement_type(self) -> _builtins.str:
        """
        The service level agreement type of the container database. The default is STANDARD.
        """
        return pulumi.get(self, "service_level_agreement_type")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="standbyMaintenanceBufferInDays")
    def standby_maintenance_buffer_in_days(self) -> _builtins.int:
        """
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database.
        """
        return pulumi.get(self, "standby_maintenance_buffer_in_days")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Autonomous Container Database.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="switchoverTrigger")
    def switchover_trigger(self) -> _builtins.int:
        return pulumi.get(self, "switchover_trigger")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Autonomous Container Database was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfLastBackup")
    def time_of_last_backup(self) -> _builtins.str:
        """
        The timestamp of last successful backup. Here NULL value represents either there are no successful backups or backups are not configured for this Autonomous Container Database.
        """
        return pulumi.get(self, "time_of_last_backup")

    @_builtins.property
    @pulumi.getter(name="timeSnapshotStandbyRevert")
    def time_snapshot_standby_revert(self) -> _builtins.str:
        """
        The date and time the Autonomous Container Database will be reverted to Standby from Snapshot Standby.
        """
        return pulumi.get(self, "time_snapshot_standby_revert")

    @_builtins.property
    @pulumi.getter(name="totalCpus")
    def total_cpus(self) -> _builtins.int:
        """
        The number of CPUs allocated to the Autonomous VM cluster.
        """
        return pulumi.get(self, "total_cpus")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

    @_builtins.property
    @pulumi.getter(name="versionPreference")
    def version_preference(self) -> _builtins.str:
        """
        The next maintenance version preference.
        """
        return pulumi.get(self, "version_preference")

    @_builtins.property
    @pulumi.getter(name="vmFailoverReservation")
    def vm_failover_reservation(self) -> _builtins.int:
        """
        The percentage of CPUs reserved across nodes to support node failover. Allowed values are 0%, 25%, and 50%, with 50% being the default option.
        """
        return pulumi.get(self, "vm_failover_reservation")


class AwaitableGetAutonomousContainerDatabaseResult(GetAutonomousContainerDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousContainerDatabaseResult(
            associated_backup_configuration_details=self.associated_backup_configuration_details,
            autonomous_container_database_backup_id=self.autonomous_container_database_backup_id,
            autonomous_container_database_id=self.autonomous_container_database_id,
            autonomous_exadata_infrastructure_id=self.autonomous_exadata_infrastructure_id,
            autonomous_vm_cluster_id=self.autonomous_vm_cluster_id,
            availability_domain=self.availability_domain,
            available_cpus=self.available_cpus,
            backup_configs=self.backup_configs,
            backup_destination_properties_lists=self.backup_destination_properties_lists,
            cloud_autonomous_vm_cluster_id=self.cloud_autonomous_vm_cluster_id,
            compartment_id=self.compartment_id,
            compute_model=self.compute_model,
            customer_contacts=self.customer_contacts,
            database_software_image_id=self.database_software_image_id,
            dataguard_group_members=self.dataguard_group_members,
            dataguards=self.dataguards,
            db_name=self.db_name,
            db_split_threshold=self.db_split_threshold,
            db_unique_name=self.db_unique_name,
            db_version=self.db_version,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            distribution_affinity=self.distribution_affinity,
            dst_file_version=self.dst_file_version,
            failover_trigger=self.failover_trigger,
            fast_start_fail_over_lag_limit_in_seconds=self.fast_start_fail_over_lag_limit_in_seconds,
            freeform_tags=self.freeform_tags,
            id=self.id,
            infrastructure_type=self.infrastructure_type,
            is_automatic_failover_enabled=self.is_automatic_failover_enabled,
            is_data_guard_enabled=self.is_data_guard_enabled,
            is_dst_file_update_enabled=self.is_dst_file_update_enabled,
            is_multiple_standby=self.is_multiple_standby,
            key_history_entries=self.key_history_entries,
            key_store_id=self.key_store_id,
            key_store_wallet_name=self.key_store_wallet_name,
            key_version_id=self.key_version_id,
            kms_key_id=self.kms_key_id,
            kms_key_version_id=self.kms_key_version_id,
            largest_provisionable_autonomous_database_in_cpus=self.largest_provisionable_autonomous_database_in_cpus,
            last_maintenance_run_id=self.last_maintenance_run_id,
            lifecycle_details=self.lifecycle_details,
            list_one_off_patches=self.list_one_off_patches,
            maintenance_window_details=self.maintenance_window_details,
            maintenance_windows=self.maintenance_windows,
            memory_per_compute_unit_in_gbs=self.memory_per_compute_unit_in_gbs,
            memory_per_oracle_compute_unit_in_gbs=self.memory_per_oracle_compute_unit_in_gbs,
            net_services_architecture=self.net_services_architecture,
            next_maintenance_run_id=self.next_maintenance_run_id,
            okv_end_point_group_name=self.okv_end_point_group_name,
            patch_id=self.patch_id,
            patch_model=self.patch_model,
            peer_autonomous_container_database_backup_configs=self.peer_autonomous_container_database_backup_configs,
            peer_autonomous_container_database_compartment_id=self.peer_autonomous_container_database_compartment_id,
            peer_autonomous_container_database_display_name=self.peer_autonomous_container_database_display_name,
            peer_autonomous_exadata_infrastructure_id=self.peer_autonomous_exadata_infrastructure_id,
            peer_autonomous_vm_cluster_id=self.peer_autonomous_vm_cluster_id,
            peer_cloud_autonomous_vm_cluster_id=self.peer_cloud_autonomous_vm_cluster_id,
            peer_db_unique_name=self.peer_db_unique_name,
            protection_mode=self.protection_mode,
            provisionable_cpuses=self.provisionable_cpuses,
            provisioned_cpus=self.provisioned_cpus,
            reclaimable_cpus=self.reclaimable_cpus,
            recovery_appliance_details=self.recovery_appliance_details,
            reinstate_trigger=self.reinstate_trigger,
            reserved_cpus=self.reserved_cpus,
            role=self.role,
            rotate_key_trigger=self.rotate_key_trigger,
            service_level_agreement_type=self.service_level_agreement_type,
            source=self.source,
            standby_maintenance_buffer_in_days=self.standby_maintenance_buffer_in_days,
            state=self.state,
            switchover_trigger=self.switchover_trigger,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_of_last_backup=self.time_of_last_backup,
            time_snapshot_standby_revert=self.time_snapshot_standby_revert,
            total_cpus=self.total_cpus,
            vault_id=self.vault_id,
            version_preference=self.version_preference,
            vm_failover_reservation=self.vm_failover_reservation)


def get_autonomous_container_database(autonomous_container_database_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousContainerDatabaseResult:
    """
    This data source provides details about a specific Autonomous Container Database resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Autonomous Container Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database = oci.Database.get_autonomous_container_database(autonomous_container_database_id=test_autonomous_container_database_oci_database_autonomous_container_database["id"])
    ```


    :param _builtins.str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousContainerDatabase:getAutonomousContainerDatabase', __args__, opts=opts, typ=GetAutonomousContainerDatabaseResult).value

    return AwaitableGetAutonomousContainerDatabaseResult(
        associated_backup_configuration_details=pulumi.get(__ret__, 'associated_backup_configuration_details'),
        autonomous_container_database_backup_id=pulumi.get(__ret__, 'autonomous_container_database_backup_id'),
        autonomous_container_database_id=pulumi.get(__ret__, 'autonomous_container_database_id'),
        autonomous_exadata_infrastructure_id=pulumi.get(__ret__, 'autonomous_exadata_infrastructure_id'),
        autonomous_vm_cluster_id=pulumi.get(__ret__, 'autonomous_vm_cluster_id'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        available_cpus=pulumi.get(__ret__, 'available_cpus'),
        backup_configs=pulumi.get(__ret__, 'backup_configs'),
        backup_destination_properties_lists=pulumi.get(__ret__, 'backup_destination_properties_lists'),
        cloud_autonomous_vm_cluster_id=pulumi.get(__ret__, 'cloud_autonomous_vm_cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_model=pulumi.get(__ret__, 'compute_model'),
        customer_contacts=pulumi.get(__ret__, 'customer_contacts'),
        database_software_image_id=pulumi.get(__ret__, 'database_software_image_id'),
        dataguard_group_members=pulumi.get(__ret__, 'dataguard_group_members'),
        dataguards=pulumi.get(__ret__, 'dataguards'),
        db_name=pulumi.get(__ret__, 'db_name'),
        db_split_threshold=pulumi.get(__ret__, 'db_split_threshold'),
        db_unique_name=pulumi.get(__ret__, 'db_unique_name'),
        db_version=pulumi.get(__ret__, 'db_version'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        distribution_affinity=pulumi.get(__ret__, 'distribution_affinity'),
        dst_file_version=pulumi.get(__ret__, 'dst_file_version'),
        failover_trigger=pulumi.get(__ret__, 'failover_trigger'),
        fast_start_fail_over_lag_limit_in_seconds=pulumi.get(__ret__, 'fast_start_fail_over_lag_limit_in_seconds'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        infrastructure_type=pulumi.get(__ret__, 'infrastructure_type'),
        is_automatic_failover_enabled=pulumi.get(__ret__, 'is_automatic_failover_enabled'),
        is_data_guard_enabled=pulumi.get(__ret__, 'is_data_guard_enabled'),
        is_dst_file_update_enabled=pulumi.get(__ret__, 'is_dst_file_update_enabled'),
        is_multiple_standby=pulumi.get(__ret__, 'is_multiple_standby'),
        key_history_entries=pulumi.get(__ret__, 'key_history_entries'),
        key_store_id=pulumi.get(__ret__, 'key_store_id'),
        key_store_wallet_name=pulumi.get(__ret__, 'key_store_wallet_name'),
        key_version_id=pulumi.get(__ret__, 'key_version_id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        kms_key_version_id=pulumi.get(__ret__, 'kms_key_version_id'),
        largest_provisionable_autonomous_database_in_cpus=pulumi.get(__ret__, 'largest_provisionable_autonomous_database_in_cpus'),
        last_maintenance_run_id=pulumi.get(__ret__, 'last_maintenance_run_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        list_one_off_patches=pulumi.get(__ret__, 'list_one_off_patches'),
        maintenance_window_details=pulumi.get(__ret__, 'maintenance_window_details'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        memory_per_compute_unit_in_gbs=pulumi.get(__ret__, 'memory_per_compute_unit_in_gbs'),
        memory_per_oracle_compute_unit_in_gbs=pulumi.get(__ret__, 'memory_per_oracle_compute_unit_in_gbs'),
        net_services_architecture=pulumi.get(__ret__, 'net_services_architecture'),
        next_maintenance_run_id=pulumi.get(__ret__, 'next_maintenance_run_id'),
        okv_end_point_group_name=pulumi.get(__ret__, 'okv_end_point_group_name'),
        patch_id=pulumi.get(__ret__, 'patch_id'),
        patch_model=pulumi.get(__ret__, 'patch_model'),
        peer_autonomous_container_database_backup_configs=pulumi.get(__ret__, 'peer_autonomous_container_database_backup_configs'),
        peer_autonomous_container_database_compartment_id=pulumi.get(__ret__, 'peer_autonomous_container_database_compartment_id'),
        peer_autonomous_container_database_display_name=pulumi.get(__ret__, 'peer_autonomous_container_database_display_name'),
        peer_autonomous_exadata_infrastructure_id=pulumi.get(__ret__, 'peer_autonomous_exadata_infrastructure_id'),
        peer_autonomous_vm_cluster_id=pulumi.get(__ret__, 'peer_autonomous_vm_cluster_id'),
        peer_cloud_autonomous_vm_cluster_id=pulumi.get(__ret__, 'peer_cloud_autonomous_vm_cluster_id'),
        peer_db_unique_name=pulumi.get(__ret__, 'peer_db_unique_name'),
        protection_mode=pulumi.get(__ret__, 'protection_mode'),
        provisionable_cpuses=pulumi.get(__ret__, 'provisionable_cpuses'),
        provisioned_cpus=pulumi.get(__ret__, 'provisioned_cpus'),
        reclaimable_cpus=pulumi.get(__ret__, 'reclaimable_cpus'),
        recovery_appliance_details=pulumi.get(__ret__, 'recovery_appliance_details'),
        reinstate_trigger=pulumi.get(__ret__, 'reinstate_trigger'),
        reserved_cpus=pulumi.get(__ret__, 'reserved_cpus'),
        role=pulumi.get(__ret__, 'role'),
        rotate_key_trigger=pulumi.get(__ret__, 'rotate_key_trigger'),
        service_level_agreement_type=pulumi.get(__ret__, 'service_level_agreement_type'),
        source=pulumi.get(__ret__, 'source'),
        standby_maintenance_buffer_in_days=pulumi.get(__ret__, 'standby_maintenance_buffer_in_days'),
        state=pulumi.get(__ret__, 'state'),
        switchover_trigger=pulumi.get(__ret__, 'switchover_trigger'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_last_backup=pulumi.get(__ret__, 'time_of_last_backup'),
        time_snapshot_standby_revert=pulumi.get(__ret__, 'time_snapshot_standby_revert'),
        total_cpus=pulumi.get(__ret__, 'total_cpus'),
        vault_id=pulumi.get(__ret__, 'vault_id'),
        version_preference=pulumi.get(__ret__, 'version_preference'),
        vm_failover_reservation=pulumi.get(__ret__, 'vm_failover_reservation'))
def get_autonomous_container_database_output(autonomous_container_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousContainerDatabaseResult]:
    """
    This data source provides details about a specific Autonomous Container Database resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Autonomous Container Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database = oci.Database.get_autonomous_container_database(autonomous_container_database_id=test_autonomous_container_database_oci_database_autonomous_container_database["id"])
    ```


    :param _builtins.str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousContainerDatabase:getAutonomousContainerDatabase', __args__, opts=opts, typ=GetAutonomousContainerDatabaseResult)
    return __ret__.apply(lambda __response__: GetAutonomousContainerDatabaseResult(
        associated_backup_configuration_details=pulumi.get(__response__, 'associated_backup_configuration_details'),
        autonomous_container_database_backup_id=pulumi.get(__response__, 'autonomous_container_database_backup_id'),
        autonomous_container_database_id=pulumi.get(__response__, 'autonomous_container_database_id'),
        autonomous_exadata_infrastructure_id=pulumi.get(__response__, 'autonomous_exadata_infrastructure_id'),
        autonomous_vm_cluster_id=pulumi.get(__response__, 'autonomous_vm_cluster_id'),
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        available_cpus=pulumi.get(__response__, 'available_cpus'),
        backup_configs=pulumi.get(__response__, 'backup_configs'),
        backup_destination_properties_lists=pulumi.get(__response__, 'backup_destination_properties_lists'),
        cloud_autonomous_vm_cluster_id=pulumi.get(__response__, 'cloud_autonomous_vm_cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_model=pulumi.get(__response__, 'compute_model'),
        customer_contacts=pulumi.get(__response__, 'customer_contacts'),
        database_software_image_id=pulumi.get(__response__, 'database_software_image_id'),
        dataguard_group_members=pulumi.get(__response__, 'dataguard_group_members'),
        dataguards=pulumi.get(__response__, 'dataguards'),
        db_name=pulumi.get(__response__, 'db_name'),
        db_split_threshold=pulumi.get(__response__, 'db_split_threshold'),
        db_unique_name=pulumi.get(__response__, 'db_unique_name'),
        db_version=pulumi.get(__response__, 'db_version'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        distribution_affinity=pulumi.get(__response__, 'distribution_affinity'),
        dst_file_version=pulumi.get(__response__, 'dst_file_version'),
        failover_trigger=pulumi.get(__response__, 'failover_trigger'),
        fast_start_fail_over_lag_limit_in_seconds=pulumi.get(__response__, 'fast_start_fail_over_lag_limit_in_seconds'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        infrastructure_type=pulumi.get(__response__, 'infrastructure_type'),
        is_automatic_failover_enabled=pulumi.get(__response__, 'is_automatic_failover_enabled'),
        is_data_guard_enabled=pulumi.get(__response__, 'is_data_guard_enabled'),
        is_dst_file_update_enabled=pulumi.get(__response__, 'is_dst_file_update_enabled'),
        is_multiple_standby=pulumi.get(__response__, 'is_multiple_standby'),
        key_history_entries=pulumi.get(__response__, 'key_history_entries'),
        key_store_id=pulumi.get(__response__, 'key_store_id'),
        key_store_wallet_name=pulumi.get(__response__, 'key_store_wallet_name'),
        key_version_id=pulumi.get(__response__, 'key_version_id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        kms_key_version_id=pulumi.get(__response__, 'kms_key_version_id'),
        largest_provisionable_autonomous_database_in_cpus=pulumi.get(__response__, 'largest_provisionable_autonomous_database_in_cpus'),
        last_maintenance_run_id=pulumi.get(__response__, 'last_maintenance_run_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        list_one_off_patches=pulumi.get(__response__, 'list_one_off_patches'),
        maintenance_window_details=pulumi.get(__response__, 'maintenance_window_details'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        memory_per_compute_unit_in_gbs=pulumi.get(__response__, 'memory_per_compute_unit_in_gbs'),
        memory_per_oracle_compute_unit_in_gbs=pulumi.get(__response__, 'memory_per_oracle_compute_unit_in_gbs'),
        net_services_architecture=pulumi.get(__response__, 'net_services_architecture'),
        next_maintenance_run_id=pulumi.get(__response__, 'next_maintenance_run_id'),
        okv_end_point_group_name=pulumi.get(__response__, 'okv_end_point_group_name'),
        patch_id=pulumi.get(__response__, 'patch_id'),
        patch_model=pulumi.get(__response__, 'patch_model'),
        peer_autonomous_container_database_backup_configs=pulumi.get(__response__, 'peer_autonomous_container_database_backup_configs'),
        peer_autonomous_container_database_compartment_id=pulumi.get(__response__, 'peer_autonomous_container_database_compartment_id'),
        peer_autonomous_container_database_display_name=pulumi.get(__response__, 'peer_autonomous_container_database_display_name'),
        peer_autonomous_exadata_infrastructure_id=pulumi.get(__response__, 'peer_autonomous_exadata_infrastructure_id'),
        peer_autonomous_vm_cluster_id=pulumi.get(__response__, 'peer_autonomous_vm_cluster_id'),
        peer_cloud_autonomous_vm_cluster_id=pulumi.get(__response__, 'peer_cloud_autonomous_vm_cluster_id'),
        peer_db_unique_name=pulumi.get(__response__, 'peer_db_unique_name'),
        protection_mode=pulumi.get(__response__, 'protection_mode'),
        provisionable_cpuses=pulumi.get(__response__, 'provisionable_cpuses'),
        provisioned_cpus=pulumi.get(__response__, 'provisioned_cpus'),
        reclaimable_cpus=pulumi.get(__response__, 'reclaimable_cpus'),
        recovery_appliance_details=pulumi.get(__response__, 'recovery_appliance_details'),
        reinstate_trigger=pulumi.get(__response__, 'reinstate_trigger'),
        reserved_cpus=pulumi.get(__response__, 'reserved_cpus'),
        role=pulumi.get(__response__, 'role'),
        rotate_key_trigger=pulumi.get(__response__, 'rotate_key_trigger'),
        service_level_agreement_type=pulumi.get(__response__, 'service_level_agreement_type'),
        source=pulumi.get(__response__, 'source'),
        standby_maintenance_buffer_in_days=pulumi.get(__response__, 'standby_maintenance_buffer_in_days'),
        state=pulumi.get(__response__, 'state'),
        switchover_trigger=pulumi.get(__response__, 'switchover_trigger'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_last_backup=pulumi.get(__response__, 'time_of_last_backup'),
        time_snapshot_standby_revert=pulumi.get(__response__, 'time_snapshot_standby_revert'),
        total_cpus=pulumi.get(__response__, 'total_cpus'),
        vault_id=pulumi.get(__response__, 'vault_id'),
        version_preference=pulumi.get(__response__, 'version_preference'),
        vm_failover_reservation=pulumi.get(__response__, 'vm_failover_reservation')))
