# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousContainerDatabaseBackupsResult',
    'AwaitableGetAutonomousContainerDatabaseBackupsResult',
    'get_autonomous_container_database_backups',
    'get_autonomous_container_database_backups_output',
]

@pulumi.output_type
class GetAutonomousContainerDatabaseBackupsResult:
    """
    A collection of values returned by getAutonomousContainerDatabaseBackups.
    """
    def __init__(__self__, autonomous_container_database_backup_collections=None, autonomous_container_database_id=None, compartment_id=None, display_name=None, filters=None, id=None, infrastructure_type=None, is_remote=None, state=None):
        if autonomous_container_database_backup_collections and not isinstance(autonomous_container_database_backup_collections, list):
            raise TypeError("Expected argument 'autonomous_container_database_backup_collections' to be a list")
        pulumi.set(__self__, "autonomous_container_database_backup_collections", autonomous_container_database_backup_collections)
        if autonomous_container_database_id and not isinstance(autonomous_container_database_id, str):
            raise TypeError("Expected argument 'autonomous_container_database_id' to be a str")
        pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure_type and not isinstance(infrastructure_type, str):
            raise TypeError("Expected argument 'infrastructure_type' to be a str")
        pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        if is_remote and not isinstance(is_remote, bool):
            raise TypeError("Expected argument 'is_remote' to be a bool")
        pulumi.set(__self__, "is_remote", is_remote)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="autonomousContainerDatabaseBackupCollections")
    def autonomous_container_database_backup_collections(self) -> Sequence['outputs.GetAutonomousContainerDatabaseBackupsAutonomousContainerDatabaseBackupCollectionResult']:
        """
        The list of autonomous_container_database_backup_collection.
        """
        return pulumi.get(self, "autonomous_container_database_backup_collections")

    @_builtins.property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Container Database.
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name for the backup. This name need not be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousContainerDatabaseBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> Optional[_builtins.str]:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @_builtins.property
    @pulumi.getter(name="isRemote")
    def is_remote(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_remote")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutonomousContainerDatabaseBackupsResult(GetAutonomousContainerDatabaseBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousContainerDatabaseBackupsResult(
            autonomous_container_database_backup_collections=self.autonomous_container_database_backup_collections,
            autonomous_container_database_id=self.autonomous_container_database_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            infrastructure_type=self.infrastructure_type,
            is_remote=self.is_remote,
            state=self.state)


def get_autonomous_container_database_backups(autonomous_container_database_id: Optional[_builtins.str] = None,
                                              compartment_id: Optional[_builtins.str] = None,
                                              display_name: Optional[_builtins.str] = None,
                                              filters: Optional[Sequence[Union['GetAutonomousContainerDatabaseBackupsFilterArgs', 'GetAutonomousContainerDatabaseBackupsFilterArgsDict']]] = None,
                                              infrastructure_type: Optional[_builtins.str] = None,
                                              is_remote: Optional[_builtins.bool] = None,
                                              state: Optional[_builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousContainerDatabaseBackupsResult:
    """
    This data source provides the list of Autonomous Container Database Backups in Oracle Cloud Infrastructure Database service.

    Gets a list of Autonomous Container Database backups by using either the 'autonomousDatabaseId' or 'compartmentId' as your query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_backups = oci.Database.get_autonomous_container_database_backups(autonomous_container_database_id=test_autonomous_container_database["id"],
        compartment_id=compartment_id,
        display_name=autonomous_container_database_backup_display_name,
        infrastructure_type=autonomous_container_database_backup_infrastructure_type,
        is_remote=autonomous_container_database_backup_is_remote,
        state=autonomous_container_database_backup_state)
    ```


    :param _builtins.str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str infrastructure_type: A filter to return only resources that match the given Infrastructure Type.
    :param _builtins.bool is_remote: call for all remote backups
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['isRemote'] = is_remote
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousContainerDatabaseBackups:getAutonomousContainerDatabaseBackups', __args__, opts=opts, typ=GetAutonomousContainerDatabaseBackupsResult).value

    return AwaitableGetAutonomousContainerDatabaseBackupsResult(
        autonomous_container_database_backup_collections=pulumi.get(__ret__, 'autonomous_container_database_backup_collections'),
        autonomous_container_database_id=pulumi.get(__ret__, 'autonomous_container_database_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        infrastructure_type=pulumi.get(__ret__, 'infrastructure_type'),
        is_remote=pulumi.get(__ret__, 'is_remote'),
        state=pulumi.get(__ret__, 'state'))
def get_autonomous_container_database_backups_output(autonomous_container_database_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                     compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                     display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousContainerDatabaseBackupsFilterArgs', 'GetAutonomousContainerDatabaseBackupsFilterArgsDict']]]]] = None,
                                                     infrastructure_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                     is_remote: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousContainerDatabaseBackupsResult]:
    """
    This data source provides the list of Autonomous Container Database Backups in Oracle Cloud Infrastructure Database service.

    Gets a list of Autonomous Container Database backups by using either the 'autonomousDatabaseId' or 'compartmentId' as your query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_backups = oci.Database.get_autonomous_container_database_backups(autonomous_container_database_id=test_autonomous_container_database["id"],
        compartment_id=compartment_id,
        display_name=autonomous_container_database_backup_display_name,
        infrastructure_type=autonomous_container_database_backup_infrastructure_type,
        is_remote=autonomous_container_database_backup_is_remote,
        state=autonomous_container_database_backup_state)
    ```


    :param _builtins.str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str infrastructure_type: A filter to return only resources that match the given Infrastructure Type.
    :param _builtins.bool is_remote: call for all remote backups
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['isRemote'] = is_remote
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousContainerDatabaseBackups:getAutonomousContainerDatabaseBackups', __args__, opts=opts, typ=GetAutonomousContainerDatabaseBackupsResult)
    return __ret__.apply(lambda __response__: GetAutonomousContainerDatabaseBackupsResult(
        autonomous_container_database_backup_collections=pulumi.get(__response__, 'autonomous_container_database_backup_collections'),
        autonomous_container_database_id=pulumi.get(__response__, 'autonomous_container_database_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        infrastructure_type=pulumi.get(__response__, 'infrastructure_type'),
        is_remote=pulumi.get(__response__, 'is_remote'),
        state=pulumi.get(__response__, 'state')))
