# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutonomousContainerDatabaseResourceUsageResult',
    'AwaitableGetAutonomousContainerDatabaseResourceUsageResult',
    'get_autonomous_container_database_resource_usage',
    'get_autonomous_container_database_resource_usage_output',
]

@pulumi.output_type
class GetAutonomousContainerDatabaseResourceUsageResult:
    """
    A collection of values returned by getAutonomousContainerDatabaseResourceUsage.
    """
    def __init__(__self__, autonomous_container_database_id=None, autonomous_container_database_vm_usages=None, available_cpus=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, largest_provisionable_autonomous_database_in_cpus=None, provisionable_cpuses=None, provisioned_cpus=None, reclaimable_cpus=None, reserved_cpus=None, used_cpus=None):
        if autonomous_container_database_id and not isinstance(autonomous_container_database_id, str):
            raise TypeError("Expected argument 'autonomous_container_database_id' to be a str")
        pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if autonomous_container_database_vm_usages and not isinstance(autonomous_container_database_vm_usages, list):
            raise TypeError("Expected argument 'autonomous_container_database_vm_usages' to be a list")
        pulumi.set(__self__, "autonomous_container_database_vm_usages", autonomous_container_database_vm_usages)
        if available_cpus and not isinstance(available_cpus, float):
            raise TypeError("Expected argument 'available_cpus' to be a float")
        pulumi.set(__self__, "available_cpus", available_cpus)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if largest_provisionable_autonomous_database_in_cpus and not isinstance(largest_provisionable_autonomous_database_in_cpus, float):
            raise TypeError("Expected argument 'largest_provisionable_autonomous_database_in_cpus' to be a float")
        pulumi.set(__self__, "largest_provisionable_autonomous_database_in_cpus", largest_provisionable_autonomous_database_in_cpus)
        if provisionable_cpuses and not isinstance(provisionable_cpuses, list):
            raise TypeError("Expected argument 'provisionable_cpuses' to be a list")
        pulumi.set(__self__, "provisionable_cpuses", provisionable_cpuses)
        if provisioned_cpus and not isinstance(provisioned_cpus, float):
            raise TypeError("Expected argument 'provisioned_cpus' to be a float")
        pulumi.set(__self__, "provisioned_cpus", provisioned_cpus)
        if reclaimable_cpus and not isinstance(reclaimable_cpus, float):
            raise TypeError("Expected argument 'reclaimable_cpus' to be a float")
        pulumi.set(__self__, "reclaimable_cpus", reclaimable_cpus)
        if reserved_cpus and not isinstance(reserved_cpus, float):
            raise TypeError("Expected argument 'reserved_cpus' to be a float")
        pulumi.set(__self__, "reserved_cpus", reserved_cpus)
        if used_cpus and not isinstance(used_cpus, float):
            raise TypeError("Expected argument 'used_cpus' to be a float")
        pulumi.set(__self__, "used_cpus", used_cpus)

    @_builtins.property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> _builtins.str:
        return pulumi.get(self, "autonomous_container_database_id")

    @_builtins.property
    @pulumi.getter(name="autonomousContainerDatabaseVmUsages")
    def autonomous_container_database_vm_usages(self) -> Sequence['outputs.GetAutonomousContainerDatabaseResourceUsageAutonomousContainerDatabaseVmUsageResult']:
        """
        List of autonomous container database resource usage per autonomous virtual machine.
        """
        return pulumi.get(self, "autonomous_container_database_vm_usages")

    @_builtins.property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> _builtins.float:
        """
        CPUs available for provisioning or scaling an Autonomous AI Database in the Autonomous Container Database.
        """
        return pulumi.get(self, "available_cpus")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the Autonomous Container Database. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="largestProvisionableAutonomousDatabaseInCpus")
    def largest_provisionable_autonomous_database_in_cpus(self) -> _builtins.float:
        """
        Largest provisionable ADB in the Autonomous Container Database.
        """
        return pulumi.get(self, "largest_provisionable_autonomous_database_in_cpus")

    @_builtins.property
    @pulumi.getter(name="provisionableCpuses")
    def provisionable_cpuses(self) -> Sequence[_builtins.float]:
        """
        Valid list of provisionable CPUs for Autonomous AI Database.
        """
        return pulumi.get(self, "provisionable_cpuses")

    @_builtins.property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> _builtins.float:
        """
        CPUs / cores assigned to ADBs in the Autonomous Container Database.
        """
        return pulumi.get(self, "provisioned_cpus")

    @_builtins.property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> _builtins.float:
        """
        Number of CPUs that are reclaimable or released to the AVMC on Autonomous Container Database restart.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @_builtins.property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> _builtins.float:
        """
        CPUs / cores reserved for scalability, resilliency and other overheads. This includes failover, autoscaling and idle instance overhead.
        """
        return pulumi.get(self, "reserved_cpus")

    @_builtins.property
    @pulumi.getter(name="usedCpus")
    def used_cpus(self) -> _builtins.float:
        """
        CPUs / cores assigned to the Autonomous Container Database. Sum of provisioned, reserved and reclaimable CPUs/ cores.
        """
        return pulumi.get(self, "used_cpus")


class AwaitableGetAutonomousContainerDatabaseResourceUsageResult(GetAutonomousContainerDatabaseResourceUsageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousContainerDatabaseResourceUsageResult(
            autonomous_container_database_id=self.autonomous_container_database_id,
            autonomous_container_database_vm_usages=self.autonomous_container_database_vm_usages,
            available_cpus=self.available_cpus,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            largest_provisionable_autonomous_database_in_cpus=self.largest_provisionable_autonomous_database_in_cpus,
            provisionable_cpuses=self.provisionable_cpuses,
            provisioned_cpus=self.provisioned_cpus,
            reclaimable_cpus=self.reclaimable_cpus,
            reserved_cpus=self.reserved_cpus,
            used_cpus=self.used_cpus)


def get_autonomous_container_database_resource_usage(autonomous_container_database_id: Optional[_builtins.str] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousContainerDatabaseResourceUsageResult:
    """
    This data source provides details about a specific Autonomous Container Database Resource Usage resource in Oracle Cloud Infrastructure Database service.

    Get resource usage details for the specified Autonomous Container Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_resource_usage = oci.Database.get_autonomous_container_database_resource_usage(autonomous_container_database_id=test_autonomous_container_database["id"])
    ```


    :param _builtins.str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousContainerDatabaseResourceUsage:getAutonomousContainerDatabaseResourceUsage', __args__, opts=opts, typ=GetAutonomousContainerDatabaseResourceUsageResult).value

    return AwaitableGetAutonomousContainerDatabaseResourceUsageResult(
        autonomous_container_database_id=pulumi.get(__ret__, 'autonomous_container_database_id'),
        autonomous_container_database_vm_usages=pulumi.get(__ret__, 'autonomous_container_database_vm_usages'),
        available_cpus=pulumi.get(__ret__, 'available_cpus'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        largest_provisionable_autonomous_database_in_cpus=pulumi.get(__ret__, 'largest_provisionable_autonomous_database_in_cpus'),
        provisionable_cpuses=pulumi.get(__ret__, 'provisionable_cpuses'),
        provisioned_cpus=pulumi.get(__ret__, 'provisioned_cpus'),
        reclaimable_cpus=pulumi.get(__ret__, 'reclaimable_cpus'),
        reserved_cpus=pulumi.get(__ret__, 'reserved_cpus'),
        used_cpus=pulumi.get(__ret__, 'used_cpus'))
def get_autonomous_container_database_resource_usage_output(autonomous_container_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousContainerDatabaseResourceUsageResult]:
    """
    This data source provides details about a specific Autonomous Container Database Resource Usage resource in Oracle Cloud Infrastructure Database service.

    Get resource usage details for the specified Autonomous Container Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_resource_usage = oci.Database.get_autonomous_container_database_resource_usage(autonomous_container_database_id=test_autonomous_container_database["id"])
    ```


    :param _builtins.str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousContainerDatabaseResourceUsage:getAutonomousContainerDatabaseResourceUsage', __args__, opts=opts, typ=GetAutonomousContainerDatabaseResourceUsageResult)
    return __ret__.apply(lambda __response__: GetAutonomousContainerDatabaseResourceUsageResult(
        autonomous_container_database_id=pulumi.get(__response__, 'autonomous_container_database_id'),
        autonomous_container_database_vm_usages=pulumi.get(__response__, 'autonomous_container_database_vm_usages'),
        available_cpus=pulumi.get(__response__, 'available_cpus'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        largest_provisionable_autonomous_database_in_cpus=pulumi.get(__response__, 'largest_provisionable_autonomous_database_in_cpus'),
        provisionable_cpuses=pulumi.get(__response__, 'provisionable_cpuses'),
        provisioned_cpus=pulumi.get(__response__, 'provisioned_cpus'),
        reclaimable_cpus=pulumi.get(__response__, 'reclaimable_cpus'),
        reserved_cpus=pulumi.get(__response__, 'reserved_cpus'),
        used_cpus=pulumi.get(__response__, 'used_cpus')))
