# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousContainerDatabasesResult',
    'AwaitableGetAutonomousContainerDatabasesResult',
    'get_autonomous_container_databases',
    'get_autonomous_container_databases_output',
]

@pulumi.output_type
class GetAutonomousContainerDatabasesResult:
    """
    A collection of values returned by getAutonomousContainerDatabases.
    """
    def __init__(__self__, autonomous_container_databases=None, autonomous_exadata_infrastructure_id=None, autonomous_vm_cluster_id=None, availability_domain=None, cloud_autonomous_vm_cluster_id=None, compartment_id=None, display_name=None, filters=None, id=None, infrastructure_type=None, service_level_agreement_type=None, state=None):
        if autonomous_container_databases and not isinstance(autonomous_container_databases, list):
            raise TypeError("Expected argument 'autonomous_container_databases' to be a list")
        pulumi.set(__self__, "autonomous_container_databases", autonomous_container_databases)
        if autonomous_exadata_infrastructure_id and not isinstance(autonomous_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'autonomous_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "autonomous_exadata_infrastructure_id", autonomous_exadata_infrastructure_id)
        if autonomous_vm_cluster_id and not isinstance(autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "autonomous_vm_cluster_id", autonomous_vm_cluster_id)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if cloud_autonomous_vm_cluster_id and not isinstance(cloud_autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure_type and not isinstance(infrastructure_type, str):
            raise TypeError("Expected argument 'infrastructure_type' to be a str")
        pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        if service_level_agreement_type and not isinstance(service_level_agreement_type, str):
            raise TypeError("Expected argument 'service_level_agreement_type' to be a str")
        pulumi.set(__self__, "service_level_agreement_type", service_level_agreement_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="autonomousContainerDatabases")
    def autonomous_container_databases(self) -> Sequence['outputs.GetAutonomousContainerDatabasesAutonomousContainerDatabaseResult']:
        """
        The list of autonomous_container_databases.
        """
        return pulumi.get(self, "autonomous_container_databases")

    @_builtins.property
    @pulumi.getter(name="autonomousExadataInfrastructureId")
    def autonomous_exadata_infrastructure_id(self) -> Optional[_builtins.str]:
        """
        **No longer used.** For Autonomous AI Database on dedicated Exadata infrastructure, the container database is created within a specified `cloudAutonomousVmCluster`.
        """
        return pulumi.get(self, "autonomous_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the Autonomous VM Cluster.
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        """
        The domain of the Autonomous Container Database
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-provided name for the Autonomous Container Database.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousContainerDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> Optional[_builtins.str]:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @_builtins.property
    @pulumi.getter(name="serviceLevelAgreementType")
    def service_level_agreement_type(self) -> Optional[_builtins.str]:
        """
        The service level agreement type of the container database. The default is STANDARD.
        """
        return pulumi.get(self, "service_level_agreement_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Autonomous Container Database.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutonomousContainerDatabasesResult(GetAutonomousContainerDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousContainerDatabasesResult(
            autonomous_container_databases=self.autonomous_container_databases,
            autonomous_exadata_infrastructure_id=self.autonomous_exadata_infrastructure_id,
            autonomous_vm_cluster_id=self.autonomous_vm_cluster_id,
            availability_domain=self.availability_domain,
            cloud_autonomous_vm_cluster_id=self.cloud_autonomous_vm_cluster_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            infrastructure_type=self.infrastructure_type,
            service_level_agreement_type=self.service_level_agreement_type,
            state=self.state)


def get_autonomous_container_databases(autonomous_exadata_infrastructure_id: Optional[_builtins.str] = None,
                                       autonomous_vm_cluster_id: Optional[_builtins.str] = None,
                                       availability_domain: Optional[_builtins.str] = None,
                                       cloud_autonomous_vm_cluster_id: Optional[_builtins.str] = None,
                                       compartment_id: Optional[_builtins.str] = None,
                                       display_name: Optional[_builtins.str] = None,
                                       filters: Optional[Sequence[Union['GetAutonomousContainerDatabasesFilterArgs', 'GetAutonomousContainerDatabasesFilterArgsDict']]] = None,
                                       infrastructure_type: Optional[_builtins.str] = None,
                                       service_level_agreement_type: Optional[_builtins.str] = None,
                                       state: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousContainerDatabasesResult:
    """
    This data source provides the list of Autonomous Container Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of the Autonomous Container Databases in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_databases = oci.Database.get_autonomous_container_databases(compartment_id=compartment_id,
        autonomous_exadata_infrastructure_id=test_autonomous_exadata_infrastructure["id"],
        autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
        availability_domain=autonomous_container_database_availability_domain,
        cloud_autonomous_vm_cluster_id=test_cloud_autonomous_vm_cluster["id"],
        display_name=autonomous_container_database_display_name,
        infrastructure_type=autonomous_container_database_infrastructure_type,
        service_level_agreement_type=autonomous_container_database_service_level_agreement_type,
        state=autonomous_container_database_state)
    ```


    :param _builtins.str autonomous_exadata_infrastructure_id: The Autonomous Exadata Infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str autonomous_vm_cluster_id: The Autonomous VM Cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param _builtins.str cloud_autonomous_vm_cluster_id: The cloud Autonomous VM Cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str infrastructure_type: A filter to return only resources that match the given Infrastructure Type.
    :param _builtins.str service_level_agreement_type: A filter to return only resources that match the given service-level agreement type exactly.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousExadataInfrastructureId'] = autonomous_exadata_infrastructure_id
    __args__['autonomousVmClusterId'] = autonomous_vm_cluster_id
    __args__['availabilityDomain'] = availability_domain
    __args__['cloudAutonomousVmClusterId'] = cloud_autonomous_vm_cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['serviceLevelAgreementType'] = service_level_agreement_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousContainerDatabases:getAutonomousContainerDatabases', __args__, opts=opts, typ=GetAutonomousContainerDatabasesResult).value

    return AwaitableGetAutonomousContainerDatabasesResult(
        autonomous_container_databases=pulumi.get(__ret__, 'autonomous_container_databases'),
        autonomous_exadata_infrastructure_id=pulumi.get(__ret__, 'autonomous_exadata_infrastructure_id'),
        autonomous_vm_cluster_id=pulumi.get(__ret__, 'autonomous_vm_cluster_id'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        cloud_autonomous_vm_cluster_id=pulumi.get(__ret__, 'cloud_autonomous_vm_cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        infrastructure_type=pulumi.get(__ret__, 'infrastructure_type'),
        service_level_agreement_type=pulumi.get(__ret__, 'service_level_agreement_type'),
        state=pulumi.get(__ret__, 'state'))
def get_autonomous_container_databases_output(autonomous_exadata_infrastructure_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              autonomous_vm_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousContainerDatabasesFilterArgs', 'GetAutonomousContainerDatabasesFilterArgsDict']]]]] = None,
                                              infrastructure_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              service_level_agreement_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousContainerDatabasesResult]:
    """
    This data source provides the list of Autonomous Container Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of the Autonomous Container Databases in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_databases = oci.Database.get_autonomous_container_databases(compartment_id=compartment_id,
        autonomous_exadata_infrastructure_id=test_autonomous_exadata_infrastructure["id"],
        autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
        availability_domain=autonomous_container_database_availability_domain,
        cloud_autonomous_vm_cluster_id=test_cloud_autonomous_vm_cluster["id"],
        display_name=autonomous_container_database_display_name,
        infrastructure_type=autonomous_container_database_infrastructure_type,
        service_level_agreement_type=autonomous_container_database_service_level_agreement_type,
        state=autonomous_container_database_state)
    ```


    :param _builtins.str autonomous_exadata_infrastructure_id: The Autonomous Exadata Infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str autonomous_vm_cluster_id: The Autonomous VM Cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param _builtins.str cloud_autonomous_vm_cluster_id: The cloud Autonomous VM Cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str infrastructure_type: A filter to return only resources that match the given Infrastructure Type.
    :param _builtins.str service_level_agreement_type: A filter to return only resources that match the given service-level agreement type exactly.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousExadataInfrastructureId'] = autonomous_exadata_infrastructure_id
    __args__['autonomousVmClusterId'] = autonomous_vm_cluster_id
    __args__['availabilityDomain'] = availability_domain
    __args__['cloudAutonomousVmClusterId'] = cloud_autonomous_vm_cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['serviceLevelAgreementType'] = service_level_agreement_type
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousContainerDatabases:getAutonomousContainerDatabases', __args__, opts=opts, typ=GetAutonomousContainerDatabasesResult)
    return __ret__.apply(lambda __response__: GetAutonomousContainerDatabasesResult(
        autonomous_container_databases=pulumi.get(__response__, 'autonomous_container_databases'),
        autonomous_exadata_infrastructure_id=pulumi.get(__response__, 'autonomous_exadata_infrastructure_id'),
        autonomous_vm_cluster_id=pulumi.get(__response__, 'autonomous_vm_cluster_id'),
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        cloud_autonomous_vm_cluster_id=pulumi.get(__response__, 'cloud_autonomous_vm_cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        infrastructure_type=pulumi.get(__response__, 'infrastructure_type'),
        service_level_agreement_type=pulumi.get(__response__, 'service_level_agreement_type'),
        state=pulumi.get(__response__, 'state')))
