# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabaseBackupsResult',
    'AwaitableGetAutonomousDatabaseBackupsResult',
    'get_autonomous_database_backups',
    'get_autonomous_database_backups_output',
]

@pulumi.output_type
class GetAutonomousDatabaseBackupsResult:
    """
    A collection of values returned by getAutonomousDatabaseBackups.
    """
    def __init__(__self__, autonomous_database_backups=None, autonomous_database_id=None, backup_destination_id=None, compartment_id=None, display_name=None, filters=None, id=None, infrastructure_type=None, key_store_id=None, state=None, type=None):
        if autonomous_database_backups and not isinstance(autonomous_database_backups, list):
            raise TypeError("Expected argument 'autonomous_database_backups' to be a list")
        pulumi.set(__self__, "autonomous_database_backups", autonomous_database_backups)
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if backup_destination_id and not isinstance(backup_destination_id, str):
            raise TypeError("Expected argument 'backup_destination_id' to be a str")
        pulumi.set(__self__, "backup_destination_id", backup_destination_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure_type and not isinstance(infrastructure_type, str):
            raise TypeError("Expected argument 'infrastructure_type' to be a str")
        pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        if key_store_id and not isinstance(key_store_id, str):
            raise TypeError("Expected argument 'key_store_id' to be a str")
        pulumi.set(__self__, "key_store_id", key_store_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseBackups")
    def autonomous_database_backups(self) -> Sequence['outputs.GetAutonomousDatabaseBackupsAutonomousDatabaseBackupResult']:
        """
        The list of autonomous_database_backups.
        """
        return pulumi.get(self, "autonomous_database_backups")

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous AI Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter(name="backupDestinationId")
    def backup_destination_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "backup_destination_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the backup. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabaseBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> Optional[_builtins.str]:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @_builtins.property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of backup.
        """
        return pulumi.get(self, "type")


class AwaitableGetAutonomousDatabaseBackupsResult(GetAutonomousDatabaseBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseBackupsResult(
            autonomous_database_backups=self.autonomous_database_backups,
            autonomous_database_id=self.autonomous_database_id,
            backup_destination_id=self.backup_destination_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            infrastructure_type=self.infrastructure_type,
            key_store_id=self.key_store_id,
            state=self.state,
            type=self.type)


def get_autonomous_database_backups(autonomous_database_id: Optional[_builtins.str] = None,
                                    backup_destination_id: Optional[_builtins.str] = None,
                                    compartment_id: Optional[_builtins.str] = None,
                                    display_name: Optional[_builtins.str] = None,
                                    filters: Optional[Sequence[Union['GetAutonomousDatabaseBackupsFilterArgs', 'GetAutonomousDatabaseBackupsFilterArgsDict']]] = None,
                                    infrastructure_type: Optional[_builtins.str] = None,
                                    key_store_id: Optional[_builtins.str] = None,
                                    state: Optional[_builtins.str] = None,
                                    type: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseBackupsResult:
    """
    This data source provides the list of Autonomous Database Backups in Oracle Cloud Infrastructure Database service.

    Gets a list of Autonomous AI Database backups based on either the `autonomousDatabaseId` or `compartmentId` specified as a query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_backups = oci.Database.get_autonomous_database_backups(autonomous_database_id=test_autonomous_database["id"],
        backup_destination_id=test_backup_destination["id"],
        compartment_id=compartment_id,
        display_name=autonomous_database_backup_display_name,
        infrastructure_type=autonomous_database_backup_infrastructure_type,
        key_store_id=test_key_store["id"],
        state=autonomous_database_backup_state,
        type=autonomous_database_backup_type)
    ```


    :param _builtins.str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str backup_destination_id: A filter to return only resources that have the given backup destination id.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str infrastructure_type: A filter to return only resources that match the given Infrastructure Type.
    :param _builtins.str key_store_id: A filter to return only resources that have the given key store id.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    :param _builtins.str type: A filter to return only backups that matches with the given type of Backup.
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['backupDestinationId'] = backup_destination_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['keyStoreId'] = key_store_id
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseBackups:getAutonomousDatabaseBackups', __args__, opts=opts, typ=GetAutonomousDatabaseBackupsResult).value

    return AwaitableGetAutonomousDatabaseBackupsResult(
        autonomous_database_backups=pulumi.get(__ret__, 'autonomous_database_backups'),
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        backup_destination_id=pulumi.get(__ret__, 'backup_destination_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        infrastructure_type=pulumi.get(__ret__, 'infrastructure_type'),
        key_store_id=pulumi.get(__ret__, 'key_store_id'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'))
def get_autonomous_database_backups_output(autonomous_database_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           backup_destination_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDatabaseBackupsFilterArgs', 'GetAutonomousDatabaseBackupsFilterArgsDict']]]]] = None,
                                           infrastructure_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           key_store_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabaseBackupsResult]:
    """
    This data source provides the list of Autonomous Database Backups in Oracle Cloud Infrastructure Database service.

    Gets a list of Autonomous AI Database backups based on either the `autonomousDatabaseId` or `compartmentId` specified as a query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_backups = oci.Database.get_autonomous_database_backups(autonomous_database_id=test_autonomous_database["id"],
        backup_destination_id=test_backup_destination["id"],
        compartment_id=compartment_id,
        display_name=autonomous_database_backup_display_name,
        infrastructure_type=autonomous_database_backup_infrastructure_type,
        key_store_id=test_key_store["id"],
        state=autonomous_database_backup_state,
        type=autonomous_database_backup_type)
    ```


    :param _builtins.str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str backup_destination_id: A filter to return only resources that have the given backup destination id.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str infrastructure_type: A filter to return only resources that match the given Infrastructure Type.
    :param _builtins.str key_store_id: A filter to return only resources that have the given key store id.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    :param _builtins.str type: A filter to return only backups that matches with the given type of Backup.
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['backupDestinationId'] = backup_destination_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['keyStoreId'] = key_store_id
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabaseBackups:getAutonomousDatabaseBackups', __args__, opts=opts, typ=GetAutonomousDatabaseBackupsResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabaseBackupsResult(
        autonomous_database_backups=pulumi.get(__response__, 'autonomous_database_backups'),
        autonomous_database_id=pulumi.get(__response__, 'autonomous_database_id'),
        backup_destination_id=pulumi.get(__response__, 'backup_destination_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        infrastructure_type=pulumi.get(__response__, 'infrastructure_type'),
        key_store_id=pulumi.get(__response__, 'key_store_id'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type')))
