# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabaseResourcePoolMembersResult',
    'AwaitableGetAutonomousDatabaseResourcePoolMembersResult',
    'get_autonomous_database_resource_pool_members',
    'get_autonomous_database_resource_pool_members_output',
]

@pulumi.output_type
class GetAutonomousDatabaseResourcePoolMembersResult:
    """
    A collection of values returned by getAutonomousDatabaseResourcePoolMembers.
    """
    def __init__(__self__, autonomous_database_id=None, filters=None, id=None, resource_pool_member_collections=None):
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_pool_member_collections and not isinstance(resource_pool_member_collections, list):
            raise TypeError("Expected argument 'resource_pool_member_collections' to be a list")
        pulumi.set(__self__, "resource_pool_member_collections", resource_pool_member_collections)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> _builtins.str:
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabaseResourcePoolMembersFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourcePoolMemberCollections")
    def resource_pool_member_collections(self) -> Sequence['outputs.GetAutonomousDatabaseResourcePoolMembersResourcePoolMemberCollectionResult']:
        """
        The list of resource_pool_member_collection.
        """
        return pulumi.get(self, "resource_pool_member_collections")


class AwaitableGetAutonomousDatabaseResourcePoolMembersResult(GetAutonomousDatabaseResourcePoolMembersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseResourcePoolMembersResult(
            autonomous_database_id=self.autonomous_database_id,
            filters=self.filters,
            id=self.id,
            resource_pool_member_collections=self.resource_pool_member_collections)


def get_autonomous_database_resource_pool_members(autonomous_database_id: Optional[_builtins.str] = None,
                                                  filters: Optional[Sequence[Union['GetAutonomousDatabaseResourcePoolMembersFilterArgs', 'GetAutonomousDatabaseResourcePoolMembersFilterArgsDict']]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseResourcePoolMembersResult:
    """
    This data source provides the list of Autonomous Database Resource Pool Members in Oracle Cloud Infrastructure Database service.

    Lists the OCIDs of the Autonomous AI Database resource pool members for the specified Autonomous AI Database leader.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_resource_pool_members = oci.Database.get_autonomous_database_resource_pool_members(autonomous_database_id=test_autonomous_database["id"])
    ```


    :param _builtins.str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseResourcePoolMembers:getAutonomousDatabaseResourcePoolMembers', __args__, opts=opts, typ=GetAutonomousDatabaseResourcePoolMembersResult).value

    return AwaitableGetAutonomousDatabaseResourcePoolMembersResult(
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_pool_member_collections=pulumi.get(__ret__, 'resource_pool_member_collections'))
def get_autonomous_database_resource_pool_members_output(autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDatabaseResourcePoolMembersFilterArgs', 'GetAutonomousDatabaseResourcePoolMembersFilterArgsDict']]]]] = None,
                                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabaseResourcePoolMembersResult]:
    """
    This data source provides the list of Autonomous Database Resource Pool Members in Oracle Cloud Infrastructure Database service.

    Lists the OCIDs of the Autonomous AI Database resource pool members for the specified Autonomous AI Database leader.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_resource_pool_members = oci.Database.get_autonomous_database_resource_pool_members(autonomous_database_id=test_autonomous_database["id"])
    ```


    :param _builtins.str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabaseResourcePoolMembers:getAutonomousDatabaseResourcePoolMembers', __args__, opts=opts, typ=GetAutonomousDatabaseResourcePoolMembersResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabaseResourcePoolMembersResult(
        autonomous_database_id=pulumi.get(__response__, 'autonomous_database_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_pool_member_collections=pulumi.get(__response__, 'resource_pool_member_collections')))
