# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAutonomousDatabaseWalletResult',
    'AwaitableGetAutonomousDatabaseWalletResult',
    'get_autonomous_database_wallet',
    'get_autonomous_database_wallet_output',
]

@pulumi.output_type
class GetAutonomousDatabaseWalletResult:
    """
    A collection of values returned by getAutonomousDatabaseWallet.
    """
    def __init__(__self__, autonomous_database_id=None, base64_encode_content=None, content=None, generate_type=None, id=None, password=None):
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if base64_encode_content and not isinstance(base64_encode_content, bool):
            raise TypeError("Expected argument 'base64_encode_content' to be a bool")
        pulumi.set(__self__, "base64_encode_content", base64_encode_content)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if generate_type and not isinstance(generate_type, str):
            raise TypeError("Expected argument 'generate_type' to be a str")
        pulumi.set(__self__, "generate_type", generate_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    @_utilities.deprecated("""The 'data.oci_database_autonomous_database_wallet' resource has been deprecated. Please use 'oci_database_autonomous_database_wallet' instead.""")
    def autonomous_database_id(self) -> _builtins.str:
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "base64_encode_content")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="generateType")
    def generate_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "generate_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        return pulumi.get(self, "password")


class AwaitableGetAutonomousDatabaseWalletResult(GetAutonomousDatabaseWalletResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseWalletResult(
            autonomous_database_id=self.autonomous_database_id,
            base64_encode_content=self.base64_encode_content,
            content=self.content,
            generate_type=self.generate_type,
            id=self.id,
            password=self.password)


def get_autonomous_database_wallet(autonomous_database_id: Optional[_builtins.str] = None,
                                   base64_encode_content: Optional[_builtins.bool] = None,
                                   generate_type: Optional[_builtins.str] = None,
                                   password: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseWalletResult:
    """
    **Deprecated. Use Database.AutonomousDatabaseWallet instead.**

    This data source provides details about a specific Autonomous Database Wallet resource in Oracle Cloud Infrastructure Database service.

    Creates and downloads a wallet for the specified Autonomous AI Database.

    ## Example Usage


    :param _builtins.str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str generate_type: The type of wallet to generate.
           
           **Serverless instance usage:**
           * `SINGLE` - used to generate a wallet for a single database
           * `ALL` - used to generate wallet for all databases in the region
           
           **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
    :param _builtins.str password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['base64EncodeContent'] = base64_encode_content
    __args__['generateType'] = generate_type
    __args__['password'] = password
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseWallet:getAutonomousDatabaseWallet', __args__, opts=opts, typ=GetAutonomousDatabaseWalletResult).value

    return AwaitableGetAutonomousDatabaseWalletResult(
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        base64_encode_content=pulumi.get(__ret__, 'base64_encode_content'),
        content=pulumi.get(__ret__, 'content'),
        generate_type=pulumi.get(__ret__, 'generate_type'),
        id=pulumi.get(__ret__, 'id'),
        password=pulumi.get(__ret__, 'password'))
def get_autonomous_database_wallet_output(autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          base64_encode_content: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                          generate_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          password: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabaseWalletResult]:
    """
    **Deprecated. Use Database.AutonomousDatabaseWallet instead.**

    This data source provides details about a specific Autonomous Database Wallet resource in Oracle Cloud Infrastructure Database service.

    Creates and downloads a wallet for the specified Autonomous AI Database.

    ## Example Usage


    :param _builtins.str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str generate_type: The type of wallet to generate.
           
           **Serverless instance usage:**
           * `SINGLE` - used to generate a wallet for a single database
           * `ALL` - used to generate wallet for all databases in the region
           
           **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
    :param _builtins.str password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['base64EncodeContent'] = base64_encode_content
    __args__['generateType'] = generate_type
    __args__['password'] = password
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabaseWallet:getAutonomousDatabaseWallet', __args__, opts=opts, typ=GetAutonomousDatabaseWalletResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabaseWalletResult(
        autonomous_database_id=pulumi.get(__response__, 'autonomous_database_id'),
        base64_encode_content=pulumi.get(__response__, 'base64_encode_content'),
        content=pulumi.get(__response__, 'content'),
        generate_type=pulumi.get(__response__, 'generate_type'),
        id=pulumi.get(__response__, 'id'),
        password=pulumi.get(__response__, 'password')))
