# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbNodeSnapshotResult',
    'AwaitableGetDbNodeSnapshotResult',
    'get_db_node_snapshot',
    'get_db_node_snapshot_output',
]

@pulumi.output_type
class GetDbNodeSnapshotResult:
    """
    A collection of values returned by getDbNodeSnapshot.
    """
    def __init__(__self__, cluster_id=None, compartment_id=None, dbnode_snapshot_id=None, defined_tags=None, freeform_tags=None, id=None, lifecycle_details=None, mount_dbnode_id=None, mount_points=None, name=None, source_dbnode_id=None, state=None, system_tags=None, time_created=None, volumes=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dbnode_snapshot_id and not isinstance(dbnode_snapshot_id, str):
            raise TypeError("Expected argument 'dbnode_snapshot_id' to be a str")
        pulumi.set(__self__, "dbnode_snapshot_id", dbnode_snapshot_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if mount_dbnode_id and not isinstance(mount_dbnode_id, str):
            raise TypeError("Expected argument 'mount_dbnode_id' to be a str")
        pulumi.set(__self__, "mount_dbnode_id", mount_dbnode_id)
        if mount_points and not isinstance(mount_points, list):
            raise TypeError("Expected argument 'mount_points' to be a list")
        pulumi.set(__self__, "mount_points", mount_points)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if source_dbnode_id and not isinstance(source_dbnode_id, str):
            raise TypeError("Expected argument 'source_dbnode_id' to be a str")
        pulumi.set(__self__, "source_dbnode_id", source_dbnode_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbnodeSnapshotId")
    def dbnode_snapshot_id(self) -> _builtins.str:
        return pulumi.get(self, "dbnode_snapshot_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node Snapshot.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state of the Exadata Database Node Snapshot.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="mountDbnodeId")
    def mount_dbnode_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node to which the snapshot is mounted. If the snapshot is not mounted to any node, then the value of `mount_dbnode_id` will be `"null"`.
        """
        return pulumi.get(self, "mount_dbnode_id")

    @_builtins.property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Sequence['outputs.GetDbNodeSnapshotMountPointResult']:
        """
        Details of the mount points
        """
        return pulumi.get(self, "mount_points")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Volume Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceDbnodeId")
    def source_dbnode_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node.
        """
        return pulumi.get(self, "source_dbnode_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Exadata Database Node Snapshot.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time that the Exadata Database Node Snapshot was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetDbNodeSnapshotVolumeResult']:
        """
        Details of the volumes
        """
        return pulumi.get(self, "volumes")


class AwaitableGetDbNodeSnapshotResult(GetDbNodeSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodeSnapshotResult(
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            dbnode_snapshot_id=self.dbnode_snapshot_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            mount_dbnode_id=self.mount_dbnode_id,
            mount_points=self.mount_points,
            name=self.name,
            source_dbnode_id=self.source_dbnode_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            volumes=self.volumes)


def get_db_node_snapshot(dbnode_snapshot_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodeSnapshotResult:
    """
    This data source provides details about a specific Db Node Snapshot resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Exadata Database Node Snapshot in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_snapshot = oci.Database.get_db_node_snapshot(dbnode_snapshot_id=test_snapshot["id"])
    ```


    :param _builtins.str dbnode_snapshot_id: The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbnodeSnapshotId'] = dbnode_snapshot_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbNodeSnapshot:getDbNodeSnapshot', __args__, opts=opts, typ=GetDbNodeSnapshotResult).value

    return AwaitableGetDbNodeSnapshotResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dbnode_snapshot_id=pulumi.get(__ret__, 'dbnode_snapshot_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        mount_dbnode_id=pulumi.get(__ret__, 'mount_dbnode_id'),
        mount_points=pulumi.get(__ret__, 'mount_points'),
        name=pulumi.get(__ret__, 'name'),
        source_dbnode_id=pulumi.get(__ret__, 'source_dbnode_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        volumes=pulumi.get(__ret__, 'volumes'))
def get_db_node_snapshot_output(dbnode_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbNodeSnapshotResult]:
    """
    This data source provides details about a specific Db Node Snapshot resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Exadata Database Node Snapshot in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_snapshot = oci.Database.get_db_node_snapshot(dbnode_snapshot_id=test_snapshot["id"])
    ```


    :param _builtins.str dbnode_snapshot_id: The Exadata Database Node Snapshot [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbnodeSnapshotId'] = dbnode_snapshot_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDbNodeSnapshot:getDbNodeSnapshot', __args__, opts=opts, typ=GetDbNodeSnapshotResult)
    return __ret__.apply(lambda __response__: GetDbNodeSnapshotResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dbnode_snapshot_id=pulumi.get(__response__, 'dbnode_snapshot_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        mount_dbnode_id=pulumi.get(__response__, 'mount_dbnode_id'),
        mount_points=pulumi.get(__response__, 'mount_points'),
        name=pulumi.get(__response__, 'name'),
        source_dbnode_id=pulumi.get(__response__, 'source_dbnode_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        volumes=pulumi.get(__response__, 'volumes')))
