# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbNodeSnapshotsResult',
    'AwaitableGetDbNodeSnapshotsResult',
    'get_db_node_snapshots',
    'get_db_node_snapshots_output',
]

@pulumi.output_type
class GetDbNodeSnapshotsResult:
    """
    A collection of values returned by getDbNodeSnapshots.
    """
    def __init__(__self__, cluster_id=None, compartment_id=None, dbnode_snapshots=None, filters=None, id=None, name=None, source_dbnode_id=None, state=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dbnode_snapshots and not isinstance(dbnode_snapshots, list):
            raise TypeError("Expected argument 'dbnode_snapshots' to be a list")
        pulumi.set(__self__, "dbnode_snapshots", dbnode_snapshots)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if source_dbnode_id and not isinstance(source_dbnode_id, str):
            raise TypeError("Expected argument 'source_dbnode_id' to be a str")
        pulumi.set(__self__, "source_dbnode_id", source_dbnode_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbnodeSnapshots")
    def dbnode_snapshots(self) -> Sequence['outputs.GetDbNodeSnapshotsDbnodeSnapshotResult']:
        """
        The list of dbnode_snapshots.
        """
        return pulumi.get(self, "dbnode_snapshots")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbNodeSnapshotsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Volume Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceDbnodeId")
    def source_dbnode_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Node.
        """
        return pulumi.get(self, "source_dbnode_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Exadata Database Node Snapshot.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbNodeSnapshotsResult(GetDbNodeSnapshotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodeSnapshotsResult(
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            dbnode_snapshots=self.dbnode_snapshots,
            filters=self.filters,
            id=self.id,
            name=self.name,
            source_dbnode_id=self.source_dbnode_id,
            state=self.state)


def get_db_node_snapshots(cluster_id: Optional[_builtins.str] = None,
                          compartment_id: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetDbNodeSnapshotsFilterArgs', 'GetDbNodeSnapshotsFilterArgsDict']]] = None,
                          name: Optional[_builtins.str] = None,
                          source_dbnode_id: Optional[_builtins.str] = None,
                          state: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodeSnapshotsResult:
    """
    This data source provides the list of Db Node Snapshots in Oracle Cloud Infrastructure Database service.

    Gets a list of the Exadata Database Node Snapshots in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_snapshots = oci.Database.get_db_node_snapshots(compartment_id=compartment_id,
        cluster_id=test_db_node_snapshot_management["exadbVmClusterId"],
        name=test_db_node_snapshot_management["snapshots"][0]["name"],
        source_dbnode_id=test_db_node_snapshot_management["snapshots"][0]["sourceDbnodeId"],
        state=test_db_node_snapshot_management["snapshots"][0]["state"])
    ```


    :param _builtins.str cluster_id: A filter to return only Exadata Database Node Snapshots that match the given VM cluster.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str name: A filter to return only resources that match the entire name given. The match is not case sensitive.
    :param _builtins.str source_dbnode_id: A filter to return only Exadata Database Snapshots that match the given database node.
    :param _builtins.str state: A filter to return only Exadata Database Snapshots that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['sourceDbnodeId'] = source_dbnode_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbNodeSnapshots:getDbNodeSnapshots', __args__, opts=opts, typ=GetDbNodeSnapshotsResult).value

    return AwaitableGetDbNodeSnapshotsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dbnode_snapshots=pulumi.get(__ret__, 'dbnode_snapshots'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        source_dbnode_id=pulumi.get(__ret__, 'source_dbnode_id'),
        state=pulumi.get(__ret__, 'state'))
def get_db_node_snapshots_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbNodeSnapshotsFilterArgs', 'GetDbNodeSnapshotsFilterArgsDict']]]]] = None,
                                 name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 source_dbnode_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbNodeSnapshotsResult]:
    """
    This data source provides the list of Db Node Snapshots in Oracle Cloud Infrastructure Database service.

    Gets a list of the Exadata Database Node Snapshots in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_snapshots = oci.Database.get_db_node_snapshots(compartment_id=compartment_id,
        cluster_id=test_db_node_snapshot_management["exadbVmClusterId"],
        name=test_db_node_snapshot_management["snapshots"][0]["name"],
        source_dbnode_id=test_db_node_snapshot_management["snapshots"][0]["sourceDbnodeId"],
        state=test_db_node_snapshot_management["snapshots"][0]["state"])
    ```


    :param _builtins.str cluster_id: A filter to return only Exadata Database Node Snapshots that match the given VM cluster.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str name: A filter to return only resources that match the entire name given. The match is not case sensitive.
    :param _builtins.str source_dbnode_id: A filter to return only Exadata Database Snapshots that match the given database node.
    :param _builtins.str state: A filter to return only Exadata Database Snapshots that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['sourceDbnodeId'] = source_dbnode_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDbNodeSnapshots:getDbNodeSnapshots', __args__, opts=opts, typ=GetDbNodeSnapshotsResult)
    return __ret__.apply(lambda __response__: GetDbNodeSnapshotsResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dbnode_snapshots=pulumi.get(__response__, 'dbnode_snapshots'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        source_dbnode_id=pulumi.get(__response__, 'source_dbnode_id'),
        state=pulumi.get(__response__, 'state')))
