# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVmClusterUpdateResult',
    'AwaitableGetVmClusterUpdateResult',
    'get_vm_cluster_update',
    'get_vm_cluster_update_output',
]

@pulumi.output_type
class GetVmClusterUpdateResult:
    """
    A collection of values returned by getVmClusterUpdate.
    """
    def __init__(__self__, available_actions=None, description=None, id=None, last_action=None, lifecycle_details=None, state=None, time_released=None, update_id=None, update_type=None, version=None, vm_cluster_id=None):
        if available_actions and not isinstance(available_actions, list):
            raise TypeError("Expected argument 'available_actions' to be a list")
        pulumi.set(__self__, "available_actions", available_actions)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_action and not isinstance(last_action, str):
            raise TypeError("Expected argument 'last_action' to be a str")
        pulumi.set(__self__, "last_action", last_action)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_released and not isinstance(time_released, str):
            raise TypeError("Expected argument 'time_released' to be a str")
        pulumi.set(__self__, "time_released", time_released)
        if update_id and not isinstance(update_id, str):
            raise TypeError("Expected argument 'update_id' to be a str")
        pulumi.set(__self__, "update_id", update_id)
        if update_type and not isinstance(update_type, str):
            raise TypeError("Expected argument 'update_type' to be a str")
        pulumi.set(__self__, "update_type", update_type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @_builtins.property
    @pulumi.getter(name="availableActions")
    def available_actions(self) -> Sequence[_builtins.str]:
        """
        The possible actions that can be performed using this maintenance update.
        """
        return pulumi.get(self, "available_actions")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Details of the maintenance update package.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastAction")
    def last_action(self) -> _builtins.str:
        """
        The update action performed most recently using this maintenance update.
        """
        return pulumi.get(self, "last_action")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Descriptive text providing additional details about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the maintenance update. Dependent on value of `lastAction`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> _builtins.str:
        """
        The date and time the maintenance update was released.
        """
        return pulumi.get(self, "time_released")

    @_builtins.property
    @pulumi.getter(name="updateId")
    def update_id(self) -> _builtins.str:
        return pulumi.get(self, "update_id")

    @_builtins.property
    @pulumi.getter(name="updateType")
    def update_type(self) -> _builtins.str:
        """
        The type of VM cluster maintenance update.
        """
        return pulumi.get(self, "update_type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the maintenance update package.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "vm_cluster_id")


class AwaitableGetVmClusterUpdateResult(GetVmClusterUpdateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterUpdateResult(
            available_actions=self.available_actions,
            description=self.description,
            id=self.id,
            last_action=self.last_action,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            time_released=self.time_released,
            update_id=self.update_id,
            update_type=self.update_type,
            version=self.version,
            vm_cluster_id=self.vm_cluster_id)


def get_vm_cluster_update(update_id: Optional[_builtins.str] = None,
                          vm_cluster_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterUpdateResult:
    """
    This data source provides details about a specific Vm Cluster Update resource in Oracle Cloud Infrastructure Database service.

    Gets information about a specified maintenance update package for a VM cluster. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_update = oci.Database.get_vm_cluster_update(update_id=test_update["id"],
        vm_cluster_id=test_vm_cluster["id"])
    ```


    :param _builtins.str update_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance update.
    :param _builtins.str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['updateId'] = update_id
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusterUpdate:getVmClusterUpdate', __args__, opts=opts, typ=GetVmClusterUpdateResult).value

    return AwaitableGetVmClusterUpdateResult(
        available_actions=pulumi.get(__ret__, 'available_actions'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        last_action=pulumi.get(__ret__, 'last_action'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        time_released=pulumi.get(__ret__, 'time_released'),
        update_id=pulumi.get(__ret__, 'update_id'),
        update_type=pulumi.get(__ret__, 'update_type'),
        version=pulumi.get(__ret__, 'version'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'))
def get_vm_cluster_update_output(update_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVmClusterUpdateResult]:
    """
    This data source provides details about a specific Vm Cluster Update resource in Oracle Cloud Infrastructure Database service.

    Gets information about a specified maintenance update package for a VM cluster. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_update = oci.Database.get_vm_cluster_update(update_id=test_update["id"],
        vm_cluster_id=test_vm_cluster["id"])
    ```


    :param _builtins.str update_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance update.
    :param _builtins.str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['updateId'] = update_id
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getVmClusterUpdate:getVmClusterUpdate', __args__, opts=opts, typ=GetVmClusterUpdateResult)
    return __ret__.apply(lambda __response__: GetVmClusterUpdateResult(
        available_actions=pulumi.get(__response__, 'available_actions'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        last_action=pulumi.get(__response__, 'last_action'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        time_released=pulumi.get(__response__, 'time_released'),
        update_id=pulumi.get(__response__, 'update_id'),
        update_type=pulumi.get(__response__, 'update_type'),
        version=pulumi.get(__response__, 'version'),
        vm_cluster_id=pulumi.get(__response__, 'vm_cluster_id')))
