# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCloudDbHomeResult',
    'AwaitableGetCloudDbHomeResult',
    'get_cloud_db_home',
    'get_cloud_db_home_output',
]

@pulumi.output_type
class GetCloudDbHomeResult:
    """
    A collection of values returned by getCloudDbHome.
    """
    def __init__(__self__, additional_details=None, cloud_db_home_id=None, cloud_db_system_id=None, compartment_id=None, component_name=None, dbaas_id=None, defined_tags=None, display_name=None, freeform_tags=None, home_directory=None, id=None, lifecycle_details=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if cloud_db_home_id and not isinstance(cloud_db_home_id, str):
            raise TypeError("Expected argument 'cloud_db_home_id' to be a str")
        pulumi.set(__self__, "cloud_db_home_id", cloud_db_home_id)
        if cloud_db_system_id and not isinstance(cloud_db_system_id, str):
            raise TypeError("Expected argument 'cloud_db_system_id' to be a str")
        pulumi.set(__self__, "cloud_db_system_id", cloud_db_system_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if component_name and not isinstance(component_name, str):
            raise TypeError("Expected argument 'component_name' to be a str")
        pulumi.set(__self__, "component_name", component_name)
        if dbaas_id and not isinstance(dbaas_id, str):
            raise TypeError("Expected argument 'dbaas_id' to be a str")
        pulumi.set(__self__, "dbaas_id", dbaas_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if home_directory and not isinstance(home_directory, str):
            raise TypeError("Expected argument 'home_directory' to be a str")
        pulumi.set(__self__, "home_directory", home_directory)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, _builtins.str]:
        """
        The additional details of the DB home defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @_builtins.property
    @pulumi.getter(name="cloudDbHomeId")
    def cloud_db_home_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_db_home_id")

    @_builtins.property
    @pulumi.getter(name="cloudDbSystemId")
    def cloud_db_system_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system that the DB home is a part of.
        """
        return pulumi.get(self, "cloud_db_system_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="componentName")
    def component_name(self) -> _builtins.str:
        """
        The name of the cloud DB home.
        """
        return pulumi.get(self, "component_name")

    @_builtins.property
    @pulumi.getter(name="dbaasId")
    def dbaas_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB home in DBaas service.
        """
        return pulumi.get(self, "dbaas_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the cloud DB home. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="homeDirectory")
    def home_directory(self) -> _builtins.str:
        """
        The location of the DB home.
        """
        return pulumi.get(self, "home_directory")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB home.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the cloud DB home.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the cloud DB home was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the cloud DB home was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetCloudDbHomeResult(GetCloudDbHomeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudDbHomeResult(
            additional_details=self.additional_details,
            cloud_db_home_id=self.cloud_db_home_id,
            cloud_db_system_id=self.cloud_db_system_id,
            compartment_id=self.compartment_id,
            component_name=self.component_name,
            dbaas_id=self.dbaas_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            home_directory=self.home_directory,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_cloud_db_home(cloud_db_home_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudDbHomeResult:
    """
    This data source provides details about a specific Cloud Db Home resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the cloud DB home specified by `cloudDbHomeId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_db_home = oci.DatabaseManagement.get_cloud_db_home(cloud_db_home_id=test_cloud_db_home_oci_database_management_cloud_db_home["id"])
    ```


    :param _builtins.str cloud_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud database home.
    """
    __args__ = dict()
    __args__['cloudDbHomeId'] = cloud_db_home_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudDbHome:getCloudDbHome', __args__, opts=opts, typ=GetCloudDbHomeResult).value

    return AwaitableGetCloudDbHomeResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        cloud_db_home_id=pulumi.get(__ret__, 'cloud_db_home_id'),
        cloud_db_system_id=pulumi.get(__ret__, 'cloud_db_system_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        component_name=pulumi.get(__ret__, 'component_name'),
        dbaas_id=pulumi.get(__ret__, 'dbaas_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        home_directory=pulumi.get(__ret__, 'home_directory'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_cloud_db_home_output(cloud_db_home_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudDbHomeResult]:
    """
    This data source provides details about a specific Cloud Db Home resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the cloud DB home specified by `cloudDbHomeId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_db_home = oci.DatabaseManagement.get_cloud_db_home(cloud_db_home_id=test_cloud_db_home_oci_database_management_cloud_db_home["id"])
    ```


    :param _builtins.str cloud_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud database home.
    """
    __args__ = dict()
    __args__['cloudDbHomeId'] = cloud_db_home_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudDbHome:getCloudDbHome', __args__, opts=opts, typ=GetCloudDbHomeResult)
    return __ret__.apply(lambda __response__: GetCloudDbHomeResult(
        additional_details=pulumi.get(__response__, 'additional_details'),
        cloud_db_home_id=pulumi.get(__response__, 'cloud_db_home_id'),
        cloud_db_system_id=pulumi.get(__response__, 'cloud_db_system_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        component_name=pulumi.get(__response__, 'component_name'),
        dbaas_id=pulumi.get(__response__, 'dbaas_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        home_directory=pulumi.get(__response__, 'home_directory'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
