# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseToolsConnectionArgs', 'DatabaseToolsConnection']

@pulumi.input_type
class DatabaseToolsConnectionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 user_name: pulumi.Input[_builtins.str],
                 user_password: pulumi.Input['DatabaseToolsConnectionUserPasswordArgs'],
                 advanced_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 key_stores: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionKeyStoreArgs']]]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionLockArgs']]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_client: Optional[pulumi.Input['DatabaseToolsConnectionProxyClientArgs']] = None,
                 related_resource: Optional[pulumi.Input['DatabaseToolsConnectionRelatedResourceArgs']] = None,
                 runtime_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_support: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseToolsConnection resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools connection.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] type: (Updatable) The Database Tools connection type.
        :param pulumi.Input[_builtins.str] user_name: (Updatable) The database user name.
        :param pulumi.Input['DatabaseToolsConnectionUserPasswordArgs'] user_password: (Updatable) The database user password.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] advanced_properties: (Updatable) The advanced connection properties key-value pair (e.g., `oracle.net.ssl_server_dn_match`).
        :param pulumi.Input[_builtins.str] connection_string: (Updatable) The connect descriptor or Easy Connect Naming method use to connect to the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionKeyStoreArgs']]] key_stores: (Updatable) Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[_builtins.str] private_endpoint_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        :param pulumi.Input['DatabaseToolsConnectionProxyClientArgs'] proxy_client: (Updatable) The proxy client information.
        :param pulumi.Input['DatabaseToolsConnectionRelatedResourceArgs'] related_resource: (Updatable) The related resource
        :param pulumi.Input[_builtins.str] runtime_identity: Specifies the identity used by the Database Tools service to issue requests to other Oracle Cloud Infrastructure services (e.g., Secrets in Vault).
        :param pulumi.Input[_builtins.str] runtime_support: Specifies whether this connection is supported by the Database Tools Runtime.
        :param pulumi.Input[_builtins.str] url: (Updatable) The JDBC URL used to connect to the Generic JDBC database system.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_password", user_password)
        if advanced_properties is not None:
            pulumi.set(__self__, "advanced_properties", advanced_properties)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if key_stores is not None:
            pulumi.set(__self__, "key_stores", key_stores)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if private_endpoint_id is not None:
            pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if proxy_client is not None:
            pulumi.set(__self__, "proxy_client", proxy_client)
        if related_resource is not None:
            pulumi.set(__self__, "related_resource", related_resource)
        if runtime_identity is not None:
            pulumi.set(__self__, "runtime_identity", runtime_identity)
        if runtime_support is not None:
            pulumi.set(__self__, "runtime_support", runtime_support)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools connection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The Database Tools connection type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The database user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> pulumi.Input['DatabaseToolsConnectionUserPasswordArgs']:
        """
        (Updatable) The database user password.
        """
        return pulumi.get(self, "user_password")

    @user_password.setter
    def user_password(self, value: pulumi.Input['DatabaseToolsConnectionUserPasswordArgs']):
        pulumi.set(self, "user_password", value)

    @_builtins.property
    @pulumi.getter(name="advancedProperties")
    def advanced_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The advanced connection properties key-value pair (e.g., `oracle.net.ssl_server_dn_match`).
        """
        return pulumi.get(self, "advanced_properties")

    @advanced_properties.setter
    def advanced_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "advanced_properties", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The connect descriptor or Easy Connect Naming method use to connect to the database.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="keyStores")
    def key_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionKeyStoreArgs']]]]:
        """
        (Updatable) Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        """
        return pulumi.get(self, "key_stores")

    @key_stores.setter
    def key_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionKeyStoreArgs']]]]):
        pulumi.set(self, "key_stores", value)

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="proxyClient")
    def proxy_client(self) -> Optional[pulumi.Input['DatabaseToolsConnectionProxyClientArgs']]:
        """
        (Updatable) The proxy client information.
        """
        return pulumi.get(self, "proxy_client")

    @proxy_client.setter
    def proxy_client(self, value: Optional[pulumi.Input['DatabaseToolsConnectionProxyClientArgs']]):
        pulumi.set(self, "proxy_client", value)

    @_builtins.property
    @pulumi.getter(name="relatedResource")
    def related_resource(self) -> Optional[pulumi.Input['DatabaseToolsConnectionRelatedResourceArgs']]:
        """
        (Updatable) The related resource
        """
        return pulumi.get(self, "related_resource")

    @related_resource.setter
    def related_resource(self, value: Optional[pulumi.Input['DatabaseToolsConnectionRelatedResourceArgs']]):
        pulumi.set(self, "related_resource", value)

    @_builtins.property
    @pulumi.getter(name="runtimeIdentity")
    def runtime_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identity used by the Database Tools service to issue requests to other Oracle Cloud Infrastructure services (e.g., Secrets in Vault).
        """
        return pulumi.get(self, "runtime_identity")

    @runtime_identity.setter
    def runtime_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_identity", value)

    @_builtins.property
    @pulumi.getter(name="runtimeSupport")
    def runtime_support(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether this connection is supported by the Database Tools Runtime.
        """
        return pulumi.get(self, "runtime_support")

    @runtime_support.setter
    def runtime_support(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_support", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The JDBC URL used to connect to the Generic JDBC database system.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _DatabaseToolsConnectionState:
    def __init__(__self__, *,
                 advanced_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 key_stores: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionKeyStoreArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionLockArgs']]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_client: Optional[pulumi.Input['DatabaseToolsConnectionProxyClientArgs']] = None,
                 related_resource: Optional[pulumi.Input['DatabaseToolsConnectionRelatedResourceArgs']] = None,
                 runtime_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_support: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input['DatabaseToolsConnectionUserPasswordArgs']] = None):
        """
        Input properties used for looking up and filtering DatabaseToolsConnection resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] advanced_properties: (Updatable) The advanced connection properties key-value pair (e.g., `oracle.net.ssl_server_dn_match`).
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools connection.
        :param pulumi.Input[_builtins.str] connection_string: (Updatable) The connect descriptor or Easy Connect Naming method use to connect to the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionKeyStoreArgs']]] key_stores: (Updatable) Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[_builtins.str] private_endpoint_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        :param pulumi.Input['DatabaseToolsConnectionProxyClientArgs'] proxy_client: (Updatable) The proxy client information.
        :param pulumi.Input['DatabaseToolsConnectionRelatedResourceArgs'] related_resource: (Updatable) The related resource
        :param pulumi.Input[_builtins.str] runtime_endpoint: Specifies the Database Tools Runtime endpoint.
        :param pulumi.Input[_builtins.str] runtime_identity: Specifies the identity used by the Database Tools service to issue requests to other Oracle Cloud Infrastructure services (e.g., Secrets in Vault).
        :param pulumi.Input[_builtins.str] runtime_support: Specifies whether this connection is supported by the Database Tools Runtime.
        :param pulumi.Input[_builtins.str] state: The current state of the Database Tools connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the Database Tools connection was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: (Updatable) The Database Tools connection type.
        :param pulumi.Input[_builtins.str] url: (Updatable) The JDBC URL used to connect to the Generic JDBC database system.
        :param pulumi.Input[_builtins.str] user_name: (Updatable) The database user name.
        :param pulumi.Input['DatabaseToolsConnectionUserPasswordArgs'] user_password: (Updatable) The database user password.
        """
        if advanced_properties is not None:
            pulumi.set(__self__, "advanced_properties", advanced_properties)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if key_stores is not None:
            pulumi.set(__self__, "key_stores", key_stores)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if private_endpoint_id is not None:
            pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if proxy_client is not None:
            pulumi.set(__self__, "proxy_client", proxy_client)
        if related_resource is not None:
            pulumi.set(__self__, "related_resource", related_resource)
        if runtime_endpoint is not None:
            pulumi.set(__self__, "runtime_endpoint", runtime_endpoint)
        if runtime_identity is not None:
            pulumi.set(__self__, "runtime_identity", runtime_identity)
        if runtime_support is not None:
            pulumi.set(__self__, "runtime_support", runtime_support)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)

    @_builtins.property
    @pulumi.getter(name="advancedProperties")
    def advanced_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The advanced connection properties key-value pair (e.g., `oracle.net.ssl_server_dn_match`).
        """
        return pulumi.get(self, "advanced_properties")

    @advanced_properties.setter
    def advanced_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "advanced_properties", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools connection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The connect descriptor or Easy Connect Naming method use to connect to the database.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="keyStores")
    def key_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionKeyStoreArgs']]]]:
        """
        (Updatable) Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        """
        return pulumi.get(self, "key_stores")

    @key_stores.setter
    def key_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionKeyStoreArgs']]]]):
        pulumi.set(self, "key_stores", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseToolsConnectionLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="proxyClient")
    def proxy_client(self) -> Optional[pulumi.Input['DatabaseToolsConnectionProxyClientArgs']]:
        """
        (Updatable) The proxy client information.
        """
        return pulumi.get(self, "proxy_client")

    @proxy_client.setter
    def proxy_client(self, value: Optional[pulumi.Input['DatabaseToolsConnectionProxyClientArgs']]):
        pulumi.set(self, "proxy_client", value)

    @_builtins.property
    @pulumi.getter(name="relatedResource")
    def related_resource(self) -> Optional[pulumi.Input['DatabaseToolsConnectionRelatedResourceArgs']]:
        """
        (Updatable) The related resource
        """
        return pulumi.get(self, "related_resource")

    @related_resource.setter
    def related_resource(self, value: Optional[pulumi.Input['DatabaseToolsConnectionRelatedResourceArgs']]):
        pulumi.set(self, "related_resource", value)

    @_builtins.property
    @pulumi.getter(name="runtimeEndpoint")
    def runtime_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Database Tools Runtime endpoint.
        """
        return pulumi.get(self, "runtime_endpoint")

    @runtime_endpoint.setter
    def runtime_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="runtimeIdentity")
    def runtime_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identity used by the Database Tools service to issue requests to other Oracle Cloud Infrastructure services (e.g., Secrets in Vault).
        """
        return pulumi.get(self, "runtime_identity")

    @runtime_identity.setter
    def runtime_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_identity", value)

    @_builtins.property
    @pulumi.getter(name="runtimeSupport")
    def runtime_support(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether this connection is supported by the Database Tools Runtime.
        """
        return pulumi.get(self, "runtime_support")

    @runtime_support.setter
    def runtime_support(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_support", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Database Tools connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the Database Tools connection was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Database Tools connection type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The JDBC URL used to connect to the Generic JDBC database system.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The database user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional[pulumi.Input['DatabaseToolsConnectionUserPasswordArgs']]:
        """
        (Updatable) The database user password.
        """
        return pulumi.get(self, "user_password")

    @user_password.setter
    def user_password(self, value: Optional[pulumi.Input['DatabaseToolsConnectionUserPasswordArgs']]):
        pulumi.set(self, "user_password", value)


@pulumi.type_token("oci:DatabaseTools/databaseToolsConnection:DatabaseToolsConnection")
class DatabaseToolsConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 key_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionKeyStoreArgs', 'DatabaseToolsConnectionKeyStoreArgsDict']]]]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionLockArgs', 'DatabaseToolsConnectionLockArgsDict']]]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_client: Optional[pulumi.Input[Union['DatabaseToolsConnectionProxyClientArgs', 'DatabaseToolsConnectionProxyClientArgsDict']]] = None,
                 related_resource: Optional[pulumi.Input[Union['DatabaseToolsConnectionRelatedResourceArgs', 'DatabaseToolsConnectionRelatedResourceArgsDict']]] = None,
                 runtime_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_support: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input[Union['DatabaseToolsConnectionUserPasswordArgs', 'DatabaseToolsConnectionUserPasswordArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        DatabaseToolsConnections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseTools/databaseToolsConnection:DatabaseToolsConnection test_database_tools_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] advanced_properties: (Updatable) The advanced connection properties key-value pair (e.g., `oracle.net.ssl_server_dn_match`).
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools connection.
        :param pulumi.Input[_builtins.str] connection_string: (Updatable) The connect descriptor or Easy Connect Naming method use to connect to the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionKeyStoreArgs', 'DatabaseToolsConnectionKeyStoreArgsDict']]]] key_stores: (Updatable) Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionLockArgs', 'DatabaseToolsConnectionLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[_builtins.str] private_endpoint_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        :param pulumi.Input[Union['DatabaseToolsConnectionProxyClientArgs', 'DatabaseToolsConnectionProxyClientArgsDict']] proxy_client: (Updatable) The proxy client information.
        :param pulumi.Input[Union['DatabaseToolsConnectionRelatedResourceArgs', 'DatabaseToolsConnectionRelatedResourceArgsDict']] related_resource: (Updatable) The related resource
        :param pulumi.Input[_builtins.str] runtime_identity: Specifies the identity used by the Database Tools service to issue requests to other Oracle Cloud Infrastructure services (e.g., Secrets in Vault).
        :param pulumi.Input[_builtins.str] runtime_support: Specifies whether this connection is supported by the Database Tools Runtime.
        :param pulumi.Input[_builtins.str] type: (Updatable) The Database Tools connection type.
        :param pulumi.Input[_builtins.str] url: (Updatable) The JDBC URL used to connect to the Generic JDBC database system.
        :param pulumi.Input[_builtins.str] user_name: (Updatable) The database user name.
        :param pulumi.Input[Union['DatabaseToolsConnectionUserPasswordArgs', 'DatabaseToolsConnectionUserPasswordArgsDict']] user_password: (Updatable) The database user password.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseToolsConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        DatabaseToolsConnections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseTools/databaseToolsConnection:DatabaseToolsConnection test_database_tools_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseToolsConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseToolsConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 key_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionKeyStoreArgs', 'DatabaseToolsConnectionKeyStoreArgsDict']]]]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionLockArgs', 'DatabaseToolsConnectionLockArgsDict']]]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_client: Optional[pulumi.Input[Union['DatabaseToolsConnectionProxyClientArgs', 'DatabaseToolsConnectionProxyClientArgsDict']]] = None,
                 related_resource: Optional[pulumi.Input[Union['DatabaseToolsConnectionRelatedResourceArgs', 'DatabaseToolsConnectionRelatedResourceArgsDict']]] = None,
                 runtime_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_support: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input[Union['DatabaseToolsConnectionUserPasswordArgs', 'DatabaseToolsConnectionUserPasswordArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseToolsConnectionArgs.__new__(DatabaseToolsConnectionArgs)

            __props__.__dict__["advanced_properties"] = advanced_properties
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connection_string"] = connection_string
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["key_stores"] = key_stores
            __props__.__dict__["locks"] = locks
            __props__.__dict__["private_endpoint_id"] = private_endpoint_id
            __props__.__dict__["proxy_client"] = proxy_client
            __props__.__dict__["related_resource"] = related_resource
            __props__.__dict__["runtime_identity"] = runtime_identity
            __props__.__dict__["runtime_support"] = runtime_support
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["url"] = url
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            if user_password is None and not opts.urn:
                raise TypeError("Missing required property 'user_password'")
            __props__.__dict__["user_password"] = user_password
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["runtime_endpoint"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DatabaseToolsConnection, __self__).__init__(
            'oci:DatabaseTools/databaseToolsConnection:DatabaseToolsConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            key_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionKeyStoreArgs', 'DatabaseToolsConnectionKeyStoreArgsDict']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionLockArgs', 'DatabaseToolsConnectionLockArgsDict']]]]] = None,
            private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_client: Optional[pulumi.Input[Union['DatabaseToolsConnectionProxyClientArgs', 'DatabaseToolsConnectionProxyClientArgsDict']]] = None,
            related_resource: Optional[pulumi.Input[Union['DatabaseToolsConnectionRelatedResourceArgs', 'DatabaseToolsConnectionRelatedResourceArgsDict']]] = None,
            runtime_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            runtime_identity: Optional[pulumi.Input[_builtins.str]] = None,
            runtime_support: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None,
            user_password: Optional[pulumi.Input[Union['DatabaseToolsConnectionUserPasswordArgs', 'DatabaseToolsConnectionUserPasswordArgsDict']]] = None) -> 'DatabaseToolsConnection':
        """
        Get an existing DatabaseToolsConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] advanced_properties: (Updatable) The advanced connection properties key-value pair (e.g., `oracle.net.ssl_server_dn_match`).
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools connection.
        :param pulumi.Input[_builtins.str] connection_string: (Updatable) The connect descriptor or Easy Connect Naming method use to connect to the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionKeyStoreArgs', 'DatabaseToolsConnectionKeyStoreArgsDict']]]] key_stores: (Updatable) Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseToolsConnectionLockArgs', 'DatabaseToolsConnectionLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[_builtins.str] private_endpoint_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        :param pulumi.Input[Union['DatabaseToolsConnectionProxyClientArgs', 'DatabaseToolsConnectionProxyClientArgsDict']] proxy_client: (Updatable) The proxy client information.
        :param pulumi.Input[Union['DatabaseToolsConnectionRelatedResourceArgs', 'DatabaseToolsConnectionRelatedResourceArgsDict']] related_resource: (Updatable) The related resource
        :param pulumi.Input[_builtins.str] runtime_endpoint: Specifies the Database Tools Runtime endpoint.
        :param pulumi.Input[_builtins.str] runtime_identity: Specifies the identity used by the Database Tools service to issue requests to other Oracle Cloud Infrastructure services (e.g., Secrets in Vault).
        :param pulumi.Input[_builtins.str] runtime_support: Specifies whether this connection is supported by the Database Tools Runtime.
        :param pulumi.Input[_builtins.str] state: The current state of the Database Tools connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the Database Tools connection was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: (Updatable) The Database Tools connection type.
        :param pulumi.Input[_builtins.str] url: (Updatable) The JDBC URL used to connect to the Generic JDBC database system.
        :param pulumi.Input[_builtins.str] user_name: (Updatable) The database user name.
        :param pulumi.Input[Union['DatabaseToolsConnectionUserPasswordArgs', 'DatabaseToolsConnectionUserPasswordArgsDict']] user_password: (Updatable) The database user password.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseToolsConnectionState.__new__(_DatabaseToolsConnectionState)

        __props__.__dict__["advanced_properties"] = advanced_properties
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["key_stores"] = key_stores
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["locks"] = locks
        __props__.__dict__["private_endpoint_id"] = private_endpoint_id
        __props__.__dict__["proxy_client"] = proxy_client
        __props__.__dict__["related_resource"] = related_resource
        __props__.__dict__["runtime_endpoint"] = runtime_endpoint
        __props__.__dict__["runtime_identity"] = runtime_identity
        __props__.__dict__["runtime_support"] = runtime_support
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["url"] = url
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["user_password"] = user_password
        return DatabaseToolsConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedProperties")
    def advanced_properties(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) The advanced connection properties key-value pair (e.g., `oracle.net.ssl_server_dn_match`).
        """
        return pulumi.get(self, "advanced_properties")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools connection.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The connect descriptor or Easy Connect Naming method use to connect to the database.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="keyStores")
    def key_stores(self) -> pulumi.Output[Sequence['outputs.DatabaseToolsConnectionKeyStore']]:
        """
        (Updatable) Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        """
        return pulumi.get(self, "key_stores")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Sequence['outputs.DatabaseToolsConnectionLock']]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        """
        return pulumi.get(self, "private_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="proxyClient")
    def proxy_client(self) -> pulumi.Output['outputs.DatabaseToolsConnectionProxyClient']:
        """
        (Updatable) The proxy client information.
        """
        return pulumi.get(self, "proxy_client")

    @_builtins.property
    @pulumi.getter(name="relatedResource")
    def related_resource(self) -> pulumi.Output['outputs.DatabaseToolsConnectionRelatedResource']:
        """
        (Updatable) The related resource
        """
        return pulumi.get(self, "related_resource")

    @_builtins.property
    @pulumi.getter(name="runtimeEndpoint")
    def runtime_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Database Tools Runtime endpoint.
        """
        return pulumi.get(self, "runtime_endpoint")

    @_builtins.property
    @pulumi.getter(name="runtimeIdentity")
    def runtime_identity(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identity used by the Database Tools service to issue requests to other Oracle Cloud Infrastructure services (e.g., Secrets in Vault).
        """
        return pulumi.get(self, "runtime_identity")

    @_builtins.property
    @pulumi.getter(name="runtimeSupport")
    def runtime_support(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether this connection is supported by the Database Tools Runtime.
        """
        return pulumi.get(self, "runtime_support")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Database Tools connection.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the Database Tools connection was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The Database Tools connection type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The JDBC URL used to connect to the Generic JDBC database system.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The database user name.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> pulumi.Output['outputs.DatabaseToolsConnectionUserPassword']:
        """
        (Updatable) The database user password.
        """
        return pulumi.get(self, "user_password")

