# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseToolsIdentitiesResult',
    'AwaitableGetDatabaseToolsIdentitiesResult',
    'get_database_tools_identities',
    'get_database_tools_identities_output',
]

@pulumi.output_type
class GetDatabaseToolsIdentitiesResult:
    """
    A collection of values returned by getDatabaseToolsIdentities.
    """
    def __init__(__self__, compartment_id=None, database_tools_connection_id=None, database_tools_identity_collections=None, display_name=None, filters=None, id=None, state=None, types=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_tools_connection_id and not isinstance(database_tools_connection_id, str):
            raise TypeError("Expected argument 'database_tools_connection_id' to be a str")
        pulumi.set(__self__, "database_tools_connection_id", database_tools_connection_id)
        if database_tools_identity_collections and not isinstance(database_tools_identity_collections, list):
            raise TypeError("Expected argument 'database_tools_identity_collections' to be a list")
        pulumi.set(__self__, "database_tools_identity_collections", database_tools_identity_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools identity.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="databaseToolsConnectionId")
    def database_tools_connection_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Database Tools connection.
        """
        return pulumi.get(self, "database_tools_connection_id")

    @_builtins.property
    @pulumi.getter(name="databaseToolsIdentityCollections")
    def database_tools_identity_collections(self) -> Sequence['outputs.GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionResult']:
        """
        The list of database_tools_identity_collection.
        """
        return pulumi.get(self, "database_tools_identity_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseToolsIdentitiesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Database Tools identity.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The Database Tools identity type.
        """
        return pulumi.get(self, "types")


class AwaitableGetDatabaseToolsIdentitiesResult(GetDatabaseToolsIdentitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseToolsIdentitiesResult(
            compartment_id=self.compartment_id,
            database_tools_connection_id=self.database_tools_connection_id,
            database_tools_identity_collections=self.database_tools_identity_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            types=self.types)


def get_database_tools_identities(compartment_id: Optional[_builtins.str] = None,
                                  database_tools_connection_id: Optional[_builtins.str] = None,
                                  display_name: Optional[_builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetDatabaseToolsIdentitiesFilterArgs', 'GetDatabaseToolsIdentitiesFilterArgsDict']]] = None,
                                  state: Optional[_builtins.str] = None,
                                  types: Optional[Sequence[_builtins.str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseToolsIdentitiesResult:
    """
    This data source provides the list of Database Tools Identities in Oracle Cloud Infrastructure Database Tools service.

    Returns a list of Database Tools identities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_identities = oci.DatabaseTools.get_database_tools_identities(compartment_id=compartment_id,
        database_tools_connection_id=test_database_tools_connection["id"],
        display_name=database_tools_identity_display_name,
        state=database_tools_identity_state,
        types=database_tools_identity_type)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str database_tools_connection_id: A filter to return only resources when their `databaseToolsConnectionId` matches the specified `databaseToolsConnectionId`.
    :param _builtins.str display_name: A filter to return only resources that match the entire specified display name.
    :param _builtins.str state: A filter to return resources only when their `databaseToolsIdentityLifecycleState` matches the specified `databaseToolsIdentityLifecycleState`.
    :param Sequence[_builtins.str] types: A filter to return only resources with one of the specified type values.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseToolsConnectionId'] = database_tools_connection_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['types'] = types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseTools/getDatabaseToolsIdentities:getDatabaseToolsIdentities', __args__, opts=opts, typ=GetDatabaseToolsIdentitiesResult).value

    return AwaitableGetDatabaseToolsIdentitiesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_tools_connection_id=pulumi.get(__ret__, 'database_tools_connection_id'),
        database_tools_identity_collections=pulumi.get(__ret__, 'database_tools_identity_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        types=pulumi.get(__ret__, 'types'))
def get_database_tools_identities_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         database_tools_connection_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabaseToolsIdentitiesFilterArgs', 'GetDatabaseToolsIdentitiesFilterArgsDict']]]]] = None,
                                         state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseToolsIdentitiesResult]:
    """
    This data source provides the list of Database Tools Identities in Oracle Cloud Infrastructure Database Tools service.

    Returns a list of Database Tools identities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_identities = oci.DatabaseTools.get_database_tools_identities(compartment_id=compartment_id,
        database_tools_connection_id=test_database_tools_connection["id"],
        display_name=database_tools_identity_display_name,
        state=database_tools_identity_state,
        types=database_tools_identity_type)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str database_tools_connection_id: A filter to return only resources when their `databaseToolsConnectionId` matches the specified `databaseToolsConnectionId`.
    :param _builtins.str display_name: A filter to return only resources that match the entire specified display name.
    :param _builtins.str state: A filter to return resources only when their `databaseToolsIdentityLifecycleState` matches the specified `databaseToolsIdentityLifecycleState`.
    :param Sequence[_builtins.str] types: A filter to return only resources with one of the specified type values.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseToolsConnectionId'] = database_tools_connection_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['types'] = types
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseTools/getDatabaseToolsIdentities:getDatabaseToolsIdentities', __args__, opts=opts, typ=GetDatabaseToolsIdentitiesResult)
    return __ret__.apply(lambda __response__: GetDatabaseToolsIdentitiesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_tools_connection_id=pulumi.get(__response__, 'database_tools_connection_id'),
        database_tools_identity_collections=pulumi.get(__response__, 'database_tools_identity_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        types=pulumi.get(__response__, 'types')))
