# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabaseToolsIdentityResult',
    'AwaitableGetDatabaseToolsIdentityResult',
    'get_database_tools_identity',
    'get_database_tools_identity_output',
]

@pulumi.output_type
class GetDatabaseToolsIdentityResult:
    """
    A collection of values returned by getDatabaseToolsIdentity.
    """
    def __init__(__self__, compartment_id=None, credential_key=None, database_tools_connection_id=None, database_tools_identity_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, locks=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if credential_key and not isinstance(credential_key, str):
            raise TypeError("Expected argument 'credential_key' to be a str")
        pulumi.set(__self__, "credential_key", credential_key)
        if database_tools_connection_id and not isinstance(database_tools_connection_id, str):
            raise TypeError("Expected argument 'database_tools_connection_id' to be a str")
        pulumi.set(__self__, "database_tools_connection_id", database_tools_connection_id)
        if database_tools_identity_id and not isinstance(database_tools_identity_id, str):
            raise TypeError("Expected argument 'database_tools_identity_id' to be a str")
        pulumi.set(__self__, "database_tools_identity_id", database_tools_identity_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools identity.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="credentialKey")
    def credential_key(self) -> _builtins.str:
        """
        The name of the credential object created in the Oracle Database.
        """
        return pulumi.get(self, "credential_key")

    @_builtins.property
    @pulumi.getter(name="databaseToolsConnectionId")
    def database_tools_connection_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Database Tools connection.
        """
        return pulumi.get(self, "database_tools_connection_id")

    @_builtins.property
    @pulumi.getter(name="databaseToolsIdentityId")
    def database_tools_identity_id(self) -> _builtins.str:
        return pulumi.get(self, "database_tools_identity_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools identity.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetDatabaseToolsIdentityLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Database Tools identity.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools identity was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Database Tools identity was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Database Tools identity type.
        """
        return pulumi.get(self, "type")


class AwaitableGetDatabaseToolsIdentityResult(GetDatabaseToolsIdentityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseToolsIdentityResult(
            compartment_id=self.compartment_id,
            credential_key=self.credential_key,
            database_tools_connection_id=self.database_tools_connection_id,
            database_tools_identity_id=self.database_tools_identity_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            locks=self.locks,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_database_tools_identity(database_tools_identity_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseToolsIdentityResult:
    """
    This data source provides details about a specific Database Tools Identity resource in Oracle Cloud Infrastructure Database Tools service.

    Gets details of the specified Database Tools identity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_identity = oci.DatabaseTools.get_database_tools_identity(database_tools_identity_id=test_database_tools_identity_oci_database_tools_database_tools_identity["id"])
    ```


    :param _builtins.str database_tools_identity_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Database Tools identity.
    """
    __args__ = dict()
    __args__['databaseToolsIdentityId'] = database_tools_identity_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseTools/getDatabaseToolsIdentity:getDatabaseToolsIdentity', __args__, opts=opts, typ=GetDatabaseToolsIdentityResult).value

    return AwaitableGetDatabaseToolsIdentityResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        credential_key=pulumi.get(__ret__, 'credential_key'),
        database_tools_connection_id=pulumi.get(__ret__, 'database_tools_connection_id'),
        database_tools_identity_id=pulumi.get(__ret__, 'database_tools_identity_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        locks=pulumi.get(__ret__, 'locks'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_database_tools_identity_output(database_tools_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseToolsIdentityResult]:
    """
    This data source provides details about a specific Database Tools Identity resource in Oracle Cloud Infrastructure Database Tools service.

    Gets details of the specified Database Tools identity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_identity = oci.DatabaseTools.get_database_tools_identity(database_tools_identity_id=test_database_tools_identity_oci_database_tools_database_tools_identity["id"])
    ```


    :param _builtins.str database_tools_identity_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Database Tools identity.
    """
    __args__ = dict()
    __args__['databaseToolsIdentityId'] = database_tools_identity_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseTools/getDatabaseToolsIdentity:getDatabaseToolsIdentity', __args__, opts=opts, typ=GetDatabaseToolsIdentityResult)
    return __ret__.apply(lambda __response__: GetDatabaseToolsIdentityResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        credential_key=pulumi.get(__response__, 'credential_key'),
        database_tools_connection_id=pulumi.get(__response__, 'database_tools_connection_id'),
        database_tools_identity_id=pulumi.get(__response__, 'database_tools_identity_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        locks=pulumi.get(__response__, 'locks'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
