# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseToolsPrivateEndpointsResult',
    'AwaitableGetDatabaseToolsPrivateEndpointsResult',
    'get_database_tools_private_endpoints',
    'get_database_tools_private_endpoints_output',
]

@pulumi.output_type
class GetDatabaseToolsPrivateEndpointsResult:
    """
    A collection of values returned by getDatabaseToolsPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, database_tools_private_endpoint_collections=None, display_name=None, endpoint_service_id=None, filters=None, id=None, state=None, subnet_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_tools_private_endpoint_collections and not isinstance(database_tools_private_endpoint_collections, list):
            raise TypeError("Expected argument 'database_tools_private_endpoint_collections' to be a list")
        pulumi.set(__self__, "database_tools_private_endpoint_collections", database_tools_private_endpoint_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoint_service_id and not isinstance(endpoint_service_id, str):
            raise TypeError("Expected argument 'endpoint_service_id' to be a str")
        pulumi.set(__self__, "endpoint_service_id", endpoint_service_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools private endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="databaseToolsPrivateEndpointCollections")
    def database_tools_private_endpoint_collections(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionResult']:
        """
        The list of database_tools_private_endpoint_collection.
        """
        return pulumi.get(self, "database_tools_private_endpoint_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="endpointServiceId")
    def endpoint_service_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools Endpoint Service.
        """
        return pulumi.get(self, "endpoint_service_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseToolsPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Database Tools private endpoint.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        """
        return pulumi.get(self, "subnet_id")


class AwaitableGetDatabaseToolsPrivateEndpointsResult(GetDatabaseToolsPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseToolsPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            database_tools_private_endpoint_collections=self.database_tools_private_endpoint_collections,
            display_name=self.display_name,
            endpoint_service_id=self.endpoint_service_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            subnet_id=self.subnet_id)


def get_database_tools_private_endpoints(compartment_id: Optional[_builtins.str] = None,
                                         display_name: Optional[_builtins.str] = None,
                                         endpoint_service_id: Optional[_builtins.str] = None,
                                         filters: Optional[Sequence[Union['GetDatabaseToolsPrivateEndpointsFilterArgs', 'GetDatabaseToolsPrivateEndpointsFilterArgsDict']]] = None,
                                         state: Optional[_builtins.str] = None,
                                         subnet_id: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseToolsPrivateEndpointsResult:
    """
    This data source provides the list of Database Tools Private Endpoints in Oracle Cloud Infrastructure Database Tools service.

    Returns a list of Database Tools private endpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_private_endpoints = oci.DatabaseTools.get_database_tools_private_endpoints(compartment_id=compartment_id,
        display_name=database_tools_private_endpoint_display_name,
        endpoint_service_id=test_service["id"],
        state=database_tools_private_endpoint_state,
        subnet_id=test_subnet["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire specified display name.
    :param _builtins.str endpoint_service_id: A filter to return only resources their `endpointServiceId` matches the specified `endpointServiceId`.
    :param _builtins.str state: A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
    :param _builtins.str subnet_id: A filter to return only resources their `subnetId` matches the specified `subnetId`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['endpointServiceId'] = endpoint_service_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['subnetId'] = subnet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseTools/getDatabaseToolsPrivateEndpoints:getDatabaseToolsPrivateEndpoints', __args__, opts=opts, typ=GetDatabaseToolsPrivateEndpointsResult).value

    return AwaitableGetDatabaseToolsPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_tools_private_endpoint_collections=pulumi.get(__ret__, 'database_tools_private_endpoint_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoint_service_id=pulumi.get(__ret__, 'endpoint_service_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'))
def get_database_tools_private_endpoints_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                endpoint_service_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabaseToolsPrivateEndpointsFilterArgs', 'GetDatabaseToolsPrivateEndpointsFilterArgsDict']]]]] = None,
                                                state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseToolsPrivateEndpointsResult]:
    """
    This data source provides the list of Database Tools Private Endpoints in Oracle Cloud Infrastructure Database Tools service.

    Returns a list of Database Tools private endpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_private_endpoints = oci.DatabaseTools.get_database_tools_private_endpoints(compartment_id=compartment_id,
        display_name=database_tools_private_endpoint_display_name,
        endpoint_service_id=test_service["id"],
        state=database_tools_private_endpoint_state,
        subnet_id=test_subnet["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire specified display name.
    :param _builtins.str endpoint_service_id: A filter to return only resources their `endpointServiceId` matches the specified `endpointServiceId`.
    :param _builtins.str state: A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
    :param _builtins.str subnet_id: A filter to return only resources their `subnetId` matches the specified `subnetId`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['endpointServiceId'] = endpoint_service_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['subnetId'] = subnet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseTools/getDatabaseToolsPrivateEndpoints:getDatabaseToolsPrivateEndpoints', __args__, opts=opts, typ=GetDatabaseToolsPrivateEndpointsResult)
    return __ret__.apply(lambda __response__: GetDatabaseToolsPrivateEndpointsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_tools_private_endpoint_collections=pulumi.get(__response__, 'database_tools_private_endpoint_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        endpoint_service_id=pulumi.get(__response__, 'endpoint_service_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id')))
