# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseToolsConnectionKeyStore',
    'DatabaseToolsConnectionKeyStoreKeyStoreContent',
    'DatabaseToolsConnectionKeyStoreKeyStorePassword',
    'DatabaseToolsConnectionLock',
    'DatabaseToolsConnectionProxyClient',
    'DatabaseToolsConnectionProxyClientUserPassword',
    'DatabaseToolsConnectionRelatedResource',
    'DatabaseToolsConnectionUserPassword',
    'DatabaseToolsIdentityLock',
    'DatabaseToolsPrivateEndpointLock',
    'DatabaseToolsPrivateEndpointReverseConnectionConfiguration',
    'DatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIp',
    'GetDatabaseToolsConnectionKeyStoreResult',
    'GetDatabaseToolsConnectionKeyStoreKeyStoreContentResult',
    'GetDatabaseToolsConnectionKeyStoreKeyStorePasswordResult',
    'GetDatabaseToolsConnectionLockResult',
    'GetDatabaseToolsConnectionProxyClientResult',
    'GetDatabaseToolsConnectionProxyClientUserPasswordResult',
    'GetDatabaseToolsConnectionRelatedResourceResult',
    'GetDatabaseToolsConnectionUserPasswordResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStoreContentResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStorePasswordResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemLockResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientUserPasswordResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemRelatedResourceResult',
    'GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemUserPasswordResult',
    'GetDatabaseToolsConnectionsFilterResult',
    'GetDatabaseToolsEndpointServicesDatabaseToolsEndpointServiceCollectionResult',
    'GetDatabaseToolsEndpointServicesDatabaseToolsEndpointServiceCollectionItemResult',
    'GetDatabaseToolsEndpointServicesFilterResult',
    'GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionResult',
    'GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemResult',
    'GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemLockResult',
    'GetDatabaseToolsIdentitiesFilterResult',
    'GetDatabaseToolsIdentityLockResult',
    'GetDatabaseToolsPrivateEndpointLockResult',
    'GetDatabaseToolsPrivateEndpointReverseConnectionConfigurationResult',
    'GetDatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIpResult',
    'GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionResult',
    'GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemResult',
    'GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemLockResult',
    'GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationResult',
    'GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationReverseConnectionsSourceIpResult',
    'GetDatabaseToolsPrivateEndpointsFilterResult',
]

@pulumi.output_type
class DatabaseToolsConnectionKeyStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyStoreContent":
            suggest = "key_store_content"
        elif key == "keyStorePassword":
            suggest = "key_store_password"
        elif key == "keyStoreType":
            suggest = "key_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsConnectionKeyStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsConnectionKeyStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsConnectionKeyStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_store_content: Optional['outputs.DatabaseToolsConnectionKeyStoreKeyStoreContent'] = None,
                 key_store_password: Optional['outputs.DatabaseToolsConnectionKeyStoreKeyStorePassword'] = None,
                 key_store_type: Optional[_builtins.str] = None):
        """
        :param 'DatabaseToolsConnectionKeyStoreKeyStoreContentArgs' key_store_content: (Updatable) The key store content.
        :param 'DatabaseToolsConnectionKeyStoreKeyStorePasswordArgs' key_store_password: (Updatable) The key store password.
        :param _builtins.str key_store_type: (Updatable) The key store type.
        """
        if key_store_content is not None:
            pulumi.set(__self__, "key_store_content", key_store_content)
        if key_store_password is not None:
            pulumi.set(__self__, "key_store_password", key_store_password)
        if key_store_type is not None:
            pulumi.set(__self__, "key_store_type", key_store_type)

    @_builtins.property
    @pulumi.getter(name="keyStoreContent")
    def key_store_content(self) -> Optional['outputs.DatabaseToolsConnectionKeyStoreKeyStoreContent']:
        """
        (Updatable) The key store content.
        """
        return pulumi.get(self, "key_store_content")

    @_builtins.property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> Optional['outputs.DatabaseToolsConnectionKeyStoreKeyStorePassword']:
        """
        (Updatable) The key store password.
        """
        return pulumi.get(self, "key_store_password")

    @_builtins.property
    @pulumi.getter(name="keyStoreType")
    def key_store_type(self) -> Optional[_builtins.str]:
        """
        (Updatable) The key store type.
        """
        return pulumi.get(self, "key_store_type")


@pulumi.output_type
class DatabaseToolsConnectionKeyStoreKeyStoreContent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"
        elif key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsConnectionKeyStoreKeyStoreContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsConnectionKeyStoreKeyStoreContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsConnectionKeyStoreKeyStoreContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value_type: _builtins.str,
                 secret_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str value_type: (Updatable) The value type of the key store content.
        :param _builtins.str secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the key store.
        """
        pulumi.set(__self__, "value_type", value_type)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        (Updatable) The value type of the key store content.
        """
        return pulumi.get(self, "value_type")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the key store.
        """
        return pulumi.get(self, "secret_id")


@pulumi.output_type
class DatabaseToolsConnectionKeyStoreKeyStorePassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"
        elif key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsConnectionKeyStoreKeyStorePassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsConnectionKeyStoreKeyStorePassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsConnectionKeyStoreKeyStorePassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value_type: _builtins.str,
                 secret_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str value_type: (Updatable) The value type of the key store password.
        :param _builtins.str secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the key store password.
        """
        pulumi.set(__self__, "value_type", value_type)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        (Updatable) The value type of the key store password.
        """
        return pulumi.get(self, "value_type")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the key store password.
        """
        return pulumi.get(self, "secret_id")


@pulumi.output_type
class DatabaseToolsConnectionLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsConnectionLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsConnectionLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsConnectionLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of the lock.
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class DatabaseToolsConnectionProxyClient(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyAuthenticationType":
            suggest = "proxy_authentication_type"
        elif key == "userName":
            suggest = "user_name"
        elif key == "userPassword":
            suggest = "user_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsConnectionProxyClient. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsConnectionProxyClient.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsConnectionProxyClient.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_authentication_type: _builtins.str,
                 roles: Optional[Sequence[_builtins.str]] = None,
                 user_name: Optional[_builtins.str] = None,
                 user_password: Optional['outputs.DatabaseToolsConnectionProxyClientUserPassword'] = None):
        """
        :param _builtins.str proxy_authentication_type: (Updatable) The proxy authentication type.
        :param Sequence[_builtins.str] roles: (Updatable) A list of database roles for the client. These roles are enabled if the proxy is authorized to use the roles on behalf of the client.
        :param _builtins.str user_name: (Updatable) The user name.
        :param 'DatabaseToolsConnectionProxyClientUserPasswordArgs' user_password: (Updatable) The database user password.
        """
        pulumi.set(__self__, "proxy_authentication_type", proxy_authentication_type)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)

    @_builtins.property
    @pulumi.getter(name="proxyAuthenticationType")
    def proxy_authentication_type(self) -> _builtins.str:
        """
        (Updatable) The proxy authentication type.
        """
        return pulumi.get(self, "proxy_authentication_type")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) A list of database roles for the client. These roles are enabled if the proxy is authorized to use the roles on behalf of the client.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The user name.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional['outputs.DatabaseToolsConnectionProxyClientUserPassword']:
        """
        (Updatable) The database user password.
        """
        return pulumi.get(self, "user_password")


@pulumi.output_type
class DatabaseToolsConnectionProxyClientUserPassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"
        elif key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsConnectionProxyClientUserPassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsConnectionProxyClientUserPassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsConnectionProxyClientUserPassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: (Updatable) The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        (Updatable) The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class DatabaseToolsConnectionRelatedResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityType":
            suggest = "entity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsConnectionRelatedResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsConnectionRelatedResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsConnectionRelatedResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_type: Optional[_builtins.str] = None,
                 identifier: Optional[_builtins.str] = None):
        """
        :param _builtins.str entity_type: (Updatable) The resource entity type.
        :param _builtins.str identifier: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related resource.
        """
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[_builtins.str]:
        """
        (Updatable) The resource entity type.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related resource.
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class DatabaseToolsConnectionUserPassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"
        elif key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsConnectionUserPassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsConnectionUserPassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsConnectionUserPassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: (Updatable) The value type of the user password.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        (Updatable) The value type of the user password.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class DatabaseToolsIdentityLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsIdentityLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsIdentityLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsIdentityLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of the lock.
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class DatabaseToolsPrivateEndpointLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsPrivateEndpointLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsPrivateEndpointLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsPrivateEndpointLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of the lock.
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class DatabaseToolsPrivateEndpointReverseConnectionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reverseConnectionsSourceIps":
            suggest = "reverse_connections_source_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsPrivateEndpointReverseConnectionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsPrivateEndpointReverseConnectionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsPrivateEndpointReverseConnectionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reverse_connections_source_ips: Optional[Sequence['outputs.DatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIp']] = None):
        """
        :param Sequence['DatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIpArgs'] reverse_connections_source_ips: A list of IP addresses in the customer VCN to be used as the source IPs for reverse connection packets traveling from the service's VCN to the customer's VCN.
        """
        if reverse_connections_source_ips is not None:
            pulumi.set(__self__, "reverse_connections_source_ips", reverse_connections_source_ips)

    @_builtins.property
    @pulumi.getter(name="reverseConnectionsSourceIps")
    def reverse_connections_source_ips(self) -> Optional[Sequence['outputs.DatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIp']]:
        """
        A list of IP addresses in the customer VCN to be used as the source IPs for reverse connection packets traveling from the service's VCN to the customer's VCN.
        """
        return pulumi.get(self, "reverse_connections_source_ips")


@pulumi.output_type
class DatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceIp":
            suggest = "source_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str source_ip: The IP address in the customer's VCN to be used as the source IP for reverse connection packets traveling from the customer's VCN to the service's VCN.
        """
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[_builtins.str]:
        """
        The IP address in the customer's VCN to be used as the source IP for reverse connection packets traveling from the customer's VCN to the service's VCN.
        """
        return pulumi.get(self, "source_ip")


@pulumi.output_type
class GetDatabaseToolsConnectionKeyStoreResult(dict):
    def __init__(__self__, *,
                 key_store_contents: Sequence['outputs.GetDatabaseToolsConnectionKeyStoreKeyStoreContentResult'],
                 key_store_passwords: Sequence['outputs.GetDatabaseToolsConnectionKeyStoreKeyStorePasswordResult'],
                 key_store_type: _builtins.str):
        """
        :param Sequence['GetDatabaseToolsConnectionKeyStoreKeyStoreContentArgs'] key_store_contents: The key store content.
        :param Sequence['GetDatabaseToolsConnectionKeyStoreKeyStorePasswordArgs'] key_store_passwords: The key store password.
        :param _builtins.str key_store_type: The key store type.
        """
        pulumi.set(__self__, "key_store_contents", key_store_contents)
        pulumi.set(__self__, "key_store_passwords", key_store_passwords)
        pulumi.set(__self__, "key_store_type", key_store_type)

    @_builtins.property
    @pulumi.getter(name="keyStoreContents")
    def key_store_contents(self) -> Sequence['outputs.GetDatabaseToolsConnectionKeyStoreKeyStoreContentResult']:
        """
        The key store content.
        """
        return pulumi.get(self, "key_store_contents")

    @_builtins.property
    @pulumi.getter(name="keyStorePasswords")
    def key_store_passwords(self) -> Sequence['outputs.GetDatabaseToolsConnectionKeyStoreKeyStorePasswordResult']:
        """
        The key store password.
        """
        return pulumi.get(self, "key_store_passwords")

    @_builtins.property
    @pulumi.getter(name="keyStoreType")
    def key_store_type(self) -> _builtins.str:
        """
        The key store type.
        """
        return pulumi.get(self, "key_store_type")


@pulumi.output_type
class GetDatabaseToolsConnectionKeyStoreKeyStoreContentResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDatabaseToolsConnectionKeyStoreKeyStorePasswordResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDatabaseToolsConnectionLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        :param _builtins.str type: The Database Tools connection type.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Database Tools connection type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseToolsConnectionProxyClientResult(dict):
    def __init__(__self__, *,
                 proxy_authentication_type: _builtins.str,
                 roles: Sequence[_builtins.str],
                 user_name: _builtins.str,
                 user_passwords: Sequence['outputs.GetDatabaseToolsConnectionProxyClientUserPasswordResult']):
        """
        :param _builtins.str proxy_authentication_type: The proxy authentication type.
        :param Sequence[_builtins.str] roles: A list of database roles for the client. These roles are enabled if the proxy is authorized to use the roles on behalf of the client.
        :param _builtins.str user_name: The database user name.
        :param Sequence['GetDatabaseToolsConnectionProxyClientUserPasswordArgs'] user_passwords: The database user password.
        """
        pulumi.set(__self__, "proxy_authentication_type", proxy_authentication_type)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_passwords", user_passwords)

    @_builtins.property
    @pulumi.getter(name="proxyAuthenticationType")
    def proxy_authentication_type(self) -> _builtins.str:
        """
        The proxy authentication type.
        """
        return pulumi.get(self, "proxy_authentication_type")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        A list of database roles for the client. These roles are enabled if the proxy is authorized to use the roles on behalf of the client.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The database user name.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userPasswords")
    def user_passwords(self) -> Sequence['outputs.GetDatabaseToolsConnectionProxyClientUserPasswordResult']:
        """
        The database user password.
        """
        return pulumi.get(self, "user_passwords")


@pulumi.output_type
class GetDatabaseToolsConnectionProxyClientUserPasswordResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDatabaseToolsConnectionRelatedResourceResult(dict):
    def __init__(__self__, *,
                 entity_type: _builtins.str,
                 identifier: _builtins.str):
        """
        :param _builtins.str entity_type: The resource entity type.
        :param _builtins.str identifier: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related resource.
        """
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "identifier", identifier)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        The resource entity type.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related resource.
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class GetDatabaseToolsConnectionUserPasswordResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemResult(dict):
    def __init__(__self__, *,
                 advanced_properties: Mapping[str, _builtins.str],
                 compartment_id: _builtins.str,
                 connection_string: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 key_stores: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreResult'],
                 lifecycle_details: _builtins.str,
                 locks: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemLockResult'],
                 private_endpoint_id: _builtins.str,
                 proxy_clients: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientResult'],
                 related_resources: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemRelatedResourceResult'],
                 runtime_endpoint: _builtins.str,
                 runtime_identity: _builtins.str,
                 runtime_support: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 type: _builtins.str,
                 url: _builtins.str,
                 user_name: _builtins.str,
                 user_passwords: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemUserPasswordResult']):
        """
        :param Mapping[str, _builtins.str] advanced_properties: The advanced connection properties key-value pair (for example, `oracle.net.ssl_server_dn_match`).
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param _builtins.str connection_string: The connect descriptor or Easy Connect Naming method used to connect to the database.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire specified display name.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools connection.
        :param Sequence['GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreArgs'] key_stores: The Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        :param Sequence['GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemLockArgs'] locks: Locks associated with this resource.
        :param _builtins.str private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        :param Sequence['GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientArgs'] proxy_clients: The proxy client information.
        :param Sequence['GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemRelatedResourceArgs'] related_resources: A related resource
        :param _builtins.str runtime_endpoint: Specifies the Database Tools Runtime endpoint.
        :param _builtins.str runtime_identity: A filter to return only resources with one of the specified runtimeIdentity values.
        :param _builtins.str runtime_support: A filter to return only resources with one of the specified type values.
        :param _builtins.str state: A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time the Database Tools connection was updated. An RFC3339 formatted datetime string.
        :param _builtins.str type: A filter to return only resources their type matches the specified type.
        :param _builtins.str url: The JDBC URL used to connect to the Generic JDBC database system.
        :param _builtins.str user_name: The database user name.
        :param Sequence['GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemUserPasswordArgs'] user_passwords: The database user password.
        """
        pulumi.set(__self__, "advanced_properties", advanced_properties)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_stores", key_stores)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "proxy_clients", proxy_clients)
        pulumi.set(__self__, "related_resources", related_resources)
        pulumi.set(__self__, "runtime_endpoint", runtime_endpoint)
        pulumi.set(__self__, "runtime_identity", runtime_identity)
        pulumi.set(__self__, "runtime_support", runtime_support)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_passwords", user_passwords)

    @_builtins.property
    @pulumi.getter(name="advancedProperties")
    def advanced_properties(self) -> Mapping[str, _builtins.str]:
        """
        The advanced connection properties key-value pair (for example, `oracle.net.ssl_server_dn_match`).
        """
        return pulumi.get(self, "advanced_properties")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> _builtins.str:
        """
        The connect descriptor or Easy Connect Naming method used to connect to the database.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire specified display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyStores")
    def key_stores(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreResult']:
        """
        The Oracle wallet or Java Keystores containing trusted certificates for authenticating the server's public certificate and the client private key and associated certificates required for client authentication.
        """
        return pulumi.get(self, "key_stores")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint used to access the database in the customer VCN.
        """
        return pulumi.get(self, "private_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="proxyClients")
    def proxy_clients(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientResult']:
        """
        The proxy client information.
        """
        return pulumi.get(self, "proxy_clients")

    @_builtins.property
    @pulumi.getter(name="relatedResources")
    def related_resources(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemRelatedResourceResult']:
        """
        A related resource
        """
        return pulumi.get(self, "related_resources")

    @_builtins.property
    @pulumi.getter(name="runtimeEndpoint")
    def runtime_endpoint(self) -> _builtins.str:
        """
        Specifies the Database Tools Runtime endpoint.
        """
        return pulumi.get(self, "runtime_endpoint")

    @_builtins.property
    @pulumi.getter(name="runtimeIdentity")
    def runtime_identity(self) -> _builtins.str:
        """
        A filter to return only resources with one of the specified runtimeIdentity values.
        """
        return pulumi.get(self, "runtime_identity")

    @_builtins.property
    @pulumi.getter(name="runtimeSupport")
    def runtime_support(self) -> _builtins.str:
        """
        A filter to return only resources with one of the specified type values.
        """
        return pulumi.get(self, "runtime_support")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Database Tools connection was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        A filter to return only resources their type matches the specified type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The JDBC URL used to connect to the Generic JDBC database system.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The database user name.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userPasswords")
    def user_passwords(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemUserPasswordResult']:
        """
        The database user password.
        """
        return pulumi.get(self, "user_passwords")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreResult(dict):
    def __init__(__self__, *,
                 key_store_contents: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStoreContentResult'],
                 key_store_passwords: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStorePasswordResult'],
                 key_store_type: _builtins.str):
        """
        :param Sequence['GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStoreContentArgs'] key_store_contents: The key store content.
        :param Sequence['GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStorePasswordArgs'] key_store_passwords: The key store password.
        :param _builtins.str key_store_type: The key store type.
        """
        pulumi.set(__self__, "key_store_contents", key_store_contents)
        pulumi.set(__self__, "key_store_passwords", key_store_passwords)
        pulumi.set(__self__, "key_store_type", key_store_type)

    @_builtins.property
    @pulumi.getter(name="keyStoreContents")
    def key_store_contents(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStoreContentResult']:
        """
        The key store content.
        """
        return pulumi.get(self, "key_store_contents")

    @_builtins.property
    @pulumi.getter(name="keyStorePasswords")
    def key_store_passwords(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStorePasswordResult']:
        """
        The key store password.
        """
        return pulumi.get(self, "key_store_passwords")

    @_builtins.property
    @pulumi.getter(name="keyStoreType")
    def key_store_type(self) -> _builtins.str:
        """
        The key store type.
        """
        return pulumi.get(self, "key_store_type")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStoreContentResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemKeyStoreKeyStorePasswordResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        :param _builtins.str type: A filter to return only resources their type matches the specified type.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools connection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        A filter to return only resources their type matches the specified type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientResult(dict):
    def __init__(__self__, *,
                 proxy_authentication_type: _builtins.str,
                 roles: Sequence[_builtins.str],
                 user_name: _builtins.str,
                 user_passwords: Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientUserPasswordResult']):
        """
        :param _builtins.str proxy_authentication_type: The proxy authentication type.
        :param Sequence[_builtins.str] roles: A list of database roles for the client. These roles are enabled if the proxy is authorized to use the roles on behalf of the client.
        :param _builtins.str user_name: The database user name.
        :param Sequence['GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientUserPasswordArgs'] user_passwords: The database user password.
        """
        pulumi.set(__self__, "proxy_authentication_type", proxy_authentication_type)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_passwords", user_passwords)

    @_builtins.property
    @pulumi.getter(name="proxyAuthenticationType")
    def proxy_authentication_type(self) -> _builtins.str:
        """
        The proxy authentication type.
        """
        return pulumi.get(self, "proxy_authentication_type")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        A list of database roles for the client. These roles are enabled if the proxy is authorized to use the roles on behalf of the client.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The database user name.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userPasswords")
    def user_passwords(self) -> Sequence['outputs.GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientUserPasswordResult']:
        """
        The database user password.
        """
        return pulumi.get(self, "user_passwords")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemProxyClientUserPasswordResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemRelatedResourceResult(dict):
    def __init__(__self__, *,
                 entity_type: _builtins.str,
                 identifier: _builtins.str):
        """
        :param _builtins.str entity_type: The resource entity type.
        :param _builtins.str identifier: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related resource.
        """
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "identifier", identifier)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        The resource entity type.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related resource.
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class GetDatabaseToolsConnectionsDatabaseToolsConnectionCollectionItemUserPasswordResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        :param _builtins.str value_type: The value type of the user password.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret containing the user password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the user password.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDatabaseToolsConnectionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDatabaseToolsEndpointServicesDatabaseToolsEndpointServiceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDatabaseToolsEndpointServicesDatabaseToolsEndpointServiceCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDatabaseToolsEndpointServicesDatabaseToolsEndpointServiceCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDatabaseToolsEndpointServicesDatabaseToolsEndpointServiceCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 name: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: A description of the Database Tools Endpoint Service.
        :param _builtins.str display_name: A filter to return only resources that match the entire specified display name.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools Endpoint Service.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param _builtins.str name: A filter to return only resources that match the entire specified name.
        :param _builtins.str state: A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the Database Tools Endpoint Service was created. An RFC3339 formatted datetime string
        :param _builtins.str time_updated: The time the Database Tools Endpoint Service was updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the Database Tools Endpoint Service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire specified display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools Endpoint Service.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire specified name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools Endpoint Service was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Database Tools Endpoint Service was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDatabaseToolsEndpointServicesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to return only resources that match the entire specified name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire specified name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 credential_key: _builtins.str,
                 database_tools_connection_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 locks: Sequence['outputs.GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemLockResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param _builtins.str credential_key: The name of the credential object created in the Oracle Database.
        :param _builtins.str database_tools_connection_id: A filter to return only resources when their `databaseToolsConnectionId` matches the specified `databaseToolsConnectionId`.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire specified display name.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools identity.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        :param Sequence['GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemLockArgs'] locks: Locks associated with this resource.
        :param _builtins.str state: A filter to return resources only when their `databaseToolsIdentityLifecycleState` matches the specified `databaseToolsIdentityLifecycleState`.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the Database Tools identity was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time the Database Tools identity was updated. An RFC3339 formatted datetime string.
        :param _builtins.str type: A filter to return only resources with one of the specified type values.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "credential_key", credential_key)
        pulumi.set(__self__, "database_tools_connection_id", database_tools_connection_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="credentialKey")
    def credential_key(self) -> _builtins.str:
        """
        The name of the credential object created in the Oracle Database.
        """
        return pulumi.get(self, "credential_key")

    @_builtins.property
    @pulumi.getter(name="databaseToolsConnectionId")
    def database_tools_connection_id(self) -> _builtins.str:
        """
        A filter to return only resources when their `databaseToolsConnectionId` matches the specified `databaseToolsConnectionId`.
        """
        return pulumi.get(self, "database_tools_connection_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire specified display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools identity.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return resources only when their `databaseToolsIdentityLifecycleState` matches the specified `databaseToolsIdentityLifecycleState`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools identity was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Database Tools identity was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        A filter to return only resources with one of the specified type values.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseToolsIdentitiesDatabaseToolsIdentityCollectionItemLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the Database Tools identity was created. An RFC3339 formatted datetime string.
        :param _builtins.str type: A filter to return only resources with one of the specified type values.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools identity was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        A filter to return only resources with one of the specified type values.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseToolsIdentitiesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDatabaseToolsIdentityLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the Database Tools identity was created. An RFC3339 formatted datetime string.
        :param _builtins.str type: The Database Tools identity type.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools identity was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Database Tools identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the Database Tools private endpoint was created. An RFC3339 formatted datetime string
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools private endpoint was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointReverseConnectionConfigurationResult(dict):
    def __init__(__self__, *,
                 reverse_connections_source_ips: Sequence['outputs.GetDatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIpResult']):
        """
        :param Sequence['GetDatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIpArgs'] reverse_connections_source_ips: A list of IP addresses in the customer VCN to be used as the source IPs for reverse connection packets traveling from the service's VCN to the customer's VCN.
        """
        pulumi.set(__self__, "reverse_connections_source_ips", reverse_connections_source_ips)

    @_builtins.property
    @pulumi.getter(name="reverseConnectionsSourceIps")
    def reverse_connections_source_ips(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIpResult']:
        """
        A list of IP addresses in the customer VCN to be used as the source IPs for reverse connection packets traveling from the service's VCN to the customer's VCN.
        """
        return pulumi.get(self, "reverse_connections_source_ips")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointReverseConnectionConfigurationReverseConnectionsSourceIpResult(dict):
    def __init__(__self__, *,
                 source_ip: _builtins.str):
        """
        :param _builtins.str source_ip: The IP address in the customer's VCN to be used as the source IP for reverse connection packets traveling from the customer's VCN to the service's VCN.
        """
        pulumi.set(__self__, "source_ip", source_ip)

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> _builtins.str:
        """
        The IP address in the customer's VCN to be used as the source IP for reverse connection packets traveling from the customer's VCN to the service's VCN.
        """
        return pulumi.get(self, "source_ip")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 additional_fqdns: Sequence[_builtins.str],
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 endpoint_fqdn: _builtins.str,
                 endpoint_service_id: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 locks: Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemLockResult'],
                 nsg_ids: Sequence[_builtins.str],
                 private_endpoint_ip: _builtins.str,
                 private_endpoint_vnic_id: _builtins.str,
                 reverse_connection_configurations: Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationResult'],
                 security_attributes: Mapping[str, _builtins.str],
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 vcn_id: _builtins.str):
        """
        :param Sequence[_builtins.str] additional_fqdns: A list of additional FQDNs that can be also be used for the private endpoint.
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: A description of the Database Tools private endpoint.
        :param _builtins.str display_name: A filter to return only resources that match the entire specified display name.
        :param _builtins.str endpoint_fqdn: Then FQDN to use for the private endpoint.
        :param _builtins.str endpoint_service_id: A filter to return only resources their `endpointServiceId` matches the specified `endpointServiceId`.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemLockArgs'] locks: Locks associated with this resource.
        :param Sequence[_builtins.str] nsg_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups that the private endpoint's VNIC belongs to.  For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param _builtins.str private_endpoint_ip: The private IP address that represents the access point for the associated endpoint service.
        :param _builtins.str private_endpoint_vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint's VNIC.
        :param Sequence['GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationArgs'] reverse_connection_configurations: Reverse connection configuration details of the private endpoint.
        :param Mapping[str, _builtins.str] security_attributes: Zero trust Packet Routing (ZPR) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param _builtins.str state: A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
        :param _builtins.str subnet_id: A filter to return only resources their `subnetId` matches the specified `subnetId`.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the Database Tools private endpoint was created. An RFC3339 formatted datetime string
        :param _builtins.str time_updated: The time the Database Tools private endpoint was updated. An RFC3339 formatted datetime string
        :param _builtins.str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN that the private endpoint belongs to.
        """
        pulumi.set(__self__, "additional_fqdns", additional_fqdns)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "endpoint_fqdn", endpoint_fqdn)
        pulumi.set(__self__, "endpoint_service_id", endpoint_service_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "private_endpoint_vnic_id", private_endpoint_vnic_id)
        pulumi.set(__self__, "reverse_connection_configurations", reverse_connection_configurations)
        pulumi.set(__self__, "security_attributes", security_attributes)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="additionalFqdns")
    def additional_fqdns(self) -> Sequence[_builtins.str]:
        """
        A list of additional FQDNs that can be also be used for the private endpoint.
        """
        return pulumi.get(self, "additional_fqdns")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the Database Tools private endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire specified display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="endpointFqdn")
    def endpoint_fqdn(self) -> _builtins.str:
        """
        Then FQDN to use for the private endpoint.
        """
        return pulumi.get(self, "endpoint_fqdn")

    @_builtins.property
    @pulumi.getter(name="endpointServiceId")
    def endpoint_service_id(self) -> _builtins.str:
        """
        A filter to return only resources their `endpointServiceId` matches the specified `endpointServiceId`.
        """
        return pulumi.get(self, "endpoint_service_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups that the private endpoint's VNIC belongs to.  For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> _builtins.str:
        """
        The private IP address that represents the access point for the associated endpoint service.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="privateEndpointVnicId")
    def private_endpoint_vnic_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint's VNIC.
        """
        return pulumi.get(self, "private_endpoint_vnic_id")

    @_builtins.property
    @pulumi.getter(name="reverseConnectionConfigurations")
    def reverse_connection_configurations(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationResult']:
        """
        Reverse connection configuration details of the private endpoint.
        """
        return pulumi.get(self, "reverse_connection_configurations")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Zero trust Packet Routing (ZPR) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        A filter to return only resources their `subnetId` matches the specified `subnetId`.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools private endpoint was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Database Tools private endpoint was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN that the private endpoint belongs to.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the Database Tools private endpoint was created. An RFC3339 formatted datetime string
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Database Tools private endpoint was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationResult(dict):
    def __init__(__self__, *,
                 reverse_connections_source_ips: Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationReverseConnectionsSourceIpResult']):
        """
        :param Sequence['GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationReverseConnectionsSourceIpArgs'] reverse_connections_source_ips: A list of IP addresses in the customer VCN to be used as the source IPs for reverse connection packets traveling from the service's VCN to the customer's VCN.
        """
        pulumi.set(__self__, "reverse_connections_source_ips", reverse_connections_source_ips)

    @_builtins.property
    @pulumi.getter(name="reverseConnectionsSourceIps")
    def reverse_connections_source_ips(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationReverseConnectionsSourceIpResult']:
        """
        A list of IP addresses in the customer VCN to be used as the source IPs for reverse connection packets traveling from the service's VCN to the customer's VCN.
        """
        return pulumi.get(self, "reverse_connections_source_ips")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionItemReverseConnectionConfigurationReverseConnectionsSourceIpResult(dict):
    def __init__(__self__, *,
                 source_ip: _builtins.str):
        """
        :param _builtins.str source_ip: The IP address in the customer's VCN to be used as the source IP for reverse connection packets traveling from the customer's VCN to the service's VCN.
        """
        pulumi.set(__self__, "source_ip", source_ip)

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> _builtins.str:
        """
        The IP address in the customer's VCN to be used as the source IP for reverse connection packets traveling from the customer's VCN to the service's VCN.
        """
        return pulumi.get(self, "source_ip")


@pulumi.output_type
class GetDatabaseToolsPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


