# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 catalog_id: pulumi.Input[_builtins.str],
                 data_asset_key: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 properties: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 type_key: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enc_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[_builtins.str] catalog_id: Unique catalog identifier.
        :param pulumi.Input[_builtins.str] data_asset_key: Unique data asset key.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] type_key: The key of the object type. Type key's can be found via the '/types' endpoint.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] description: (Updatable) A description of the connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] enc_properties: (Updatable) A map of maps that contains the encrypted values for sensitive properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. To determine the set of optional and required properties for a connection type, a query can be done on '/types?type=connection' that returns a collection of all connection types. The appropriate connection type, which will include definitions of all of it's properties, can be identified from this collection. Example: `{"encProperties": { "default": { "password": "example-password"}}}`
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) Indicates whether this connection is the default connection. The first connection of a data asset defaults to being the default, subsequent connections default to not being the default. If a default connection already exists, then trying to create a connection as the default will fail. In this case the default connection would need to be updated not to be the default and then the new connection can then be created as the default.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "data_asset_key", data_asset_key)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type_key", type_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enc_properties is not None:
            pulumi.set(__self__, "enc_properties", enc_properties)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="dataAssetKey")
    def data_asset_key(self) -> pulumi.Input[_builtins.str]:
        """
        Unique data asset key.
        """
        return pulumi.get(self, "data_asset_key")

    @data_asset_key.setter
    def data_asset_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_asset_key", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> pulumi.Input[_builtins.str]:
        """
        The key of the object type. Type key's can be found via the '/types' endpoint.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type_key")

    @type_key.setter
    def type_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type_key", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A description of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encProperties")
    def enc_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A map of maps that contains the encrypted values for sensitive properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. To determine the set of optional and required properties for a connection type, a query can be done on '/types?type=connection' that returns a collection of all connection types. The appropriate connection type, which will include definitions of all of it's properties, can be identified from this collection. Example: `{"encProperties": { "default": { "password": "example-password"}}}`
        """
        return pulumi.get(self, "enc_properties")

    @enc_properties.setter
    def enc_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enc_properties", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates whether this connection is the default connection. The first connection of a data asset defaults to being the default, subsequent connections default to not being the default. If a default connection already exists, then trying to create a connection as the default will fail. In this case the default connection would need to be updated not to be the default and then the new connection can then be created as the default.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_asset_key: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enc_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_key: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_status_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type_key: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_by_id: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[_builtins.str] catalog_id: Unique catalog identifier.
        :param pulumi.Input[_builtins.str] created_by_id: OCID of the user who created the connection.
        :param pulumi.Input[_builtins.str] data_asset_key: Unique data asset key.
        :param pulumi.Input[_builtins.str] description: (Updatable) A description of the connection.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] enc_properties: (Updatable) A map of maps that contains the encrypted values for sensitive properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. To determine the set of optional and required properties for a connection type, a query can be done on '/types?type=connection' that returns a collection of all connection types. The appropriate connection type, which will include definitions of all of it's properties, can be identified from this collection. Example: `{"encProperties": { "default": { "password": "example-password"}}}`
        :param pulumi.Input[_builtins.str] external_key: Unique external key of this object from the source system.
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) Indicates whether this connection is the default connection. The first connection of a data asset defaults to being the default, subsequent connections default to not being the default. If a default connection already exists, then trying to create a connection as the default will fail. In this case the default connection would need to be updated not to be the default and then the new connection can then be created as the default.
        :param pulumi.Input[_builtins.str] key: Unique connection key that is immutable.
        :param pulumi.Input[_builtins.str] state: The current state of the connection.
        :param pulumi.Input[_builtins.str] time_created: The date and time the connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_status_updated: Time that the connections status was last updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The last time that any change was made to the connection. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] type_key: The key of the object type. Type key's can be found via the '/types' endpoint.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] updated_by_id: OCID of the user who modified the connection.
        :param pulumi.Input[_builtins.str] uri: URI to the connection instance in the API.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if created_by_id is not None:
            pulumi.set(__self__, "created_by_id", created_by_id)
        if data_asset_key is not None:
            pulumi.set(__self__, "data_asset_key", data_asset_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enc_properties is not None:
            pulumi.set(__self__, "enc_properties", enc_properties)
        if external_key is not None:
            pulumi.set(__self__, "external_key", external_key)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_status_updated is not None:
            pulumi.set(__self__, "time_status_updated", time_status_updated)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type_key is not None:
            pulumi.set(__self__, "type_key", type_key)
        if updated_by_id is not None:
            pulumi.set(__self__, "updated_by_id", updated_by_id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="createdById")
    def created_by_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the user who created the connection.
        """
        return pulumi.get(self, "created_by_id")

    @created_by_id.setter
    def created_by_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by_id", value)

    @_builtins.property
    @pulumi.getter(name="dataAssetKey")
    def data_asset_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique data asset key.
        """
        return pulumi.get(self, "data_asset_key")

    @data_asset_key.setter
    def data_asset_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_asset_key", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A description of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="encProperties")
    def enc_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A map of maps that contains the encrypted values for sensitive properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. To determine the set of optional and required properties for a connection type, a query can be done on '/types?type=connection' that returns a collection of all connection types. The appropriate connection type, which will include definitions of all of it's properties, can be identified from this collection. Example: `{"encProperties": { "default": { "password": "example-password"}}}`
        """
        return pulumi.get(self, "enc_properties")

    @enc_properties.setter
    def enc_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enc_properties", value)

    @_builtins.property
    @pulumi.getter(name="externalKey")
    def external_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique external key of this object from the source system.
        """
        return pulumi.get(self, "external_key")

    @external_key.setter
    def external_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_key", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates whether this connection is the default connection. The first connection of a data asset defaults to being the default, subsequent connections default to not being the default. If a default connection already exists, then trying to create a connection as the default will fail. In this case the default connection would need to be updated not to be the default and then the new connection can then be created as the default.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique connection key that is immutable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeStatusUpdated")
    def time_status_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time that the connections status was last updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_status_updated")

    @time_status_updated.setter
    def time_status_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_status_updated", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time that any change was made to the connection. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the object type. Type key's can be found via the '/types' endpoint.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type_key")

    @type_key.setter
    def type_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_key", value)

    @_builtins.property
    @pulumi.getter(name="updatedById")
    def updated_by_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the user who modified the connection.
        """
        return pulumi.get(self, "updated_by_id")

    @updated_by_id.setter
    def updated_by_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by_id", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI to the connection instance in the API.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.type_token("oci:DataCatalog/connection:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_asset_key: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enc_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.datacatalog.Connection("test_connection",
            catalog_id=test_catalog["id"],
            data_asset_key=connection_data_asset_key,
            display_name=connection_display_name,
            properties=connection_properties,
            type_key=connection_type_key,
            description=connection_description,
            enc_properties=connection_enc_properties,
            is_default=connection_is_default)
        ```

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataCatalog/connection:Connection test_connection "catalogs/{catalogId}/dataAssets/{dataAssetKey}/connections/{connectionKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: Unique catalog identifier.
        :param pulumi.Input[_builtins.str] data_asset_key: Unique data asset key.
        :param pulumi.Input[_builtins.str] description: (Updatable) A description of the connection.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] enc_properties: (Updatable) A map of maps that contains the encrypted values for sensitive properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. To determine the set of optional and required properties for a connection type, a query can be done on '/types?type=connection' that returns a collection of all connection types. The appropriate connection type, which will include definitions of all of it's properties, can be identified from this collection. Example: `{"encProperties": { "default": { "password": "example-password"}}}`
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) Indicates whether this connection is the default connection. The first connection of a data asset defaults to being the default, subsequent connections default to not being the default. If a default connection already exists, then trying to create a connection as the default will fail. In this case the default connection would need to be updated not to be the default and then the new connection can then be created as the default.
        :param pulumi.Input[_builtins.str] type_key: The key of the object type. Type key's can be found via the '/types' endpoint.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.datacatalog.Connection("test_connection",
            catalog_id=test_catalog["id"],
            data_asset_key=connection_data_asset_key,
            display_name=connection_display_name,
            properties=connection_properties,
            type_key=connection_type_key,
            description=connection_description,
            enc_properties=connection_enc_properties,
            is_default=connection_is_default)
        ```

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataCatalog/connection:Connection test_connection "catalogs/{catalogId}/dataAssets/{dataAssetKey}/connections/{connectionKey}"
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_asset_key: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enc_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            if catalog_id is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_id'")
            __props__.__dict__["catalog_id"] = catalog_id
            if data_asset_key is None and not opts.urn:
                raise TypeError("Missing required property 'data_asset_key'")
            __props__.__dict__["data_asset_key"] = data_asset_key
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enc_properties"] = None if enc_properties is None else pulumi.Output.secret(enc_properties)
            __props__.__dict__["is_default"] = is_default
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            if type_key is None and not opts.urn:
                raise TypeError("Missing required property 'type_key'")
            __props__.__dict__["type_key"] = type_key
            __props__.__dict__["created_by_id"] = None
            __props__.__dict__["external_key"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_status_updated"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["updated_by_id"] = None
            __props__.__dict__["uri"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encProperties"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Connection, __self__).__init__(
            'oci:DataCatalog/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_by_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_asset_key: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enc_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            external_key: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_status_updated: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type_key: Optional[pulumi.Input[_builtins.str]] = None,
            updated_by_id: Optional[pulumi.Input[_builtins.str]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: Unique catalog identifier.
        :param pulumi.Input[_builtins.str] created_by_id: OCID of the user who created the connection.
        :param pulumi.Input[_builtins.str] data_asset_key: Unique data asset key.
        :param pulumi.Input[_builtins.str] description: (Updatable) A description of the connection.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] enc_properties: (Updatable) A map of maps that contains the encrypted values for sensitive properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. To determine the set of optional and required properties for a connection type, a query can be done on '/types?type=connection' that returns a collection of all connection types. The appropriate connection type, which will include definitions of all of it's properties, can be identified from this collection. Example: `{"encProperties": { "default": { "password": "example-password"}}}`
        :param pulumi.Input[_builtins.str] external_key: Unique external key of this object from the source system.
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) Indicates whether this connection is the default connection. The first connection of a data asset defaults to being the default, subsequent connections default to not being the default. If a default connection already exists, then trying to create a connection as the default will fail. In this case the default connection would need to be updated not to be the default and then the new connection can then be created as the default.
        :param pulumi.Input[_builtins.str] key: Unique connection key that is immutable.
        :param pulumi.Input[_builtins.str] state: The current state of the connection.
        :param pulumi.Input[_builtins.str] time_created: The date and time the connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_status_updated: Time that the connections status was last updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The last time that any change was made to the connection. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] type_key: The key of the object type. Type key's can be found via the '/types' endpoint.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] updated_by_id: OCID of the user who modified the connection.
        :param pulumi.Input[_builtins.str] uri: URI to the connection instance in the API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["created_by_id"] = created_by_id
        __props__.__dict__["data_asset_key"] = data_asset_key
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enc_properties"] = enc_properties
        __props__.__dict__["external_key"] = external_key
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["key"] = key
        __props__.__dict__["properties"] = properties
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_status_updated"] = time_status_updated
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type_key"] = type_key
        __props__.__dict__["updated_by_id"] = updated_by_id
        __props__.__dict__["uri"] = uri
        return Connection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter(name="createdById")
    def created_by_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the user who created the connection.
        """
        return pulumi.get(self, "created_by_id")

    @_builtins.property
    @pulumi.getter(name="dataAssetKey")
    def data_asset_key(self) -> pulumi.Output[_builtins.str]:
        """
        Unique data asset key.
        """
        return pulumi.get(self, "data_asset_key")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A description of the connection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encProperties")
    def enc_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        (Updatable) A map of maps that contains the encrypted values for sensitive properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. To determine the set of optional and required properties for a connection type, a query can be done on '/types?type=connection' that returns a collection of all connection types. The appropriate connection type, which will include definitions of all of it's properties, can be identified from this collection. Example: `{"encProperties": { "default": { "password": "example-password"}}}`
        """
        return pulumi.get(self, "enc_properties")

    @_builtins.property
    @pulumi.getter(name="externalKey")
    def external_key(self) -> pulumi.Output[_builtins.str]:
        """
        Unique external key of this object from the source system.
        """
        return pulumi.get(self, "external_key")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates whether this connection is the default connection. The first connection of a data asset defaults to being the default, subsequent connections default to not being the default. If a default connection already exists, then trying to create a connection as the default will fail. In this case the default connection would need to be updated not to be the default and then the new connection can then be created as the default.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        Unique connection key that is immutable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the connection.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeStatusUpdated")
    def time_status_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Time that the connections status was last updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_status_updated")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The last time that any change was made to the connection. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the object type. Type key's can be found via the '/types' endpoint.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type_key")

    @_builtins.property
    @pulumi.getter(name="updatedById")
    def updated_by_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the user who modified the connection.
        """
        return pulumi.get(self, "updated_by_id")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[_builtins.str]:
        """
        URI to the connection instance in the API.
        """
        return pulumi.get(self, "uri")

