# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RunStatementArgs', 'RunStatement']

@pulumi.input_type
class RunStatementArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[_builtins.str],
                 run_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a RunStatement resource.
        :param pulumi.Input[_builtins.str] code: The statement code to execute. Example: `println(sc.version)`
        :param pulumi.Input[_builtins.str] run_id: The unique ID for the run 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "run_id", run_id)

    @_builtins.property
    @pulumi.getter
    def code(self) -> pulumi.Input[_builtins.str]:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter(name="runId")
    def run_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique ID for the run 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "run_id")

    @run_id.setter
    def run_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "run_id", value)


@pulumi.input_type
class _RunStatementState:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[_builtins.str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]]] = None,
                 progress: Optional[pulumi.Input[_builtins.float]] = None,
                 run_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_completed: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RunStatement resources.
        :param pulumi.Input[_builtins.str] code: The statement code to execute. Example: `println(sc.version)`
        :param pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]] outputs: The execution output of a statement.
        :param pulumi.Input[_builtins.float] progress: The execution progress.
        :param pulumi.Input[_builtins.str] run_id: The unique ID for the run 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of this statement.
        :param pulumi.Input[_builtins.str] time_completed: The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if run_id is not None:
            pulumi.set(__self__, "run_id", run_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_completed is not None:
            pulumi.set(__self__, "time_completed", time_completed)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]]]:
        """
        The execution output of a statement.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]]]):
        pulumi.set(self, "outputs", value)

    @_builtins.property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The execution progress.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "progress", value)

    @_builtins.property
    @pulumi.getter(name="runId")
    def run_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID for the run 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "run_id")

    @run_id.setter
    def run_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of this statement.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        """
        return pulumi.get(self, "time_completed")

    @time_completed.setter
    def time_completed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_completed", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:DataFlow/runStatement:RunStatement")
class RunStatement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code: Optional[pulumi.Input[_builtins.str]] = None,
                 run_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_run_statement = oci.dataflow.RunStatement("test_run_statement",
            code=run_statement_code,
            run_id=test_run["id"])
        ```

        ## Import

        RunStatements can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataFlow/runStatement:RunStatement test_run_statement "runs/{runId}/statements/{statementId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] code: The statement code to execute. Example: `println(sc.version)`
        :param pulumi.Input[_builtins.str] run_id: The unique ID for the run 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RunStatementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_run_statement = oci.dataflow.RunStatement("test_run_statement",
            code=run_statement_code,
            run_id=test_run["id"])
        ```

        ## Import

        RunStatements can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataFlow/runStatement:RunStatement test_run_statement "runs/{runId}/statements/{statementId}"
        ```

        :param str resource_name: The name of the resource.
        :param RunStatementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RunStatementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code: Optional[pulumi.Input[_builtins.str]] = None,
                 run_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RunStatementArgs.__new__(RunStatementArgs)

            if code is None and not opts.urn:
                raise TypeError("Missing required property 'code'")
            __props__.__dict__["code"] = code
            if run_id is None and not opts.urn:
                raise TypeError("Missing required property 'run_id'")
            __props__.__dict__["run_id"] = run_id
            __props__.__dict__["outputs"] = None
            __props__.__dict__["progress"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_completed"] = None
            __props__.__dict__["time_created"] = None
        super(RunStatement, __self__).__init__(
            'oci:DataFlow/runStatement:RunStatement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            code: Optional[pulumi.Input[_builtins.str]] = None,
            outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunStatementOutputArgs', 'RunStatementOutputArgsDict']]]]] = None,
            progress: Optional[pulumi.Input[_builtins.float]] = None,
            run_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_completed: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None) -> 'RunStatement':
        """
        Get an existing RunStatement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] code: The statement code to execute. Example: `println(sc.version)`
        :param pulumi.Input[Sequence[pulumi.Input[Union['RunStatementOutputArgs', 'RunStatementOutputArgsDict']]]] outputs: The execution output of a statement.
        :param pulumi.Input[_builtins.float] progress: The execution progress.
        :param pulumi.Input[_builtins.str] run_id: The unique ID for the run 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of this statement.
        :param pulumi.Input[_builtins.str] time_completed: The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RunStatementState.__new__(_RunStatementState)

        __props__.__dict__["code"] = code
        __props__.__dict__["outputs"] = outputs
        __props__.__dict__["progress"] = progress
        __props__.__dict__["run_id"] = run_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_completed"] = time_completed
        __props__.__dict__["time_created"] = time_created
        return RunStatement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def code(self) -> pulumi.Output[_builtins.str]:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Sequence['outputs.RunStatementOutput']]:
        """
        The execution output of a statement.
        """
        return pulumi.get(self, "outputs")

    @_builtins.property
    @pulumi.getter
    def progress(self) -> pulumi.Output[_builtins.float]:
        """
        The execution progress.
        """
        return pulumi.get(self, "progress")

    @_builtins.property
    @pulumi.getter(name="runId")
    def run_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID for the run 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "run_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of this statement.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        """
        return pulumi.get(self, "time_completed")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

