# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AttributeSetArgs', 'AttributeSet']

@pulumi.input_type
class AttributeSetArgs:
    def __init__(__self__, *,
                 attribute_set_type: pulumi.Input[_builtins.str],
                 attribute_set_values: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AttributeSet resource.
        :param pulumi.Input[_builtins.str] attribute_set_type: The type of attribute set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attribute_set_values: (Updatable) The list of values in an attribute set
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the attribute set.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the attribute set. The name is unique and changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the attribute set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "attribute_set_type", attribute_set_type)
        pulumi.set(__self__, "attribute_set_values", attribute_set_values)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="attributeSetType")
    def attribute_set_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of attribute set.
        """
        return pulumi.get(self, "attribute_set_type")

    @attribute_set_type.setter
    def attribute_set_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "attribute_set_type", value)

    @_builtins.property
    @pulumi.getter(name="attributeSetValues")
    def attribute_set_values(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) The list of values in an attribute set
        """
        return pulumi.get(self, "attribute_set_values")

    @attribute_set_values.setter
    def attribute_set_values(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "attribute_set_values", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the attribute set.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The display name of the attribute set. The name is unique and changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the attribute set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AttributeSetState:
    def __init__(__self__, *,
                 attribute_set_type: Optional[pulumi.Input[_builtins.str]] = None,
                 attribute_set_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 in_use: Optional[pulumi.Input[_builtins.str]] = None,
                 is_user_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AttributeSet resources.
        :param pulumi.Input[_builtins.str] attribute_set_type: The type of attribute set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attribute_set_values: (Updatable) The list of values in an attribute set
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the attribute set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the attribute set.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the attribute set. The name is unique and changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] in_use: Indicates whether the attribute set is in use by other resource.
        :param pulumi.Input[_builtins.bool] is_user_defined: A boolean flag indicating to list user defined or seeded attribute sets.
        :param pulumi.Input[_builtins.str] state: The current state of an attribute set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time an attribute set was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time an attribute set was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if attribute_set_type is not None:
            pulumi.set(__self__, "attribute_set_type", attribute_set_type)
        if attribute_set_values is not None:
            pulumi.set(__self__, "attribute_set_values", attribute_set_values)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if in_use is not None:
            pulumi.set(__self__, "in_use", in_use)
        if is_user_defined is not None:
            pulumi.set(__self__, "is_user_defined", is_user_defined)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="attributeSetType")
    def attribute_set_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of attribute set.
        """
        return pulumi.get(self, "attribute_set_type")

    @attribute_set_type.setter
    def attribute_set_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attribute_set_type", value)

    @_builtins.property
    @pulumi.getter(name="attributeSetValues")
    def attribute_set_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The list of values in an attribute set
        """
        return pulumi.get(self, "attribute_set_values")

    @attribute_set_values.setter
    def attribute_set_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attribute_set_values", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains the attribute set.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the attribute set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the attribute set. The name is unique and changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inUse")
    def in_use(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the attribute set is in use by other resource.
        """
        return pulumi.get(self, "in_use")

    @in_use.setter
    def in_use(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "in_use", value)

    @_builtins.property
    @pulumi.getter(name="isUserDefined")
    def is_user_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag indicating to list user defined or seeded attribute sets.
        """
        return pulumi.get(self, "is_user_defined")

    @is_user_defined.setter
    def is_user_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_user_defined", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of an attribute set.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time an attribute set was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time an attribute set was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataSafe/attributeSet:AttributeSet")
class AttributeSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_set_type: Optional[pulumi.Input[_builtins.str]] = None,
                 attribute_set_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_attribute_set = oci.datasafe.AttributeSet("test_attribute_set",
            attribute_set_type=attribute_set_attribute_set_type,
            attribute_set_values=attribute_set_attribute_set_values,
            compartment_id=compartment_id,
            display_name=attribute_set_display_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=attribute_set_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AttributeSets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/attributeSet:AttributeSet test_attribute_set "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attribute_set_type: The type of attribute set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attribute_set_values: (Updatable) The list of values in an attribute set
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the attribute set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the attribute set.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the attribute set. The name is unique and changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AttributeSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_attribute_set = oci.datasafe.AttributeSet("test_attribute_set",
            attribute_set_type=attribute_set_attribute_set_type,
            attribute_set_values=attribute_set_attribute_set_values,
            compartment_id=compartment_id,
            display_name=attribute_set_display_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=attribute_set_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AttributeSets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/attributeSet:AttributeSet test_attribute_set "id"
        ```

        :param str resource_name: The name of the resource.
        :param AttributeSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AttributeSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_set_type: Optional[pulumi.Input[_builtins.str]] = None,
                 attribute_set_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AttributeSetArgs.__new__(AttributeSetArgs)

            if attribute_set_type is None and not opts.urn:
                raise TypeError("Missing required property 'attribute_set_type'")
            __props__.__dict__["attribute_set_type"] = attribute_set_type
            if attribute_set_values is None and not opts.urn:
                raise TypeError("Missing required property 'attribute_set_values'")
            __props__.__dict__["attribute_set_values"] = attribute_set_values
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["in_use"] = None
            __props__.__dict__["is_user_defined"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AttributeSet, __self__).__init__(
            'oci:DataSafe/attributeSet:AttributeSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_set_type: Optional[pulumi.Input[_builtins.str]] = None,
            attribute_set_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            in_use: Optional[pulumi.Input[_builtins.str]] = None,
            is_user_defined: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'AttributeSet':
        """
        Get an existing AttributeSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attribute_set_type: The type of attribute set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attribute_set_values: (Updatable) The list of values in an attribute set
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the attribute set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the attribute set.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the attribute set. The name is unique and changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] in_use: Indicates whether the attribute set is in use by other resource.
        :param pulumi.Input[_builtins.bool] is_user_defined: A boolean flag indicating to list user defined or seeded attribute sets.
        :param pulumi.Input[_builtins.str] state: The current state of an attribute set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time an attribute set was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time an attribute set was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AttributeSetState.__new__(_AttributeSetState)

        __props__.__dict__["attribute_set_type"] = attribute_set_type
        __props__.__dict__["attribute_set_values"] = attribute_set_values
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["in_use"] = in_use
        __props__.__dict__["is_user_defined"] = is_user_defined
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AttributeSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attributeSetType")
    def attribute_set_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of attribute set.
        """
        return pulumi.get(self, "attribute_set_type")

    @_builtins.property
    @pulumi.getter(name="attributeSetValues")
    def attribute_set_values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The list of values in an attribute set
        """
        return pulumi.get(self, "attribute_set_values")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the attribute set.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Description of the attribute set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the attribute set. The name is unique and changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="inUse")
    def in_use(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether the attribute set is in use by other resource.
        """
        return pulumi.get(self, "in_use")

    @_builtins.property
    @pulumi.getter(name="isUserDefined")
    def is_user_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        A boolean flag indicating to list user defined or seeded attribute sets.
        """
        return pulumi.get(self, "is_user_defined")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of an attribute set.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time an attribute set was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time an attribute set was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

