# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataSafeConfigurationResult',
    'AwaitableGetDataSafeConfigurationResult',
    'get_data_safe_configuration',
    'get_data_safe_configuration_output',
]

@pulumi.output_type
class GetDataSafeConfigurationResult:
    """
    A collection of values returned by getDataSafeConfiguration.
    """
    def __init__(__self__, compartment_id=None, data_safe_nat_gateway_ip_address=None, defined_tags=None, freeform_tags=None, global_settings=None, id=None, is_enabled=None, state=None, time_enabled=None, url=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_safe_nat_gateway_ip_address and not isinstance(data_safe_nat_gateway_ip_address, str):
            raise TypeError("Expected argument 'data_safe_nat_gateway_ip_address' to be a str")
        pulumi.set(__self__, "data_safe_nat_gateway_ip_address", data_safe_nat_gateway_ip_address)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if global_settings and not isinstance(global_settings, list):
            raise TypeError("Expected argument 'global_settings' to be a list")
        pulumi.set(__self__, "global_settings", global_settings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_enabled and not isinstance(time_enabled, str):
            raise TypeError("Expected argument 'time_enabled' to be a str")
        pulumi.set(__self__, "time_enabled", time_enabled)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the tenancy used to enable Data Safe.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dataSafeNatGatewayIpAddress")
    def data_safe_nat_gateway_ip_address(self) -> _builtins.str:
        """
        The Oracle Data Safe's NAT Gateway IP Address.
        """
        return pulumi.get(self, "data_safe_nat_gateway_ip_address")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="globalSettings")
    def global_settings(self) -> Sequence['outputs.GetDataSafeConfigurationGlobalSettingResult']:
        """
        Details of the tenancy level global settings in Data Safe.
        """
        return pulumi.get(self, "global_settings")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Indicates if Data Safe is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of Data Safe.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeEnabled")
    def time_enabled(self) -> _builtins.str:
        """
        The date and time Data Safe was enabled, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_enabled")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the Data Safe service.
        """
        return pulumi.get(self, "url")


class AwaitableGetDataSafeConfigurationResult(GetDataSafeConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSafeConfigurationResult(
            compartment_id=self.compartment_id,
            data_safe_nat_gateway_ip_address=self.data_safe_nat_gateway_ip_address,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            global_settings=self.global_settings,
            id=self.id,
            is_enabled=self.is_enabled,
            state=self.state,
            time_enabled=self.time_enabled,
            url=self.url)


def get_data_safe_configuration(compartment_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSafeConfigurationResult:
    """
    This data source provides details about a specific Data Safe Configuration resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the Data Safe configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_safe_configuration = oci.DataSafe.get_data_safe_configuration(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: A filter to return the Data Safe configuration for the specified tenancy OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getDataSafeConfiguration:getDataSafeConfiguration', __args__, opts=opts, typ=GetDataSafeConfigurationResult).value

    return AwaitableGetDataSafeConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_safe_nat_gateway_ip_address=pulumi.get(__ret__, 'data_safe_nat_gateway_ip_address'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        global_settings=pulumi.get(__ret__, 'global_settings'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        state=pulumi.get(__ret__, 'state'),
        time_enabled=pulumi.get(__ret__, 'time_enabled'),
        url=pulumi.get(__ret__, 'url'))
def get_data_safe_configuration_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataSafeConfigurationResult]:
    """
    This data source provides details about a specific Data Safe Configuration resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the Data Safe configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_safe_configuration = oci.DataSafe.get_data_safe_configuration(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: A filter to return the Data Safe configuration for the specified tenancy OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getDataSafeConfiguration:getDataSafeConfiguration', __args__, opts=opts, typ=GetDataSafeConfigurationResult)
    return __ret__.apply(lambda __response__: GetDataSafeConfigurationResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        data_safe_nat_gateway_ip_address=pulumi.get(__response__, 'data_safe_nat_gateway_ip_address'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        global_settings=pulumi.get(__response__, 'global_settings'),
        id=pulumi.get(__response__, 'id'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        state=pulumi.get(__response__, 'state'),
        time_enabled=pulumi.get(__response__, 'time_enabled'),
        url=pulumi.get(__response__, 'url')))
