# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityAssessmentChecksResult',
    'AwaitableGetSecurityAssessmentChecksResult',
    'get_security_assessment_checks',
    'get_security_assessment_checks_output',
]

@pulumi.output_type
class GetSecurityAssessmentChecksResult:
    """
    A collection of values returned by getSecurityAssessmentChecks.
    """
    def __init__(__self__, access_level=None, checks=None, compartment_id_in_subtree=None, contains_references=None, contains_severities=None, filters=None, id=None, key=None, security_assessment_id=None, suggested_severity=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if checks and not isinstance(checks, list):
            raise TypeError("Expected argument 'checks' to be a list")
        pulumi.set(__self__, "checks", checks)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if contains_references and not isinstance(contains_references, list):
            raise TypeError("Expected argument 'contains_references' to be a list")
        pulumi.set(__self__, "contains_references", contains_references)
        if contains_severities and not isinstance(contains_severities, list):
            raise TypeError("Expected argument 'contains_severities' to be a list")
        pulumi.set(__self__, "contains_severities", contains_severities)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if security_assessment_id and not isinstance(security_assessment_id, str):
            raise TypeError("Expected argument 'security_assessment_id' to be a str")
        pulumi.set(__self__, "security_assessment_id", security_assessment_id)
        if suggested_severity and not isinstance(suggested_severity, str):
            raise TypeError("Expected argument 'suggested_severity' to be a str")
        pulumi.set(__self__, "suggested_severity", suggested_severity)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter
    def checks(self) -> Sequence['outputs.GetSecurityAssessmentChecksCheckResult']:
        """
        The list of checks.
        """
        return pulumi.get(self, "checks")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="containsReferences")
    def contains_references(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "contains_references")

    @_builtins.property
    @pulumi.getter(name="containsSeverities")
    def contains_severities(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "contains_severities")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityAssessmentChecksFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        A unique identifier for the check.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> _builtins.str:
        return pulumi.get(self, "security_assessment_id")

    @_builtins.property
    @pulumi.getter(name="suggestedSeverity")
    def suggested_severity(self) -> Optional[_builtins.str]:
        """
        The severity of the check as suggested by Data Safe security assessment. This will be the default severity in the template baseline security assessment.
        """
        return pulumi.get(self, "suggested_severity")


class AwaitableGetSecurityAssessmentChecksResult(GetSecurityAssessmentChecksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAssessmentChecksResult(
            access_level=self.access_level,
            checks=self.checks,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            contains_references=self.contains_references,
            contains_severities=self.contains_severities,
            filters=self.filters,
            id=self.id,
            key=self.key,
            security_assessment_id=self.security_assessment_id,
            suggested_severity=self.suggested_severity)


def get_security_assessment_checks(access_level: Optional[_builtins.str] = None,
                                   compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                   contains_references: Optional[Sequence[_builtins.str]] = None,
                                   contains_severities: Optional[Sequence[_builtins.str]] = None,
                                   filters: Optional[Sequence[Union['GetSecurityAssessmentChecksFilterArgs', 'GetSecurityAssessmentChecksFilterArgsDict']]] = None,
                                   key: Optional[_builtins.str] = None,
                                   security_assessment_id: Optional[_builtins.str] = None,
                                   suggested_severity: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAssessmentChecksResult:
    """
    This data source provides the list of Security Assessment Checks in Oracle Cloud Infrastructure Data Safe service.

    Lists all the security checks in the specified compartment for security assessment of type TEMPLATE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_checks = oci.DataSafe.get_security_assessment_checks(security_assessment_id=test_security_assessment["id"],
        access_level=security_assessment_check_access_level,
        compartment_id_in_subtree=security_assessment_check_compartment_id_in_subtree,
        contains_references=security_assessment_check_contains_references,
        contains_severities=security_assessment_check_contains_severity,
        key=security_assessment_check_key,
        suggested_severity=security_assessment_check_suggested_severity)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[_builtins.str] contains_references: An optional filter to return only findings that match the specified references. Use containsReferences param if need to filter by multiple references.
    :param Sequence[_builtins.str] contains_severities: A filter to return only findings that match the specified risk level(s). Use containsSeverity parameter if need to filter by multiple risk levels.
    :param _builtins.str key: Each check in security assessment has an associated key (think of key as a check's name). For a given check, the key will be the same across targets. The user can use these keys to filter the checks.
    :param _builtins.str security_assessment_id: The OCID of the security assessment.
    :param _builtins.str suggested_severity: A filter to return only checks of a particular risk level.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['containsReferences'] = contains_references
    __args__['containsSeverities'] = contains_severities
    __args__['filters'] = filters
    __args__['key'] = key
    __args__['securityAssessmentId'] = security_assessment_id
    __args__['suggestedSeverity'] = suggested_severity
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityAssessmentChecks:getSecurityAssessmentChecks', __args__, opts=opts, typ=GetSecurityAssessmentChecksResult).value

    return AwaitableGetSecurityAssessmentChecksResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        checks=pulumi.get(__ret__, 'checks'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        contains_references=pulumi.get(__ret__, 'contains_references'),
        contains_severities=pulumi.get(__ret__, 'contains_severities'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        security_assessment_id=pulumi.get(__ret__, 'security_assessment_id'),
        suggested_severity=pulumi.get(__ret__, 'suggested_severity'))
def get_security_assessment_checks_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                          contains_references: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          contains_severities: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityAssessmentChecksFilterArgs', 'GetSecurityAssessmentChecksFilterArgsDict']]]]] = None,
                                          key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          suggested_severity: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityAssessmentChecksResult]:
    """
    This data source provides the list of Security Assessment Checks in Oracle Cloud Infrastructure Data Safe service.

    Lists all the security checks in the specified compartment for security assessment of type TEMPLATE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_checks = oci.DataSafe.get_security_assessment_checks(security_assessment_id=test_security_assessment["id"],
        access_level=security_assessment_check_access_level,
        compartment_id_in_subtree=security_assessment_check_compartment_id_in_subtree,
        contains_references=security_assessment_check_contains_references,
        contains_severities=security_assessment_check_contains_severity,
        key=security_assessment_check_key,
        suggested_severity=security_assessment_check_suggested_severity)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[_builtins.str] contains_references: An optional filter to return only findings that match the specified references. Use containsReferences param if need to filter by multiple references.
    :param Sequence[_builtins.str] contains_severities: A filter to return only findings that match the specified risk level(s). Use containsSeverity parameter if need to filter by multiple risk levels.
    :param _builtins.str key: Each check in security assessment has an associated key (think of key as a check's name). For a given check, the key will be the same across targets. The user can use these keys to filter the checks.
    :param _builtins.str security_assessment_id: The OCID of the security assessment.
    :param _builtins.str suggested_severity: A filter to return only checks of a particular risk level.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['containsReferences'] = contains_references
    __args__['containsSeverities'] = contains_severities
    __args__['filters'] = filters
    __args__['key'] = key
    __args__['securityAssessmentId'] = security_assessment_id
    __args__['suggestedSeverity'] = suggested_severity
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSecurityAssessmentChecks:getSecurityAssessmentChecks', __args__, opts=opts, typ=GetSecurityAssessmentChecksResult)
    return __ret__.apply(lambda __response__: GetSecurityAssessmentChecksResult(
        access_level=pulumi.get(__response__, 'access_level'),
        checks=pulumi.get(__response__, 'checks'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        contains_references=pulumi.get(__response__, 'contains_references'),
        contains_severities=pulumi.get(__response__, 'contains_severities'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        security_assessment_id=pulumi.get(__response__, 'security_assessment_id'),
        suggested_severity=pulumi.get(__response__, 'suggested_severity')))
