# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MaskingPolicyArgs', 'MaskingPolicy']

@pulumi.input_type
class MaskingPolicyArgs:
    def __init__(__self__, *,
                 column_sources: pulumi.Input[Sequence[pulumi.Input['MaskingPolicyColumnSourceArgs']]],
                 compartment_id: pulumi.Input[_builtins.str],
                 add_masking_columns_from_sdm_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 generate_health_report_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 is_drop_temp_tables_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_redo_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_refresh_stats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 parallel_degree: Optional[pulumi.Input[_builtins.str]] = None,
                 post_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
                 recompile: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MaskingPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input['MaskingPolicyColumnSourceArgs']]] column_sources: (Updatable) Details to associate a column source with a masking policy.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the masking policy should be created.
        :param pulumi.Input[_builtins.int] add_masking_columns_from_sdm_trigger: (Updatable) An optional property when incremented triggers Add Masking Columns From Sdm. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the masking policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the masking policy. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.int] generate_health_report_trigger: (Updatable) An optional property when incremented triggers Generate Health Report. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_drop_temp_tables_enabled: (Updatable) Indicates if the temporary tables created during a masking operation should be dropped after masking. It's enabled by default. Set this attribute to false to preserve the temporary tables. Masking creates temporary tables that map the original sensitive  data values to mask values. By default, these temporary tables are dropped after masking. But, in some cases, you may want  to preserve this information to track how masking changed your data. Note that doing so compromises security. These tables  must be dropped before the database is available for unprivileged users.
        :param pulumi.Input[_builtins.bool] is_redo_logging_enabled: (Updatable) Indicates if redo logging is enabled during a masking operation. It's disabled by default. Set this attribute to true to enable redo logging. By default, masking disables redo logging and flashback logging to purge any original unmasked  data from logs. However, in certain circumstances when you only want to test masking, rollback changes, and retry masking, you could enable logging and use a flashback database to retrieve the original unmasked data after it has been masked.
        :param pulumi.Input[_builtins.bool] is_refresh_stats_enabled: (Updatable) Indicates if statistics gathering is enabled. It's enabled by default. Set this attribute to false to disable statistics gathering. The masking process gathers statistics on masked database tables after masking completes.
        :param pulumi.Input[_builtins.str] parallel_degree: (Updatable) Specifies options to enable parallel execution when running data masking. Allowed values are 'NONE' (no parallelism), 'DEFAULT' (the Oracle Database computes the optimum degree of parallelism) or an integer value to be used as the degree of parallelism. Parallel execution helps effectively use multiple CPUs and improve masking performance. Refer to the Oracle Database parallel execution framework when choosing an explicit degree of parallelism.
        :param pulumi.Input[_builtins.str] post_masking_script: (Updatable) A post-masking script, which can contain SQL and PL/SQL statements. It's executed after the core masking script generated using the masking policy. It's usually used to perform additional transformation or cleanup work after masking.
        :param pulumi.Input[_builtins.str] pre_masking_script: (Updatable) A pre-masking script, which can contain SQL and PL/SQL statements. It's executed before  the core masking script generated using the masking policy. It's usually used to perform any preparation or prerequisite work before masking data.
        :param pulumi.Input[_builtins.str] recompile: (Updatable) Specifies how to recompile invalid objects post data masking. Allowed values are 'SERIAL' (recompile in serial),  'PARALLEL' (recompile in parallel), 'NONE' (do not recompile). If it's set to PARALLEL, the value of parallelDegree attribute is used. Use the built-in UTL_RECOMP package to recompile any remaining invalid objects after masking completes.
        """
        pulumi.set(__self__, "column_sources", column_sources)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if add_masking_columns_from_sdm_trigger is not None:
            pulumi.set(__self__, "add_masking_columns_from_sdm_trigger", add_masking_columns_from_sdm_trigger)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_health_report_trigger is not None:
            pulumi.set(__self__, "generate_health_report_trigger", generate_health_report_trigger)
        if is_drop_temp_tables_enabled is not None:
            pulumi.set(__self__, "is_drop_temp_tables_enabled", is_drop_temp_tables_enabled)
        if is_redo_logging_enabled is not None:
            pulumi.set(__self__, "is_redo_logging_enabled", is_redo_logging_enabled)
        if is_refresh_stats_enabled is not None:
            pulumi.set(__self__, "is_refresh_stats_enabled", is_refresh_stats_enabled)
        if parallel_degree is not None:
            pulumi.set(__self__, "parallel_degree", parallel_degree)
        if post_masking_script is not None:
            pulumi.set(__self__, "post_masking_script", post_masking_script)
        if pre_masking_script is not None:
            pulumi.set(__self__, "pre_masking_script", pre_masking_script)
        if recompile is not None:
            pulumi.set(__self__, "recompile", recompile)

    @_builtins.property
    @pulumi.getter(name="columnSources")
    def column_sources(self) -> pulumi.Input[Sequence[pulumi.Input['MaskingPolicyColumnSourceArgs']]]:
        """
        (Updatable) Details to associate a column source with a masking policy.
        """
        return pulumi.get(self, "column_sources")

    @column_sources.setter
    def column_sources(self, value: pulumi.Input[Sequence[pulumi.Input['MaskingPolicyColumnSourceArgs']]]):
        pulumi.set(self, "column_sources", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where the masking policy should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="addMaskingColumnsFromSdmTrigger")
    def add_masking_columns_from_sdm_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Add Masking Columns From Sdm. Could be set to any integer value.
        """
        return pulumi.get(self, "add_masking_columns_from_sdm_trigger")

    @add_masking_columns_from_sdm_trigger.setter
    def add_masking_columns_from_sdm_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "add_masking_columns_from_sdm_trigger", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the masking policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the masking policy. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="generateHealthReportTrigger")
    def generate_health_report_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Health Report. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "generate_health_report_trigger")

    @generate_health_report_trigger.setter
    def generate_health_report_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "generate_health_report_trigger", value)

    @_builtins.property
    @pulumi.getter(name="isDropTempTablesEnabled")
    def is_drop_temp_tables_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if the temporary tables created during a masking operation should be dropped after masking. It's enabled by default. Set this attribute to false to preserve the temporary tables. Masking creates temporary tables that map the original sensitive  data values to mask values. By default, these temporary tables are dropped after masking. But, in some cases, you may want  to preserve this information to track how masking changed your data. Note that doing so compromises security. These tables  must be dropped before the database is available for unprivileged users.
        """
        return pulumi.get(self, "is_drop_temp_tables_enabled")

    @is_drop_temp_tables_enabled.setter
    def is_drop_temp_tables_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_drop_temp_tables_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isRedoLoggingEnabled")
    def is_redo_logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if redo logging is enabled during a masking operation. It's disabled by default. Set this attribute to true to enable redo logging. By default, masking disables redo logging and flashback logging to purge any original unmasked  data from logs. However, in certain circumstances when you only want to test masking, rollback changes, and retry masking, you could enable logging and use a flashback database to retrieve the original unmasked data after it has been masked.
        """
        return pulumi.get(self, "is_redo_logging_enabled")

    @is_redo_logging_enabled.setter
    def is_redo_logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_redo_logging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isRefreshStatsEnabled")
    def is_refresh_stats_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if statistics gathering is enabled. It's enabled by default. Set this attribute to false to disable statistics gathering. The masking process gathers statistics on masked database tables after masking completes.
        """
        return pulumi.get(self, "is_refresh_stats_enabled")

    @is_refresh_stats_enabled.setter
    def is_refresh_stats_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_refresh_stats_enabled", value)

    @_builtins.property
    @pulumi.getter(name="parallelDegree")
    def parallel_degree(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies options to enable parallel execution when running data masking. Allowed values are 'NONE' (no parallelism), 'DEFAULT' (the Oracle Database computes the optimum degree of parallelism) or an integer value to be used as the degree of parallelism. Parallel execution helps effectively use multiple CPUs and improve masking performance. Refer to the Oracle Database parallel execution framework when choosing an explicit degree of parallelism.
        """
        return pulumi.get(self, "parallel_degree")

    @parallel_degree.setter
    def parallel_degree(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parallel_degree", value)

    @_builtins.property
    @pulumi.getter(name="postMaskingScript")
    def post_masking_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A post-masking script, which can contain SQL and PL/SQL statements. It's executed after the core masking script generated using the masking policy. It's usually used to perform additional transformation or cleanup work after masking.
        """
        return pulumi.get(self, "post_masking_script")

    @post_masking_script.setter
    def post_masking_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_masking_script", value)

    @_builtins.property
    @pulumi.getter(name="preMaskingScript")
    def pre_masking_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A pre-masking script, which can contain SQL and PL/SQL statements. It's executed before  the core masking script generated using the masking policy. It's usually used to perform any preparation or prerequisite work before masking data.
        """
        return pulumi.get(self, "pre_masking_script")

    @pre_masking_script.setter
    def pre_masking_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_masking_script", value)

    @_builtins.property
    @pulumi.getter
    def recompile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies how to recompile invalid objects post data masking. Allowed values are 'SERIAL' (recompile in serial),  'PARALLEL' (recompile in parallel), 'NONE' (do not recompile). If it's set to PARALLEL, the value of parallelDegree attribute is used. Use the built-in UTL_RECOMP package to recompile any remaining invalid objects after masking completes.
        """
        return pulumi.get(self, "recompile")

    @recompile.setter
    def recompile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recompile", value)


@pulumi.input_type
class _MaskingPolicyState:
    def __init__(__self__, *,
                 add_masking_columns_from_sdm_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 column_sources: Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPolicyColumnSourceArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 generate_health_report_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 is_drop_temp_tables_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_redo_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_refresh_stats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 parallel_degree: Optional[pulumi.Input[_builtins.str]] = None,
                 post_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
                 recompile: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MaskingPolicy resources.
        :param pulumi.Input[_builtins.int] add_masking_columns_from_sdm_trigger: (Updatable) An optional property when incremented triggers Add Masking Columns From Sdm. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input['MaskingPolicyColumnSourceArgs']]] column_sources: (Updatable) Details to associate a column source with a masking policy.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the masking policy should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the masking policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the masking policy. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.int] generate_health_report_trigger: (Updatable) An optional property when incremented triggers Generate Health Report. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_drop_temp_tables_enabled: (Updatable) Indicates if the temporary tables created during a masking operation should be dropped after masking. It's enabled by default. Set this attribute to false to preserve the temporary tables. Masking creates temporary tables that map the original sensitive  data values to mask values. By default, these temporary tables are dropped after masking. But, in some cases, you may want  to preserve this information to track how masking changed your data. Note that doing so compromises security. These tables  must be dropped before the database is available for unprivileged users.
        :param pulumi.Input[_builtins.bool] is_redo_logging_enabled: (Updatable) Indicates if redo logging is enabled during a masking operation. It's disabled by default. Set this attribute to true to enable redo logging. By default, masking disables redo logging and flashback logging to purge any original unmasked  data from logs. However, in certain circumstances when you only want to test masking, rollback changes, and retry masking, you could enable logging and use a flashback database to retrieve the original unmasked data after it has been masked.
        :param pulumi.Input[_builtins.bool] is_refresh_stats_enabled: (Updatable) Indicates if statistics gathering is enabled. It's enabled by default. Set this attribute to false to disable statistics gathering. The masking process gathers statistics on masked database tables after masking completes.
        :param pulumi.Input[_builtins.str] parallel_degree: (Updatable) Specifies options to enable parallel execution when running data masking. Allowed values are 'NONE' (no parallelism), 'DEFAULT' (the Oracle Database computes the optimum degree of parallelism) or an integer value to be used as the degree of parallelism. Parallel execution helps effectively use multiple CPUs and improve masking performance. Refer to the Oracle Database parallel execution framework when choosing an explicit degree of parallelism.
        :param pulumi.Input[_builtins.str] post_masking_script: (Updatable) A post-masking script, which can contain SQL and PL/SQL statements. It's executed after the core masking script generated using the masking policy. It's usually used to perform additional transformation or cleanup work after masking.
        :param pulumi.Input[_builtins.str] pre_masking_script: (Updatable) A pre-masking script, which can contain SQL and PL/SQL statements. It's executed before  the core masking script generated using the masking policy. It's usually used to perform any preparation or prerequisite work before masking data.
        :param pulumi.Input[_builtins.str] recompile: (Updatable) Specifies how to recompile invalid objects post data masking. Allowed values are 'SERIAL' (recompile in serial),  'PARALLEL' (recompile in parallel), 'NONE' (do not recompile). If it's set to PARALLEL, the value of parallelDegree attribute is used. Use the built-in UTL_RECOMP package to recompile any remaining invalid objects after masking completes.
        :param pulumi.Input[_builtins.str] state: The current state of the masking policy.
        :param pulumi.Input[_builtins.str] time_created: The date and time the masking policy was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the masking policy was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        if add_masking_columns_from_sdm_trigger is not None:
            pulumi.set(__self__, "add_masking_columns_from_sdm_trigger", add_masking_columns_from_sdm_trigger)
        if column_sources is not None:
            pulumi.set(__self__, "column_sources", column_sources)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_health_report_trigger is not None:
            pulumi.set(__self__, "generate_health_report_trigger", generate_health_report_trigger)
        if is_drop_temp_tables_enabled is not None:
            pulumi.set(__self__, "is_drop_temp_tables_enabled", is_drop_temp_tables_enabled)
        if is_redo_logging_enabled is not None:
            pulumi.set(__self__, "is_redo_logging_enabled", is_redo_logging_enabled)
        if is_refresh_stats_enabled is not None:
            pulumi.set(__self__, "is_refresh_stats_enabled", is_refresh_stats_enabled)
        if parallel_degree is not None:
            pulumi.set(__self__, "parallel_degree", parallel_degree)
        if post_masking_script is not None:
            pulumi.set(__self__, "post_masking_script", post_masking_script)
        if pre_masking_script is not None:
            pulumi.set(__self__, "pre_masking_script", pre_masking_script)
        if recompile is not None:
            pulumi.set(__self__, "recompile", recompile)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="addMaskingColumnsFromSdmTrigger")
    def add_masking_columns_from_sdm_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Add Masking Columns From Sdm. Could be set to any integer value.
        """
        return pulumi.get(self, "add_masking_columns_from_sdm_trigger")

    @add_masking_columns_from_sdm_trigger.setter
    def add_masking_columns_from_sdm_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "add_masking_columns_from_sdm_trigger", value)

    @_builtins.property
    @pulumi.getter(name="columnSources")
    def column_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPolicyColumnSourceArgs']]]]:
        """
        (Updatable) Details to associate a column source with a masking policy.
        """
        return pulumi.get(self, "column_sources")

    @column_sources.setter
    def column_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPolicyColumnSourceArgs']]]]):
        pulumi.set(self, "column_sources", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment where the masking policy should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the masking policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the masking policy. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="generateHealthReportTrigger")
    def generate_health_report_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Health Report. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "generate_health_report_trigger")

    @generate_health_report_trigger.setter
    def generate_health_report_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "generate_health_report_trigger", value)

    @_builtins.property
    @pulumi.getter(name="isDropTempTablesEnabled")
    def is_drop_temp_tables_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if the temporary tables created during a masking operation should be dropped after masking. It's enabled by default. Set this attribute to false to preserve the temporary tables. Masking creates temporary tables that map the original sensitive  data values to mask values. By default, these temporary tables are dropped after masking. But, in some cases, you may want  to preserve this information to track how masking changed your data. Note that doing so compromises security. These tables  must be dropped before the database is available for unprivileged users.
        """
        return pulumi.get(self, "is_drop_temp_tables_enabled")

    @is_drop_temp_tables_enabled.setter
    def is_drop_temp_tables_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_drop_temp_tables_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isRedoLoggingEnabled")
    def is_redo_logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if redo logging is enabled during a masking operation. It's disabled by default. Set this attribute to true to enable redo logging. By default, masking disables redo logging and flashback logging to purge any original unmasked  data from logs. However, in certain circumstances when you only want to test masking, rollback changes, and retry masking, you could enable logging and use a flashback database to retrieve the original unmasked data after it has been masked.
        """
        return pulumi.get(self, "is_redo_logging_enabled")

    @is_redo_logging_enabled.setter
    def is_redo_logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_redo_logging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isRefreshStatsEnabled")
    def is_refresh_stats_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if statistics gathering is enabled. It's enabled by default. Set this attribute to false to disable statistics gathering. The masking process gathers statistics on masked database tables after masking completes.
        """
        return pulumi.get(self, "is_refresh_stats_enabled")

    @is_refresh_stats_enabled.setter
    def is_refresh_stats_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_refresh_stats_enabled", value)

    @_builtins.property
    @pulumi.getter(name="parallelDegree")
    def parallel_degree(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies options to enable parallel execution when running data masking. Allowed values are 'NONE' (no parallelism), 'DEFAULT' (the Oracle Database computes the optimum degree of parallelism) or an integer value to be used as the degree of parallelism. Parallel execution helps effectively use multiple CPUs and improve masking performance. Refer to the Oracle Database parallel execution framework when choosing an explicit degree of parallelism.
        """
        return pulumi.get(self, "parallel_degree")

    @parallel_degree.setter
    def parallel_degree(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parallel_degree", value)

    @_builtins.property
    @pulumi.getter(name="postMaskingScript")
    def post_masking_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A post-masking script, which can contain SQL and PL/SQL statements. It's executed after the core masking script generated using the masking policy. It's usually used to perform additional transformation or cleanup work after masking.
        """
        return pulumi.get(self, "post_masking_script")

    @post_masking_script.setter
    def post_masking_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_masking_script", value)

    @_builtins.property
    @pulumi.getter(name="preMaskingScript")
    def pre_masking_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A pre-masking script, which can contain SQL and PL/SQL statements. It's executed before  the core masking script generated using the masking policy. It's usually used to perform any preparation or prerequisite work before masking data.
        """
        return pulumi.get(self, "pre_masking_script")

    @pre_masking_script.setter
    def pre_masking_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_masking_script", value)

    @_builtins.property
    @pulumi.getter
    def recompile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies how to recompile invalid objects post data masking. Allowed values are 'SERIAL' (recompile in serial),  'PARALLEL' (recompile in parallel), 'NONE' (do not recompile). If it's set to PARALLEL, the value of parallelDegree attribute is used. Use the built-in UTL_RECOMP package to recompile any remaining invalid objects after masking completes.
        """
        return pulumi.get(self, "recompile")

    @recompile.setter
    def recompile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recompile", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the masking policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the masking policy was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the masking policy was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataSafe/maskingPolicy:MaskingPolicy")
class MaskingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_masking_columns_from_sdm_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 column_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MaskingPolicyColumnSourceArgs', 'MaskingPolicyColumnSourceArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 generate_health_report_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 is_drop_temp_tables_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_redo_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_refresh_stats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 parallel_degree: Optional[pulumi.Input[_builtins.str]] = None,
                 post_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
                 recompile: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_masking_policy = oci.datasafe.MaskingPolicy("test_masking_policy",
            column_sources=[{
                "column_source": masking_policy_column_source_column_source,
                "sensitive_data_model_id": test_sensitive_data_model["id"],
                "target_id": test_target["id"],
            }],
            compartment_id=compartment_id,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=masking_policy_description,
            display_name=masking_policy_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_drop_temp_tables_enabled=masking_policy_is_drop_temp_tables_enabled,
            is_redo_logging_enabled=masking_policy_is_redo_logging_enabled,
            is_refresh_stats_enabled=masking_policy_is_refresh_stats_enabled,
            parallel_degree=masking_policy_parallel_degree,
            post_masking_script=masking_policy_post_masking_script,
            pre_masking_script=masking_policy_pre_masking_script,
            recompile=masking_policy_recompile)
        ```

        ## Import

        MaskingPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/maskingPolicy:MaskingPolicy test_masking_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] add_masking_columns_from_sdm_trigger: (Updatable) An optional property when incremented triggers Add Masking Columns From Sdm. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MaskingPolicyColumnSourceArgs', 'MaskingPolicyColumnSourceArgsDict']]]] column_sources: (Updatable) Details to associate a column source with a masking policy.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the masking policy should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the masking policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the masking policy. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.int] generate_health_report_trigger: (Updatable) An optional property when incremented triggers Generate Health Report. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_drop_temp_tables_enabled: (Updatable) Indicates if the temporary tables created during a masking operation should be dropped after masking. It's enabled by default. Set this attribute to false to preserve the temporary tables. Masking creates temporary tables that map the original sensitive  data values to mask values. By default, these temporary tables are dropped after masking. But, in some cases, you may want  to preserve this information to track how masking changed your data. Note that doing so compromises security. These tables  must be dropped before the database is available for unprivileged users.
        :param pulumi.Input[_builtins.bool] is_redo_logging_enabled: (Updatable) Indicates if redo logging is enabled during a masking operation. It's disabled by default. Set this attribute to true to enable redo logging. By default, masking disables redo logging and flashback logging to purge any original unmasked  data from logs. However, in certain circumstances when you only want to test masking, rollback changes, and retry masking, you could enable logging and use a flashback database to retrieve the original unmasked data after it has been masked.
        :param pulumi.Input[_builtins.bool] is_refresh_stats_enabled: (Updatable) Indicates if statistics gathering is enabled. It's enabled by default. Set this attribute to false to disable statistics gathering. The masking process gathers statistics on masked database tables after masking completes.
        :param pulumi.Input[_builtins.str] parallel_degree: (Updatable) Specifies options to enable parallel execution when running data masking. Allowed values are 'NONE' (no parallelism), 'DEFAULT' (the Oracle Database computes the optimum degree of parallelism) or an integer value to be used as the degree of parallelism. Parallel execution helps effectively use multiple CPUs and improve masking performance. Refer to the Oracle Database parallel execution framework when choosing an explicit degree of parallelism.
        :param pulumi.Input[_builtins.str] post_masking_script: (Updatable) A post-masking script, which can contain SQL and PL/SQL statements. It's executed after the core masking script generated using the masking policy. It's usually used to perform additional transformation or cleanup work after masking.
        :param pulumi.Input[_builtins.str] pre_masking_script: (Updatable) A pre-masking script, which can contain SQL and PL/SQL statements. It's executed before  the core masking script generated using the masking policy. It's usually used to perform any preparation or prerequisite work before masking data.
        :param pulumi.Input[_builtins.str] recompile: (Updatable) Specifies how to recompile invalid objects post data masking. Allowed values are 'SERIAL' (recompile in serial),  'PARALLEL' (recompile in parallel), 'NONE' (do not recompile). If it's set to PARALLEL, the value of parallelDegree attribute is used. Use the built-in UTL_RECOMP package to recompile any remaining invalid objects after masking completes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaskingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_masking_policy = oci.datasafe.MaskingPolicy("test_masking_policy",
            column_sources=[{
                "column_source": masking_policy_column_source_column_source,
                "sensitive_data_model_id": test_sensitive_data_model["id"],
                "target_id": test_target["id"],
            }],
            compartment_id=compartment_id,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=masking_policy_description,
            display_name=masking_policy_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_drop_temp_tables_enabled=masking_policy_is_drop_temp_tables_enabled,
            is_redo_logging_enabled=masking_policy_is_redo_logging_enabled,
            is_refresh_stats_enabled=masking_policy_is_refresh_stats_enabled,
            parallel_degree=masking_policy_parallel_degree,
            post_masking_script=masking_policy_post_masking_script,
            pre_masking_script=masking_policy_pre_masking_script,
            recompile=masking_policy_recompile)
        ```

        ## Import

        MaskingPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/maskingPolicy:MaskingPolicy test_masking_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param MaskingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaskingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_masking_columns_from_sdm_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 column_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MaskingPolicyColumnSourceArgs', 'MaskingPolicyColumnSourceArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 generate_health_report_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 is_drop_temp_tables_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_redo_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_refresh_stats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 parallel_degree: Optional[pulumi.Input[_builtins.str]] = None,
                 post_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
                 recompile: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaskingPolicyArgs.__new__(MaskingPolicyArgs)

            __props__.__dict__["add_masking_columns_from_sdm_trigger"] = add_masking_columns_from_sdm_trigger
            if column_sources is None and not opts.urn:
                raise TypeError("Missing required property 'column_sources'")
            __props__.__dict__["column_sources"] = column_sources
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["generate_health_report_trigger"] = generate_health_report_trigger
            __props__.__dict__["is_drop_temp_tables_enabled"] = is_drop_temp_tables_enabled
            __props__.__dict__["is_redo_logging_enabled"] = is_redo_logging_enabled
            __props__.__dict__["is_refresh_stats_enabled"] = is_refresh_stats_enabled
            __props__.__dict__["parallel_degree"] = parallel_degree
            __props__.__dict__["post_masking_script"] = post_masking_script
            __props__.__dict__["pre_masking_script"] = pre_masking_script
            __props__.__dict__["recompile"] = recompile
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MaskingPolicy, __self__).__init__(
            'oci:DataSafe/maskingPolicy:MaskingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_masking_columns_from_sdm_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            column_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MaskingPolicyColumnSourceArgs', 'MaskingPolicyColumnSourceArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            generate_health_report_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            is_drop_temp_tables_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_redo_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_refresh_stats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            parallel_degree: Optional[pulumi.Input[_builtins.str]] = None,
            post_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
            pre_masking_script: Optional[pulumi.Input[_builtins.str]] = None,
            recompile: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'MaskingPolicy':
        """
        Get an existing MaskingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] add_masking_columns_from_sdm_trigger: (Updatable) An optional property when incremented triggers Add Masking Columns From Sdm. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MaskingPolicyColumnSourceArgs', 'MaskingPolicyColumnSourceArgsDict']]]] column_sources: (Updatable) Details to associate a column source with a masking policy.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the masking policy should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the masking policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the masking policy. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.int] generate_health_report_trigger: (Updatable) An optional property when incremented triggers Generate Health Report. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_drop_temp_tables_enabled: (Updatable) Indicates if the temporary tables created during a masking operation should be dropped after masking. It's enabled by default. Set this attribute to false to preserve the temporary tables. Masking creates temporary tables that map the original sensitive  data values to mask values. By default, these temporary tables are dropped after masking. But, in some cases, you may want  to preserve this information to track how masking changed your data. Note that doing so compromises security. These tables  must be dropped before the database is available for unprivileged users.
        :param pulumi.Input[_builtins.bool] is_redo_logging_enabled: (Updatable) Indicates if redo logging is enabled during a masking operation. It's disabled by default. Set this attribute to true to enable redo logging. By default, masking disables redo logging and flashback logging to purge any original unmasked  data from logs. However, in certain circumstances when you only want to test masking, rollback changes, and retry masking, you could enable logging and use a flashback database to retrieve the original unmasked data after it has been masked.
        :param pulumi.Input[_builtins.bool] is_refresh_stats_enabled: (Updatable) Indicates if statistics gathering is enabled. It's enabled by default. Set this attribute to false to disable statistics gathering. The masking process gathers statistics on masked database tables after masking completes.
        :param pulumi.Input[_builtins.str] parallel_degree: (Updatable) Specifies options to enable parallel execution when running data masking. Allowed values are 'NONE' (no parallelism), 'DEFAULT' (the Oracle Database computes the optimum degree of parallelism) or an integer value to be used as the degree of parallelism. Parallel execution helps effectively use multiple CPUs and improve masking performance. Refer to the Oracle Database parallel execution framework when choosing an explicit degree of parallelism.
        :param pulumi.Input[_builtins.str] post_masking_script: (Updatable) A post-masking script, which can contain SQL and PL/SQL statements. It's executed after the core masking script generated using the masking policy. It's usually used to perform additional transformation or cleanup work after masking.
        :param pulumi.Input[_builtins.str] pre_masking_script: (Updatable) A pre-masking script, which can contain SQL and PL/SQL statements. It's executed before  the core masking script generated using the masking policy. It's usually used to perform any preparation or prerequisite work before masking data.
        :param pulumi.Input[_builtins.str] recompile: (Updatable) Specifies how to recompile invalid objects post data masking. Allowed values are 'SERIAL' (recompile in serial),  'PARALLEL' (recompile in parallel), 'NONE' (do not recompile). If it's set to PARALLEL, the value of parallelDegree attribute is used. Use the built-in UTL_RECOMP package to recompile any remaining invalid objects after masking completes.
        :param pulumi.Input[_builtins.str] state: The current state of the masking policy.
        :param pulumi.Input[_builtins.str] time_created: The date and time the masking policy was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the masking policy was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaskingPolicyState.__new__(_MaskingPolicyState)

        __props__.__dict__["add_masking_columns_from_sdm_trigger"] = add_masking_columns_from_sdm_trigger
        __props__.__dict__["column_sources"] = column_sources
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["generate_health_report_trigger"] = generate_health_report_trigger
        __props__.__dict__["is_drop_temp_tables_enabled"] = is_drop_temp_tables_enabled
        __props__.__dict__["is_redo_logging_enabled"] = is_redo_logging_enabled
        __props__.__dict__["is_refresh_stats_enabled"] = is_refresh_stats_enabled
        __props__.__dict__["parallel_degree"] = parallel_degree
        __props__.__dict__["post_masking_script"] = post_masking_script
        __props__.__dict__["pre_masking_script"] = pre_masking_script
        __props__.__dict__["recompile"] = recompile
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MaskingPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addMaskingColumnsFromSdmTrigger")
    def add_masking_columns_from_sdm_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Add Masking Columns From Sdm. Could be set to any integer value.
        """
        return pulumi.get(self, "add_masking_columns_from_sdm_trigger")

    @_builtins.property
    @pulumi.getter(name="columnSources")
    def column_sources(self) -> pulumi.Output[Sequence['outputs.MaskingPolicyColumnSource']]:
        """
        (Updatable) Details to associate a column source with a masking policy.
        """
        return pulumi.get(self, "column_sources")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where the masking policy should be created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the masking policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the masking policy. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="generateHealthReportTrigger")
    def generate_health_report_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Health Report. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "generate_health_report_trigger")

    @_builtins.property
    @pulumi.getter(name="isDropTempTablesEnabled")
    def is_drop_temp_tables_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if the temporary tables created during a masking operation should be dropped after masking. It's enabled by default. Set this attribute to false to preserve the temporary tables. Masking creates temporary tables that map the original sensitive  data values to mask values. By default, these temporary tables are dropped after masking. But, in some cases, you may want  to preserve this information to track how masking changed your data. Note that doing so compromises security. These tables  must be dropped before the database is available for unprivileged users.
        """
        return pulumi.get(self, "is_drop_temp_tables_enabled")

    @_builtins.property
    @pulumi.getter(name="isRedoLoggingEnabled")
    def is_redo_logging_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if redo logging is enabled during a masking operation. It's disabled by default. Set this attribute to true to enable redo logging. By default, masking disables redo logging and flashback logging to purge any original unmasked  data from logs. However, in certain circumstances when you only want to test masking, rollback changes, and retry masking, you could enable logging and use a flashback database to retrieve the original unmasked data after it has been masked.
        """
        return pulumi.get(self, "is_redo_logging_enabled")

    @_builtins.property
    @pulumi.getter(name="isRefreshStatsEnabled")
    def is_refresh_stats_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if statistics gathering is enabled. It's enabled by default. Set this attribute to false to disable statistics gathering. The masking process gathers statistics on masked database tables after masking completes.
        """
        return pulumi.get(self, "is_refresh_stats_enabled")

    @_builtins.property
    @pulumi.getter(name="parallelDegree")
    def parallel_degree(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Specifies options to enable parallel execution when running data masking. Allowed values are 'NONE' (no parallelism), 'DEFAULT' (the Oracle Database computes the optimum degree of parallelism) or an integer value to be used as the degree of parallelism. Parallel execution helps effectively use multiple CPUs and improve masking performance. Refer to the Oracle Database parallel execution framework when choosing an explicit degree of parallelism.
        """
        return pulumi.get(self, "parallel_degree")

    @_builtins.property
    @pulumi.getter(name="postMaskingScript")
    def post_masking_script(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A post-masking script, which can contain SQL and PL/SQL statements. It's executed after the core masking script generated using the masking policy. It's usually used to perform additional transformation or cleanup work after masking.
        """
        return pulumi.get(self, "post_masking_script")

    @_builtins.property
    @pulumi.getter(name="preMaskingScript")
    def pre_masking_script(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A pre-masking script, which can contain SQL and PL/SQL statements. It's executed before  the core masking script generated using the masking policy. It's usually used to perform any preparation or prerequisite work before masking data.
        """
        return pulumi.get(self, "pre_masking_script")

    @_builtins.property
    @pulumi.getter
    def recompile(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Specifies how to recompile invalid objects post data masking. Allowed values are 'SERIAL' (recompile in serial),  'PARALLEL' (recompile in parallel), 'NONE' (do not recompile). If it's set to PARALLEL, the value of parallelDegree attribute is used. Use the built-in UTL_RECOMP package to recompile any remaining invalid objects after masking completes.
        """
        return pulumi.get(self, "recompile")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the masking policy.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the masking policy was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the masking policy was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_updated")

