# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityAssessmentCheckInitArgs', 'SecurityAssessmentCheck']

@pulumi.input_type
class SecurityAssessmentCheckInitArgs:
    def __init__(__self__, *,
                 security_assessment_id: pulumi.Input[_builtins.str],
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckPatchOperationArgs']]]] = None):
        """
        The set of arguments for constructing a SecurityAssessmentCheck resource.
        :param pulumi.Input[_builtins.str] security_assessment_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckPatchOperationArgs']]] patch_operations: (Updatable)
        """
        pulumi.set(__self__, "security_assessment_id", security_assessment_id)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)

    @_builtins.property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> pulumi.Input[_builtins.str]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_assessment_id")

    @security_assessment_id.setter
    def security_assessment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_assessment_id", value)

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckPatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)


@pulumi.input_type
class _SecurityAssessmentCheckState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 oneline: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckPatchOperationArgs']]]] = None,
                 references: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckReferenceArgs']]]] = None,
                 remarks: Optional[pulumi.Input[_builtins.str]] = None,
                 security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 suggested_severity: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityAssessmentCheck resources.
        :param pulumi.Input[_builtins.str] category: The category to which the check belongs to.
        :param pulumi.Input[_builtins.str] key: A unique identifier for the check.
        :param pulumi.Input[_builtins.str] oneline: Provides a recommended approach to take to remediate the check reported.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckPatchOperationArgs']]] patch_operations: (Updatable)
        :param pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckReferenceArgs']]] references: Provides information on whether the check is related to a CIS Oracle Database Benchmark recommendation, STIG rule, GDPR Article/Recital or related to the Oracle Best Practice.
        :param pulumi.Input[_builtins.str] remarks: The explanation of the issue in this check. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.
        :param pulumi.Input[_builtins.str] security_assessment_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] suggested_severity: The severity of the check as suggested by Data Safe security assessment. This will be the default severity in the template baseline security assessment.
        :param pulumi.Input[_builtins.str] title: The short title for the check.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if oneline is not None:
            pulumi.set(__self__, "oneline", oneline)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if references is not None:
            pulumi.set(__self__, "references", references)
        if remarks is not None:
            pulumi.set(__self__, "remarks", remarks)
        if security_assessment_id is not None:
            pulumi.set(__self__, "security_assessment_id", security_assessment_id)
        if suggested_severity is not None:
            pulumi.set(__self__, "suggested_severity", suggested_severity)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category to which the check belongs to.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for the check.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def oneline(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provides a recommended approach to take to remediate the check reported.
        """
        return pulumi.get(self, "oneline")

    @oneline.setter
    def oneline(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oneline", value)

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckPatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @_builtins.property
    @pulumi.getter
    def references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckReferenceArgs']]]]:
        """
        Provides information on whether the check is related to a CIS Oracle Database Benchmark recommendation, STIG rule, GDPR Article/Recital or related to the Oracle Best Practice.
        """
        return pulumi.get(self, "references")

    @references.setter
    def references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentCheckReferenceArgs']]]]):
        pulumi.set(self, "references", value)

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The explanation of the issue in this check. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.
        """
        return pulumi.get(self, "remarks")

    @remarks.setter
    def remarks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remarks", value)

    @_builtins.property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_assessment_id")

    @security_assessment_id.setter
    def security_assessment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_assessment_id", value)

    @_builtins.property
    @pulumi.getter(name="suggestedSeverity")
    def suggested_severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The severity of the check as suggested by Data Safe security assessment. This will be the default severity in the template baseline security assessment.
        """
        return pulumi.get(self, "suggested_severity")

    @suggested_severity.setter
    def suggested_severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suggested_severity", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The short title for the check.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("oci:DataSafe/securityAssessmentCheck:SecurityAssessmentCheck")
class SecurityAssessmentCheck(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentCheckPatchOperationArgs', 'SecurityAssessmentCheckPatchOperationArgsDict']]]]] = None,
                 security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_assessment_check = oci.datasafe.SecurityAssessmentCheck("test_security_assessment_check",
            security_assessment_id=test_security_assessment["id"],
            patch_operations=[{
                "operation": security_assessment_check_patch_operations_operation,
                "selection": security_assessment_check_patch_operations_selection,
                "value": security_assessment_check_patch_operations_value,
            }])
        ```

        ## Import

        SecurityAssessmentChecks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/securityAssessmentCheck:SecurityAssessmentCheck test_security_assessment_check "securityAssessments/{securityAssessmentId}/checks"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentCheckPatchOperationArgs', 'SecurityAssessmentCheckPatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[_builtins.str] security_assessment_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityAssessmentCheckInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_assessment_check = oci.datasafe.SecurityAssessmentCheck("test_security_assessment_check",
            security_assessment_id=test_security_assessment["id"],
            patch_operations=[{
                "operation": security_assessment_check_patch_operations_operation,
                "selection": security_assessment_check_patch_operations_selection,
                "value": security_assessment_check_patch_operations_value,
            }])
        ```

        ## Import

        SecurityAssessmentChecks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/securityAssessmentCheck:SecurityAssessmentCheck test_security_assessment_check "securityAssessments/{securityAssessmentId}/checks"
        ```

        :param str resource_name: The name of the resource.
        :param SecurityAssessmentCheckInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityAssessmentCheckInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentCheckPatchOperationArgs', 'SecurityAssessmentCheckPatchOperationArgsDict']]]]] = None,
                 security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityAssessmentCheckInitArgs.__new__(SecurityAssessmentCheckInitArgs)

            __props__.__dict__["patch_operations"] = patch_operations
            if security_assessment_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_assessment_id'")
            __props__.__dict__["security_assessment_id"] = security_assessment_id
            __props__.__dict__["category"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["oneline"] = None
            __props__.__dict__["references"] = None
            __props__.__dict__["remarks"] = None
            __props__.__dict__["suggested_severity"] = None
            __props__.__dict__["title"] = None
        super(SecurityAssessmentCheck, __self__).__init__(
            'oci:DataSafe/securityAssessmentCheck:SecurityAssessmentCheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            oneline: Optional[pulumi.Input[_builtins.str]] = None,
            patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentCheckPatchOperationArgs', 'SecurityAssessmentCheckPatchOperationArgsDict']]]]] = None,
            references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentCheckReferenceArgs', 'SecurityAssessmentCheckReferenceArgsDict']]]]] = None,
            remarks: Optional[pulumi.Input[_builtins.str]] = None,
            security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
            suggested_severity: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityAssessmentCheck':
        """
        Get an existing SecurityAssessmentCheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: The category to which the check belongs to.
        :param pulumi.Input[_builtins.str] key: A unique identifier for the check.
        :param pulumi.Input[_builtins.str] oneline: Provides a recommended approach to take to remediate the check reported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentCheckPatchOperationArgs', 'SecurityAssessmentCheckPatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentCheckReferenceArgs', 'SecurityAssessmentCheckReferenceArgsDict']]]] references: Provides information on whether the check is related to a CIS Oracle Database Benchmark recommendation, STIG rule, GDPR Article/Recital or related to the Oracle Best Practice.
        :param pulumi.Input[_builtins.str] remarks: The explanation of the issue in this check. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.
        :param pulumi.Input[_builtins.str] security_assessment_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] suggested_severity: The severity of the check as suggested by Data Safe security assessment. This will be the default severity in the template baseline security assessment.
        :param pulumi.Input[_builtins.str] title: The short title for the check.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityAssessmentCheckState.__new__(_SecurityAssessmentCheckState)

        __props__.__dict__["category"] = category
        __props__.__dict__["key"] = key
        __props__.__dict__["oneline"] = oneline
        __props__.__dict__["patch_operations"] = patch_operations
        __props__.__dict__["references"] = references
        __props__.__dict__["remarks"] = remarks
        __props__.__dict__["security_assessment_id"] = security_assessment_id
        __props__.__dict__["suggested_severity"] = suggested_severity
        __props__.__dict__["title"] = title
        return SecurityAssessmentCheck(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The category to which the check belongs to.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for the check.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def oneline(self) -> pulumi.Output[_builtins.str]:
        """
        Provides a recommended approach to take to remediate the check reported.
        """
        return pulumi.get(self, "oneline")

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityAssessmentCheckPatchOperation']]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @_builtins.property
    @pulumi.getter
    def references(self) -> pulumi.Output[Sequence['outputs.SecurityAssessmentCheckReference']]:
        """
        Provides information on whether the check is related to a CIS Oracle Database Benchmark recommendation, STIG rule, GDPR Article/Recital or related to the Oracle Best Practice.
        """
        return pulumi.get(self, "references")

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> pulumi.Output[_builtins.str]:
        """
        The explanation of the issue in this check. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.
        """
        return pulumi.get(self, "remarks")

    @_builtins.property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> pulumi.Output[_builtins.str]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_assessment_id")

    @_builtins.property
    @pulumi.getter(name="suggestedSeverity")
    def suggested_severity(self) -> pulumi.Output[_builtins.str]:
        """
        The severity of the check as suggested by Data Safe security assessment. This will be the default severity in the template baseline security assessment.
        """
        return pulumi.get(self, "suggested_severity")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[_builtins.str]:
        """
        The short title for the check.
        """
        return pulumi.get(self, "title")

