# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityAssessmentFindingArgs', 'SecurityAssessmentFinding']

@pulumi.input_type
class SecurityAssessmentFindingArgs:
    def __init__(__self__, *,
                 security_assessment_id: pulumi.Input[_builtins.str],
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingPatchOperationArgs']]]] = None):
        """
        The set of arguments for constructing a SecurityAssessmentFinding resource.
        :param pulumi.Input[_builtins.str] security_assessment_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingPatchOperationArgs']]] patch_operations: (Updatable)
        """
        pulumi.set(__self__, "security_assessment_id", security_assessment_id)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)

    @_builtins.property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> pulumi.Input[_builtins.str]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_assessment_id")

    @security_assessment_id.setter
    def security_assessment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_assessment_id", value)

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingPatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)


@pulumi.input_type
class _SecurityAssessmentFindingState:
    def __init__(__self__, *,
                 assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 has_target_db_risk_level_changed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_risk_modified: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_top_finding: Optional[pulumi.Input[_builtins.bool]] = None,
                 justification: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 oneline: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_defined_severity: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingPatchOperationArgs']]]] = None,
                 references: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingReferenceArgs']]]] = None,
                 remarks: Optional[pulumi.Input[_builtins.str]] = None,
                 security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 time_valid_until: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityAssessmentFinding resources.
        :param pulumi.Input[_builtins.str] assessment_id: The OCID of the assessment that generated this finding.
        :param pulumi.Input[_builtins.str] category: The category to which the finding belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] details: The details of the finding. Provides detailed information to explain the finding summary, typically results from the assessed database, followed by any recommendations for changes.
        :param pulumi.Input[_builtins.bool] has_target_db_risk_level_changed: Determines if this risk level has changed on the target database since the last time 'severity' was modified by user.
        :param pulumi.Input[_builtins.bool] is_risk_modified: Determines if this risk level was modified by user.
        :param pulumi.Input[_builtins.bool] is_top_finding: Indicates whether a given finding is marked as topFinding or not.
        :param pulumi.Input[_builtins.str] justification: User provided reason for accepting or modifying this finding if they choose to do so.
        :param pulumi.Input[_builtins.str] key: The unique finding key. This is a system-generated identifier. To get the finding key for a finding, use ListFindings.
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the finding.
        :param pulumi.Input[_builtins.str] oneline: Provides a recommended approach to take to remediate the finding reported.
        :param pulumi.Input[_builtins.str] oracle_defined_severity: The severity of the finding as determined by security assessment. This cannot be modified by user.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingPatchOperationArgs']]] patch_operations: (Updatable)
        :param pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingReferenceArgs']]] references: Provides information on whether the finding is related to a CIS Oracle Database Benchmark recommendation, a STIG rule, or a GDPR Article/Recital.
        :param pulumi.Input[_builtins.str] remarks: The explanation of the issue in this finding. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.
        :param pulumi.Input[_builtins.str] security_assessment_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] severity: The severity of the finding as determined by security assessment and is same as oracleDefinedSeverity, unless modified by user.
        :param pulumi.Input[_builtins.str] state: The current state of the finding.
        :param pulumi.Input[_builtins.str] summary: The brief summary of the finding. When the finding is informational, the summary typically reports only the number of data elements that were examined.
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target database.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the risk level of finding was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_valid_until: The time until which the change in severity(deferred / modified) of this finding is valid.
        :param pulumi.Input[_builtins.str] title: The short title for the finding.
        """
        if assessment_id is not None:
            pulumi.set(__self__, "assessment_id", assessment_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if has_target_db_risk_level_changed is not None:
            pulumi.set(__self__, "has_target_db_risk_level_changed", has_target_db_risk_level_changed)
        if is_risk_modified is not None:
            pulumi.set(__self__, "is_risk_modified", is_risk_modified)
        if is_top_finding is not None:
            pulumi.set(__self__, "is_top_finding", is_top_finding)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if oneline is not None:
            pulumi.set(__self__, "oneline", oneline)
        if oracle_defined_severity is not None:
            pulumi.set(__self__, "oracle_defined_severity", oracle_defined_severity)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if references is not None:
            pulumi.set(__self__, "references", references)
        if remarks is not None:
            pulumi.set(__self__, "remarks", remarks)
        if security_assessment_id is not None:
            pulumi.set(__self__, "security_assessment_id", security_assessment_id)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if time_valid_until is not None:
            pulumi.set(__self__, "time_valid_until", time_valid_until)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the assessment that generated this finding.
        """
        return pulumi.get(self, "assessment_id")

    @assessment_id.setter
    def assessment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assessment_id", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category to which the finding belongs to.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The details of the finding. Provides detailed information to explain the finding summary, typically results from the assessed database, followed by any recommendations for changes.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "details", value)

    @_builtins.property
    @pulumi.getter(name="hasTargetDbRiskLevelChanged")
    def has_target_db_risk_level_changed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if this risk level has changed on the target database since the last time 'severity' was modified by user.
        """
        return pulumi.get(self, "has_target_db_risk_level_changed")

    @has_target_db_risk_level_changed.setter
    def has_target_db_risk_level_changed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_target_db_risk_level_changed", value)

    @_builtins.property
    @pulumi.getter(name="isRiskModified")
    def is_risk_modified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if this risk level was modified by user.
        """
        return pulumi.get(self, "is_risk_modified")

    @is_risk_modified.setter
    def is_risk_modified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_risk_modified", value)

    @_builtins.property
    @pulumi.getter(name="isTopFinding")
    def is_top_finding(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a given finding is marked as topFinding or not.
        """
        return pulumi.get(self, "is_top_finding")

    @is_top_finding.setter
    def is_top_finding(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_top_finding", value)

    @_builtins.property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User provided reason for accepting or modifying this finding if they choose to do so.
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "justification", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique finding key. This is a system-generated identifier. To get the finding key for a finding, use ListFindings.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details about the current state of the finding.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def oneline(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provides a recommended approach to take to remediate the finding reported.
        """
        return pulumi.get(self, "oneline")

    @oneline.setter
    def oneline(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oneline", value)

    @_builtins.property
    @pulumi.getter(name="oracleDefinedSeverity")
    def oracle_defined_severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The severity of the finding as determined by security assessment. This cannot be modified by user.
        """
        return pulumi.get(self, "oracle_defined_severity")

    @oracle_defined_severity.setter
    def oracle_defined_severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oracle_defined_severity", value)

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingPatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @_builtins.property
    @pulumi.getter
    def references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingReferenceArgs']]]]:
        """
        Provides information on whether the finding is related to a CIS Oracle Database Benchmark recommendation, a STIG rule, or a GDPR Article/Recital.
        """
        return pulumi.get(self, "references")

    @references.setter
    def references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAssessmentFindingReferenceArgs']]]]):
        pulumi.set(self, "references", value)

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The explanation of the issue in this finding. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.
        """
        return pulumi.get(self, "remarks")

    @remarks.setter
    def remarks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remarks", value)

    @_builtins.property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_assessment_id")

    @security_assessment_id.setter
    def security_assessment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_assessment_id", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The severity of the finding as determined by security assessment and is same as oracleDefinedSeverity, unless modified by user.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the finding.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The brief summary of the finding. When the finding is informational, the summary typically reports only the number of data elements that were examined.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "summary", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the target database.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the risk level of finding was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="timeValidUntil")
    def time_valid_until(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time until which the change in severity(deferred / modified) of this finding is valid.
        """
        return pulumi.get(self, "time_valid_until")

    @time_valid_until.setter
    def time_valid_until(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_valid_until", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The short title for the finding.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("oci:DataSafe/securityAssessmentFinding:SecurityAssessmentFinding")
class SecurityAssessmentFinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentFindingPatchOperationArgs', 'SecurityAssessmentFindingPatchOperationArgsDict']]]]] = None,
                 security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_assessment_finding = oci.datasafe.SecurityAssessmentFinding("test_security_assessment_finding",
            security_assessment_id=test_security_assessment["id"],
            patch_operations=[{
                "operation": security_assessment_finding_patch_operations_operation,
                "selection": security_assessment_finding_patch_operations_selection,
                "value": security_assessment_finding_patch_operations_value,
            }])
        ```

        ## Import

        SecurityAssessmentFindings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/securityAssessmentFinding:SecurityAssessmentFinding test_security_assessment_finding "securityAssessments/{securityAssessmentId}/findings"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentFindingPatchOperationArgs', 'SecurityAssessmentFindingPatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[_builtins.str] security_assessment_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityAssessmentFindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_assessment_finding = oci.datasafe.SecurityAssessmentFinding("test_security_assessment_finding",
            security_assessment_id=test_security_assessment["id"],
            patch_operations=[{
                "operation": security_assessment_finding_patch_operations_operation,
                "selection": security_assessment_finding_patch_operations_selection,
                "value": security_assessment_finding_patch_operations_value,
            }])
        ```

        ## Import

        SecurityAssessmentFindings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/securityAssessmentFinding:SecurityAssessmentFinding test_security_assessment_finding "securityAssessments/{securityAssessmentId}/findings"
        ```

        :param str resource_name: The name of the resource.
        :param SecurityAssessmentFindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityAssessmentFindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentFindingPatchOperationArgs', 'SecurityAssessmentFindingPatchOperationArgsDict']]]]] = None,
                 security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityAssessmentFindingArgs.__new__(SecurityAssessmentFindingArgs)

            __props__.__dict__["patch_operations"] = patch_operations
            if security_assessment_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_assessment_id'")
            __props__.__dict__["security_assessment_id"] = security_assessment_id
            __props__.__dict__["assessment_id"] = None
            __props__.__dict__["category"] = None
            __props__.__dict__["details"] = None
            __props__.__dict__["has_target_db_risk_level_changed"] = None
            __props__.__dict__["is_risk_modified"] = None
            __props__.__dict__["is_top_finding"] = None
            __props__.__dict__["justification"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["oneline"] = None
            __props__.__dict__["oracle_defined_severity"] = None
            __props__.__dict__["references"] = None
            __props__.__dict__["remarks"] = None
            __props__.__dict__["severity"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["summary"] = None
            __props__.__dict__["target_id"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["time_valid_until"] = None
            __props__.__dict__["title"] = None
        super(SecurityAssessmentFinding, __self__).__init__(
            'oci:DataSafe/securityAssessmentFinding:SecurityAssessmentFinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            details: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            has_target_db_risk_level_changed: Optional[pulumi.Input[_builtins.bool]] = None,
            is_risk_modified: Optional[pulumi.Input[_builtins.bool]] = None,
            is_top_finding: Optional[pulumi.Input[_builtins.bool]] = None,
            justification: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            oneline: Optional[pulumi.Input[_builtins.str]] = None,
            oracle_defined_severity: Optional[pulumi.Input[_builtins.str]] = None,
            patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentFindingPatchOperationArgs', 'SecurityAssessmentFindingPatchOperationArgsDict']]]]] = None,
            references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentFindingReferenceArgs', 'SecurityAssessmentFindingReferenceArgsDict']]]]] = None,
            remarks: Optional[pulumi.Input[_builtins.str]] = None,
            security_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            summary: Optional[pulumi.Input[_builtins.str]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            time_valid_until: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityAssessmentFinding':
        """
        Get an existing SecurityAssessmentFinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assessment_id: The OCID of the assessment that generated this finding.
        :param pulumi.Input[_builtins.str] category: The category to which the finding belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] details: The details of the finding. Provides detailed information to explain the finding summary, typically results from the assessed database, followed by any recommendations for changes.
        :param pulumi.Input[_builtins.bool] has_target_db_risk_level_changed: Determines if this risk level has changed on the target database since the last time 'severity' was modified by user.
        :param pulumi.Input[_builtins.bool] is_risk_modified: Determines if this risk level was modified by user.
        :param pulumi.Input[_builtins.bool] is_top_finding: Indicates whether a given finding is marked as topFinding or not.
        :param pulumi.Input[_builtins.str] justification: User provided reason for accepting or modifying this finding if they choose to do so.
        :param pulumi.Input[_builtins.str] key: The unique finding key. This is a system-generated identifier. To get the finding key for a finding, use ListFindings.
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the finding.
        :param pulumi.Input[_builtins.str] oneline: Provides a recommended approach to take to remediate the finding reported.
        :param pulumi.Input[_builtins.str] oracle_defined_severity: The severity of the finding as determined by security assessment. This cannot be modified by user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentFindingPatchOperationArgs', 'SecurityAssessmentFindingPatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityAssessmentFindingReferenceArgs', 'SecurityAssessmentFindingReferenceArgsDict']]]] references: Provides information on whether the finding is related to a CIS Oracle Database Benchmark recommendation, a STIG rule, or a GDPR Article/Recital.
        :param pulumi.Input[_builtins.str] remarks: The explanation of the issue in this finding. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.
        :param pulumi.Input[_builtins.str] security_assessment_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] severity: The severity of the finding as determined by security assessment and is same as oracleDefinedSeverity, unless modified by user.
        :param pulumi.Input[_builtins.str] state: The current state of the finding.
        :param pulumi.Input[_builtins.str] summary: The brief summary of the finding. When the finding is informational, the summary typically reports only the number of data elements that were examined.
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target database.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the risk level of finding was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_valid_until: The time until which the change in severity(deferred / modified) of this finding is valid.
        :param pulumi.Input[_builtins.str] title: The short title for the finding.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityAssessmentFindingState.__new__(_SecurityAssessmentFindingState)

        __props__.__dict__["assessment_id"] = assessment_id
        __props__.__dict__["category"] = category
        __props__.__dict__["details"] = details
        __props__.__dict__["has_target_db_risk_level_changed"] = has_target_db_risk_level_changed
        __props__.__dict__["is_risk_modified"] = is_risk_modified
        __props__.__dict__["is_top_finding"] = is_top_finding
        __props__.__dict__["justification"] = justification
        __props__.__dict__["key"] = key
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["oneline"] = oneline
        __props__.__dict__["oracle_defined_severity"] = oracle_defined_severity
        __props__.__dict__["patch_operations"] = patch_operations
        __props__.__dict__["references"] = references
        __props__.__dict__["remarks"] = remarks
        __props__.__dict__["security_assessment_id"] = security_assessment_id
        __props__.__dict__["severity"] = severity
        __props__.__dict__["state"] = state
        __props__.__dict__["summary"] = summary
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["time_valid_until"] = time_valid_until
        __props__.__dict__["title"] = title
        return SecurityAssessmentFinding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the assessment that generated this finding.
        """
        return pulumi.get(self, "assessment_id")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The category to which the finding belongs to.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def details(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The details of the finding. Provides detailed information to explain the finding summary, typically results from the assessed database, followed by any recommendations for changes.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="hasTargetDbRiskLevelChanged")
    def has_target_db_risk_level_changed(self) -> pulumi.Output[_builtins.bool]:
        """
        Determines if this risk level has changed on the target database since the last time 'severity' was modified by user.
        """
        return pulumi.get(self, "has_target_db_risk_level_changed")

    @_builtins.property
    @pulumi.getter(name="isRiskModified")
    def is_risk_modified(self) -> pulumi.Output[_builtins.bool]:
        """
        Determines if this risk level was modified by user.
        """
        return pulumi.get(self, "is_risk_modified")

    @_builtins.property
    @pulumi.getter(name="isTopFinding")
    def is_top_finding(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether a given finding is marked as topFinding or not.
        """
        return pulumi.get(self, "is_top_finding")

    @_builtins.property
    @pulumi.getter
    def justification(self) -> pulumi.Output[_builtins.str]:
        """
        User provided reason for accepting or modifying this finding if they choose to do so.
        """
        return pulumi.get(self, "justification")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The unique finding key. This is a system-generated identifier. To get the finding key for a finding, use ListFindings.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details about the current state of the finding.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def oneline(self) -> pulumi.Output[_builtins.str]:
        """
        Provides a recommended approach to take to remediate the finding reported.
        """
        return pulumi.get(self, "oneline")

    @_builtins.property
    @pulumi.getter(name="oracleDefinedSeverity")
    def oracle_defined_severity(self) -> pulumi.Output[_builtins.str]:
        """
        The severity of the finding as determined by security assessment. This cannot be modified by user.
        """
        return pulumi.get(self, "oracle_defined_severity")

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityAssessmentFindingPatchOperation']]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @_builtins.property
    @pulumi.getter
    def references(self) -> pulumi.Output[Sequence['outputs.SecurityAssessmentFindingReference']]:
        """
        Provides information on whether the finding is related to a CIS Oracle Database Benchmark recommendation, a STIG rule, or a GDPR Article/Recital.
        """
        return pulumi.get(self, "references")

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> pulumi.Output[_builtins.str]:
        """
        The explanation of the issue in this finding. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.
        """
        return pulumi.get(self, "remarks")

    @_builtins.property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> pulumi.Output[_builtins.str]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_assessment_id")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.str]:
        """
        The severity of the finding as determined by security assessment and is same as oracleDefinedSeverity, unless modified by user.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the finding.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> pulumi.Output[_builtins.str]:
        """
        The brief summary of the finding. When the finding is informational, the summary typically reports only the number of data elements that were examined.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the target database.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the risk level of finding was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="timeValidUntil")
    def time_valid_until(self) -> pulumi.Output[_builtins.str]:
        """
        The time until which the change in severity(deferred / modified) of this finding is valid.
        """
        return pulumi.get(self, "time_valid_until")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[_builtins.str]:
        """
        The short title for the finding.
        """
        return pulumi.get(self, "title")

