# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SqlFirewallPolicyManagementArgs', 'SqlFirewallPolicyManagement']

@pulumi.input_type
class SqlFirewallPolicyManagementArgs:
    def __init__(__self__, *,
                 allowed_client_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_client_os_usernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_client_programs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sql_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_action: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_audit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqlFirewallPolicyManagement resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_ips: (Updatable) List of allowed ip addresses for the SQL Firewall policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_os_usernames: (Updatable) List of allowed operating system user names for the SQL Firewall policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_programs: (Updatable) List of allowed client programs for the SQL Firewall policy.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the SQL collection.
        :param pulumi.Input[_builtins.str] db_user_name: The database user name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the SQL Firewall policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[_builtins.str] enforcement_scope: (Updatable) Specifies the SQL Firewall policy enforcement option.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] sql_firewall_policy_id: The OCID of the SQL firewall policy resource.
        :param pulumi.Input[_builtins.str] state: The current state of the SQL firewall policy.
        :param pulumi.Input[_builtins.str] status: (Updatable) Specifies whether the SQL firewall policy is enabled or disabled.
        :param pulumi.Input[_builtins.str] target_id: Unique target identifier.
        :param pulumi.Input[_builtins.str] violation_action: (Updatable) Specifies the SQL firewall action based on detection of SQL firewall violations.
        :param pulumi.Input[_builtins.str] violation_audit: (Updatable) Specifies whether a unified audit policy should be enabled for auditing the SQL firewall policy violations.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if allowed_client_ips is not None:
            pulumi.set(__self__, "allowed_client_ips", allowed_client_ips)
        if allowed_client_os_usernames is not None:
            pulumi.set(__self__, "allowed_client_os_usernames", allowed_client_os_usernames)
        if allowed_client_programs is not None:
            pulumi.set(__self__, "allowed_client_programs", allowed_client_programs)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if db_user_name is not None:
            pulumi.set(__self__, "db_user_name", db_user_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enforcement_scope is not None:
            pulumi.set(__self__, "enforcement_scope", enforcement_scope)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if sql_firewall_policy_id is not None:
            pulumi.set(__self__, "sql_firewall_policy_id", sql_firewall_policy_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if violation_action is not None:
            pulumi.set(__self__, "violation_action", violation_action)
        if violation_audit is not None:
            pulumi.set(__self__, "violation_audit", violation_audit)

    @_builtins.property
    @pulumi.getter(name="allowedClientIps")
    def allowed_client_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of allowed ip addresses for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_ips")

    @allowed_client_ips.setter
    def allowed_client_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_client_ips", value)

    @_builtins.property
    @pulumi.getter(name="allowedClientOsUsernames")
    def allowed_client_os_usernames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of allowed operating system user names for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_os_usernames")

    @allowed_client_os_usernames.setter
    def allowed_client_os_usernames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_client_os_usernames", value)

    @_builtins.property
    @pulumi.getter(name="allowedClientPrograms")
    def allowed_client_programs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of allowed client programs for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_programs")

    @allowed_client_programs.setter
    def allowed_client_programs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_client_programs", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment containing the SQL collection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @db_user_name.setter
    def db_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_user_name", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the SQL Firewall policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enforcementScope")
    def enforcement_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies the SQL Firewall policy enforcement option.
        """
        return pulumi.get(self, "enforcement_scope")

    @enforcement_scope.setter
    def enforcement_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforcement_scope", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="sqlFirewallPolicyId")
    def sql_firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the SQL firewall policy resource.
        """
        return pulumi.get(self, "sql_firewall_policy_id")

    @sql_firewall_policy_id.setter
    def sql_firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the SQL firewall policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies whether the SQL firewall policy is enabled or disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique target identifier.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="violationAction")
    def violation_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies the SQL firewall action based on detection of SQL firewall violations.
        """
        return pulumi.get(self, "violation_action")

    @violation_action.setter
    def violation_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "violation_action", value)

    @_builtins.property
    @pulumi.getter(name="violationAudit")
    def violation_audit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies whether a unified audit policy should be enabled for auditing the SQL firewall policy violations.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "violation_audit")

    @violation_audit.setter
    def violation_audit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "violation_audit", value)


@pulumi.input_type
class _SqlFirewallPolicyManagementState:
    def __init__(__self__, *,
                 allowed_client_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_client_os_usernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_client_programs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_level: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_action: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_audit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlFirewallPolicyManagement resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_ips: (Updatable) List of allowed ip addresses for the SQL Firewall policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_os_usernames: (Updatable) List of allowed operating system user names for the SQL Firewall policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_programs: (Updatable) List of allowed client programs for the SQL Firewall policy.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the SQL collection.
        :param pulumi.Input[_builtins.str] db_user_name: The database user name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the SQL Firewall policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[_builtins.str] enforcement_scope: (Updatable) Specifies the SQL Firewall policy enforcement option.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the SQL firewall policy in Data Safe.
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the SQL firewall policy.
        :param pulumi.Input[_builtins.str] sql_firewall_policy_id: The OCID of the SQL firewall policy resource.
        :param pulumi.Input[_builtins.str] sql_level: Specifies the level of SQL included for this SQL firewall policy. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        :param pulumi.Input[_builtins.str] state: The current state of the SQL firewall policy.
        :param pulumi.Input[_builtins.str] status: (Updatable) Specifies whether the SQL firewall policy is enabled or disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_id: Unique target identifier.
        :param pulumi.Input[_builtins.str] time_created: The time that the SQL firewall policy was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the SQL firewall policy was last updated, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] violation_action: (Updatable) Specifies the SQL firewall action based on detection of SQL firewall violations.
        :param pulumi.Input[_builtins.str] violation_audit: (Updatable) Specifies whether a unified audit policy should be enabled for auditing the SQL firewall policy violations.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if allowed_client_ips is not None:
            pulumi.set(__self__, "allowed_client_ips", allowed_client_ips)
        if allowed_client_os_usernames is not None:
            pulumi.set(__self__, "allowed_client_os_usernames", allowed_client_os_usernames)
        if allowed_client_programs is not None:
            pulumi.set(__self__, "allowed_client_programs", allowed_client_programs)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if db_user_name is not None:
            pulumi.set(__self__, "db_user_name", db_user_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enforcement_scope is not None:
            pulumi.set(__self__, "enforcement_scope", enforcement_scope)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if sql_firewall_policy_id is not None:
            pulumi.set(__self__, "sql_firewall_policy_id", sql_firewall_policy_id)
        if sql_level is not None:
            pulumi.set(__self__, "sql_level", sql_level)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if violation_action is not None:
            pulumi.set(__self__, "violation_action", violation_action)
        if violation_audit is not None:
            pulumi.set(__self__, "violation_audit", violation_audit)

    @_builtins.property
    @pulumi.getter(name="allowedClientIps")
    def allowed_client_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of allowed ip addresses for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_ips")

    @allowed_client_ips.setter
    def allowed_client_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_client_ips", value)

    @_builtins.property
    @pulumi.getter(name="allowedClientOsUsernames")
    def allowed_client_os_usernames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of allowed operating system user names for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_os_usernames")

    @allowed_client_os_usernames.setter
    def allowed_client_os_usernames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_client_os_usernames", value)

    @_builtins.property
    @pulumi.getter(name="allowedClientPrograms")
    def allowed_client_programs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of allowed client programs for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_programs")

    @allowed_client_programs.setter
    def allowed_client_programs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_client_programs", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment containing the SQL collection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @db_user_name.setter
    def db_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_user_name", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the SQL Firewall policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enforcementScope")
    def enforcement_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies the SQL Firewall policy enforcement option.
        """
        return pulumi.get(self, "enforcement_scope")

    @enforcement_scope.setter
    def enforcement_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforcement_scope", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details about the current state of the SQL firewall policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the security policy corresponding to the SQL firewall policy.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlFirewallPolicyId")
    def sql_firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the SQL firewall policy resource.
        """
        return pulumi.get(self, "sql_firewall_policy_id")

    @sql_firewall_policy_id.setter
    def sql_firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlLevel")
    def sql_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the level of SQL included for this SQL firewall policy. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        """
        return pulumi.get(self, "sql_level")

    @sql_level.setter
    def sql_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_level", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the SQL firewall policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies whether the SQL firewall policy is enabled or disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique target identifier.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time that the SQL firewall policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the SQL firewall policy was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="violationAction")
    def violation_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies the SQL firewall action based on detection of SQL firewall violations.
        """
        return pulumi.get(self, "violation_action")

    @violation_action.setter
    def violation_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "violation_action", value)

    @_builtins.property
    @pulumi.getter(name="violationAudit")
    def violation_audit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Specifies whether a unified audit policy should be enabled for auditing the SQL firewall policy violations.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "violation_audit")

    @violation_audit.setter
    def violation_audit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "violation_audit", value)


@pulumi.type_token("oci:DataSafe/sqlFirewallPolicyManagement:SqlFirewallPolicyManagement")
class SqlFirewallPolicyManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_client_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_client_os_usernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_client_programs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sql_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_action: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_audit: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sql_firewall_policy_management = oci.datasafe.SqlFirewallPolicyManagement("test_sql_firewall_policy_management",
            compartment_id=compartment_id,
            target_id=test_target_database["id"],
            db_user_name=test_user["name"],
            allowed_client_ips=sql_firewall_policy_management_allowed_client_ips,
            allowed_client_os_usernames=sql_firewall_policy_management_allowed_client_os_usernames,
            allowed_client_programs=sql_firewall_policy_management_allowed_client_programs,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=sql_firewall_policy_management_description,
            display_name=sql_firewall_policy_management_display_name,
            enforcement_scope=sql_firewall_policy_management_enforcement_scope,
            freeform_tags={
                "Department": "Finance",
            },
            status=sql_firewall_policy_management_status,
            violation_action=sql_firewall_policy_management_violation_action,
            violation_audit=sql_firewall_policy_management_violation_audit)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_ips: (Updatable) List of allowed ip addresses for the SQL Firewall policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_os_usernames: (Updatable) List of allowed operating system user names for the SQL Firewall policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_programs: (Updatable) List of allowed client programs for the SQL Firewall policy.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the SQL collection.
        :param pulumi.Input[_builtins.str] db_user_name: The database user name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the SQL Firewall policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[_builtins.str] enforcement_scope: (Updatable) Specifies the SQL Firewall policy enforcement option.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] sql_firewall_policy_id: The OCID of the SQL firewall policy resource.
        :param pulumi.Input[_builtins.str] state: The current state of the SQL firewall policy.
        :param pulumi.Input[_builtins.str] status: (Updatable) Specifies whether the SQL firewall policy is enabled or disabled.
        :param pulumi.Input[_builtins.str] target_id: Unique target identifier.
        :param pulumi.Input[_builtins.str] violation_action: (Updatable) Specifies the SQL firewall action based on detection of SQL firewall violations.
        :param pulumi.Input[_builtins.str] violation_audit: (Updatable) Specifies whether a unified audit policy should be enabled for auditing the SQL firewall policy violations.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SqlFirewallPolicyManagementArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sql_firewall_policy_management = oci.datasafe.SqlFirewallPolicyManagement("test_sql_firewall_policy_management",
            compartment_id=compartment_id,
            target_id=test_target_database["id"],
            db_user_name=test_user["name"],
            allowed_client_ips=sql_firewall_policy_management_allowed_client_ips,
            allowed_client_os_usernames=sql_firewall_policy_management_allowed_client_os_usernames,
            allowed_client_programs=sql_firewall_policy_management_allowed_client_programs,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=sql_firewall_policy_management_description,
            display_name=sql_firewall_policy_management_display_name,
            enforcement_scope=sql_firewall_policy_management_enforcement_scope,
            freeform_tags={
                "Department": "Finance",
            },
            status=sql_firewall_policy_management_status,
            violation_action=sql_firewall_policy_management_violation_action,
            violation_audit=sql_firewall_policy_management_violation_audit)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param SqlFirewallPolicyManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlFirewallPolicyManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_client_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_client_os_usernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_client_programs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sql_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_action: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_audit: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlFirewallPolicyManagementArgs.__new__(SqlFirewallPolicyManagementArgs)

            __props__.__dict__["allowed_client_ips"] = allowed_client_ips
            __props__.__dict__["allowed_client_os_usernames"] = allowed_client_os_usernames
            __props__.__dict__["allowed_client_programs"] = allowed_client_programs
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["db_user_name"] = db_user_name
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enforcement_scope"] = enforcement_scope
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["sql_firewall_policy_id"] = sql_firewall_policy_id
            __props__.__dict__["state"] = state
            __props__.__dict__["status"] = status
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["violation_action"] = violation_action
            __props__.__dict__["violation_audit"] = violation_audit
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["security_policy_id"] = None
            __props__.__dict__["sql_level"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(SqlFirewallPolicyManagement, __self__).__init__(
            'oci:DataSafe/sqlFirewallPolicyManagement:SqlFirewallPolicyManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_client_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_client_os_usernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_client_programs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enforcement_scope: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            sql_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            sql_level: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            violation_action: Optional[pulumi.Input[_builtins.str]] = None,
            violation_audit: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlFirewallPolicyManagement':
        """
        Get an existing SqlFirewallPolicyManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_ips: (Updatable) List of allowed ip addresses for the SQL Firewall policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_os_usernames: (Updatable) List of allowed operating system user names for the SQL Firewall policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_programs: (Updatable) List of allowed client programs for the SQL Firewall policy.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the SQL collection.
        :param pulumi.Input[_builtins.str] db_user_name: The database user name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the SQL Firewall policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[_builtins.str] enforcement_scope: (Updatable) Specifies the SQL Firewall policy enforcement option.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the SQL firewall policy in Data Safe.
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the SQL firewall policy.
        :param pulumi.Input[_builtins.str] sql_firewall_policy_id: The OCID of the SQL firewall policy resource.
        :param pulumi.Input[_builtins.str] sql_level: Specifies the level of SQL included for this SQL firewall policy. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        :param pulumi.Input[_builtins.str] state: The current state of the SQL firewall policy.
        :param pulumi.Input[_builtins.str] status: (Updatable) Specifies whether the SQL firewall policy is enabled or disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_id: Unique target identifier.
        :param pulumi.Input[_builtins.str] time_created: The time that the SQL firewall policy was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the SQL firewall policy was last updated, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] violation_action: (Updatable) Specifies the SQL firewall action based on detection of SQL firewall violations.
        :param pulumi.Input[_builtins.str] violation_audit: (Updatable) Specifies whether a unified audit policy should be enabled for auditing the SQL firewall policy violations.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlFirewallPolicyManagementState.__new__(_SqlFirewallPolicyManagementState)

        __props__.__dict__["allowed_client_ips"] = allowed_client_ips
        __props__.__dict__["allowed_client_os_usernames"] = allowed_client_os_usernames
        __props__.__dict__["allowed_client_programs"] = allowed_client_programs
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["db_user_name"] = db_user_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enforcement_scope"] = enforcement_scope
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["sql_firewall_policy_id"] = sql_firewall_policy_id
        __props__.__dict__["sql_level"] = sql_level
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["violation_action"] = violation_action
        __props__.__dict__["violation_audit"] = violation_audit
        return SqlFirewallPolicyManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedClientIps")
    def allowed_client_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of allowed ip addresses for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_ips")

    @_builtins.property
    @pulumi.getter(name="allowedClientOsUsernames")
    def allowed_client_os_usernames(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of allowed operating system user names for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_os_usernames")

    @_builtins.property
    @pulumi.getter(name="allowedClientPrograms")
    def allowed_client_programs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of allowed client programs for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_programs")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment containing the SQL collection.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the SQL Firewall policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enforcementScope")
    def enforcement_scope(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Specifies the SQL Firewall policy enforcement option.
        """
        return pulumi.get(self, "enforcement_scope")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details about the current state of the SQL firewall policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the security policy corresponding to the SQL firewall policy.
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter(name="sqlFirewallPolicyId")
    def sql_firewall_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the SQL firewall policy resource.
        """
        return pulumi.get(self, "sql_firewall_policy_id")

    @_builtins.property
    @pulumi.getter(name="sqlLevel")
    def sql_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the level of SQL included for this SQL firewall policy. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        """
        return pulumi.get(self, "sql_level")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the SQL firewall policy.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Specifies whether the SQL firewall policy is enabled or disabled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique target identifier.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time that the SQL firewall policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the SQL firewall policy was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="violationAction")
    def violation_action(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Specifies the SQL firewall action based on detection of SQL firewall violations.
        """
        return pulumi.get(self, "violation_action")

    @_builtins.property
    @pulumi.getter(name="violationAudit")
    def violation_audit(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Specifies whether a unified audit policy should be enabled for auditing the SQL firewall policy violations.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "violation_audit")

