# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserAssessmentArgs', 'UserAssessment']

@pulumi.input_type
class UserAssessmentArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 target_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_assessment_scheduled: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserAssessment resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the user assessment.
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target database or target database group on which user assessment is to be run.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the user assessment.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the user assessment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_assessment_scheduled: (Updatable) Indicates whether the assessment is scheduled to run.
        :param pulumi.Input[_builtins.str] schedule: (Updatable) To schedule the assessment for saving periodically, specify the schedule in this attribute. Create or schedule one assessment per compartment. If not defined, the assessment runs immediately. Format - <version-string>;<version-specific-schedule>
               
               Allowed version strings - "v1" v1's version specific schedule -<ss> <mm> <hh> <day-of-week> <day-of-month> Each of the above fields potentially introduce constraints. A workrequest is created only when clock time satisfies all the constraints. Constraints introduced: 1. seconds = <ss> (So, the allowed range for <ss> is [0, 59]) 2. minutes = <mm> (So, the allowed range for <mm> is [0, 59]) 3. hours = <hh> (So, the allowed range for <hh> is [0, 23]) <day-of-week> can be either '*' (without quotes or a number between 1(Monday) and 7(Sunday)) 4. No constraint introduced when it is '*'. When not, day of week must equal the given value <day-of-month> can be either '*' (without quotes or a number between 1 and 28) 5. No constraint introduced when it is '*'. When not, day of month must equal the given value
        :param pulumi.Input[_builtins.str] target_type: The type of user assessment resource whether it is individual or group resource. For individual target use type TARGET_DATABASE and for group resource use type TARGET_DATABASE_GROUP. If not provided, TARGET_DATABASE would be used as default value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "target_id", target_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_assessment_scheduled is not None:
            pulumi.set(__self__, "is_assessment_scheduled", is_assessment_scheduled)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the user assessment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the target database or target database group on which user assessment is to be run.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the user assessment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the user assessment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAssessmentScheduled")
    def is_assessment_scheduled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates whether the assessment is scheduled to run.
        """
        return pulumi.get(self, "is_assessment_scheduled")

    @is_assessment_scheduled.setter
    def is_assessment_scheduled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_assessment_scheduled", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) To schedule the assessment for saving periodically, specify the schedule in this attribute. Create or schedule one assessment per compartment. If not defined, the assessment runs immediately. Format - <version-string>;<version-specific-schedule>

        Allowed version strings - "v1" v1's version specific schedule -<ss> <mm> <hh> <day-of-week> <day-of-month> Each of the above fields potentially introduce constraints. A workrequest is created only when clock time satisfies all the constraints. Constraints introduced: 1. seconds = <ss> (So, the allowed range for <ss> is [0, 59]) 2. minutes = <mm> (So, the allowed range for <mm> is [0, 59]) 3. hours = <hh> (So, the allowed range for <hh> is [0, 23]) <day-of-week> can be either '*' (without quotes or a number between 1(Monday) and 7(Sunday)) 4. No constraint introduced when it is '*'. When not, day of week must equal the given value <day-of-month> can be either '*' (without quotes or a number between 1 and 28) 5. No constraint introduced when it is '*'. When not, day of month must equal the given value
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of user assessment resource whether it is individual or group resource. For individual target use type TARGET_DATABASE and for group resource use type TARGET_DATABASE_GROUP. If not provided, TARGET_DATABASE would be used as default value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_type", value)


@pulumi.input_type
class _UserAssessmentState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ignored_assessment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ignored_targets: Optional[pulumi.Input[Sequence[pulumi.Input['UserAssessmentIgnoredTargetArgs']]]] = None,
                 is_assessment_scheduled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_baseline: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_deviated_from_baseline: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_compared_baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 statistics: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_database_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_assessed: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 triggered_by: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserAssessment resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the user assessment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the user assessment.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the user assessment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_assessment_ids: List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        :param pulumi.Input[Sequence[pulumi.Input['UserAssessmentIgnoredTargetArgs']]] ignored_targets: List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        :param pulumi.Input[_builtins.bool] is_assessment_scheduled: (Updatable) Indicates whether the assessment is scheduled to run.
        :param pulumi.Input[_builtins.bool] is_baseline: Indicates if the user assessment is set as a baseline. This is applicable only to saved user assessments.
        :param pulumi.Input[_builtins.bool] is_deviated_from_baseline: Indicates if the user assessment deviates from the baseline.
        :param pulumi.Input[_builtins.str] last_compared_baseline_id: The OCID of the last user assessment baseline against which the latest assessment was compared.
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the user assessment.
        :param pulumi.Input[_builtins.str] schedule: (Updatable) To schedule the assessment for saving periodically, specify the schedule in this attribute. Create or schedule one assessment per compartment. If not defined, the assessment runs immediately. Format - <version-string>;<version-specific-schedule>
               
               Allowed version strings - "v1" v1's version specific schedule -<ss> <mm> <hh> <day-of-week> <day-of-month> Each of the above fields potentially introduce constraints. A workrequest is created only when clock time satisfies all the constraints. Constraints introduced: 1. seconds = <ss> (So, the allowed range for <ss> is [0, 59]) 2. minutes = <mm> (So, the allowed range for <mm> is [0, 59]) 3. hours = <hh> (So, the allowed range for <hh> is [0, 23]) <day-of-week> can be either '*' (without quotes or a number between 1(Monday) and 7(Sunday)) 4. No constraint introduced when it is '*'. When not, day of week must equal the given value <day-of-month> can be either '*' (without quotes or a number between 1 and 28) 5. No constraint introduced when it is '*'. When not, day of month must equal the given value
        :param pulumi.Input[_builtins.str] schedule_assessment_id: The OCID of the user assessment that is responsible for creating this scheduled save assessment.
        :param pulumi.Input[_builtins.str] state: The current state of the user assessment.
        :param pulumi.Input[_builtins.str] statistics: Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_database_group_id: The OCID of target database group.
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target database or target database group on which user assessment is to be run.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_ids: Array of database target OCIDs.
        :param pulumi.Input[_builtins.str] target_type: The type of user assessment resource whether it is individual or group resource. For individual target use type TARGET_DATABASE and for group resource use type TARGET_DATABASE_GROUP. If not provided, TARGET_DATABASE would be used as default value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time the user assessment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_last_assessed: The date and time the user assessment was last executed, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the user assessment was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] triggered_by: Indicates whether the user assessment was created by the system or the user.
        :param pulumi.Input[_builtins.str] type: The type of the user assessment. The possible types are:
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ignored_assessment_ids is not None:
            pulumi.set(__self__, "ignored_assessment_ids", ignored_assessment_ids)
        if ignored_targets is not None:
            pulumi.set(__self__, "ignored_targets", ignored_targets)
        if is_assessment_scheduled is not None:
            pulumi.set(__self__, "is_assessment_scheduled", is_assessment_scheduled)
        if is_baseline is not None:
            pulumi.set(__self__, "is_baseline", is_baseline)
        if is_deviated_from_baseline is not None:
            pulumi.set(__self__, "is_deviated_from_baseline", is_deviated_from_baseline)
        if last_compared_baseline_id is not None:
            pulumi.set(__self__, "last_compared_baseline_id", last_compared_baseline_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schedule_assessment_id is not None:
            pulumi.set(__self__, "schedule_assessment_id", schedule_assessment_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_database_group_id is not None:
            pulumi.set(__self__, "target_database_group_id", target_database_group_id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_ids is not None:
            pulumi.set(__self__, "target_ids", target_ids)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_assessed is not None:
            pulumi.set(__self__, "time_last_assessed", time_last_assessed)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if triggered_by is not None:
            pulumi.set(__self__, "triggered_by", triggered_by)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains the user assessment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the user assessment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the user assessment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="ignoredAssessmentIds")
    def ignored_assessment_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        """
        return pulumi.get(self, "ignored_assessment_ids")

    @ignored_assessment_ids.setter
    def ignored_assessment_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignored_assessment_ids", value)

    @_builtins.property
    @pulumi.getter(name="ignoredTargets")
    def ignored_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserAssessmentIgnoredTargetArgs']]]]:
        """
        List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        """
        return pulumi.get(self, "ignored_targets")

    @ignored_targets.setter
    def ignored_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserAssessmentIgnoredTargetArgs']]]]):
        pulumi.set(self, "ignored_targets", value)

    @_builtins.property
    @pulumi.getter(name="isAssessmentScheduled")
    def is_assessment_scheduled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates whether the assessment is scheduled to run.
        """
        return pulumi.get(self, "is_assessment_scheduled")

    @is_assessment_scheduled.setter
    def is_assessment_scheduled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_assessment_scheduled", value)

    @_builtins.property
    @pulumi.getter(name="isBaseline")
    def is_baseline(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the user assessment is set as a baseline. This is applicable only to saved user assessments.
        """
        return pulumi.get(self, "is_baseline")

    @is_baseline.setter
    def is_baseline(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_baseline", value)

    @_builtins.property
    @pulumi.getter(name="isDeviatedFromBaseline")
    def is_deviated_from_baseline(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the user assessment deviates from the baseline.
        """
        return pulumi.get(self, "is_deviated_from_baseline")

    @is_deviated_from_baseline.setter
    def is_deviated_from_baseline(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_deviated_from_baseline", value)

    @_builtins.property
    @pulumi.getter(name="lastComparedBaselineId")
    def last_compared_baseline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the last user assessment baseline against which the latest assessment was compared.
        """
        return pulumi.get(self, "last_compared_baseline_id")

    @last_compared_baseline_id.setter
    def last_compared_baseline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_compared_baseline_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details about the current state of the user assessment.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) To schedule the assessment for saving periodically, specify the schedule in this attribute. Create or schedule one assessment per compartment. If not defined, the assessment runs immediately. Format - <version-string>;<version-specific-schedule>

        Allowed version strings - "v1" v1's version specific schedule -<ss> <mm> <hh> <day-of-week> <day-of-month> Each of the above fields potentially introduce constraints. A workrequest is created only when clock time satisfies all the constraints. Constraints introduced: 1. seconds = <ss> (So, the allowed range for <ss> is [0, 59]) 2. minutes = <mm> (So, the allowed range for <mm> is [0, 59]) 3. hours = <hh> (So, the allowed range for <hh> is [0, 23]) <day-of-week> can be either '*' (without quotes or a number between 1(Monday) and 7(Sunday)) 4. No constraint introduced when it is '*'. When not, day of week must equal the given value <day-of-month> can be either '*' (without quotes or a number between 1 and 28) 5. No constraint introduced when it is '*'. When not, day of month must equal the given value
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="scheduleAssessmentId")
    def schedule_assessment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the user assessment that is responsible for creating this scheduled save assessment.
        """
        return pulumi.get(self, "schedule_assessment_id")

    @schedule_assessment_id.setter
    def schedule_assessment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_assessment_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the user assessment.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        """
        return pulumi.get(self, "statistics")

    @statistics.setter
    def statistics(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "statistics", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetDatabaseGroupId")
    def target_database_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of target database group.
        """
        return pulumi.get(self, "target_database_group_id")

    @target_database_group_id.setter
    def target_database_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_database_group_id", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the target database or target database group on which user assessment is to be run.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of database target OCIDs.
        """
        return pulumi.get(self, "target_ids")

    @target_ids.setter
    def target_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_ids", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of user assessment resource whether it is individual or group resource. For individual target use type TARGET_DATABASE and for group resource use type TARGET_DATABASE_GROUP. If not provided, TARGET_DATABASE would be used as default value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_type", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the user assessment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeLastAssessed")
    def time_last_assessed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the user assessment was last executed, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_last_assessed")

    @time_last_assessed.setter
    def time_last_assessed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_assessed", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the user assessment was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="triggeredBy")
    def triggered_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the user assessment was created by the system or the user.
        """
        return pulumi.get(self, "triggered_by")

    @triggered_by.setter
    def triggered_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "triggered_by", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the user assessment. The possible types are:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:DataSafe/userAssessment:UserAssessment")
class UserAssessment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_assessment_scheduled: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_user_assessment = oci.datasafe.UserAssessment("test_user_assessment",
            compartment_id=compartment_id,
            target_id=test_target["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=user_assessment_description,
            display_name=user_assessment_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_assessment_scheduled=user_assessment_is_assessment_scheduled,
            schedule=user_assessment_schedule,
            target_type=user_assessment_target_type)
        ```

        ## Import

        UserAssessments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/userAssessment:UserAssessment test_user_assessment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the user assessment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the user assessment.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the user assessment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_assessment_scheduled: (Updatable) Indicates whether the assessment is scheduled to run.
        :param pulumi.Input[_builtins.str] schedule: (Updatable) To schedule the assessment for saving periodically, specify the schedule in this attribute. Create or schedule one assessment per compartment. If not defined, the assessment runs immediately. Format - <version-string>;<version-specific-schedule>
               
               Allowed version strings - "v1" v1's version specific schedule -<ss> <mm> <hh> <day-of-week> <day-of-month> Each of the above fields potentially introduce constraints. A workrequest is created only when clock time satisfies all the constraints. Constraints introduced: 1. seconds = <ss> (So, the allowed range for <ss> is [0, 59]) 2. minutes = <mm> (So, the allowed range for <mm> is [0, 59]) 3. hours = <hh> (So, the allowed range for <hh> is [0, 23]) <day-of-week> can be either '*' (without quotes or a number between 1(Monday) and 7(Sunday)) 4. No constraint introduced when it is '*'. When not, day of week must equal the given value <day-of-month> can be either '*' (without quotes or a number between 1 and 28) 5. No constraint introduced when it is '*'. When not, day of month must equal the given value
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target database or target database group on which user assessment is to be run.
        :param pulumi.Input[_builtins.str] target_type: The type of user assessment resource whether it is individual or group resource. For individual target use type TARGET_DATABASE and for group resource use type TARGET_DATABASE_GROUP. If not provided, TARGET_DATABASE would be used as default value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserAssessmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_user_assessment = oci.datasafe.UserAssessment("test_user_assessment",
            compartment_id=compartment_id,
            target_id=test_target["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=user_assessment_description,
            display_name=user_assessment_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_assessment_scheduled=user_assessment_is_assessment_scheduled,
            schedule=user_assessment_schedule,
            target_type=user_assessment_target_type)
        ```

        ## Import

        UserAssessments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/userAssessment:UserAssessment test_user_assessment "id"
        ```

        :param str resource_name: The name of the resource.
        :param UserAssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserAssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_assessment_scheduled: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserAssessmentArgs.__new__(UserAssessmentArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_assessment_scheduled"] = is_assessment_scheduled
            __props__.__dict__["schedule"] = schedule
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["ignored_assessment_ids"] = None
            __props__.__dict__["ignored_targets"] = None
            __props__.__dict__["is_baseline"] = None
            __props__.__dict__["is_deviated_from_baseline"] = None
            __props__.__dict__["last_compared_baseline_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["schedule_assessment_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statistics"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_database_group_id"] = None
            __props__.__dict__["target_ids"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_assessed"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["triggered_by"] = None
            __props__.__dict__["type"] = None
        super(UserAssessment, __self__).__init__(
            'oci:DataSafe/userAssessment:UserAssessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ignored_assessment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ignored_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserAssessmentIgnoredTargetArgs', 'UserAssessmentIgnoredTargetArgsDict']]]]] = None,
            is_assessment_scheduled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_baseline: Optional[pulumi.Input[_builtins.bool]] = None,
            is_deviated_from_baseline: Optional[pulumi.Input[_builtins.bool]] = None,
            last_compared_baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            statistics: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_database_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_type: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_assessed: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            triggered_by: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserAssessment':
        """
        Get an existing UserAssessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the user assessment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the user assessment.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the user assessment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_assessment_ids: List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserAssessmentIgnoredTargetArgs', 'UserAssessmentIgnoredTargetArgsDict']]]] ignored_targets: List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        :param pulumi.Input[_builtins.bool] is_assessment_scheduled: (Updatable) Indicates whether the assessment is scheduled to run.
        :param pulumi.Input[_builtins.bool] is_baseline: Indicates if the user assessment is set as a baseline. This is applicable only to saved user assessments.
        :param pulumi.Input[_builtins.bool] is_deviated_from_baseline: Indicates if the user assessment deviates from the baseline.
        :param pulumi.Input[_builtins.str] last_compared_baseline_id: The OCID of the last user assessment baseline against which the latest assessment was compared.
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the user assessment.
        :param pulumi.Input[_builtins.str] schedule: (Updatable) To schedule the assessment for saving periodically, specify the schedule in this attribute. Create or schedule one assessment per compartment. If not defined, the assessment runs immediately. Format - <version-string>;<version-specific-schedule>
               
               Allowed version strings - "v1" v1's version specific schedule -<ss> <mm> <hh> <day-of-week> <day-of-month> Each of the above fields potentially introduce constraints. A workrequest is created only when clock time satisfies all the constraints. Constraints introduced: 1. seconds = <ss> (So, the allowed range for <ss> is [0, 59]) 2. minutes = <mm> (So, the allowed range for <mm> is [0, 59]) 3. hours = <hh> (So, the allowed range for <hh> is [0, 23]) <day-of-week> can be either '*' (without quotes or a number between 1(Monday) and 7(Sunday)) 4. No constraint introduced when it is '*'. When not, day of week must equal the given value <day-of-month> can be either '*' (without quotes or a number between 1 and 28) 5. No constraint introduced when it is '*'. When not, day of month must equal the given value
        :param pulumi.Input[_builtins.str] schedule_assessment_id: The OCID of the user assessment that is responsible for creating this scheduled save assessment.
        :param pulumi.Input[_builtins.str] state: The current state of the user assessment.
        :param pulumi.Input[_builtins.str] statistics: Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_database_group_id: The OCID of target database group.
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target database or target database group on which user assessment is to be run.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_ids: Array of database target OCIDs.
        :param pulumi.Input[_builtins.str] target_type: The type of user assessment resource whether it is individual or group resource. For individual target use type TARGET_DATABASE and for group resource use type TARGET_DATABASE_GROUP. If not provided, TARGET_DATABASE would be used as default value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time the user assessment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_last_assessed: The date and time the user assessment was last executed, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the user assessment was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] triggered_by: Indicates whether the user assessment was created by the system or the user.
        :param pulumi.Input[_builtins.str] type: The type of the user assessment. The possible types are:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserAssessmentState.__new__(_UserAssessmentState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ignored_assessment_ids"] = ignored_assessment_ids
        __props__.__dict__["ignored_targets"] = ignored_targets
        __props__.__dict__["is_assessment_scheduled"] = is_assessment_scheduled
        __props__.__dict__["is_baseline"] = is_baseline
        __props__.__dict__["is_deviated_from_baseline"] = is_deviated_from_baseline
        __props__.__dict__["last_compared_baseline_id"] = last_compared_baseline_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["schedule_assessment_id"] = schedule_assessment_id
        __props__.__dict__["state"] = state
        __props__.__dict__["statistics"] = statistics
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_database_group_id"] = target_database_group_id
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["target_ids"] = target_ids
        __props__.__dict__["target_type"] = target_type
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_assessed"] = time_last_assessed
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["triggered_by"] = triggered_by
        __props__.__dict__["type"] = type
        return UserAssessment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the user assessment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the user assessment.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the user assessment.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="ignoredAssessmentIds")
    def ignored_assessment_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        """
        return pulumi.get(self, "ignored_assessment_ids")

    @_builtins.property
    @pulumi.getter(name="ignoredTargets")
    def ignored_targets(self) -> pulumi.Output[Sequence['outputs.UserAssessmentIgnoredTarget']]:
        """
        List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        """
        return pulumi.get(self, "ignored_targets")

    @_builtins.property
    @pulumi.getter(name="isAssessmentScheduled")
    def is_assessment_scheduled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates whether the assessment is scheduled to run.
        """
        return pulumi.get(self, "is_assessment_scheduled")

    @_builtins.property
    @pulumi.getter(name="isBaseline")
    def is_baseline(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if the user assessment is set as a baseline. This is applicable only to saved user assessments.
        """
        return pulumi.get(self, "is_baseline")

    @_builtins.property
    @pulumi.getter(name="isDeviatedFromBaseline")
    def is_deviated_from_baseline(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if the user assessment deviates from the baseline.
        """
        return pulumi.get(self, "is_deviated_from_baseline")

    @_builtins.property
    @pulumi.getter(name="lastComparedBaselineId")
    def last_compared_baseline_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the last user assessment baseline against which the latest assessment was compared.
        """
        return pulumi.get(self, "last_compared_baseline_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details about the current state of the user assessment.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) To schedule the assessment for saving periodically, specify the schedule in this attribute. Create or schedule one assessment per compartment. If not defined, the assessment runs immediately. Format - <version-string>;<version-specific-schedule>

        Allowed version strings - "v1" v1's version specific schedule -<ss> <mm> <hh> <day-of-week> <day-of-month> Each of the above fields potentially introduce constraints. A workrequest is created only when clock time satisfies all the constraints. Constraints introduced: 1. seconds = <ss> (So, the allowed range for <ss> is [0, 59]) 2. minutes = <mm> (So, the allowed range for <mm> is [0, 59]) 3. hours = <hh> (So, the allowed range for <hh> is [0, 23]) <day-of-week> can be either '*' (without quotes or a number between 1(Monday) and 7(Sunday)) 4. No constraint introduced when it is '*'. When not, day of week must equal the given value <day-of-month> can be either '*' (without quotes or a number between 1 and 28) 5. No constraint introduced when it is '*'. When not, day of month must equal the given value
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="scheduleAssessmentId")
    def schedule_assessment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the user assessment that is responsible for creating this scheduled save assessment.
        """
        return pulumi.get(self, "schedule_assessment_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the user assessment.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> pulumi.Output[_builtins.str]:
        """
        Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        """
        return pulumi.get(self, "statistics")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetDatabaseGroupId")
    def target_database_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of target database group.
        """
        return pulumi.get(self, "target_database_group_id")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the target database or target database group on which user assessment is to be run.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Array of database target OCIDs.
        """
        return pulumi.get(self, "target_ids")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of user assessment resource whether it is individual or group resource. For individual target use type TARGET_DATABASE and for group resource use type TARGET_DATABASE_GROUP. If not provided, TARGET_DATABASE would be used as default value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_type")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the user assessment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastAssessed")
    def time_last_assessed(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the user assessment was last executed, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_last_assessed")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the user assessment was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="triggeredBy")
    def triggered_by(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether the user assessment was created by the system or the user.
        """
        return pulumi.get(self, "triggered_by")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the user assessment. The possible types are:
        """
        return pulumi.get(self, "type")

