# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMlApplicationsResult',
    'AwaitableGetMlApplicationsResult',
    'get_ml_applications',
    'get_ml_applications_output',
]

@pulumi.output_type
class GetMlApplicationsResult:
    """
    A collection of values returned by getMlApplications.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, ml_application_collections=None, ml_application_id=None, name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ml_application_collections and not isinstance(ml_application_collections, list):
            raise TypeError("Expected argument 'ml_application_collections' to be a list")
        pulumi.set(__self__, "ml_application_collections", ml_application_collections)
        if ml_application_id and not isinstance(ml_application_id, str):
            raise TypeError("Expected argument 'ml_application_id' to be a str")
        pulumi.set(__self__, "ml_application_id", ml_application_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where the MlApplication is created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMlApplicationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mlApplicationCollections")
    def ml_application_collections(self) -> Sequence['outputs.GetMlApplicationsMlApplicationCollectionResult']:
        """
        The list of ml_application_collection.
        """
        return pulumi.get(self, "ml_application_collections")

    @_builtins.property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ml_application_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of MlApplication. It is unique in a given tenancy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the MlApplication.
        """
        return pulumi.get(self, "state")


class AwaitableGetMlApplicationsResult(GetMlApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMlApplicationsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            ml_application_collections=self.ml_application_collections,
            ml_application_id=self.ml_application_id,
            name=self.name,
            state=self.state)


def get_ml_applications(compartment_id: Optional[_builtins.str] = None,
                        compartment_id_in_subtree: Optional[_builtins.bool] = None,
                        filters: Optional[Sequence[Union['GetMlApplicationsFilterArgs', 'GetMlApplicationsFilterArgsDict']]] = None,
                        ml_application_id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        state: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMlApplicationsResult:
    """
    This data source provides the list of Ml Applications in Oracle Cloud Infrastructure Data Science service.

    Returns a list of MlApplications.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_applications = oci.DataScience.get_ml_applications(compartment_id=compartment_id,
        compartment_id_in_subtree=ml_application_compartment_id_in_subtree,
        ml_application_id=test_ml_application["id"],
        name=ml_application_name,
        state=ml_application_state)
    ```


    :param _builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool compartment_id_in_subtree: If it is true search must include all results from descendant compartments. Value true is allowed only if compartmentId refers to root compartment.
    :param _builtins.str ml_application_id: unique MlApplication identifier
    :param _builtins.str name: A filter to return only resources that match the entire name given.
    :param _builtins.str state: A filter to return only resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['mlApplicationId'] = ml_application_id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getMlApplications:getMlApplications', __args__, opts=opts, typ=GetMlApplicationsResult).value

    return AwaitableGetMlApplicationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ml_application_collections=pulumi.get(__ret__, 'ml_application_collections'),
        ml_application_id=pulumi.get(__ret__, 'ml_application_id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_ml_applications_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                               compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMlApplicationsFilterArgs', 'GetMlApplicationsFilterArgsDict']]]]] = None,
                               ml_application_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMlApplicationsResult]:
    """
    This data source provides the list of Ml Applications in Oracle Cloud Infrastructure Data Science service.

    Returns a list of MlApplications.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_applications = oci.DataScience.get_ml_applications(compartment_id=compartment_id,
        compartment_id_in_subtree=ml_application_compartment_id_in_subtree,
        ml_application_id=test_ml_application["id"],
        name=ml_application_name,
        state=ml_application_state)
    ```


    :param _builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool compartment_id_in_subtree: If it is true search must include all results from descendant compartments. Value true is allowed only if compartmentId refers to root compartment.
    :param _builtins.str ml_application_id: unique MlApplication identifier
    :param _builtins.str name: A filter to return only resources that match the entire name given.
    :param _builtins.str state: A filter to return only resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['mlApplicationId'] = ml_application_id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getMlApplications:getMlApplications', __args__, opts=opts, typ=GetMlApplicationsResult)
    return __ret__.apply(lambda __response__: GetMlApplicationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ml_application_collections=pulumi.get(__response__, 'ml_application_collections'),
        ml_application_id=pulumi.get(__response__, 'ml_application_id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
