# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelGroupArgs', 'ModelGroup']

@pulumi.input_type
class ModelGroupArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 create_type: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 member_model_entries: Optional[pulumi.Input['ModelGroupMemberModelEntriesArgs']] = None,
                 model_group_clone_source_details: Optional[pulumi.Input['ModelGroupModelGroupCloneSourceDetailsArgs']] = None,
                 model_group_details: Optional[pulumi.Input['ModelGroupModelGroupDetailsArgs']] = None,
                 model_group_version_history_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_label: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ModelGroup resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the modelGroup in.
        :param pulumi.Input[_builtins.str] create_type: The type of the model group create operation.
        :param pulumi.Input[_builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the modelGroup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the modelGroup.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My ModelGroup`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['ModelGroupMemberModelEntriesArgs'] member_model_entries: List of member models (inferenceKey & modelId) to be associated with the model group.
        :param pulumi.Input['ModelGroupModelGroupCloneSourceDetailsArgs'] model_group_clone_source_details: Model Group clone source details.
        :param pulumi.Input['ModelGroupModelGroupDetailsArgs'] model_group_details: The model group details.
        :param pulumi.Input[_builtins.str] model_group_version_history_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
        :param pulumi.Input[_builtins.str] version_label: (Updatable) An additional description of the lifecycle state of the model group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "create_type", create_type)
        pulumi.set(__self__, "project_id", project_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if member_model_entries is not None:
            pulumi.set(__self__, "member_model_entries", member_model_entries)
        if model_group_clone_source_details is not None:
            pulumi.set(__self__, "model_group_clone_source_details", model_group_clone_source_details)
        if model_group_details is not None:
            pulumi.set(__self__, "model_group_details", model_group_details)
        if model_group_version_history_id is not None:
            pulumi.set(__self__, "model_group_version_history_id", model_group_version_history_id)
        if version_label is not None:
            pulumi.set(__self__, "version_label", version_label)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the modelGroup in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="createType")
    def create_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the model group create operation.
        """
        return pulumi.get(self, "create_type")

    @create_type.setter
    def create_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "create_type", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the modelGroup.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A short description of the modelGroup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My ModelGroup`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="memberModelEntries")
    def member_model_entries(self) -> Optional[pulumi.Input['ModelGroupMemberModelEntriesArgs']]:
        """
        List of member models (inferenceKey & modelId) to be associated with the model group.
        """
        return pulumi.get(self, "member_model_entries")

    @member_model_entries.setter
    def member_model_entries(self, value: Optional[pulumi.Input['ModelGroupMemberModelEntriesArgs']]):
        pulumi.set(self, "member_model_entries", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupCloneSourceDetails")
    def model_group_clone_source_details(self) -> Optional[pulumi.Input['ModelGroupModelGroupCloneSourceDetailsArgs']]:
        """
        Model Group clone source details.
        """
        return pulumi.get(self, "model_group_clone_source_details")

    @model_group_clone_source_details.setter
    def model_group_clone_source_details(self, value: Optional[pulumi.Input['ModelGroupModelGroupCloneSourceDetailsArgs']]):
        pulumi.set(self, "model_group_clone_source_details", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupDetails")
    def model_group_details(self) -> Optional[pulumi.Input['ModelGroupModelGroupDetailsArgs']]:
        """
        The model group details.
        """
        return pulumi.get(self, "model_group_details")

    @model_group_details.setter
    def model_group_details(self, value: Optional[pulumi.Input['ModelGroupModelGroupDetailsArgs']]):
        pulumi.set(self, "model_group_details", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupVersionHistoryId")
    def model_group_version_history_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
        """
        return pulumi.get(self, "model_group_version_history_id")

    @model_group_version_history_id.setter
    def model_group_version_history_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_group_version_history_id", value)

    @_builtins.property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An additional description of the lifecycle state of the model group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_label", value)


@pulumi.input_type
class _ModelGroupState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 member_model_entries: Optional[pulumi.Input['ModelGroupMemberModelEntriesArgs']] = None,
                 model_group_clone_source_details: Optional[pulumi.Input['ModelGroupModelGroupCloneSourceDetailsArgs']] = None,
                 model_group_details: Optional[pulumi.Input['ModelGroupModelGroupDetailsArgs']] = None,
                 model_group_version_history_id: Optional[pulumi.Input[_builtins.str]] = None,
                 model_group_version_history_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_model_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_label: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ModelGroup resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the modelGroup in.
        :param pulumi.Input[_builtins.str] create_type: The type of the model group create operation.
        :param pulumi.Input[_builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the modelGroup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the modelGroup.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My ModelGroup`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the lifecycle state of the model group.
        :param pulumi.Input['ModelGroupMemberModelEntriesArgs'] member_model_entries: List of member models (inferenceKey & modelId) to be associated with the model group.
        :param pulumi.Input['ModelGroupModelGroupCloneSourceDetailsArgs'] model_group_clone_source_details: Model Group clone source details.
        :param pulumi.Input['ModelGroupModelGroupDetailsArgs'] model_group_details: The model group details.
        :param pulumi.Input[_builtins.str] model_group_version_history_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
        :param pulumi.Input[_builtins.str] model_group_version_history_name: The name of the model group version history to which the model group is associated.
        :param pulumi.Input[_builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the modelGroup.
        :param pulumi.Input[_builtins.str] source_model_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group used for the clone operation.
        :param pulumi.Input[_builtins.str] state: The state of the modelGroup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        :param pulumi.Input[_builtins.str] time_updated: The date and time the resource was last updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        :param pulumi.Input[_builtins.str] version_id: Unique identifier assigned to each version of the model group. It would be auto-incremented number generated by service.
        :param pulumi.Input[_builtins.str] version_label: (Updatable) An additional description of the lifecycle state of the model group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if create_type is not None:
            pulumi.set(__self__, "create_type", create_type)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if member_model_entries is not None:
            pulumi.set(__self__, "member_model_entries", member_model_entries)
        if model_group_clone_source_details is not None:
            pulumi.set(__self__, "model_group_clone_source_details", model_group_clone_source_details)
        if model_group_details is not None:
            pulumi.set(__self__, "model_group_details", model_group_details)
        if model_group_version_history_id is not None:
            pulumi.set(__self__, "model_group_version_history_id", model_group_version_history_id)
        if model_group_version_history_name is not None:
            pulumi.set(__self__, "model_group_version_history_name", model_group_version_history_name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if source_model_group_id is not None:
            pulumi.set(__self__, "source_model_group_id", source_model_group_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if version_label is not None:
            pulumi.set(__self__, "version_label", version_label)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the modelGroup in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="createType")
    def create_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the model group create operation.
        """
        return pulumi.get(self, "create_type")

    @create_type.setter
    def create_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_type", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the modelGroup.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A short description of the modelGroup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My ModelGroup`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details about the lifecycle state of the model group.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="memberModelEntries")
    def member_model_entries(self) -> Optional[pulumi.Input['ModelGroupMemberModelEntriesArgs']]:
        """
        List of member models (inferenceKey & modelId) to be associated with the model group.
        """
        return pulumi.get(self, "member_model_entries")

    @member_model_entries.setter
    def member_model_entries(self, value: Optional[pulumi.Input['ModelGroupMemberModelEntriesArgs']]):
        pulumi.set(self, "member_model_entries", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupCloneSourceDetails")
    def model_group_clone_source_details(self) -> Optional[pulumi.Input['ModelGroupModelGroupCloneSourceDetailsArgs']]:
        """
        Model Group clone source details.
        """
        return pulumi.get(self, "model_group_clone_source_details")

    @model_group_clone_source_details.setter
    def model_group_clone_source_details(self, value: Optional[pulumi.Input['ModelGroupModelGroupCloneSourceDetailsArgs']]):
        pulumi.set(self, "model_group_clone_source_details", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupDetails")
    def model_group_details(self) -> Optional[pulumi.Input['ModelGroupModelGroupDetailsArgs']]:
        """
        The model group details.
        """
        return pulumi.get(self, "model_group_details")

    @model_group_details.setter
    def model_group_details(self, value: Optional[pulumi.Input['ModelGroupModelGroupDetailsArgs']]):
        pulumi.set(self, "model_group_details", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupVersionHistoryId")
    def model_group_version_history_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
        """
        return pulumi.get(self, "model_group_version_history_id")

    @model_group_version_history_id.setter
    def model_group_version_history_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_group_version_history_id", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupVersionHistoryName")
    def model_group_version_history_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the model group version history to which the model group is associated.
        """
        return pulumi.get(self, "model_group_version_history_name")

    @model_group_version_history_name.setter
    def model_group_version_history_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_group_version_history_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the modelGroup.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceModelGroupId")
    def source_model_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group used for the clone operation.
        """
        return pulumi.get(self, "source_model_group_id")

    @source_model_group_id.setter
    def source_model_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_model_group_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the modelGroup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the resource was last updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier assigned to each version of the model group. It would be auto-incremented number generated by service.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)

    @_builtins.property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An additional description of the lifecycle state of the model group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_label", value)


@pulumi.type_token("oci:DataScience/modelGroup:ModelGroup")
class ModelGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 member_model_entries: Optional[pulumi.Input[Union['ModelGroupMemberModelEntriesArgs', 'ModelGroupMemberModelEntriesArgsDict']]] = None,
                 model_group_clone_source_details: Optional[pulumi.Input[Union['ModelGroupModelGroupCloneSourceDetailsArgs', 'ModelGroupModelGroupCloneSourceDetailsArgsDict']]] = None,
                 model_group_details: Optional[pulumi.Input[Union['ModelGroupModelGroupDetailsArgs', 'ModelGroupModelGroupDetailsArgsDict']]] = None,
                 model_group_version_history_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_label: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_group = oci.datascience.ModelGroup("test_model_group",
            compartment_id=compartment_id,
            create_type=model_group_create_type,
            project_id=test_project["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=model_group_description,
            display_name=model_group_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            member_model_entries={
                "member_model_details": [{
                    "inference_key": model_group_member_model_entries_member_model_details_inference_key,
                    "model_id": test_model["id"],
                }],
            },
            model_group_clone_source_details={
                "model_group_clone_source_type": model_group_model_group_clone_source_details_model_group_clone_source_type,
                "source_id": test_source["id"],
                "modify_model_group_details": {
                    "defined_tags": model_group_model_group_clone_source_details_modify_model_group_details_defined_tags,
                    "description": model_group_model_group_clone_source_details_modify_model_group_details_description,
                    "display_name": model_group_model_group_clone_source_details_modify_model_group_details_display_name,
                    "freeform_tags": model_group_model_group_clone_source_details_modify_model_group_details_freeform_tags,
                    "model_group_details": {
                        "type": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_type,
                        "base_model_id": test_model["id"],
                        "custom_metadata_lists": [{
                            "category": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_custom_metadata_list_category,
                            "description": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_custom_metadata_list_description,
                            "key": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_custom_metadata_list_key,
                            "value": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_custom_metadata_list_value,
                        }],
                    },
                    "model_group_version_history_id": test_model_group_version_history["id"],
                    "version_label": model_group_model_group_clone_source_details_modify_model_group_details_version_label,
                },
                "patch_model_group_member_model_details": {
                    "items": [{
                        "operation": model_group_model_group_clone_source_details_patch_model_group_member_model_details_items_operation,
                        "values": [{
                            "model_id": test_model["id"],
                            "inference_key": model_group_model_group_clone_source_details_patch_model_group_member_model_details_items_values_inference_key,
                        }],
                    }],
                },
            },
            model_group_details={
                "type": model_group_model_group_details_type,
                "base_model_id": test_model["id"],
                "custom_metadata_lists": [{
                    "category": model_group_model_group_details_custom_metadata_list_category,
                    "description": model_group_model_group_details_custom_metadata_list_description,
                    "key": model_group_model_group_details_custom_metadata_list_key,
                    "value": model_group_model_group_details_custom_metadata_list_value,
                }],
            },
            model_group_version_history_id=test_model_group_version_history["id"],
            version_label=model_group_version_label)
        ```

        ## Import

        ModelGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/modelGroup:ModelGroup test_model_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the modelGroup in.
        :param pulumi.Input[_builtins.str] create_type: The type of the model group create operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the modelGroup.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My ModelGroup`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['ModelGroupMemberModelEntriesArgs', 'ModelGroupMemberModelEntriesArgsDict']] member_model_entries: List of member models (inferenceKey & modelId) to be associated with the model group.
        :param pulumi.Input[Union['ModelGroupModelGroupCloneSourceDetailsArgs', 'ModelGroupModelGroupCloneSourceDetailsArgsDict']] model_group_clone_source_details: Model Group clone source details.
        :param pulumi.Input[Union['ModelGroupModelGroupDetailsArgs', 'ModelGroupModelGroupDetailsArgsDict']] model_group_details: The model group details.
        :param pulumi.Input[_builtins.str] model_group_version_history_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
        :param pulumi.Input[_builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the modelGroup.
        :param pulumi.Input[_builtins.str] version_label: (Updatable) An additional description of the lifecycle state of the model group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_group = oci.datascience.ModelGroup("test_model_group",
            compartment_id=compartment_id,
            create_type=model_group_create_type,
            project_id=test_project["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=model_group_description,
            display_name=model_group_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            member_model_entries={
                "member_model_details": [{
                    "inference_key": model_group_member_model_entries_member_model_details_inference_key,
                    "model_id": test_model["id"],
                }],
            },
            model_group_clone_source_details={
                "model_group_clone_source_type": model_group_model_group_clone_source_details_model_group_clone_source_type,
                "source_id": test_source["id"],
                "modify_model_group_details": {
                    "defined_tags": model_group_model_group_clone_source_details_modify_model_group_details_defined_tags,
                    "description": model_group_model_group_clone_source_details_modify_model_group_details_description,
                    "display_name": model_group_model_group_clone_source_details_modify_model_group_details_display_name,
                    "freeform_tags": model_group_model_group_clone_source_details_modify_model_group_details_freeform_tags,
                    "model_group_details": {
                        "type": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_type,
                        "base_model_id": test_model["id"],
                        "custom_metadata_lists": [{
                            "category": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_custom_metadata_list_category,
                            "description": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_custom_metadata_list_description,
                            "key": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_custom_metadata_list_key,
                            "value": model_group_model_group_clone_source_details_modify_model_group_details_model_group_details_custom_metadata_list_value,
                        }],
                    },
                    "model_group_version_history_id": test_model_group_version_history["id"],
                    "version_label": model_group_model_group_clone_source_details_modify_model_group_details_version_label,
                },
                "patch_model_group_member_model_details": {
                    "items": [{
                        "operation": model_group_model_group_clone_source_details_patch_model_group_member_model_details_items_operation,
                        "values": [{
                            "model_id": test_model["id"],
                            "inference_key": model_group_model_group_clone_source_details_patch_model_group_member_model_details_items_values_inference_key,
                        }],
                    }],
                },
            },
            model_group_details={
                "type": model_group_model_group_details_type,
                "base_model_id": test_model["id"],
                "custom_metadata_lists": [{
                    "category": model_group_model_group_details_custom_metadata_list_category,
                    "description": model_group_model_group_details_custom_metadata_list_description,
                    "key": model_group_model_group_details_custom_metadata_list_key,
                    "value": model_group_model_group_details_custom_metadata_list_value,
                }],
            },
            model_group_version_history_id=test_model_group_version_history["id"],
            version_label=model_group_version_label)
        ```

        ## Import

        ModelGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/modelGroup:ModelGroup test_model_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 member_model_entries: Optional[pulumi.Input[Union['ModelGroupMemberModelEntriesArgs', 'ModelGroupMemberModelEntriesArgsDict']]] = None,
                 model_group_clone_source_details: Optional[pulumi.Input[Union['ModelGroupModelGroupCloneSourceDetailsArgs', 'ModelGroupModelGroupCloneSourceDetailsArgsDict']]] = None,
                 model_group_details: Optional[pulumi.Input[Union['ModelGroupModelGroupDetailsArgs', 'ModelGroupModelGroupDetailsArgsDict']]] = None,
                 model_group_version_history_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_label: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelGroupArgs.__new__(ModelGroupArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if create_type is None and not opts.urn:
                raise TypeError("Missing required property 'create_type'")
            __props__.__dict__["create_type"] = create_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["member_model_entries"] = member_model_entries
            __props__.__dict__["model_group_clone_source_details"] = model_group_clone_source_details
            __props__.__dict__["model_group_details"] = model_group_details
            __props__.__dict__["model_group_version_history_id"] = model_group_version_history_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["version_label"] = version_label
            __props__.__dict__["created_by"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["model_group_version_history_name"] = None
            __props__.__dict__["source_model_group_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version_id"] = None
        super(ModelGroup, __self__).__init__(
            'oci:DataScience/modelGroup:ModelGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_type: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            member_model_entries: Optional[pulumi.Input[Union['ModelGroupMemberModelEntriesArgs', 'ModelGroupMemberModelEntriesArgsDict']]] = None,
            model_group_clone_source_details: Optional[pulumi.Input[Union['ModelGroupModelGroupCloneSourceDetailsArgs', 'ModelGroupModelGroupCloneSourceDetailsArgsDict']]] = None,
            model_group_details: Optional[pulumi.Input[Union['ModelGroupModelGroupDetailsArgs', 'ModelGroupModelGroupDetailsArgsDict']]] = None,
            model_group_version_history_id: Optional[pulumi.Input[_builtins.str]] = None,
            model_group_version_history_name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_model_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None,
            version_label: Optional[pulumi.Input[_builtins.str]] = None) -> 'ModelGroup':
        """
        Get an existing ModelGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the modelGroup in.
        :param pulumi.Input[_builtins.str] create_type: The type of the model group create operation.
        :param pulumi.Input[_builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the modelGroup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the modelGroup.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My ModelGroup`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the lifecycle state of the model group.
        :param pulumi.Input[Union['ModelGroupMemberModelEntriesArgs', 'ModelGroupMemberModelEntriesArgsDict']] member_model_entries: List of member models (inferenceKey & modelId) to be associated with the model group.
        :param pulumi.Input[Union['ModelGroupModelGroupCloneSourceDetailsArgs', 'ModelGroupModelGroupCloneSourceDetailsArgsDict']] model_group_clone_source_details: Model Group clone source details.
        :param pulumi.Input[Union['ModelGroupModelGroupDetailsArgs', 'ModelGroupModelGroupDetailsArgsDict']] model_group_details: The model group details.
        :param pulumi.Input[_builtins.str] model_group_version_history_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
        :param pulumi.Input[_builtins.str] model_group_version_history_name: The name of the model group version history to which the model group is associated.
        :param pulumi.Input[_builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the modelGroup.
        :param pulumi.Input[_builtins.str] source_model_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group used for the clone operation.
        :param pulumi.Input[_builtins.str] state: The state of the modelGroup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        :param pulumi.Input[_builtins.str] time_updated: The date and time the resource was last updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        :param pulumi.Input[_builtins.str] version_id: Unique identifier assigned to each version of the model group. It would be auto-incremented number generated by service.
        :param pulumi.Input[_builtins.str] version_label: (Updatable) An additional description of the lifecycle state of the model group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelGroupState.__new__(_ModelGroupState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["create_type"] = create_type
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["member_model_entries"] = member_model_entries
        __props__.__dict__["model_group_clone_source_details"] = model_group_clone_source_details
        __props__.__dict__["model_group_details"] = model_group_details
        __props__.__dict__["model_group_version_history_id"] = model_group_version_history_id
        __props__.__dict__["model_group_version_history_name"] = model_group_version_history_name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["source_model_group_id"] = source_model_group_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["version_label"] = version_label
        return ModelGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the modelGroup in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createType")
    def create_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the model group create operation.
        """
        return pulumi.get(self, "create_type")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the modelGroup.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A short description of the modelGroup.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My ModelGroup`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details about the lifecycle state of the model group.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="memberModelEntries")
    def member_model_entries(self) -> pulumi.Output['outputs.ModelGroupMemberModelEntries']:
        """
        List of member models (inferenceKey & modelId) to be associated with the model group.
        """
        return pulumi.get(self, "member_model_entries")

    @_builtins.property
    @pulumi.getter(name="modelGroupCloneSourceDetails")
    def model_group_clone_source_details(self) -> pulumi.Output['outputs.ModelGroupModelGroupCloneSourceDetails']:
        """
        Model Group clone source details.
        """
        return pulumi.get(self, "model_group_clone_source_details")

    @_builtins.property
    @pulumi.getter(name="modelGroupDetails")
    def model_group_details(self) -> pulumi.Output['outputs.ModelGroupModelGroupDetails']:
        """
        The model group details.
        """
        return pulumi.get(self, "model_group_details")

    @_builtins.property
    @pulumi.getter(name="modelGroupVersionHistoryId")
    def model_group_version_history_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
        """
        return pulumi.get(self, "model_group_version_history_id")

    @_builtins.property
    @pulumi.getter(name="modelGroupVersionHistoryName")
    def model_group_version_history_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the model group version history to which the model group is associated.
        """
        return pulumi.get(self, "model_group_version_history_name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the modelGroup.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="sourceModelGroupId")
    def source_model_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group used for the clone operation.
        """
        return pulumi.get(self, "source_model_group_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the modelGroup.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the resource was last updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier assigned to each version of the model group. It would be auto-incremented number generated by service.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An additional description of the lifecycle state of the model group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version_label")

