# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutomaticDrConfigurationArgs', 'AutomaticDrConfiguration']

@pulumi.input_type
class AutomaticDrConfigurationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 dr_protection_group_id: pulumi.Input[_builtins.str],
                 members: pulumi.Input[Sequence[pulumi.Input['AutomaticDrConfigurationMemberArgs']]],
                 default_failover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_switchover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AutomaticDrConfiguration resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the Automatic DR configuration being created.  Example: `Automatic DR Configuration`
        :param pulumi.Input[_builtins.str] dr_protection_group_id: The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[Sequence[pulumi.Input['AutomaticDrConfigurationMemberArgs']]] members: (Updatable) A list of members for Automatic DR configuration.
        :param pulumi.Input[_builtins.str] default_failover_dr_plan_id: (Updatable) The unique id of a Failover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        :param pulumi.Input[_builtins.str] default_switchover_dr_plan_id: (Updatable) The unique id of a Switchover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        pulumi.set(__self__, "members", members)
        if default_failover_dr_plan_id is not None:
            pulumi.set(__self__, "default_failover_dr_plan_id", default_failover_dr_plan_id)
        if default_switchover_dr_plan_id is not None:
            pulumi.set(__self__, "default_switchover_dr_plan_id", default_switchover_dr_plan_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The display name of the Automatic DR configuration being created.  Example: `Automatic DR Configuration`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @dr_protection_group_id.setter
    def dr_protection_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dr_protection_group_id", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input['AutomaticDrConfigurationMemberArgs']]]:
        """
        (Updatable) A list of members for Automatic DR configuration.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input['AutomaticDrConfigurationMemberArgs']]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter(name="defaultFailoverDrPlanId")
    def default_failover_dr_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The unique id of a Failover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "default_failover_dr_plan_id")

    @default_failover_dr_plan_id.setter
    def default_failover_dr_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_failover_dr_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultSwitchoverDrPlanId")
    def default_switchover_dr_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The unique id of a Switchover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "default_switchover_dr_plan_id")

    @default_switchover_dr_plan_id.setter
    def default_switchover_dr_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_switchover_dr_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AutomaticDrConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_failover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_switchover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 last_automatic_dr_execution_submit_details: Optional[pulumi.Input[_builtins.str]] = None,
                 last_automatic_dr_execution_submit_status: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['AutomaticDrConfigurationMemberArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_automatic_dr_execution_submit_attempt: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutomaticDrConfiguration resources.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment containing the Automatic DR configuration.  Example: `ocid1.compartment.oc1..uniqueID`
        :param pulumi.Input[_builtins.str] default_failover_dr_plan_id: (Updatable) The unique id of a Failover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        :param pulumi.Input[_builtins.str] default_switchover_dr_plan_id: (Updatable) The unique id of a Switchover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the Automatic DR configuration being created.  Example: `Automatic DR Configuration`
        :param pulumi.Input[_builtins.str] dr_protection_group_id: The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] last_automatic_dr_execution_submit_details: A message describing the result of the most recent attempt made to submit an Automatic DR plan execution.
        :param pulumi.Input[_builtins.str] last_automatic_dr_execution_submit_status: The status of most recent attempt to submit Automatic DR plan execution.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the Automatic DR configuration's current state in more detail.
        :param pulumi.Input[Sequence[pulumi.Input['AutomaticDrConfigurationMemberArgs']]] members: (Updatable) A list of members for Automatic DR configuration.
        :param pulumi.Input[_builtins.str] state: The current state of the Automatic DR configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Automatic DR configuration was created. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_last_automatic_dr_execution_submit_attempt: The date and time of the most recent attempt made to submit an Automatic DR plan execution. An RFC3339 formatted datetime string.  Example: `2025-06-30T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Automatic DR configuration was updated. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if default_failover_dr_plan_id is not None:
            pulumi.set(__self__, "default_failover_dr_plan_id", default_failover_dr_plan_id)
        if default_switchover_dr_plan_id is not None:
            pulumi.set(__self__, "default_switchover_dr_plan_id", default_switchover_dr_plan_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dr_protection_group_id is not None:
            pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if last_automatic_dr_execution_submit_details is not None:
            pulumi.set(__self__, "last_automatic_dr_execution_submit_details", last_automatic_dr_execution_submit_details)
        if last_automatic_dr_execution_submit_status is not None:
            pulumi.set(__self__, "last_automatic_dr_execution_submit_status", last_automatic_dr_execution_submit_status)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_automatic_dr_execution_submit_attempt is not None:
            pulumi.set(__self__, "time_last_automatic_dr_execution_submit_attempt", time_last_automatic_dr_execution_submit_attempt)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment containing the Automatic DR configuration.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultFailoverDrPlanId")
    def default_failover_dr_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The unique id of a Failover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "default_failover_dr_plan_id")

    @default_failover_dr_plan_id.setter
    def default_failover_dr_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_failover_dr_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultSwitchoverDrPlanId")
    def default_switchover_dr_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The unique id of a Switchover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "default_switchover_dr_plan_id")

    @default_switchover_dr_plan_id.setter
    def default_switchover_dr_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_switchover_dr_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the Automatic DR configuration being created.  Example: `Automatic DR Configuration`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @dr_protection_group_id.setter
    def dr_protection_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dr_protection_group_id", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lastAutomaticDrExecutionSubmitDetails")
    def last_automatic_dr_execution_submit_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the result of the most recent attempt made to submit an Automatic DR plan execution.
        """
        return pulumi.get(self, "last_automatic_dr_execution_submit_details")

    @last_automatic_dr_execution_submit_details.setter
    def last_automatic_dr_execution_submit_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_automatic_dr_execution_submit_details", value)

    @_builtins.property
    @pulumi.getter(name="lastAutomaticDrExecutionSubmitStatus")
    def last_automatic_dr_execution_submit_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of most recent attempt to submit Automatic DR plan execution.
        """
        return pulumi.get(self, "last_automatic_dr_execution_submit_status")

    @last_automatic_dr_execution_submit_status.setter
    def last_automatic_dr_execution_submit_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_automatic_dr_execution_submit_status", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the Automatic DR configuration's current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutomaticDrConfigurationMemberArgs']]]]:
        """
        (Updatable) A list of members for Automatic DR configuration.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutomaticDrConfigurationMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Automatic DR configuration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Automatic DR configuration was created. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeLastAutomaticDrExecutionSubmitAttempt")
    def time_last_automatic_dr_execution_submit_attempt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the most recent attempt made to submit an Automatic DR plan execution. An RFC3339 formatted datetime string.  Example: `2025-06-30T09:36:42Z`
        """
        return pulumi.get(self, "time_last_automatic_dr_execution_submit_attempt")

    @time_last_automatic_dr_execution_submit_attempt.setter
    def time_last_automatic_dr_execution_submit_attempt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_automatic_dr_execution_submit_attempt", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Automatic DR configuration was updated. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DisasterRecovery/automaticDrConfiguration:AutomaticDrConfiguration")
class AutomaticDrConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_failover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_switchover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutomaticDrConfigurationMemberArgs', 'AutomaticDrConfigurationMemberArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Automatic Dr Configuration resource in Oracle Cloud Infrastructure Disaster Recovery service.

        Create a Automatic DR configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_automatic_dr_configuration = oci.disasterrecovery.AutomaticDrConfiguration("test_automatic_dr_configuration",
            display_name=automatic_dr_configuration_display_name,
            dr_protection_group_id=test_dr_protection_group["id"],
            members=[{
                "member_id": test_member["id"],
                "member_type": automatic_dr_configuration_members_member_type,
                "is_auto_failover_enabled": automatic_dr_configuration_members_is_auto_failover_enabled,
                "is_auto_switchover_enabled": automatic_dr_configuration_members_is_auto_switchover_enabled,
            }],
            default_failover_dr_plan_id=test_dr_plan["id"],
            default_switchover_dr_plan_id=test_dr_plan["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AutomaticDrConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DisasterRecovery/automaticDrConfiguration:AutomaticDrConfiguration test_automatic_dr_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_failover_dr_plan_id: (Updatable) The unique id of a Failover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        :param pulumi.Input[_builtins.str] default_switchover_dr_plan_id: (Updatable) The unique id of a Switchover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the Automatic DR configuration being created.  Example: `Automatic DR Configuration`
        :param pulumi.Input[_builtins.str] dr_protection_group_id: The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutomaticDrConfigurationMemberArgs', 'AutomaticDrConfigurationMemberArgsDict']]]] members: (Updatable) A list of members for Automatic DR configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomaticDrConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Automatic Dr Configuration resource in Oracle Cloud Infrastructure Disaster Recovery service.

        Create a Automatic DR configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_automatic_dr_configuration = oci.disasterrecovery.AutomaticDrConfiguration("test_automatic_dr_configuration",
            display_name=automatic_dr_configuration_display_name,
            dr_protection_group_id=test_dr_protection_group["id"],
            members=[{
                "member_id": test_member["id"],
                "member_type": automatic_dr_configuration_members_member_type,
                "is_auto_failover_enabled": automatic_dr_configuration_members_is_auto_failover_enabled,
                "is_auto_switchover_enabled": automatic_dr_configuration_members_is_auto_switchover_enabled,
            }],
            default_failover_dr_plan_id=test_dr_plan["id"],
            default_switchover_dr_plan_id=test_dr_plan["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AutomaticDrConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DisasterRecovery/automaticDrConfiguration:AutomaticDrConfiguration test_automatic_dr_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param AutomaticDrConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomaticDrConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_failover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_switchover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutomaticDrConfigurationMemberArgs', 'AutomaticDrConfigurationMemberArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomaticDrConfigurationArgs.__new__(AutomaticDrConfigurationArgs)

            __props__.__dict__["default_failover_dr_plan_id"] = default_failover_dr_plan_id
            __props__.__dict__["default_switchover_dr_plan_id"] = default_switchover_dr_plan_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if dr_protection_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'dr_protection_group_id'")
            __props__.__dict__["dr_protection_group_id"] = dr_protection_group_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["last_automatic_dr_execution_submit_details"] = None
            __props__.__dict__["last_automatic_dr_execution_submit_status"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_automatic_dr_execution_submit_attempt"] = None
            __props__.__dict__["time_updated"] = None
        super(AutomaticDrConfiguration, __self__).__init__(
            'oci:DisasterRecovery/automaticDrConfiguration:AutomaticDrConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_failover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_switchover_dr_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            last_automatic_dr_execution_submit_details: Optional[pulumi.Input[_builtins.str]] = None,
            last_automatic_dr_execution_submit_status: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutomaticDrConfigurationMemberArgs', 'AutomaticDrConfigurationMemberArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_automatic_dr_execution_submit_attempt: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutomaticDrConfiguration':
        """
        Get an existing AutomaticDrConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment containing the Automatic DR configuration.  Example: `ocid1.compartment.oc1..uniqueID`
        :param pulumi.Input[_builtins.str] default_failover_dr_plan_id: (Updatable) The unique id of a Failover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        :param pulumi.Input[_builtins.str] default_switchover_dr_plan_id: (Updatable) The unique id of a Switchover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the Automatic DR configuration being created.  Example: `Automatic DR Configuration`
        :param pulumi.Input[_builtins.str] dr_protection_group_id: The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] last_automatic_dr_execution_submit_details: A message describing the result of the most recent attempt made to submit an Automatic DR plan execution.
        :param pulumi.Input[_builtins.str] last_automatic_dr_execution_submit_status: The status of most recent attempt to submit Automatic DR plan execution.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the Automatic DR configuration's current state in more detail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutomaticDrConfigurationMemberArgs', 'AutomaticDrConfigurationMemberArgsDict']]]] members: (Updatable) A list of members for Automatic DR configuration.
        :param pulumi.Input[_builtins.str] state: The current state of the Automatic DR configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Automatic DR configuration was created. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_last_automatic_dr_execution_submit_attempt: The date and time of the most recent attempt made to submit an Automatic DR plan execution. An RFC3339 formatted datetime string.  Example: `2025-06-30T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Automatic DR configuration was updated. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutomaticDrConfigurationState.__new__(_AutomaticDrConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["default_failover_dr_plan_id"] = default_failover_dr_plan_id
        __props__.__dict__["default_switchover_dr_plan_id"] = default_switchover_dr_plan_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dr_protection_group_id"] = dr_protection_group_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["last_automatic_dr_execution_submit_details"] = last_automatic_dr_execution_submit_details
        __props__.__dict__["last_automatic_dr_execution_submit_status"] = last_automatic_dr_execution_submit_status
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["members"] = members
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_automatic_dr_execution_submit_attempt"] = time_last_automatic_dr_execution_submit_attempt
        __props__.__dict__["time_updated"] = time_updated
        return AutomaticDrConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment containing the Automatic DR configuration.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="defaultFailoverDrPlanId")
    def default_failover_dr_plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The unique id of a Failover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "default_failover_dr_plan_id")

    @_builtins.property
    @pulumi.getter(name="defaultSwitchoverDrPlanId")
    def default_switchover_dr_plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The unique id of a Switchover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "default_switchover_dr_plan_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the Automatic DR configuration being created.  Example: `Automatic DR Configuration`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lastAutomaticDrExecutionSubmitDetails")
    def last_automatic_dr_execution_submit_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the result of the most recent attempt made to submit an Automatic DR plan execution.
        """
        return pulumi.get(self, "last_automatic_dr_execution_submit_details")

    @_builtins.property
    @pulumi.getter(name="lastAutomaticDrExecutionSubmitStatus")
    def last_automatic_dr_execution_submit_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of most recent attempt to submit Automatic DR plan execution.
        """
        return pulumi.get(self, "last_automatic_dr_execution_submit_status")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the Automatic DR configuration's current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence['outputs.AutomaticDrConfigurationMember']]:
        """
        (Updatable) A list of members for Automatic DR configuration.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Automatic DR configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Automatic DR configuration was created. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastAutomaticDrExecutionSubmitAttempt")
    def time_last_automatic_dr_execution_submit_attempt(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the most recent attempt made to submit an Automatic DR plan execution. An RFC3339 formatted datetime string.  Example: `2025-06-30T09:36:42Z`
        """
        return pulumi.get(self, "time_last_automatic_dr_execution_submit_attempt")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Automatic DR configuration was updated. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

