# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutomaticDrConfigurationResult',
    'AwaitableGetAutomaticDrConfigurationResult',
    'get_automatic_dr_configuration',
    'get_automatic_dr_configuration_output',
]

@pulumi.output_type
class GetAutomaticDrConfigurationResult:
    """
    A collection of values returned by getAutomaticDrConfiguration.
    """
    def __init__(__self__, automatic_dr_configuration_id=None, compartment_id=None, default_failover_dr_plan_id=None, default_switchover_dr_plan_id=None, defined_tags=None, display_name=None, dr_protection_group_id=None, freeform_tags=None, id=None, last_automatic_dr_execution_submit_details=None, last_automatic_dr_execution_submit_status=None, lifecycle_details=None, members=None, state=None, system_tags=None, time_created=None, time_last_automatic_dr_execution_submit_attempt=None, time_updated=None):
        if automatic_dr_configuration_id and not isinstance(automatic_dr_configuration_id, str):
            raise TypeError("Expected argument 'automatic_dr_configuration_id' to be a str")
        pulumi.set(__self__, "automatic_dr_configuration_id", automatic_dr_configuration_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if default_failover_dr_plan_id and not isinstance(default_failover_dr_plan_id, str):
            raise TypeError("Expected argument 'default_failover_dr_plan_id' to be a str")
        pulumi.set(__self__, "default_failover_dr_plan_id", default_failover_dr_plan_id)
        if default_switchover_dr_plan_id and not isinstance(default_switchover_dr_plan_id, str):
            raise TypeError("Expected argument 'default_switchover_dr_plan_id' to be a str")
        pulumi.set(__self__, "default_switchover_dr_plan_id", default_switchover_dr_plan_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_automatic_dr_execution_submit_details and not isinstance(last_automatic_dr_execution_submit_details, str):
            raise TypeError("Expected argument 'last_automatic_dr_execution_submit_details' to be a str")
        pulumi.set(__self__, "last_automatic_dr_execution_submit_details", last_automatic_dr_execution_submit_details)
        if last_automatic_dr_execution_submit_status and not isinstance(last_automatic_dr_execution_submit_status, str):
            raise TypeError("Expected argument 'last_automatic_dr_execution_submit_status' to be a str")
        pulumi.set(__self__, "last_automatic_dr_execution_submit_status", last_automatic_dr_execution_submit_status)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_automatic_dr_execution_submit_attempt and not isinstance(time_last_automatic_dr_execution_submit_attempt, str):
            raise TypeError("Expected argument 'time_last_automatic_dr_execution_submit_attempt' to be a str")
        pulumi.set(__self__, "time_last_automatic_dr_execution_submit_attempt", time_last_automatic_dr_execution_submit_attempt)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="automaticDrConfigurationId")
    def automatic_dr_configuration_id(self) -> _builtins.str:
        return pulumi.get(self, "automatic_dr_configuration_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing the Automatic DR configuration.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="defaultFailoverDrPlanId")
    def default_failover_dr_plan_id(self) -> _builtins.str:
        """
        The unique id of a Failover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "default_failover_dr_plan_id")

    @_builtins.property
    @pulumi.getter(name="defaultSwitchoverDrPlanId")
    def default_switchover_dr_plan_id(self) -> _builtins.str:
        """
        The unique id of a Switchover DR Plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "default_switchover_dr_plan_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the Automatic DR configuration.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> _builtins.str:
        """
        The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the Automatic DR configuration.  Example: `ocid1.automaticdrconfiguration.oc1..uniqueID`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastAutomaticDrExecutionSubmitDetails")
    def last_automatic_dr_execution_submit_details(self) -> _builtins.str:
        """
        A message describing the result of the most recent attempt made to submit an Automatic DR plan execution.
        """
        return pulumi.get(self, "last_automatic_dr_execution_submit_details")

    @_builtins.property
    @pulumi.getter(name="lastAutomaticDrExecutionSubmitStatus")
    def last_automatic_dr_execution_submit_status(self) -> _builtins.str:
        """
        The status of most recent attempt to submit Automatic DR plan execution.
        """
        return pulumi.get(self, "last_automatic_dr_execution_submit_status")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the Automatic DR configuration's current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetAutomaticDrConfigurationMemberResult']:
        """
        The list of members in this Automatic DR configuration.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Automatic DR configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Automatic DR configuration was created. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastAutomaticDrExecutionSubmitAttempt")
    def time_last_automatic_dr_execution_submit_attempt(self) -> _builtins.str:
        """
        The date and time of the most recent attempt made to submit an Automatic DR plan execution. An RFC3339 formatted datetime string.  Example: `2025-06-30T09:36:42Z`
        """
        return pulumi.get(self, "time_last_automatic_dr_execution_submit_attempt")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Automatic DR configuration was updated. An RFC3339 formatted datetime string.  Example: `2024-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAutomaticDrConfigurationResult(GetAutomaticDrConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutomaticDrConfigurationResult(
            automatic_dr_configuration_id=self.automatic_dr_configuration_id,
            compartment_id=self.compartment_id,
            default_failover_dr_plan_id=self.default_failover_dr_plan_id,
            default_switchover_dr_plan_id=self.default_switchover_dr_plan_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dr_protection_group_id=self.dr_protection_group_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            last_automatic_dr_execution_submit_details=self.last_automatic_dr_execution_submit_details,
            last_automatic_dr_execution_submit_status=self.last_automatic_dr_execution_submit_status,
            lifecycle_details=self.lifecycle_details,
            members=self.members,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_last_automatic_dr_execution_submit_attempt=self.time_last_automatic_dr_execution_submit_attempt,
            time_updated=self.time_updated)


def get_automatic_dr_configuration(automatic_dr_configuration_id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutomaticDrConfigurationResult:
    """
    This data source provides details about a specific Automatic Dr Configuration resource in Oracle Cloud Infrastructure Disaster Recovery service.

    Get details for the Automatic DR configuration identified by *automaticDrConfigurationId*.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_automatic_dr_configuration = oci.DisasterRecovery.get_automatic_dr_configuration(automatic_dr_configuration_id=test_automatic_dr_configuration_oci_disaster_recovery_automatic_dr_configuration["id"])
    ```


    :param _builtins.str automatic_dr_configuration_id: The OCID of the Automatic DR configuration.  Example: `ocid1.automaticDrConfiguration.oc1..uniqueID`
    """
    __args__ = dict()
    __args__['automaticDrConfigurationId'] = automatic_dr_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getAutomaticDrConfiguration:getAutomaticDrConfiguration', __args__, opts=opts, typ=GetAutomaticDrConfigurationResult).value

    return AwaitableGetAutomaticDrConfigurationResult(
        automatic_dr_configuration_id=pulumi.get(__ret__, 'automatic_dr_configuration_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        default_failover_dr_plan_id=pulumi.get(__ret__, 'default_failover_dr_plan_id'),
        default_switchover_dr_plan_id=pulumi.get(__ret__, 'default_switchover_dr_plan_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        last_automatic_dr_execution_submit_details=pulumi.get(__ret__, 'last_automatic_dr_execution_submit_details'),
        last_automatic_dr_execution_submit_status=pulumi.get(__ret__, 'last_automatic_dr_execution_submit_status'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        members=pulumi.get(__ret__, 'members'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_automatic_dr_execution_submit_attempt=pulumi.get(__ret__, 'time_last_automatic_dr_execution_submit_attempt'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_automatic_dr_configuration_output(automatic_dr_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutomaticDrConfigurationResult]:
    """
    This data source provides details about a specific Automatic Dr Configuration resource in Oracle Cloud Infrastructure Disaster Recovery service.

    Get details for the Automatic DR configuration identified by *automaticDrConfigurationId*.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_automatic_dr_configuration = oci.DisasterRecovery.get_automatic_dr_configuration(automatic_dr_configuration_id=test_automatic_dr_configuration_oci_disaster_recovery_automatic_dr_configuration["id"])
    ```


    :param _builtins.str automatic_dr_configuration_id: The OCID of the Automatic DR configuration.  Example: `ocid1.automaticDrConfiguration.oc1..uniqueID`
    """
    __args__ = dict()
    __args__['automaticDrConfigurationId'] = automatic_dr_configuration_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DisasterRecovery/getAutomaticDrConfiguration:getAutomaticDrConfiguration', __args__, opts=opts, typ=GetAutomaticDrConfigurationResult)
    return __ret__.apply(lambda __response__: GetAutomaticDrConfigurationResult(
        automatic_dr_configuration_id=pulumi.get(__response__, 'automatic_dr_configuration_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        default_failover_dr_plan_id=pulumi.get(__response__, 'default_failover_dr_plan_id'),
        default_switchover_dr_plan_id=pulumi.get(__response__, 'default_switchover_dr_plan_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        dr_protection_group_id=pulumi.get(__response__, 'dr_protection_group_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        last_automatic_dr_execution_submit_details=pulumi.get(__response__, 'last_automatic_dr_execution_submit_details'),
        last_automatic_dr_execution_submit_status=pulumi.get(__response__, 'last_automatic_dr_execution_submit_status'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        members=pulumi.get(__response__, 'members'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_automatic_dr_execution_submit_attempt=pulumi.get(__response__, 'time_last_automatic_dr_execution_submit_attempt'),
        time_updated=pulumi.get(__response__, 'time_updated')))
