# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutomaticDrConfigurationsResult',
    'AwaitableGetAutomaticDrConfigurationsResult',
    'get_automatic_dr_configurations',
    'get_automatic_dr_configurations_output',
]

@pulumi.output_type
class GetAutomaticDrConfigurationsResult:
    """
    A collection of values returned by getAutomaticDrConfigurations.
    """
    def __init__(__self__, automatic_dr_configuration_collections=None, automatic_dr_configuration_id=None, display_name=None, dr_protection_group_id=None, filters=None, id=None, lifecycle_state_not_equal_to=None, state=None):
        if automatic_dr_configuration_collections and not isinstance(automatic_dr_configuration_collections, list):
            raise TypeError("Expected argument 'automatic_dr_configuration_collections' to be a list")
        pulumi.set(__self__, "automatic_dr_configuration_collections", automatic_dr_configuration_collections)
        if automatic_dr_configuration_id and not isinstance(automatic_dr_configuration_id, str):
            raise TypeError("Expected argument 'automatic_dr_configuration_id' to be a str")
        pulumi.set(__self__, "automatic_dr_configuration_id", automatic_dr_configuration_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_state_not_equal_to and not isinstance(lifecycle_state_not_equal_to, str):
            raise TypeError("Expected argument 'lifecycle_state_not_equal_to' to be a str")
        pulumi.set(__self__, "lifecycle_state_not_equal_to", lifecycle_state_not_equal_to)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="automaticDrConfigurationCollections")
    def automatic_dr_configuration_collections(self) -> Sequence['outputs.GetAutomaticDrConfigurationsAutomaticDrConfigurationCollectionResult']:
        """
        The list of automatic_dr_configuration_collection.
        """
        return pulumi.get(self, "automatic_dr_configuration_collections")

    @_builtins.property
    @pulumi.getter(name="automaticDrConfigurationId")
    def automatic_dr_configuration_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "automatic_dr_configuration_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the Automatic DR configuration.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> _builtins.str:
        """
        The OCID of the DR protection group to which this Automatic DR configuration belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutomaticDrConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateNotEqualTo")
    def lifecycle_state_not_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lifecycle_state_not_equal_to")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Automatic DR configuration.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutomaticDrConfigurationsResult(GetAutomaticDrConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutomaticDrConfigurationsResult(
            automatic_dr_configuration_collections=self.automatic_dr_configuration_collections,
            automatic_dr_configuration_id=self.automatic_dr_configuration_id,
            display_name=self.display_name,
            dr_protection_group_id=self.dr_protection_group_id,
            filters=self.filters,
            id=self.id,
            lifecycle_state_not_equal_to=self.lifecycle_state_not_equal_to,
            state=self.state)


def get_automatic_dr_configurations(automatic_dr_configuration_id: Optional[_builtins.str] = None,
                                    display_name: Optional[_builtins.str] = None,
                                    dr_protection_group_id: Optional[_builtins.str] = None,
                                    filters: Optional[Sequence[Union['GetAutomaticDrConfigurationsFilterArgs', 'GetAutomaticDrConfigurationsFilterArgsDict']]] = None,
                                    lifecycle_state_not_equal_to: Optional[_builtins.str] = None,
                                    state: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutomaticDrConfigurationsResult:
    """
    This data source provides the list of Automatic Dr Configurations in Oracle Cloud Infrastructure Disaster Recovery service.

    Get a summary list of automatic DR configurations for a DR protection group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_automatic_dr_configurations = oci.DisasterRecovery.get_automatic_dr_configurations(dr_protection_group_id=test_dr_protection_group["id"],
        automatic_dr_configuration_id=test_automatic_dr_configuration["id"],
        display_name=automatic_dr_configuration_display_name,
        lifecycle_state_not_equal_to=automatic_dr_configuration_lifecycle_state_not_equal_to,
        state=automatic_dr_configuration_state)
    ```


    :param _builtins.str automatic_dr_configuration_id: The OCID of the automatic DR configuration.  Example: `ocid1.automaticDrConfiguration.oc1..uniqueID`
    :param _builtins.str display_name: A filter to return only resources that match the given display name.  Example: `MyResourceDisplayName`
    :param _builtins.str dr_protection_group_id: The OCID of the DR protection group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    :param _builtins.str lifecycle_state_not_equal_to: A filter to return only Automatic DR configurations that do not match the given lifecycle state.
    :param _builtins.str state: A filter to return only Automatic DR configurations that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['automaticDrConfigurationId'] = automatic_dr_configuration_id
    __args__['displayName'] = display_name
    __args__['drProtectionGroupId'] = dr_protection_group_id
    __args__['filters'] = filters
    __args__['lifecycleStateNotEqualTo'] = lifecycle_state_not_equal_to
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getAutomaticDrConfigurations:getAutomaticDrConfigurations', __args__, opts=opts, typ=GetAutomaticDrConfigurationsResult).value

    return AwaitableGetAutomaticDrConfigurationsResult(
        automatic_dr_configuration_collections=pulumi.get(__ret__, 'automatic_dr_configuration_collections'),
        automatic_dr_configuration_id=pulumi.get(__ret__, 'automatic_dr_configuration_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_state_not_equal_to=pulumi.get(__ret__, 'lifecycle_state_not_equal_to'),
        state=pulumi.get(__ret__, 'state'))
def get_automatic_dr_configurations_output(automatic_dr_configuration_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutomaticDrConfigurationsFilterArgs', 'GetAutomaticDrConfigurationsFilterArgsDict']]]]] = None,
                                           lifecycle_state_not_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutomaticDrConfigurationsResult]:
    """
    This data source provides the list of Automatic Dr Configurations in Oracle Cloud Infrastructure Disaster Recovery service.

    Get a summary list of automatic DR configurations for a DR protection group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_automatic_dr_configurations = oci.DisasterRecovery.get_automatic_dr_configurations(dr_protection_group_id=test_dr_protection_group["id"],
        automatic_dr_configuration_id=test_automatic_dr_configuration["id"],
        display_name=automatic_dr_configuration_display_name,
        lifecycle_state_not_equal_to=automatic_dr_configuration_lifecycle_state_not_equal_to,
        state=automatic_dr_configuration_state)
    ```


    :param _builtins.str automatic_dr_configuration_id: The OCID of the automatic DR configuration.  Example: `ocid1.automaticDrConfiguration.oc1..uniqueID`
    :param _builtins.str display_name: A filter to return only resources that match the given display name.  Example: `MyResourceDisplayName`
    :param _builtins.str dr_protection_group_id: The OCID of the DR protection group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    :param _builtins.str lifecycle_state_not_equal_to: A filter to return only Automatic DR configurations that do not match the given lifecycle state.
    :param _builtins.str state: A filter to return only Automatic DR configurations that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['automaticDrConfigurationId'] = automatic_dr_configuration_id
    __args__['displayName'] = display_name
    __args__['drProtectionGroupId'] = dr_protection_group_id
    __args__['filters'] = filters
    __args__['lifecycleStateNotEqualTo'] = lifecycle_state_not_equal_to
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DisasterRecovery/getAutomaticDrConfigurations:getAutomaticDrConfigurations', __args__, opts=opts, typ=GetAutomaticDrConfigurationsResult)
    return __ret__.apply(lambda __response__: GetAutomaticDrConfigurationsResult(
        automatic_dr_configuration_collections=pulumi.get(__response__, 'automatic_dr_configuration_collections'),
        automatic_dr_configuration_id=pulumi.get(__response__, 'automatic_dr_configuration_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        dr_protection_group_id=pulumi.get(__response__, 'dr_protection_group_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_state_not_equal_to=pulumi.get(__response__, 'lifecycle_state_not_equal_to'),
        state=pulumi.get(__response__, 'state')))
