# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FleetResourceInitArgs', 'FleetResource']

@pulumi.input_type
class FleetResourceInitArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 fleet_id: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str],
                 tenancy_id: pulumi.Input[_builtins.str],
                 resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FleetResource resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) OCID of the compartment to which the resource belongs to.
        :param pulumi.Input[_builtins.str] fleet_id: Unique Fleet identifier.
        :param pulumi.Input[_builtins.str] resource_id: The OCID of the resource.
        :param pulumi.Input[_builtins.str] tenancy_id: (Updatable) OCID of the tenancy to which the resource belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[_builtins.str] resource_type: Type of the Resource.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "fleet_id", fleet_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) OCID of the compartment to which the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique Fleet identifier.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) OCID of the tenancy to which the resource belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenancy_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_region", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the Resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class _FleetResourceState:
    def __init__(__self__, *,
                 compartment: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compliance_state: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 percent_compliant: Optional[pulumi.Input[_builtins.float]] = None,
                 product: Optional[pulumi.Input[_builtins.str]] = None,
                 product_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenancy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FleetResource resources.
        :param pulumi.Input[_builtins.str] compartment: Resource Compartment name.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) OCID of the compartment to which the resource belongs to.
        :param pulumi.Input[_builtins.str] compliance_state: Compliance State of the Resource.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[_builtins.str] environment_type: Environment Type associated with the Fleet when the resource type is fleet. Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        :param pulumi.Input[_builtins.str] fleet_id: Unique Fleet identifier.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.float] percent_compliant: The compliance percentage.
        :param pulumi.Input[_builtins.str] product: Product associated with the resource when the resource type is fleet. Will only be returned for PRODUCT fleets that are part of a GROUP Fleet.
        :param pulumi.Input[_builtins.int] product_count: Count of products within the resource.
        :param pulumi.Input[_builtins.str] resource_id: The OCID of the resource.
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[_builtins.str] resource_type: Type of the Resource.
        :param pulumi.Input[_builtins.str] state: The current state of the FleetResource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.int] target_count: Count of targets within the resource.
        :param pulumi.Input[_builtins.str] tenancy_id: (Updatable) OCID of the tenancy to which the resource belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] tenancy_name: Resource Tenancy Name.
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        if compartment is not None:
            pulumi.set(__self__, "compartment", compartment)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compliance_state is not None:
            pulumi.set(__self__, "compliance_state", compliance_state)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_type is not None:
            pulumi.set(__self__, "environment_type", environment_type)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if percent_compliant is not None:
            pulumi.set(__self__, "percent_compliant", percent_compliant)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if product_count is not None:
            pulumi.set(__self__, "product_count", product_count)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_count is not None:
            pulumi.set(__self__, "target_count", target_count)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if tenancy_name is not None:
            pulumi.set(__self__, "tenancy_name", tenancy_name)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def compartment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Compartment name.
        """
        return pulumi.get(self, "compartment")

    @compartment.setter
    def compartment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) OCID of the compartment to which the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compliance State of the Resource.
        """
        return pulumi.get(self, "compliance_state")

    @compliance_state.setter
    def compliance_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compliance_state", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Environment Type associated with the Fleet when the resource type is fleet. Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_type", value)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique Fleet identifier.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="percentCompliant")
    def percent_compliant(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The compliance percentage.
        """
        return pulumi.get(self, "percent_compliant")

    @percent_compliant.setter
    def percent_compliant(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "percent_compliant", value)

    @_builtins.property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product associated with the resource when the resource type is fleet. Will only be returned for PRODUCT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product", value)

    @_builtins.property
    @pulumi.getter(name="productCount")
    def product_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Count of products within the resource.
        """
        return pulumi.get(self, "product_count")

    @product_count.setter
    def product_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "product_count", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_region", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the Resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the FleetResource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Count of targets within the resource.
        """
        return pulumi.get(self, "target_count")

    @target_count.setter
    def target_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_count", value)

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) OCID of the tenancy to which the resource belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy_id", value)

    @_builtins.property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Tenancy Name.
        """
        return pulumi.get(self, "tenancy_name")

    @tenancy_name.setter
    def tenancy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy_name", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:FleetAppsManagement/fleetResource:FleetResource")
class FleetResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet_resource = oci.fleetappsmanagement.FleetResource("test_fleet_resource",
            compartment_id=compartment_id,
            fleet_id=test_fleet["id"],
            resource_id=test_resource["id"],
            tenancy_id=test_tenancy["id"],
            resource_region=fleet_resource_resource_region,
            resource_type=fleet_resource_resource_type)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) OCID of the compartment to which the resource belongs to.
        :param pulumi.Input[_builtins.str] fleet_id: Unique Fleet identifier.
        :param pulumi.Input[_builtins.str] resource_id: The OCID of the resource.
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[_builtins.str] resource_type: Type of the Resource.
        :param pulumi.Input[_builtins.str] tenancy_id: (Updatable) OCID of the tenancy to which the resource belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetResourceInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet_resource = oci.fleetappsmanagement.FleetResource("test_fleet_resource",
            compartment_id=compartment_id,
            fleet_id=test_fleet["id"],
            resource_id=test_resource["id"],
            tenancy_id=test_tenancy["id"],
            resource_region=fleet_resource_resource_region,
            resource_type=fleet_resource_resource_type)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param FleetResourceInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetResourceInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetResourceInitArgs.__new__(FleetResourceInitArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if fleet_id is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_id'")
            __props__.__dict__["fleet_id"] = fleet_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["resource_region"] = resource_region
            __props__.__dict__["resource_type"] = resource_type
            if tenancy_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenancy_id'")
            __props__.__dict__["tenancy_id"] = tenancy_id
            __props__.__dict__["compartment"] = None
            __props__.__dict__["compliance_state"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["environment_type"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["percent_compliant"] = None
            __props__.__dict__["product"] = None
            __props__.__dict__["product_count"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_count"] = None
            __props__.__dict__["tenancy_name"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(FleetResource, __self__).__init__(
            'oci:FleetAppsManagement/fleetResource:FleetResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compliance_state: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            environment_type: Optional[pulumi.Input[_builtins.str]] = None,
            fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            percent_compliant: Optional[pulumi.Input[_builtins.float]] = None,
            product: Optional[pulumi.Input[_builtins.str]] = None,
            product_count: Optional[pulumi.Input[_builtins.int]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_count: Optional[pulumi.Input[_builtins.int]] = None,
            tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenancy_name: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'FleetResource':
        """
        Get an existing FleetResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment: Resource Compartment name.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) OCID of the compartment to which the resource belongs to.
        :param pulumi.Input[_builtins.str] compliance_state: Compliance State of the Resource.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[_builtins.str] environment_type: Environment Type associated with the Fleet when the resource type is fleet. Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        :param pulumi.Input[_builtins.str] fleet_id: Unique Fleet identifier.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.float] percent_compliant: The compliance percentage.
        :param pulumi.Input[_builtins.str] product: Product associated with the resource when the resource type is fleet. Will only be returned for PRODUCT fleets that are part of a GROUP Fleet.
        :param pulumi.Input[_builtins.int] product_count: Count of products within the resource.
        :param pulumi.Input[_builtins.str] resource_id: The OCID of the resource.
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[_builtins.str] resource_type: Type of the Resource.
        :param pulumi.Input[_builtins.str] state: The current state of the FleetResource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.int] target_count: Count of targets within the resource.
        :param pulumi.Input[_builtins.str] tenancy_id: (Updatable) OCID of the tenancy to which the resource belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] tenancy_name: Resource Tenancy Name.
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetResourceState.__new__(_FleetResourceState)

        __props__.__dict__["compartment"] = compartment
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compliance_state"] = compliance_state
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment_type"] = environment_type
        __props__.__dict__["fleet_id"] = fleet_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["percent_compliant"] = percent_compliant
        __props__.__dict__["product"] = product
        __props__.__dict__["product_count"] = product_count
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_region"] = resource_region
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_count"] = target_count
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["tenancy_name"] = tenancy_name
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return FleetResource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def compartment(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Compartment name.
        """
        return pulumi.get(self, "compartment")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) OCID of the compartment to which the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> pulumi.Output[_builtins.str]:
        """
        Compliance State of the Resource.
        """
        return pulumi.get(self, "compliance_state")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Environment Type associated with the Fleet when the resource type is fleet. Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "environment_type")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique Fleet identifier.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="percentCompliant")
    def percent_compliant(self) -> pulumi.Output[_builtins.float]:
        """
        The compliance percentage.
        """
        return pulumi.get(self, "percent_compliant")

    @_builtins.property
    @pulumi.getter
    def product(self) -> pulumi.Output[_builtins.str]:
        """
        Product associated with the resource when the resource type is fleet. Will only be returned for PRODUCT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter(name="productCount")
    def product_count(self) -> pulumi.Output[_builtins.int]:
        """
        Count of products within the resource.
        """
        return pulumi.get(self, "product_count")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> pulumi.Output[_builtins.str]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the Resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the FleetResource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> pulumi.Output[_builtins.int]:
        """
        Count of targets within the resource.
        """
        return pulumi.get(self, "target_count")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) OCID of the tenancy to which the resource belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Tenancy Name.
        """
        return pulumi.get(self, "tenancy_name")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

