# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCatalogItemResult',
    'AwaitableGetCatalogItemResult',
    'get_catalog_item',
    'get_catalog_item_output',
]

@pulumi.output_type
class GetCatalogItemResult:
    """
    A collection of values returned by getCatalogItem.
    """
    def __init__(__self__, catalog_item_id=None, catalog_result_payloads=None, catalog_source_payloads=None, clone_catalog_item_trigger=None, compartment_id=None, config_source_type=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, listing_id=None, listing_version=None, package_type=None, short_description=None, should_list_public_items=None, state=None, system_tags=None, time_backfill_last_checked=None, time_created=None, time_last_checked=None, time_released=None, time_updated=None, version_description=None):
        if catalog_item_id and not isinstance(catalog_item_id, str):
            raise TypeError("Expected argument 'catalog_item_id' to be a str")
        pulumi.set(__self__, "catalog_item_id", catalog_item_id)
        if catalog_result_payloads and not isinstance(catalog_result_payloads, list):
            raise TypeError("Expected argument 'catalog_result_payloads' to be a list")
        pulumi.set(__self__, "catalog_result_payloads", catalog_result_payloads)
        if catalog_source_payloads and not isinstance(catalog_source_payloads, list):
            raise TypeError("Expected argument 'catalog_source_payloads' to be a list")
        pulumi.set(__self__, "catalog_source_payloads", catalog_source_payloads)
        if clone_catalog_item_trigger and not isinstance(clone_catalog_item_trigger, int):
            raise TypeError("Expected argument 'clone_catalog_item_trigger' to be a int")
        pulumi.set(__self__, "clone_catalog_item_trigger", clone_catalog_item_trigger)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_source_type and not isinstance(config_source_type, str):
            raise TypeError("Expected argument 'config_source_type' to be a str")
        pulumi.set(__self__, "config_source_type", config_source_type)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listing_id and not isinstance(listing_id, str):
            raise TypeError("Expected argument 'listing_id' to be a str")
        pulumi.set(__self__, "listing_id", listing_id)
        if listing_version and not isinstance(listing_version, str):
            raise TypeError("Expected argument 'listing_version' to be a str")
        pulumi.set(__self__, "listing_version", listing_version)
        if package_type and not isinstance(package_type, str):
            raise TypeError("Expected argument 'package_type' to be a str")
        pulumi.set(__self__, "package_type", package_type)
        if short_description and not isinstance(short_description, str):
            raise TypeError("Expected argument 'short_description' to be a str")
        pulumi.set(__self__, "short_description", short_description)
        if should_list_public_items and not isinstance(should_list_public_items, bool):
            raise TypeError("Expected argument 'should_list_public_items' to be a bool")
        pulumi.set(__self__, "should_list_public_items", should_list_public_items)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_backfill_last_checked and not isinstance(time_backfill_last_checked, str):
            raise TypeError("Expected argument 'time_backfill_last_checked' to be a str")
        pulumi.set(__self__, "time_backfill_last_checked", time_backfill_last_checked)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_checked and not isinstance(time_last_checked, str):
            raise TypeError("Expected argument 'time_last_checked' to be a str")
        pulumi.set(__self__, "time_last_checked", time_last_checked)
        if time_released and not isinstance(time_released, str):
            raise TypeError("Expected argument 'time_released' to be a str")
        pulumi.set(__self__, "time_released", time_released)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version_description and not isinstance(version_description, str):
            raise TypeError("Expected argument 'version_description' to be a str")
        pulumi.set(__self__, "version_description", version_description)

    @_builtins.property
    @pulumi.getter(name="catalogItemId")
    def catalog_item_id(self) -> _builtins.str:
        return pulumi.get(self, "catalog_item_id")

    @_builtins.property
    @pulumi.getter(name="catalogResultPayloads")
    def catalog_result_payloads(self) -> Sequence['outputs.GetCatalogItemCatalogResultPayloadResult']:
        """
        Catalog result payload.
        """
        return pulumi.get(self, "catalog_result_payloads")

    @_builtins.property
    @pulumi.getter(name="catalogSourcePayloads")
    def catalog_source_payloads(self) -> Sequence['outputs.GetCatalogItemCatalogSourcePayloadResult']:
        """
        Catalog source payload.
        """
        return pulumi.get(self, "catalog_source_payloads")

    @_builtins.property
    @pulumi.getter(name="cloneCatalogItemTrigger")
    def clone_catalog_item_trigger(self) -> _builtins.int:
        return pulumi.get(self, "clone_catalog_item_trigger")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configSourceType")
    def config_source_type(self) -> _builtins.str:
        """
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        """
        return pulumi.get(self, "config_source_type")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description about the catalog item.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the catalog.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        The details of lifecycle state CatalogItem.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> _builtins.str:
        """
        The catalog listing Id.
        """
        return pulumi.get(self, "listing_id")

    @_builtins.property
    @pulumi.getter(name="listingVersion")
    def listing_version(self) -> _builtins.str:
        """
        The catalog package version.
        """
        return pulumi.get(self, "listing_version")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> _builtins.str:
        """
        Short description about the catalog item.
        """
        return pulumi.get(self, "short_description")

    @_builtins.property
    @pulumi.getter(name="shouldListPublicItems")
    def should_list_public_items(self) -> _builtins.bool:
        """
        The indicator to append Public Items from the root compartment to any query, when set to TRUE.
        """
        return pulumi.get(self, "should_list_public_items")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the CatalogItem.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeBackfillLastChecked")
    def time_backfill_last_checked(self) -> _builtins.str:
        """
        The date and time the CatalogItem was last checked by backfill job, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_backfill_last_checked")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the CatalogItem was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastChecked")
    def time_last_checked(self) -> _builtins.str:
        """
        The date and time the CatalogItem was last checked, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_last_checked")

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> _builtins.str:
        """
        The date and time the CatalogItem was released, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_released")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the CatalogItem was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> _builtins.str:
        """
        Version description about the catalog item.
        """
        return pulumi.get(self, "version_description")


class AwaitableGetCatalogItemResult(GetCatalogItemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogItemResult(
            catalog_item_id=self.catalog_item_id,
            catalog_result_payloads=self.catalog_result_payloads,
            catalog_source_payloads=self.catalog_source_payloads,
            clone_catalog_item_trigger=self.clone_catalog_item_trigger,
            compartment_id=self.compartment_id,
            config_source_type=self.config_source_type,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            listing_id=self.listing_id,
            listing_version=self.listing_version,
            package_type=self.package_type,
            short_description=self.short_description,
            should_list_public_items=self.should_list_public_items,
            state=self.state,
            system_tags=self.system_tags,
            time_backfill_last_checked=self.time_backfill_last_checked,
            time_created=self.time_created,
            time_last_checked=self.time_last_checked,
            time_released=self.time_released,
            time_updated=self.time_updated,
            version_description=self.version_description)


def get_catalog_item(catalog_item_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogItemResult:
    """
    This data source provides details about a specific Catalog Item resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets information about a CatalogItem.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_item = oci.FleetAppsManagement.get_catalog_item(catalog_item_id=test_catalog_item_oci_fleet_apps_management_catalog_item["id"])
    ```


    :param _builtins.str catalog_item_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CatalogItem.
    """
    __args__ = dict()
    __args__['catalogItemId'] = catalog_item_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getCatalogItem:getCatalogItem', __args__, opts=opts, typ=GetCatalogItemResult).value

    return AwaitableGetCatalogItemResult(
        catalog_item_id=pulumi.get(__ret__, 'catalog_item_id'),
        catalog_result_payloads=pulumi.get(__ret__, 'catalog_result_payloads'),
        catalog_source_payloads=pulumi.get(__ret__, 'catalog_source_payloads'),
        clone_catalog_item_trigger=pulumi.get(__ret__, 'clone_catalog_item_trigger'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_source_type=pulumi.get(__ret__, 'config_source_type'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        listing_id=pulumi.get(__ret__, 'listing_id'),
        listing_version=pulumi.get(__ret__, 'listing_version'),
        package_type=pulumi.get(__ret__, 'package_type'),
        short_description=pulumi.get(__ret__, 'short_description'),
        should_list_public_items=pulumi.get(__ret__, 'should_list_public_items'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_backfill_last_checked=pulumi.get(__ret__, 'time_backfill_last_checked'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_checked=pulumi.get(__ret__, 'time_last_checked'),
        time_released=pulumi.get(__ret__, 'time_released'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version_description=pulumi.get(__ret__, 'version_description'))
def get_catalog_item_output(catalog_item_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCatalogItemResult]:
    """
    This data source provides details about a specific Catalog Item resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets information about a CatalogItem.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_item = oci.FleetAppsManagement.get_catalog_item(catalog_item_id=test_catalog_item_oci_fleet_apps_management_catalog_item["id"])
    ```


    :param _builtins.str catalog_item_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CatalogItem.
    """
    __args__ = dict()
    __args__['catalogItemId'] = catalog_item_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getCatalogItem:getCatalogItem', __args__, opts=opts, typ=GetCatalogItemResult)
    return __ret__.apply(lambda __response__: GetCatalogItemResult(
        catalog_item_id=pulumi.get(__response__, 'catalog_item_id'),
        catalog_result_payloads=pulumi.get(__response__, 'catalog_result_payloads'),
        catalog_source_payloads=pulumi.get(__response__, 'catalog_source_payloads'),
        clone_catalog_item_trigger=pulumi.get(__response__, 'clone_catalog_item_trigger'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        config_source_type=pulumi.get(__response__, 'config_source_type'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        listing_id=pulumi.get(__response__, 'listing_id'),
        listing_version=pulumi.get(__response__, 'listing_version'),
        package_type=pulumi.get(__response__, 'package_type'),
        short_description=pulumi.get(__response__, 'short_description'),
        should_list_public_items=pulumi.get(__response__, 'should_list_public_items'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_backfill_last_checked=pulumi.get(__response__, 'time_backfill_last_checked'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_checked=pulumi.get(__response__, 'time_last_checked'),
        time_released=pulumi.get(__response__, 'time_released'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        version_description=pulumi.get(__response__, 'version_description')))
