# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCatalogItemsResult',
    'AwaitableGetCatalogItemsResult',
    'get_catalog_items',
    'get_catalog_items_output',
]

@pulumi.output_type
class GetCatalogItemsResult:
    """
    A collection of values returned by getCatalogItems.
    """
    def __init__(__self__, catalog_item_collections=None, catalog_listing_id=None, catalog_listing_version_criteria=None, compartment_id=None, config_source_type=None, display_name=None, filters=None, id=None, package_type=None, should_list_public_items=None, state=None):
        if catalog_item_collections and not isinstance(catalog_item_collections, list):
            raise TypeError("Expected argument 'catalog_item_collections' to be a list")
        pulumi.set(__self__, "catalog_item_collections", catalog_item_collections)
        if catalog_listing_id and not isinstance(catalog_listing_id, str):
            raise TypeError("Expected argument 'catalog_listing_id' to be a str")
        pulumi.set(__self__, "catalog_listing_id", catalog_listing_id)
        if catalog_listing_version_criteria and not isinstance(catalog_listing_version_criteria, str):
            raise TypeError("Expected argument 'catalog_listing_version_criteria' to be a str")
        pulumi.set(__self__, "catalog_listing_version_criteria", catalog_listing_version_criteria)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_source_type and not isinstance(config_source_type, str):
            raise TypeError("Expected argument 'config_source_type' to be a str")
        pulumi.set(__self__, "config_source_type", config_source_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if package_type and not isinstance(package_type, str):
            raise TypeError("Expected argument 'package_type' to be a str")
        pulumi.set(__self__, "package_type", package_type)
        if should_list_public_items and not isinstance(should_list_public_items, bool):
            raise TypeError("Expected argument 'should_list_public_items' to be a bool")
        pulumi.set(__self__, "should_list_public_items", should_list_public_items)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="catalogItemCollections")
    def catalog_item_collections(self) -> Sequence['outputs.GetCatalogItemsCatalogItemCollectionResult']:
        """
        The list of catalog_item_collection.
        """
        return pulumi.get(self, "catalog_item_collections")

    @_builtins.property
    @pulumi.getter(name="catalogListingId")
    def catalog_listing_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "catalog_listing_id")

    @_builtins.property
    @pulumi.getter(name="catalogListingVersionCriteria")
    def catalog_listing_version_criteria(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "catalog_listing_version_criteria")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configSourceType")
    def config_source_type(self) -> Optional[_builtins.str]:
        """
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        """
        return pulumi.get(self, "config_source_type")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCatalogItemsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[_builtins.str]:
        """
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="shouldListPublicItems")
    def should_list_public_items(self) -> Optional[_builtins.bool]:
        """
        The indicator to append Public Items from the root compartment to any query, when set to TRUE.
        """
        return pulumi.get(self, "should_list_public_items")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the CatalogItem.
        """
        return pulumi.get(self, "state")


class AwaitableGetCatalogItemsResult(GetCatalogItemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogItemsResult(
            catalog_item_collections=self.catalog_item_collections,
            catalog_listing_id=self.catalog_listing_id,
            catalog_listing_version_criteria=self.catalog_listing_version_criteria,
            compartment_id=self.compartment_id,
            config_source_type=self.config_source_type,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            package_type=self.package_type,
            should_list_public_items=self.should_list_public_items,
            state=self.state)


def get_catalog_items(catalog_listing_id: Optional[_builtins.str] = None,
                      catalog_listing_version_criteria: Optional[_builtins.str] = None,
                      compartment_id: Optional[_builtins.str] = None,
                      config_source_type: Optional[_builtins.str] = None,
                      display_name: Optional[_builtins.str] = None,
                      filters: Optional[Sequence[Union['GetCatalogItemsFilterArgs', 'GetCatalogItemsFilterArgsDict']]] = None,
                      package_type: Optional[_builtins.str] = None,
                      should_list_public_items: Optional[_builtins.bool] = None,
                      state: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogItemsResult:
    """
    This data source provides the list of Catalog Items in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of Catalog Items in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_items = oci.FleetAppsManagement.get_catalog_items(compartment_id=compartment_id,
        catalog_listing_id=test_listing["id"],
        catalog_listing_version_criteria=catalog_item_catalog_listing_version_criteria,
        config_source_type=catalog_item_config_source_type,
        display_name=catalog_item_display_name,
        package_type=catalog_item_package_type,
        should_list_public_items=catalog_item_should_list_public_items,
        state=catalog_item_state)
    ```


    :param _builtins.str catalog_listing_id: catalogListingId of the package. This is an integer whose min and max length are specified.
    :param _builtins.str catalog_listing_version_criteria: Parameter to list all catalog items only with latest version or list all catalog items with all versions.
    :param _builtins.str compartment_id: (Updatable) The ID of the compartment in which to list resources.
    :param _builtins.str config_source_type: The [ConfigSourceType](https://www.terraform.io/definitions/CatalogItem/configSourceType) Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, URL_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str package_type: A filter to return only resources that match the given package type. The state value is case-insensitive.
    :param _builtins.bool should_list_public_items: The indicator to append Public Items from the root compartment to any query, when set to TRUE.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['catalogListingId'] = catalog_listing_id
    __args__['catalogListingVersionCriteria'] = catalog_listing_version_criteria
    __args__['compartmentId'] = compartment_id
    __args__['configSourceType'] = config_source_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['packageType'] = package_type
    __args__['shouldListPublicItems'] = should_list_public_items
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getCatalogItems:getCatalogItems', __args__, opts=opts, typ=GetCatalogItemsResult).value

    return AwaitableGetCatalogItemsResult(
        catalog_item_collections=pulumi.get(__ret__, 'catalog_item_collections'),
        catalog_listing_id=pulumi.get(__ret__, 'catalog_listing_id'),
        catalog_listing_version_criteria=pulumi.get(__ret__, 'catalog_listing_version_criteria'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_source_type=pulumi.get(__ret__, 'config_source_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        package_type=pulumi.get(__ret__, 'package_type'),
        should_list_public_items=pulumi.get(__ret__, 'should_list_public_items'),
        state=pulumi.get(__ret__, 'state'))
def get_catalog_items_output(catalog_listing_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             catalog_listing_version_criteria: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                             config_source_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCatalogItemsFilterArgs', 'GetCatalogItemsFilterArgsDict']]]]] = None,
                             package_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             should_list_public_items: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCatalogItemsResult]:
    """
    This data source provides the list of Catalog Items in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of Catalog Items in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_items = oci.FleetAppsManagement.get_catalog_items(compartment_id=compartment_id,
        catalog_listing_id=test_listing["id"],
        catalog_listing_version_criteria=catalog_item_catalog_listing_version_criteria,
        config_source_type=catalog_item_config_source_type,
        display_name=catalog_item_display_name,
        package_type=catalog_item_package_type,
        should_list_public_items=catalog_item_should_list_public_items,
        state=catalog_item_state)
    ```


    :param _builtins.str catalog_listing_id: catalogListingId of the package. This is an integer whose min and max length are specified.
    :param _builtins.str catalog_listing_version_criteria: Parameter to list all catalog items only with latest version or list all catalog items with all versions.
    :param _builtins.str compartment_id: (Updatable) The ID of the compartment in which to list resources.
    :param _builtins.str config_source_type: The [ConfigSourceType](https://www.terraform.io/definitions/CatalogItem/configSourceType) Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, URL_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str package_type: A filter to return only resources that match the given package type. The state value is case-insensitive.
    :param _builtins.bool should_list_public_items: The indicator to append Public Items from the root compartment to any query, when set to TRUE.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['catalogListingId'] = catalog_listing_id
    __args__['catalogListingVersionCriteria'] = catalog_listing_version_criteria
    __args__['compartmentId'] = compartment_id
    __args__['configSourceType'] = config_source_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['packageType'] = package_type
    __args__['shouldListPublicItems'] = should_list_public_items
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getCatalogItems:getCatalogItems', __args__, opts=opts, typ=GetCatalogItemsResult)
    return __ret__.apply(lambda __response__: GetCatalogItemsResult(
        catalog_item_collections=pulumi.get(__response__, 'catalog_item_collections'),
        catalog_listing_id=pulumi.get(__response__, 'catalog_listing_id'),
        catalog_listing_version_criteria=pulumi.get(__response__, 'catalog_listing_version_criteria'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        config_source_type=pulumi.get(__response__, 'config_source_type'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        package_type=pulumi.get(__response__, 'package_type'),
        should_list_public_items=pulumi.get(__response__, 'should_list_public_items'),
        state=pulumi.get(__response__, 'state')))
