# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFleetComplianceResult',
    'AwaitableGetFleetComplianceResult',
    'get_fleet_compliance',
    'get_fleet_compliance_output',
]

@pulumi.output_type
class GetFleetComplianceResult:
    """
    A collection of values returned by getFleetCompliance.
    """
    def __init__(__self__, compliance_state=None, confirmed_target_count=None, fleet_id=None, id=None, non_compliant_target_count=None):
        if compliance_state and not isinstance(compliance_state, str):
            raise TypeError("Expected argument 'compliance_state' to be a str")
        pulumi.set(__self__, "compliance_state", compliance_state)
        if confirmed_target_count and not isinstance(confirmed_target_count, int):
            raise TypeError("Expected argument 'confirmed_target_count' to be a int")
        pulumi.set(__self__, "confirmed_target_count", confirmed_target_count)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if non_compliant_target_count and not isinstance(non_compliant_target_count, int):
            raise TypeError("Expected argument 'non_compliant_target_count' to be a int")
        pulumi.set(__self__, "non_compliant_target_count", non_compliant_target_count)

    @_builtins.property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> _builtins.str:
        """
        Compliance State.
        """
        return pulumi.get(self, "compliance_state")

    @_builtins.property
    @pulumi.getter(name="confirmedTargetCount")
    def confirmed_target_count(self) -> _builtins.int:
        """
        Confirmed Target Count.
        """
        return pulumi.get(self, "confirmed_target_count")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nonCompliantTargetCount")
    def non_compliant_target_count(self) -> _builtins.int:
        """
        Non Compliant Target Count.
        """
        return pulumi.get(self, "non_compliant_target_count")


class AwaitableGetFleetComplianceResult(GetFleetComplianceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetComplianceResult(
            compliance_state=self.compliance_state,
            confirmed_target_count=self.confirmed_target_count,
            fleet_id=self.fleet_id,
            id=self.id,
            non_compliant_target_count=self.non_compliant_target_count)


def get_fleet_compliance(fleet_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetComplianceResult:
    """
    This data source provides details about a specific Fleet Compliance resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Retrieve compliance for a fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_compliance = oci.FleetAppsManagement.get_fleet_compliance(fleet_id=test_fleet["id"])
    ```


    :param _builtins.str fleet_id: Unique Fleet identifier.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetCompliance:getFleetCompliance', __args__, opts=opts, typ=GetFleetComplianceResult).value

    return AwaitableGetFleetComplianceResult(
        compliance_state=pulumi.get(__ret__, 'compliance_state'),
        confirmed_target_count=pulumi.get(__ret__, 'confirmed_target_count'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        non_compliant_target_count=pulumi.get(__ret__, 'non_compliant_target_count'))
def get_fleet_compliance_output(fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetComplianceResult]:
    """
    This data source provides details about a specific Fleet Compliance resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Retrieve compliance for a fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_compliance = oci.FleetAppsManagement.get_fleet_compliance(fleet_id=test_fleet["id"])
    ```


    :param _builtins.str fleet_id: Unique Fleet identifier.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetCompliance:getFleetCompliance', __args__, opts=opts, typ=GetFleetComplianceResult)
    return __ret__.apply(lambda __response__: GetFleetComplianceResult(
        compliance_state=pulumi.get(__response__, 'compliance_state'),
        confirmed_target_count=pulumi.get(__response__, 'confirmed_target_count'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        non_compliant_target_count=pulumi.get(__response__, 'non_compliant_target_count')))
