# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstalledPatchesResult',
    'AwaitableGetInstalledPatchesResult',
    'get_installed_patches',
    'get_installed_patches_output',
]

@pulumi.output_type
class GetInstalledPatchesResult:
    """
    A collection of values returned by getInstalledPatches.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, installed_patch_collections=None, patch_level=None, patch_type=None, severity=None, target_id=None, target_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if installed_patch_collections and not isinstance(installed_patch_collections, list):
            raise TypeError("Expected argument 'installed_patch_collections' to be a list")
        pulumi.set(__self__, "installed_patch_collections", installed_patch_collections)
        if patch_level and not isinstance(patch_level, str):
            raise TypeError("Expected argument 'patch_level' to be a str")
        pulumi.set(__self__, "patch_level", patch_level)
        if patch_type and not isinstance(patch_type, str):
            raise TypeError("Expected argument 'patch_type' to be a str")
        pulumi.set(__self__, "patch_type", patch_type)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if target_name and not isinstance(target_name, str):
            raise TypeError("Expected argument 'target_name' to be a str")
        pulumi.set(__self__, "target_name", target_name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstalledPatchesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="installedPatchCollections")
    def installed_patch_collections(self) -> Sequence['outputs.GetInstalledPatchesInstalledPatchCollectionResult']:
        """
        The list of installed_patch_collection.
        """
        return pulumi.get(self, "installed_patch_collections")

    @_builtins.property
    @pulumi.getter(name="patchLevel")
    def patch_level(self) -> Optional[_builtins.str]:
        """
        Patch level.
        """
        return pulumi.get(self, "patch_level")

    @_builtins.property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> Optional[_builtins.str]:
        """
        Type of the patch.
        """
        return pulumi.get(self, "patch_type")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        """
        Patch severity.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_name")


class AwaitableGetInstalledPatchesResult(GetInstalledPatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstalledPatchesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            installed_patch_collections=self.installed_patch_collections,
            patch_level=self.patch_level,
            patch_type=self.patch_type,
            severity=self.severity,
            target_id=self.target_id,
            target_name=self.target_name)


def get_installed_patches(compartment_id: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetInstalledPatchesFilterArgs', 'GetInstalledPatchesFilterArgsDict']]] = None,
                          patch_level: Optional[_builtins.str] = None,
                          patch_type: Optional[_builtins.str] = None,
                          severity: Optional[_builtins.str] = None,
                          target_id: Optional[_builtins.str] = None,
                          target_name: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstalledPatchesResult:
    """
    This data source provides the list of Installed Patches in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of installed patches for the specified target.
    CompartmentId should be the compartment OCID of the resource (Containing the target).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_installed_patches = oci.FleetAppsManagement.get_installed_patches(compartment_id=compartment_id,
        target_id=fleet_target_id,
        target_name=fleet_target_name,
        patch_level=installed_patch_patch_level,
        patch_type=installed_patch_patch_type,
        severity=installed_patch_severity)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param _builtins.str patch_level: Patch level with values like LATEST, LATEST_MINUS_ONE, LATEST_MIUS_TWO etc.,.
    :param _builtins.str patch_type: Patch type.
    :param _builtins.str severity: Patch severity with values like CRITICAL, HIGH, MEDIUM and LOW.
    :param _builtins.str target_id: Target identifier.
    :param _builtins.str target_name: Target name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['patchLevel'] = patch_level
    __args__['patchType'] = patch_type
    __args__['severity'] = severity
    __args__['targetId'] = target_id
    __args__['targetName'] = target_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getInstalledPatches:getInstalledPatches', __args__, opts=opts, typ=GetInstalledPatchesResult).value

    return AwaitableGetInstalledPatchesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        installed_patch_collections=pulumi.get(__ret__, 'installed_patch_collections'),
        patch_level=pulumi.get(__ret__, 'patch_level'),
        patch_type=pulumi.get(__ret__, 'patch_type'),
        severity=pulumi.get(__ret__, 'severity'),
        target_id=pulumi.get(__ret__, 'target_id'),
        target_name=pulumi.get(__ret__, 'target_name'))
def get_installed_patches_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstalledPatchesFilterArgs', 'GetInstalledPatchesFilterArgsDict']]]]] = None,
                                 patch_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 patch_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 severity: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 target_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 target_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstalledPatchesResult]:
    """
    This data source provides the list of Installed Patches in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of installed patches for the specified target.
    CompartmentId should be the compartment OCID of the resource (Containing the target).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_installed_patches = oci.FleetAppsManagement.get_installed_patches(compartment_id=compartment_id,
        target_id=fleet_target_id,
        target_name=fleet_target_name,
        patch_level=installed_patch_patch_level,
        patch_type=installed_patch_patch_type,
        severity=installed_patch_severity)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param _builtins.str patch_level: Patch level with values like LATEST, LATEST_MINUS_ONE, LATEST_MIUS_TWO etc.,.
    :param _builtins.str patch_type: Patch type.
    :param _builtins.str severity: Patch severity with values like CRITICAL, HIGH, MEDIUM and LOW.
    :param _builtins.str target_id: Target identifier.
    :param _builtins.str target_name: Target name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['patchLevel'] = patch_level
    __args__['patchType'] = patch_type
    __args__['severity'] = severity
    __args__['targetId'] = target_id
    __args__['targetName'] = target_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getInstalledPatches:getInstalledPatches', __args__, opts=opts, typ=GetInstalledPatchesResult)
    return __ret__.apply(lambda __response__: GetInstalledPatchesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        installed_patch_collections=pulumi.get(__response__, 'installed_patch_collections'),
        patch_level=pulumi.get(__response__, 'patch_level'),
        patch_type=pulumi.get(__response__, 'patch_type'),
        severity=pulumi.get(__response__, 'severity'),
        target_id=pulumi.get(__response__, 'target_id'),
        target_name=pulumi.get(__response__, 'target_name')))
