# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInventoryRecordsResult',
    'AwaitableGetInventoryRecordsResult',
    'get_inventory_records',
    'get_inventory_records_output',
]

@pulumi.output_type
class GetInventoryRecordsResult:
    """
    A collection of values returned by getInventoryRecords.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, fleet_id=None, id=None, inventory_record_collections=None, is_details_required=None, resource_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inventory_record_collections and not isinstance(inventory_record_collections, list):
            raise TypeError("Expected argument 'inventory_record_collections' to be a list")
        pulumi.set(__self__, "inventory_record_collections", inventory_record_collections)
        if is_details_required and not isinstance(is_details_required, bool):
            raise TypeError("Expected argument 'is_details_required' to be a bool")
        pulumi.set(__self__, "is_details_required", is_details_required)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        OCID of the compartment to which the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInventoryRecordsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inventoryRecordCollections")
    def inventory_record_collections(self) -> Sequence['outputs.GetInventoryRecordsInventoryRecordCollectionResult']:
        """
        The list of inventory_record_collection.
        """
        return pulumi.get(self, "inventory_record_collections")

    @_builtins.property
    @pulumi.getter(name="isDetailsRequired")
    def is_details_required(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_details_required")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_id")


class AwaitableGetInventoryRecordsResult(GetInventoryRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInventoryRecordsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            inventory_record_collections=self.inventory_record_collections,
            is_details_required=self.is_details_required,
            resource_id=self.resource_id)


def get_inventory_records(compartment_id: Optional[_builtins.str] = None,
                          compartment_id_in_subtree: Optional[_builtins.bool] = None,
                          filters: Optional[Sequence[Union['GetInventoryRecordsFilterArgs', 'GetInventoryRecordsFilterArgsDict']]] = None,
                          fleet_id: Optional[_builtins.str] = None,
                          is_details_required: Optional[_builtins.bool] = None,
                          resource_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInventoryRecordsResult:
    """
    This data source provides the list of Inventory Records in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of inventoryDetails.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_inventory_records = oci.FleetAppsManagement.get_inventory_records(compartment_id=compartment_id,
        compartment_id_in_subtree=inventory_record_compartment_id_in_subtree,
        fleet_id=test_fleet["id"],
        is_details_required=inventory_record_is_details_required,
        resource_id=test_resource["id"])
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.bool compartment_id_in_subtree: If set to true, resources will be returned for not only the provided compartment, but all compartments which descend from it. Which resources are returned and their field contents depends on the value of accessLevel.
    :param _builtins.str fleet_id: unique Fleet identifier
    :param _builtins.bool is_details_required: If set to true, inventory details will be returned.
    :param _builtins.str resource_id: Resource Identifier
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['isDetailsRequired'] = is_details_required
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getInventoryRecords:getInventoryRecords', __args__, opts=opts, typ=GetInventoryRecordsResult).value

    return AwaitableGetInventoryRecordsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        inventory_record_collections=pulumi.get(__ret__, 'inventory_record_collections'),
        is_details_required=pulumi.get(__ret__, 'is_details_required'),
        resource_id=pulumi.get(__ret__, 'resource_id'))
def get_inventory_records_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInventoryRecordsFilterArgs', 'GetInventoryRecordsFilterArgsDict']]]]] = None,
                                 fleet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 is_details_required: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInventoryRecordsResult]:
    """
    This data source provides the list of Inventory Records in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of inventoryDetails.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_inventory_records = oci.FleetAppsManagement.get_inventory_records(compartment_id=compartment_id,
        compartment_id_in_subtree=inventory_record_compartment_id_in_subtree,
        fleet_id=test_fleet["id"],
        is_details_required=inventory_record_is_details_required,
        resource_id=test_resource["id"])
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.bool compartment_id_in_subtree: If set to true, resources will be returned for not only the provided compartment, but all compartments which descend from it. Which resources are returned and their field contents depends on the value of accessLevel.
    :param _builtins.str fleet_id: unique Fleet identifier
    :param _builtins.bool is_details_required: If set to true, inventory details will be returned.
    :param _builtins.str resource_id: Resource Identifier
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['isDetailsRequired'] = is_details_required
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getInventoryRecords:getInventoryRecords', __args__, opts=opts, typ=GetInventoryRecordsResult)
    return __ret__.apply(lambda __response__: GetInventoryRecordsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        inventory_record_collections=pulumi.get(__response__, 'inventory_record_collections'),
        is_details_required=pulumi.get(__response__, 'is_details_required'),
        resource_id=pulumi.get(__response__, 'resource_id')))
