# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRunbookExportResult',
    'AwaitableGetRunbookExportResult',
    'get_runbook_export',
    'get_runbook_export_output',
]

@pulumi.output_type
class GetRunbookExportResult:
    """
    A collection of values returned by getRunbookExport.
    """
    def __init__(__self__, details=None, export_id=None, id=None, runbook_id=None, runbook_name=None, runbook_version=None, status=None, tracking_id=None):
        if details and not isinstance(details, dict):
            raise TypeError("Expected argument 'details' to be a dict")
        pulumi.set(__self__, "details", details)
        if export_id and not isinstance(export_id, str):
            raise TypeError("Expected argument 'export_id' to be a str")
        pulumi.set(__self__, "export_id", export_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if runbook_id and not isinstance(runbook_id, str):
            raise TypeError("Expected argument 'runbook_id' to be a str")
        pulumi.set(__self__, "runbook_id", runbook_id)
        if runbook_name and not isinstance(runbook_name, str):
            raise TypeError("Expected argument 'runbook_name' to be a str")
        pulumi.set(__self__, "runbook_name", runbook_name)
        if runbook_version and not isinstance(runbook_version, str):
            raise TypeError("Expected argument 'runbook_version' to be a str")
        pulumi.set(__self__, "runbook_version", runbook_version)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tracking_id and not isinstance(tracking_id, str):
            raise TypeError("Expected argument 'tracking_id' to be a str")
        pulumi.set(__self__, "tracking_id", tracking_id)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Mapping[str, _builtins.str]:
        """
        Map of runbook export details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="exportId")
    def export_id(self) -> _builtins.str:
        return pulumi.get(self, "export_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> _builtins.str:
        """
        The OCID of the runbook.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> _builtins.str:
        """
        Runbook name.
        """
        return pulumi.get(self, "runbook_name")

    @_builtins.property
    @pulumi.getter(name="runbookVersion")
    def runbook_version(self) -> _builtins.str:
        """
        Runbook version.
        """
        return pulumi.get(self, "runbook_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trackingId")
    def tracking_id(self) -> _builtins.str:
        """
        Tracking/Export identifier.
        """
        return pulumi.get(self, "tracking_id")


class AwaitableGetRunbookExportResult(GetRunbookExportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbookExportResult(
            details=self.details,
            export_id=self.export_id,
            id=self.id,
            runbook_id=self.runbook_id,
            runbook_name=self.runbook_name,
            runbook_version=self.runbook_version,
            status=self.status,
            tracking_id=self.tracking_id)


def get_runbook_export(export_id: Optional[_builtins.str] = None,
                       runbook_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbookExportResult:
    """
    This data source provides details about a specific Runbook Export resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the runbook export status for provided runbook and exportId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_export = oci.FleetAppsManagement.get_runbook_export(export_id=runbook_export_id,
        runbook_id=test_runbook["id"])
    ```


    :param _builtins.str export_id: Unique tracking identifier to fetch runbook export status.
    :param _builtins.str runbook_id: Unique Runbook identifier.
    """
    __args__ = dict()
    __args__['exportId'] = export_id
    __args__['runbookId'] = runbook_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getRunbookExport:getRunbookExport', __args__, opts=opts, typ=GetRunbookExportResult).value

    return AwaitableGetRunbookExportResult(
        details=pulumi.get(__ret__, 'details'),
        export_id=pulumi.get(__ret__, 'export_id'),
        id=pulumi.get(__ret__, 'id'),
        runbook_id=pulumi.get(__ret__, 'runbook_id'),
        runbook_name=pulumi.get(__ret__, 'runbook_name'),
        runbook_version=pulumi.get(__ret__, 'runbook_version'),
        status=pulumi.get(__ret__, 'status'),
        tracking_id=pulumi.get(__ret__, 'tracking_id'))
def get_runbook_export_output(export_id: Optional[pulumi.Input[_builtins.str]] = None,
                              runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRunbookExportResult]:
    """
    This data source provides details about a specific Runbook Export resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the runbook export status for provided runbook and exportId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_export = oci.FleetAppsManagement.get_runbook_export(export_id=runbook_export_id,
        runbook_id=test_runbook["id"])
    ```


    :param _builtins.str export_id: Unique tracking identifier to fetch runbook export status.
    :param _builtins.str runbook_id: Unique Runbook identifier.
    """
    __args__ = dict()
    __args__['exportId'] = export_id
    __args__['runbookId'] = runbook_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getRunbookExport:getRunbookExport', __args__, opts=opts, typ=GetRunbookExportResult)
    return __ret__.apply(lambda __response__: GetRunbookExportResult(
        details=pulumi.get(__response__, 'details'),
        export_id=pulumi.get(__response__, 'export_id'),
        id=pulumi.get(__response__, 'id'),
        runbook_id=pulumi.get(__response__, 'runbook_id'),
        runbook_name=pulumi.get(__response__, 'runbook_name'),
        runbook_version=pulumi.get(__response__, 'runbook_version'),
        status=pulumi.get(__response__, 'status'),
        tracking_id=pulumi.get(__response__, 'tracking_id')))
