# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRunbookExportStatusesResult',
    'AwaitableGetRunbookExportStatusesResult',
    'get_runbook_export_statuses',
    'get_runbook_export_statuses_output',
]

@pulumi.output_type
class GetRunbookExportStatusesResult:
    """
    A collection of values returned by getRunbookExportStatuses.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, runbook_export_status_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if runbook_export_status_collections and not isinstance(runbook_export_status_collections, list):
            raise TypeError("Expected argument 'runbook_export_status_collections' to be a list")
        pulumi.set(__self__, "runbook_export_status_collections", runbook_export_status_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRunbookExportStatusesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="runbookExportStatusCollections")
    def runbook_export_status_collections(self) -> Sequence['outputs.GetRunbookExportStatusesRunbookExportStatusCollectionResult']:
        """
        The list of runbook_export_status_collection.
        """
        return pulumi.get(self, "runbook_export_status_collections")


class AwaitableGetRunbookExportStatusesResult(GetRunbookExportStatusesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbookExportStatusesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            runbook_export_status_collections=self.runbook_export_status_collections)


def get_runbook_export_statuses(compartment_id: Optional[_builtins.str] = None,
                                filters: Optional[Sequence[Union['GetRunbookExportStatusesFilterArgs', 'GetRunbookExportStatusesFilterArgsDict']]] = None,
                                id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbookExportStatusesResult:
    """
    This data source provides the list of Runbook Export Statuses in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the Runbook export status in the specified compartment.
    The query parameter `compartmentId` is required.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_export_statuses = oci.FleetAppsManagement.get_runbook_export_statuses(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getRunbookExportStatuses:getRunbookExportStatuses', __args__, opts=opts, typ=GetRunbookExportStatusesResult).value

    return AwaitableGetRunbookExportStatusesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        runbook_export_status_collections=pulumi.get(__ret__, 'runbook_export_status_collections'))
def get_runbook_export_statuses_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRunbookExportStatusesFilterArgs', 'GetRunbookExportStatusesFilterArgsDict']]]]] = None,
                                       id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRunbookExportStatusesResult]:
    """
    This data source provides the list of Runbook Export Statuses in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the Runbook export status in the specified compartment.
    The query parameter `compartmentId` is required.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_export_statuses = oci.FleetAppsManagement.get_runbook_export_statuses(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getRunbookExportStatuses:getRunbookExportStatuses', __args__, opts=opts, typ=GetRunbookExportStatusesResult)
    return __ret__.apply(lambda __response__: GetRunbookExportStatusesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        runbook_export_status_collections=pulumi.get(__response__, 'runbook_export_status_collections')))
