# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRunbookImportResult',
    'AwaitableGetRunbookImportResult',
    'get_runbook_import',
    'get_runbook_import_output',
]

@pulumi.output_type
class GetRunbookImportResult:
    """
    A collection of values returned by getRunbookImport.
    """
    def __init__(__self__, details=None, id=None, import_id=None, runbook_id=None, runbook_name=None, runbook_version=None, status=None, tracking_id=None):
        if details and not isinstance(details, dict):
            raise TypeError("Expected argument 'details' to be a dict")
        pulumi.set(__self__, "details", details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if import_id and not isinstance(import_id, str):
            raise TypeError("Expected argument 'import_id' to be a str")
        pulumi.set(__self__, "import_id", import_id)
        if runbook_id and not isinstance(runbook_id, str):
            raise TypeError("Expected argument 'runbook_id' to be a str")
        pulumi.set(__self__, "runbook_id", runbook_id)
        if runbook_name and not isinstance(runbook_name, str):
            raise TypeError("Expected argument 'runbook_name' to be a str")
        pulumi.set(__self__, "runbook_name", runbook_name)
        if runbook_version and not isinstance(runbook_version, str):
            raise TypeError("Expected argument 'runbook_version' to be a str")
        pulumi.set(__self__, "runbook_version", runbook_version)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tracking_id and not isinstance(tracking_id, str):
            raise TypeError("Expected argument 'tracking_id' to be a str")
        pulumi.set(__self__, "tracking_id", tracking_id)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Mapping[str, _builtins.str]:
        """
        Map of runbook import details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="importId")
    def import_id(self) -> _builtins.str:
        return pulumi.get(self, "import_id")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> _builtins.str:
        """
        The OCID of the runbook.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> _builtins.str:
        """
        Runbook name.
        """
        return pulumi.get(self, "runbook_name")

    @_builtins.property
    @pulumi.getter(name="runbookVersion")
    def runbook_version(self) -> _builtins.str:
        """
        Runbook version.
        """
        return pulumi.get(self, "runbook_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trackingId")
    def tracking_id(self) -> _builtins.str:
        """
        Tracking/Import identifier.
        """
        return pulumi.get(self, "tracking_id")


class AwaitableGetRunbookImportResult(GetRunbookImportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbookImportResult(
            details=self.details,
            id=self.id,
            import_id=self.import_id,
            runbook_id=self.runbook_id,
            runbook_name=self.runbook_name,
            runbook_version=self.runbook_version,
            status=self.status,
            tracking_id=self.tracking_id)


def get_runbook_import(import_id: Optional[_builtins.str] = None,
                       runbook_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbookImportResult:
    """
    This data source provides details about a specific Runbook Import resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the runbook import status for provided runbook and importId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_import = oci.FleetAppsManagement.get_runbook_import(import_id=runbook_import_id,
        runbook_id=test_runbook["id"])
    ```


    :param _builtins.str import_id: Unique tracking identifier to fetch runbook import status.
    :param _builtins.str runbook_id: Unique Runbook identifier.
    """
    __args__ = dict()
    __args__['importId'] = import_id
    __args__['runbookId'] = runbook_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getRunbookImport:getRunbookImport', __args__, opts=opts, typ=GetRunbookImportResult).value

    return AwaitableGetRunbookImportResult(
        details=pulumi.get(__ret__, 'details'),
        id=pulumi.get(__ret__, 'id'),
        import_id=pulumi.get(__ret__, 'import_id'),
        runbook_id=pulumi.get(__ret__, 'runbook_id'),
        runbook_name=pulumi.get(__ret__, 'runbook_name'),
        runbook_version=pulumi.get(__ret__, 'runbook_version'),
        status=pulumi.get(__ret__, 'status'),
        tracking_id=pulumi.get(__ret__, 'tracking_id'))
def get_runbook_import_output(import_id: Optional[pulumi.Input[_builtins.str]] = None,
                              runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRunbookImportResult]:
    """
    This data source provides details about a specific Runbook Import resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the runbook import status for provided runbook and importId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_import = oci.FleetAppsManagement.get_runbook_import(import_id=runbook_import_id,
        runbook_id=test_runbook["id"])
    ```


    :param _builtins.str import_id: Unique tracking identifier to fetch runbook import status.
    :param _builtins.str runbook_id: Unique Runbook identifier.
    """
    __args__ = dict()
    __args__['importId'] = import_id
    __args__['runbookId'] = runbook_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getRunbookImport:getRunbookImport', __args__, opts=opts, typ=GetRunbookImportResult)
    return __ret__.apply(lambda __response__: GetRunbookImportResult(
        details=pulumi.get(__response__, 'details'),
        id=pulumi.get(__response__, 'id'),
        import_id=pulumi.get(__response__, 'import_id'),
        runbook_id=pulumi.get(__response__, 'runbook_id'),
        runbook_name=pulumi.get(__response__, 'runbook_name'),
        runbook_version=pulumi.get(__response__, 'runbook_version'),
        status=pulumi.get(__response__, 'status'),
        tracking_id=pulumi.get(__response__, 'tracking_id')))
