# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRunbookVersionResult',
    'AwaitableGetRunbookVersionResult',
    'get_runbook_version',
    'get_runbook_version_output',
]

@pulumi.output_type
class GetRunbookVersionResult:
    """
    A collection of values returned by getRunbookVersion.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, execution_workflow_details=None, freeform_tags=None, groups=None, id=None, is_latest=None, lifecycle_details=None, name=None, rollback_workflow_details=None, runbook_id=None, runbook_version_id=None, state=None, system_tags=None, tasks=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if execution_workflow_details and not isinstance(execution_workflow_details, list):
            raise TypeError("Expected argument 'execution_workflow_details' to be a list")
        pulumi.set(__self__, "execution_workflow_details", execution_workflow_details)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rollback_workflow_details and not isinstance(rollback_workflow_details, list):
            raise TypeError("Expected argument 'rollback_workflow_details' to be a list")
        pulumi.set(__self__, "rollback_workflow_details", rollback_workflow_details)
        if runbook_id and not isinstance(runbook_id, str):
            raise TypeError("Expected argument 'runbook_id' to be a str")
        pulumi.set(__self__, "runbook_id", runbook_id)
        if runbook_version_id and not isinstance(runbook_version_id, str):
            raise TypeError("Expected argument 'runbook_version_id' to be a str")
        pulumi.set(__self__, "runbook_version_id", runbook_version_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tasks and not isinstance(tasks, list):
            raise TypeError("Expected argument 'tasks' to be a list")
        pulumi.set(__self__, "tasks", tasks)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="executionWorkflowDetails")
    def execution_workflow_details(self) -> Sequence['outputs.GetRunbookVersionExecutionWorkflowDetailResult']:
        """
        Execution Workflow details.
        """
        return pulumi.get(self, "execution_workflow_details")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetRunbookVersionGroupResult']:
        """
        The groups of the runbook.
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> _builtins.bool:
        return pulumi.get(self, "is_latest")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rollbackWorkflowDetails")
    def rollback_workflow_details(self) -> Sequence['outputs.GetRunbookVersionRollbackWorkflowDetailResult']:
        """
        Rollback Workflow details.
        """
        return pulumi.get(self, "rollback_workflow_details")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> _builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="runbookVersionId")
    def runbook_version_id(self) -> _builtins.str:
        return pulumi.get(self, "runbook_version_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the runbook version.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetRunbookVersionTaskResult']:
        """
        A set of tasks to execute in the runbook.
        """
        return pulumi.get(self, "tasks")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetRunbookVersionResult(GetRunbookVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbookVersionResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            execution_workflow_details=self.execution_workflow_details,
            freeform_tags=self.freeform_tags,
            groups=self.groups,
            id=self.id,
            is_latest=self.is_latest,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            rollback_workflow_details=self.rollback_workflow_details,
            runbook_id=self.runbook_id,
            runbook_version_id=self.runbook_version_id,
            state=self.state,
            system_tags=self.system_tags,
            tasks=self.tasks,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_runbook_version(runbook_version_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbookVersionResult:
    """
    This data source provides details about a specific Runbook Version resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a Runbook Version by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_version = oci.FleetAppsManagement.get_runbook_version(runbook_version_id=test_runbook_version_oci_fleet_apps_management_runbook_version["id"])
    ```


    :param _builtins.str runbook_version_id: Unique Runbook Version identifier
    """
    __args__ = dict()
    __args__['runbookVersionId'] = runbook_version_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getRunbookVersion:getRunbookVersion', __args__, opts=opts, typ=GetRunbookVersionResult).value

    return AwaitableGetRunbookVersionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        execution_workflow_details=pulumi.get(__ret__, 'execution_workflow_details'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        rollback_workflow_details=pulumi.get(__ret__, 'rollback_workflow_details'),
        runbook_id=pulumi.get(__ret__, 'runbook_id'),
        runbook_version_id=pulumi.get(__ret__, 'runbook_version_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tasks=pulumi.get(__ret__, 'tasks'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_runbook_version_output(runbook_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRunbookVersionResult]:
    """
    This data source provides details about a specific Runbook Version resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a Runbook Version by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_version = oci.FleetAppsManagement.get_runbook_version(runbook_version_id=test_runbook_version_oci_fleet_apps_management_runbook_version["id"])
    ```


    :param _builtins.str runbook_version_id: Unique Runbook Version identifier
    """
    __args__ = dict()
    __args__['runbookVersionId'] = runbook_version_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getRunbookVersion:getRunbookVersion', __args__, opts=opts, typ=GetRunbookVersionResult)
    return __ret__.apply(lambda __response__: GetRunbookVersionResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        execution_workflow_details=pulumi.get(__response__, 'execution_workflow_details'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        is_latest=pulumi.get(__response__, 'is_latest'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        rollback_workflow_details=pulumi.get(__response__, 'rollback_workflow_details'),
        runbook_id=pulumi.get(__response__, 'runbook_id'),
        runbook_version_id=pulumi.get(__response__, 'runbook_version_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tasks=pulumi.get(__response__, 'tasks'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
