# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRunbookVersionsResult',
    'AwaitableGetRunbookVersionsResult',
    'get_runbook_versions',
    'get_runbook_versions_output',
]

@pulumi.output_type
class GetRunbookVersionsResult:
    """
    A collection of values returned by getRunbookVersions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, is_latest=None, name=None, runbook_id=None, runbook_version_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if runbook_id and not isinstance(runbook_id, str):
            raise TypeError("Expected argument 'runbook_id' to be a str")
        pulumi.set(__self__, "runbook_id", runbook_id)
        if runbook_version_collections and not isinstance(runbook_version_collections, list):
            raise TypeError("Expected argument 'runbook_version_collections' to be a list")
        pulumi.set(__self__, "runbook_version_collections", runbook_version_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRunbookVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> _builtins.bool:
        return pulumi.get(self, "is_latest")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="runbookVersionCollections")
    def runbook_version_collections(self) -> Sequence['outputs.GetRunbookVersionsRunbookVersionCollectionResult']:
        """
        The list of runbook_version_collection.
        """
        return pulumi.get(self, "runbook_version_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the runbook version.
        """
        return pulumi.get(self, "state")


class AwaitableGetRunbookVersionsResult(GetRunbookVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbookVersionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            is_latest=self.is_latest,
            name=self.name,
            runbook_id=self.runbook_id,
            runbook_version_collections=self.runbook_version_collections,
            state=self.state)


def get_runbook_versions(compartment_id: Optional[_builtins.str] = None,
                         filters: Optional[Sequence[Union['GetRunbookVersionsFilterArgs', 'GetRunbookVersionsFilterArgsDict']]] = None,
                         id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         runbook_id: Optional[_builtins.str] = None,
                         state: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbookVersionsResult:
    """
    This data source provides the list of Runbook Versions in Oracle Cloud Infrastructure Fleet Apps Management service.

    List versions for a runbook in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_versions = oci.FleetAppsManagement.get_runbook_versions(compartment_id=compartment_id,
        id=runbook_version_id,
        name=runbook_version_name,
        runbook_id=test_runbook["id"],
        state=runbook_version_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.str id: A filter to return runbook versions whose identifier matches the given identifier.
    :param _builtins.str name: A filter to return only resources that match the entire name given.
    :param _builtins.str runbook_id: A filter to return only schedule definitions whose associated runbookId matches the given runbookId.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['runbookId'] = runbook_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getRunbookVersions:getRunbookVersions', __args__, opts=opts, typ=GetRunbookVersionsResult).value

    return AwaitableGetRunbookVersionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        name=pulumi.get(__ret__, 'name'),
        runbook_id=pulumi.get(__ret__, 'runbook_id'),
        runbook_version_collections=pulumi.get(__ret__, 'runbook_version_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_runbook_versions_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRunbookVersionsFilterArgs', 'GetRunbookVersionsFilterArgsDict']]]]] = None,
                                id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                runbook_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRunbookVersionsResult]:
    """
    This data source provides the list of Runbook Versions in Oracle Cloud Infrastructure Fleet Apps Management service.

    List versions for a runbook in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook_versions = oci.FleetAppsManagement.get_runbook_versions(compartment_id=compartment_id,
        id=runbook_version_id,
        name=runbook_version_name,
        runbook_id=test_runbook["id"],
        state=runbook_version_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.str id: A filter to return runbook versions whose identifier matches the given identifier.
    :param _builtins.str name: A filter to return only resources that match the entire name given.
    :param _builtins.str runbook_id: A filter to return only schedule definitions whose associated runbookId matches the given runbookId.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['runbookId'] = runbook_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getRunbookVersions:getRunbookVersions', __args__, opts=opts, typ=GetRunbookVersionsResult)
    return __ret__.apply(lambda __response__: GetRunbookVersionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_latest=pulumi.get(__response__, 'is_latest'),
        name=pulumi.get(__response__, 'name'),
        runbook_id=pulumi.get(__response__, 'runbook_id'),
        runbook_version_collections=pulumi.get(__response__, 'runbook_version_collections'),
        state=pulumi.get(__response__, 'state')))
