# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTargetPropertiesResult',
    'AwaitableGetTargetPropertiesResult',
    'get_target_properties',
    'get_target_properties_output',
]

@pulumi.output_type
class GetTargetPropertiesResult:
    """
    A collection of values returned by getTargetProperties.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, severity=None, target_id=None, target_name=None, target_property_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if target_name and not isinstance(target_name, str):
            raise TypeError("Expected argument 'target_name' to be a str")
        pulumi.set(__self__, "target_name", target_name)
        if target_property_collections and not isinstance(target_property_collections, list):
            raise TypeError("Expected argument 'target_property_collections' to be a list")
        pulumi.set(__self__, "target_property_collections", target_property_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTargetPropertiesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter(name="targetPropertyCollections")
    def target_property_collections(self) -> Sequence['outputs.GetTargetPropertiesTargetPropertyCollectionResult']:
        """
        The list of target_property_collection.
        """
        return pulumi.get(self, "target_property_collections")


class AwaitableGetTargetPropertiesResult(GetTargetPropertiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetPropertiesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            severity=self.severity,
            target_id=self.target_id,
            target_name=self.target_name,
            target_property_collections=self.target_property_collections)


def get_target_properties(compartment_id: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetTargetPropertiesFilterArgs', 'GetTargetPropertiesFilterArgsDict']]] = None,
                          severity: Optional[_builtins.str] = None,
                          target_id: Optional[_builtins.str] = None,
                          target_name: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetPropertiesResult:
    """
    This data source provides the list of Target Properties in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of target properties for the specified target.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_properties = oci.FleetAppsManagement.get_target_properties(compartment_id=compartment_id,
        target_id=fleet_target_id,
        target_name=fleet_target_name,
        severity=target_property_severity)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param _builtins.str severity: Patch severity.
    :param _builtins.str target_id: Target identifier.
    :param _builtins.str target_name: Target name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['severity'] = severity
    __args__['targetId'] = target_id
    __args__['targetName'] = target_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getTargetProperties:getTargetProperties', __args__, opts=opts, typ=GetTargetPropertiesResult).value

    return AwaitableGetTargetPropertiesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        severity=pulumi.get(__ret__, 'severity'),
        target_id=pulumi.get(__ret__, 'target_id'),
        target_name=pulumi.get(__ret__, 'target_name'),
        target_property_collections=pulumi.get(__ret__, 'target_property_collections'))
def get_target_properties_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTargetPropertiesFilterArgs', 'GetTargetPropertiesFilterArgsDict']]]]] = None,
                                 severity: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 target_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 target_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTargetPropertiesResult]:
    """
    This data source provides the list of Target Properties in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of target properties for the specified target.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_properties = oci.FleetAppsManagement.get_target_properties(compartment_id=compartment_id,
        target_id=fleet_target_id,
        target_name=fleet_target_name,
        severity=target_property_severity)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param _builtins.str severity: Patch severity.
    :param _builtins.str target_id: Target identifier.
    :param _builtins.str target_name: Target name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['severity'] = severity
    __args__['targetId'] = target_id
    __args__['targetName'] = target_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getTargetProperties:getTargetProperties', __args__, opts=opts, typ=GetTargetPropertiesResult)
    return __ret__.apply(lambda __response__: GetTargetPropertiesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        severity=pulumi.get(__response__, 'severity'),
        target_id=pulumi.get(__response__, 'target_id'),
        target_name=pulumi.get(__response__, 'target_name'),
        target_property_collections=pulumi.get(__response__, 'target_property_collections')))
