# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OnboardingArgs', 'Onboarding']

@pulumi.input_type
class OnboardingArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_cost_tracking_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_fams_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Onboarding resource.
        :param pulumi.Input[_builtins.str] compartment_id: Tenancy OCID
               <<<<<<< ours
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_cost_tracking_tag_enabled: A value determining if the cost tracking tag is enabled or not. Allow
               Fleet Application Management to tag resources with cost tracking tag using "Oracle$FAMS-Tags.FAMSManaged" tag.
        :param pulumi.Input[_builtins.bool] is_fams_tag_enabled: A value determining if the Fleet Application Management tagging is enabled or not.
               Allow Fleet Application Management to tag resources with fleet name using "Oracle$FAMS-Tags.FleetName" tag.
               >>>>>>> theirs
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the
               new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_cost_tracking_tag_enabled is not None:
            pulumi.set(__self__, "is_cost_tracking_tag_enabled", is_cost_tracking_tag_enabled)
        if is_fams_tag_enabled is not None:
            pulumi.set(__self__, "is_fams_tag_enabled", is_fams_tag_enabled)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Tenancy OCID
        <<<<<<< ours
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isCostTrackingTagEnabled")
    def is_cost_tracking_tag_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value determining if the cost tracking tag is enabled or not. Allow
        Fleet Application Management to tag resources with cost tracking tag using "Oracle$FAMS-Tags.FAMSManaged" tag.
        """
        return pulumi.get(self, "is_cost_tracking_tag_enabled")

    @is_cost_tracking_tag_enabled.setter
    def is_cost_tracking_tag_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cost_tracking_tag_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isFamsTagEnabled")
    def is_fams_tag_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value determining if the Fleet Application Management tagging is enabled or not.
        Allow Fleet Application Management to tag resources with fleet name using "Oracle$FAMS-Tags.FleetName" tag.
        >>>>>>> theirs

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the
        new property values
        """
        return pulumi.get(self, "is_fams_tag_enabled")

    @is_fams_tag_enabled.setter
    def is_fams_tag_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_fams_tag_enabled", value)


@pulumi.input_type
class _OnboardingState:
    def __init__(__self__, *,
                 applied_policies: Optional[pulumi.Input[Sequence[pulumi.Input['OnboardingAppliedPolicyArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 discovery_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_cost_tracking_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_fams_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Onboarding resources.
        :param pulumi.Input[Sequence[pulumi.Input['OnboardingAppliedPolicyArgs']]] applied_policies: Summary of the Fleet Application Management Onboard Policy.
        :param pulumi.Input[_builtins.str] compartment_id: Tenancy OCID
               <<<<<<< ours
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] discovery_frequency: Provide discovery frequency.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_cost_tracking_tag_enabled: A value determining if the cost tracking tag is enabled or not. Allow
               Fleet Application Management to tag resources with cost tracking tag using "Oracle$FAMS-Tags.FAMSManaged" tag.
        :param pulumi.Input[_builtins.bool] is_fams_tag_enabled: A value determining if the Fleet Application Management tagging is enabled or not.
               Allow Fleet Application Management to tag resources with fleet name using "Oracle$FAMS-Tags.FleetName" tag.
               >>>>>>> theirs
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the
               new property values
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[_builtins.str] state: The current state of the Onboarding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example:
               `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] version: The version of Fleet Application Management that the tenant is onboarded to.
        """
        if applied_policies is not None:
            pulumi.set(__self__, "applied_policies", applied_policies)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_frequency is not None:
            pulumi.set(__self__, "discovery_frequency", discovery_frequency)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_cost_tracking_tag_enabled is not None:
            pulumi.set(__self__, "is_cost_tracking_tag_enabled", is_cost_tracking_tag_enabled)
        if is_fams_tag_enabled is not None:
            pulumi.set(__self__, "is_fams_tag_enabled", is_fams_tag_enabled)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="appliedPolicies")
    def applied_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnboardingAppliedPolicyArgs']]]]:
        """
        Summary of the Fleet Application Management Onboard Policy.
        """
        return pulumi.get(self, "applied_policies")

    @applied_policies.setter
    def applied_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnboardingAppliedPolicyArgs']]]]):
        pulumi.set(self, "applied_policies", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tenancy OCID
        <<<<<<< ours
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="discoveryFrequency")
    def discovery_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide discovery frequency.
        """
        return pulumi.get(self, "discovery_frequency")

    @discovery_frequency.setter
    def discovery_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_frequency", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isCostTrackingTagEnabled")
    def is_cost_tracking_tag_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value determining if the cost tracking tag is enabled or not. Allow
        Fleet Application Management to tag resources with cost tracking tag using "Oracle$FAMS-Tags.FAMSManaged" tag.
        """
        return pulumi.get(self, "is_cost_tracking_tag_enabled")

    @is_cost_tracking_tag_enabled.setter
    def is_cost_tracking_tag_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cost_tracking_tag_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isFamsTagEnabled")
    def is_fams_tag_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value determining if the Fleet Application Management tagging is enabled or not.
        Allow Fleet Application Management to tag resources with fleet name using "Oracle$FAMS-Tags.FleetName" tag.
        >>>>>>> theirs

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the
        new property values
        """
        return pulumi.get(self, "is_fams_tag_enabled")

    @is_fams_tag_enabled.setter
    def is_fams_tag_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_fams_tag_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Onboarding.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example:
        `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of Fleet Application Management that the tenant is onboarded to.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:FleetAppsManagement/onboarding:Onboarding")
class Onboarding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_cost_tracking_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_fams_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Onboardings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/onboarding:Onboarding test_onboarding "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: Tenancy OCID
               <<<<<<< ours
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_cost_tracking_tag_enabled: A value determining if the cost tracking tag is enabled or not. Allow
               Fleet Application Management to tag resources with cost tracking tag using "Oracle$FAMS-Tags.FAMSManaged" tag.
        :param pulumi.Input[_builtins.bool] is_fams_tag_enabled: A value determining if the Fleet Application Management tagging is enabled or not.
               Allow Fleet Application Management to tag resources with fleet name using "Oracle$FAMS-Tags.FleetName" tag.
               >>>>>>> theirs
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the
               new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OnboardingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Onboardings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/onboarding:Onboarding test_onboarding "id"
        ```

        :param str resource_name: The name of the resource.
        :param OnboardingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OnboardingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_cost_tracking_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_fams_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OnboardingArgs.__new__(OnboardingArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_cost_tracking_tag_enabled"] = is_cost_tracking_tag_enabled
            __props__.__dict__["is_fams_tag_enabled"] = is_fams_tag_enabled
            __props__.__dict__["applied_policies"] = None
            __props__.__dict__["discovery_frequency"] = None
            __props__.__dict__["resource_region"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
        super(Onboarding, __self__).__init__(
            'oci:FleetAppsManagement/onboarding:Onboarding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applied_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnboardingAppliedPolicyArgs', 'OnboardingAppliedPolicyArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            discovery_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_cost_tracking_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_fams_tag_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Onboarding':
        """
        Get an existing Onboarding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnboardingAppliedPolicyArgs', 'OnboardingAppliedPolicyArgsDict']]]] applied_policies: Summary of the Fleet Application Management Onboard Policy.
        :param pulumi.Input[_builtins.str] compartment_id: Tenancy OCID
               <<<<<<< ours
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] discovery_frequency: Provide discovery frequency.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_cost_tracking_tag_enabled: A value determining if the cost tracking tag is enabled or not. Allow
               Fleet Application Management to tag resources with cost tracking tag using "Oracle$FAMS-Tags.FAMSManaged" tag.
        :param pulumi.Input[_builtins.bool] is_fams_tag_enabled: A value determining if the Fleet Application Management tagging is enabled or not.
               Allow Fleet Application Management to tag resources with fleet name using "Oracle$FAMS-Tags.FleetName" tag.
               >>>>>>> theirs
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the
               new property values
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[_builtins.str] state: The current state of the Onboarding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example:
               `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] version: The version of Fleet Application Management that the tenant is onboarded to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OnboardingState.__new__(_OnboardingState)

        __props__.__dict__["applied_policies"] = applied_policies
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["discovery_frequency"] = discovery_frequency
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_cost_tracking_tag_enabled"] = is_cost_tracking_tag_enabled
        __props__.__dict__["is_fams_tag_enabled"] = is_fams_tag_enabled
        __props__.__dict__["resource_region"] = resource_region
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        return Onboarding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appliedPolicies")
    def applied_policies(self) -> pulumi.Output[Sequence['outputs.OnboardingAppliedPolicy']]:
        """
        Summary of the Fleet Application Management Onboard Policy.
        """
        return pulumi.get(self, "applied_policies")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Tenancy OCID
        <<<<<<< ours
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="discoveryFrequency")
    def discovery_frequency(self) -> pulumi.Output[_builtins.str]:
        """
        Provide discovery frequency.
        """
        return pulumi.get(self, "discovery_frequency")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isCostTrackingTagEnabled")
    def is_cost_tracking_tag_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        A value determining if the cost tracking tag is enabled or not. Allow
        Fleet Application Management to tag resources with cost tracking tag using "Oracle$FAMS-Tags.FAMSManaged" tag.
        """
        return pulumi.get(self, "is_cost_tracking_tag_enabled")

    @_builtins.property
    @pulumi.getter(name="isFamsTagEnabled")
    def is_fams_tag_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        A value determining if the Fleet Application Management tagging is enabled or not.
        Allow Fleet Application Management to tag resources with fleet name using "Oracle$FAMS-Tags.FleetName" tag.
        >>>>>>> theirs

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the
        new property values
        """
        return pulumi.get(self, "is_fams_tag_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> pulumi.Output[_builtins.str]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Onboarding.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example:
        `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of Fleet Application Management that the tenant is onboarded to.
        """
        return pulumi.get(self, "version")

