# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RunbookArgs', 'Runbook']

@pulumi.input_type
class RunbookArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 operation: pulumi.Input[_builtins.str],
                 runbook_version: pulumi.Input['RunbookRunbookVersionArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 estimated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sudo_access_needed: Optional[pulumi.Input[_builtins.bool]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Runbook resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable)
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[_builtins.str] operation: (Updatable) The lifecycle operation performed by the task.
        :param pulumi.Input['RunbookRunbookVersionArgs'] runbook_version: Version for the runbook. Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] estimated_time: (Updatable) Estimated time to successfully complete the runbook execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) Is the runbook default?
        :param pulumi.Input[_builtins.bool] is_sudo_access_needed: (Updatable) Does this runbook need SUDO access to execute?
        :param pulumi.Input[_builtins.str] os_type: (Updatable) The OS type for the runbook.
        :param pulumi.Input[_builtins.str] platform: (Updatable) The platform of the runbook.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "runbook_version", runbook_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if estimated_time is not None:
            pulumi.set(__self__, "estimated_time", estimated_time)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_sudo_access_needed is not None:
            pulumi.set(__self__, "is_sudo_access_needed", is_sudo_access_needed)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The lifecycle operation performed by the task.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operation", value)

    @_builtins.property
    @pulumi.getter(name="runbookVersion")
    def runbook_version(self) -> pulumi.Input['RunbookRunbookVersionArgs']:
        """
        Version for the runbook. Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
        """
        return pulumi.get(self, "runbook_version")

    @runbook_version.setter
    def runbook_version(self, value: pulumi.Input['RunbookRunbookVersionArgs']):
        pulumi.set(self, "runbook_version", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="estimatedTime")
    def estimated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Estimated time to successfully complete the runbook execution.
        """
        return pulumi.get(self, "estimated_time")

    @estimated_time.setter
    def estimated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "estimated_time", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Is the runbook default?
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="isSudoAccessNeeded")
    def is_sudo_access_needed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Does this runbook need SUDO access to execute?
        """
        return pulumi.get(self, "is_sudo_access_needed")

    @is_sudo_access_needed.setter
    def is_sudo_access_needed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sudo_access_needed", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)


@pulumi.input_type
class _RunbookState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 estimated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 has_draft_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sudo_access_needed: Optional[pulumi.Input[_builtins.bool]] = None,
                 latest_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_version: Optional[pulumi.Input['RunbookRunbookVersionArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Runbook resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[_builtins.str] estimated_time: (Updatable) Estimated time to successfully complete the runbook execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] has_draft_version: Does this runbook has draft versions?
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) Is the runbook default?
        :param pulumi.Input[_builtins.bool] is_sudo_access_needed: (Updatable) Does this runbook need SUDO access to execute?
        :param pulumi.Input[_builtins.str] latest_version: Latest runbook version.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] operation: (Updatable) The lifecycle operation performed by the task.
        :param pulumi.Input[_builtins.str] os_type: (Updatable) The OS type for the runbook.
        :param pulumi.Input[_builtins.str] platform: (Updatable) The platform of the runbook.
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input['RunbookRunbookVersionArgs'] runbook_version: Version for the runbook. Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
        :param pulumi.Input[_builtins.str] state: The current state of the runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: The type of the runbook.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_time is not None:
            pulumi.set(__self__, "estimated_time", estimated_time)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if has_draft_version is not None:
            pulumi.set(__self__, "has_draft_version", has_draft_version)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_sudo_access_needed is not None:
            pulumi.set(__self__, "is_sudo_access_needed", is_sudo_access_needed)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if runbook_version is not None:
            pulumi.set(__self__, "runbook_version", runbook_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="estimatedTime")
    def estimated_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Estimated time to successfully complete the runbook execution.
        """
        return pulumi.get(self, "estimated_time")

    @estimated_time.setter
    def estimated_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "estimated_time", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="hasDraftVersion")
    def has_draft_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Does this runbook has draft versions?
        """
        return pulumi.get(self, "has_draft_version")

    @has_draft_version.setter
    def has_draft_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_draft_version", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Is the runbook default?
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="isSudoAccessNeeded")
    def is_sudo_access_needed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Does this runbook need SUDO access to execute?
        """
        return pulumi.get(self, "is_sudo_access_needed")

    @is_sudo_access_needed.setter
    def is_sudo_access_needed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sudo_access_needed", value)

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Latest runbook version.
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_version", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The lifecycle operation performed by the task.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_region", value)

    @_builtins.property
    @pulumi.getter(name="runbookVersion")
    def runbook_version(self) -> Optional[pulumi.Input['RunbookRunbookVersionArgs']]:
        """
        Version for the runbook. Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
        """
        return pulumi.get(self, "runbook_version")

    @runbook_version.setter
    def runbook_version(self, value: Optional[pulumi.Input['RunbookRunbookVersionArgs']]):
        pulumi.set(self, "runbook_version", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the runbook.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:FleetAppsManagement/runbook:Runbook")
class Runbook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 estimated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sudo_access_needed: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_version: Optional[pulumi.Input[Union['RunbookRunbookVersionArgs', 'RunbookRunbookVersionArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_runbook = oci.fleetappsmanagement.Runbook("test_runbook",
            compartment_id=compartment_id,
            display_name=runbook_display_name,
            operation=runbook_operation,
            runbook_version={
                "execution_workflow_details": {
                    "workflows": [{
                        "group_name": test_group["name"],
                        "steps": [{
                            "type": runbook_runbook_version_execution_workflow_details_workflow_steps_type,
                            "group_name": test_group["name"],
                            "step_name": runbook_runbook_version_execution_workflow_details_workflow_steps_step_name,
                            "steps": runbook_runbook_version_execution_workflow_details_workflow_steps_steps,
                        }],
                        "type": runbook_runbook_version_execution_workflow_details_workflow_type,
                    }],
                },
                "groups": [{
                    "name": runbook_runbook_version_groups_name,
                    "type": runbook_runbook_version_groups_type,
                    "properties": {
                        "action_on_failure": runbook_runbook_version_groups_properties_action_on_failure,
                        "notification_preferences": {
                            "should_notify_on_pause": runbook_runbook_version_groups_properties_notification_preferences_should_notify_on_pause,
                            "should_notify_on_task_failure": runbook_runbook_version_groups_properties_notification_preferences_should_notify_on_task_failure,
                            "should_notify_on_task_success": runbook_runbook_version_groups_properties_notification_preferences_should_notify_on_task_success,
                        },
                        "pause_details": {
                            "kind": runbook_runbook_version_groups_properties_pause_details_kind,
                            "duration_in_minutes": runbook_runbook_version_groups_properties_pause_details_duration_in_minutes,
                        },
                        "pre_condition": runbook_runbook_version_groups_properties_pre_condition,
                        "run_on": {
                            "kind": runbook_runbook_version_groups_properties_run_on_kind,
                            "condition": runbook_runbook_version_groups_properties_run_on_condition,
                            "host": runbook_runbook_version_groups_properties_run_on_host,
                            "previous_task_instance_details": [{
                                "output_variable_details": {
                                    "output_variable_name": runbook_runbook_version_groups_properties_run_on_previous_task_instance_details_output_variable_details_output_variable_name,
                                    "step_name": runbook_runbook_version_groups_properties_run_on_previous_task_instance_details_output_variable_details_step_name,
                                },
                                "resource_id": test_resource["id"],
                                "resource_type": runbook_runbook_version_groups_properties_run_on_previous_task_instance_details_resource_type,
                            }],
                        },
                    },
                }],
                "tasks": [{
                    "step_name": runbook_runbook_version_tasks_step_name,
                    "task_record_details": {
                        "scope": runbook_runbook_version_tasks_task_record_details_scope,
                        "description": runbook_runbook_version_tasks_task_record_details_description,
                        "execution_details": {
                            "execution_type": runbook_runbook_version_tasks_task_record_details_execution_details_execution_type,
                            "catalog_id": test_catalog["id"],
                            "command": runbook_runbook_version_tasks_task_record_details_execution_details_command,
                            "config_file": runbook_runbook_version_tasks_task_record_details_execution_details_config_file,
                            "content": {
                                "source_type": runbook_runbook_version_tasks_task_record_details_execution_details_content_source_type,
                                "bucket": runbook_runbook_version_tasks_task_record_details_execution_details_content_bucket,
                                "catalog_id": test_catalog["id"],
                                "checksum": runbook_runbook_version_tasks_task_record_details_execution_details_content_checksum,
                                "namespace": runbook_runbook_version_tasks_task_record_details_execution_details_content_namespace,
                                "object": runbook_runbook_version_tasks_task_record_details_execution_details_content_object,
                            },
                            "credentials": [{
                                "display_name": runbook_runbook_version_tasks_task_record_details_execution_details_credentials_display_name,
                                "id": runbook_runbook_version_tasks_task_record_details_execution_details_credentials_id,
                            }],
                            "endpoint": runbook_runbook_version_tasks_task_record_details_execution_details_endpoint,
                            "is_executable_content": runbook_runbook_version_tasks_task_record_details_execution_details_is_executable_content,
                            "is_locked": runbook_runbook_version_tasks_task_record_details_execution_details_is_locked,
                            "is_read_output_variable_enabled": runbook_runbook_version_tasks_task_record_details_execution_details_is_read_output_variable_enabled,
                            "system_variables": runbook_runbook_version_tasks_task_record_details_execution_details_system_variables,
                            "target_compartment_id": test_compartment["id"],
                            "variables": {
                                "input_variables": [{
                                    "description": runbook_runbook_version_tasks_task_record_details_execution_details_variables_input_variables_description,
                                    "name": runbook_runbook_version_tasks_task_record_details_execution_details_variables_input_variables_name,
                                    "type": runbook_runbook_version_tasks_task_record_details_execution_details_variables_input_variables_type,
                                }],
                                "output_variables": runbook_runbook_version_tasks_task_record_details_execution_details_variables_output_variables,
                            },
                        },
                        "is_apply_subject_task": runbook_runbook_version_tasks_task_record_details_is_apply_subject_task,
                        "is_copy_to_library_enabled": runbook_runbook_version_tasks_task_record_details_is_copy_to_library_enabled,
                        "is_discovery_output_task": runbook_runbook_version_tasks_task_record_details_is_discovery_output_task,
                        "name": runbook_runbook_version_tasks_task_record_details_name,
                        "os_type": runbook_runbook_version_tasks_task_record_details_os_type,
                        "platform": runbook_runbook_version_tasks_task_record_details_platform,
                        "properties": {
                            "num_retries": runbook_runbook_version_tasks_task_record_details_properties_num_retries,
                            "timeout_in_seconds": runbook_runbook_version_tasks_task_record_details_properties_timeout_in_seconds,
                        },
                        "task_record_id": test_task_record["id"],
                    },
                    "output_variable_mappings": [{
                        "name": runbook_runbook_version_tasks_output_variable_mappings_name,
                        "output_variable_details": {
                            "output_variable_name": runbook_runbook_version_tasks_output_variable_mappings_output_variable_details_output_variable_name,
                            "step_name": runbook_runbook_version_tasks_output_variable_mappings_output_variable_details_step_name,
                        },
                    }],
                    "step_properties": {
                        "action_on_failure": runbook_runbook_version_tasks_step_properties_action_on_failure,
                        "notification_preferences": {
                            "should_notify_on_pause": runbook_runbook_version_tasks_step_properties_notification_preferences_should_notify_on_pause,
                            "should_notify_on_task_failure": runbook_runbook_version_tasks_step_properties_notification_preferences_should_notify_on_task_failure,
                            "should_notify_on_task_success": runbook_runbook_version_tasks_step_properties_notification_preferences_should_notify_on_task_success,
                        },
                        "pause_details": {
                            "kind": runbook_runbook_version_tasks_step_properties_pause_details_kind,
                            "duration_in_minutes": runbook_runbook_version_tasks_step_properties_pause_details_duration_in_minutes,
                        },
                        "pre_condition": runbook_runbook_version_tasks_step_properties_pre_condition,
                        "run_on": {
                            "kind": runbook_runbook_version_tasks_step_properties_run_on_kind,
                            "condition": runbook_runbook_version_tasks_step_properties_run_on_condition,
                            "host": runbook_runbook_version_tasks_step_properties_run_on_host,
                            "previous_task_instance_details": [{
                                "output_variable_details": {
                                    "output_variable_name": runbook_runbook_version_tasks_step_properties_run_on_previous_task_instance_details_output_variable_details_output_variable_name,
                                    "step_name": runbook_runbook_version_tasks_step_properties_run_on_previous_task_instance_details_output_variable_details_step_name,
                                },
                                "resource_id": test_resource["id"],
                                "resource_type": runbook_runbook_version_tasks_step_properties_run_on_previous_task_instance_details_resource_type,
                            }],
                        },
                    },
                }],
                "is_latest": runbook_runbook_version_is_latest,
                "rollback_workflow_details": {
                    "scope": runbook_runbook_version_rollback_workflow_details_scope,
                    "workflows": [{
                        "group_name": test_group["name"],
                        "steps": [{
                            "type": runbook_runbook_version_rollback_workflow_details_workflow_steps_type,
                            "group_name": test_group["name"],
                            "step_name": runbook_runbook_version_rollback_workflow_details_workflow_steps_step_name,
                            "steps": runbook_runbook_version_rollback_workflow_details_workflow_steps_steps,
                        }],
                        "type": runbook_runbook_version_rollback_workflow_details_workflow_type,
                    }],
                },
                "version": runbook_runbook_version_version,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=runbook_description,
            estimated_time=runbook_estimated_time,
            freeform_tags={
                "bar-key": "value",
            },
            is_default=runbook_is_default,
            is_sudo_access_needed=runbook_is_sudo_access_needed,
            os_type=runbook_os_type,
            platform=runbook_platform)
        ```

        ## Import

        Runbooks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/runbook:Runbook test_runbook "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[_builtins.str] estimated_time: (Updatable) Estimated time to successfully complete the runbook execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) Is the runbook default?
        :param pulumi.Input[_builtins.bool] is_sudo_access_needed: (Updatable) Does this runbook need SUDO access to execute?
        :param pulumi.Input[_builtins.str] operation: (Updatable) The lifecycle operation performed by the task.
        :param pulumi.Input[_builtins.str] os_type: (Updatable) The OS type for the runbook.
        :param pulumi.Input[_builtins.str] platform: (Updatable) The platform of the runbook.
        :param pulumi.Input[Union['RunbookRunbookVersionArgs', 'RunbookRunbookVersionArgsDict']] runbook_version: Version for the runbook. Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RunbookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_runbook = oci.fleetappsmanagement.Runbook("test_runbook",
            compartment_id=compartment_id,
            display_name=runbook_display_name,
            operation=runbook_operation,
            runbook_version={
                "execution_workflow_details": {
                    "workflows": [{
                        "group_name": test_group["name"],
                        "steps": [{
                            "type": runbook_runbook_version_execution_workflow_details_workflow_steps_type,
                            "group_name": test_group["name"],
                            "step_name": runbook_runbook_version_execution_workflow_details_workflow_steps_step_name,
                            "steps": runbook_runbook_version_execution_workflow_details_workflow_steps_steps,
                        }],
                        "type": runbook_runbook_version_execution_workflow_details_workflow_type,
                    }],
                },
                "groups": [{
                    "name": runbook_runbook_version_groups_name,
                    "type": runbook_runbook_version_groups_type,
                    "properties": {
                        "action_on_failure": runbook_runbook_version_groups_properties_action_on_failure,
                        "notification_preferences": {
                            "should_notify_on_pause": runbook_runbook_version_groups_properties_notification_preferences_should_notify_on_pause,
                            "should_notify_on_task_failure": runbook_runbook_version_groups_properties_notification_preferences_should_notify_on_task_failure,
                            "should_notify_on_task_success": runbook_runbook_version_groups_properties_notification_preferences_should_notify_on_task_success,
                        },
                        "pause_details": {
                            "kind": runbook_runbook_version_groups_properties_pause_details_kind,
                            "duration_in_minutes": runbook_runbook_version_groups_properties_pause_details_duration_in_minutes,
                        },
                        "pre_condition": runbook_runbook_version_groups_properties_pre_condition,
                        "run_on": {
                            "kind": runbook_runbook_version_groups_properties_run_on_kind,
                            "condition": runbook_runbook_version_groups_properties_run_on_condition,
                            "host": runbook_runbook_version_groups_properties_run_on_host,
                            "previous_task_instance_details": [{
                                "output_variable_details": {
                                    "output_variable_name": runbook_runbook_version_groups_properties_run_on_previous_task_instance_details_output_variable_details_output_variable_name,
                                    "step_name": runbook_runbook_version_groups_properties_run_on_previous_task_instance_details_output_variable_details_step_name,
                                },
                                "resource_id": test_resource["id"],
                                "resource_type": runbook_runbook_version_groups_properties_run_on_previous_task_instance_details_resource_type,
                            }],
                        },
                    },
                }],
                "tasks": [{
                    "step_name": runbook_runbook_version_tasks_step_name,
                    "task_record_details": {
                        "scope": runbook_runbook_version_tasks_task_record_details_scope,
                        "description": runbook_runbook_version_tasks_task_record_details_description,
                        "execution_details": {
                            "execution_type": runbook_runbook_version_tasks_task_record_details_execution_details_execution_type,
                            "catalog_id": test_catalog["id"],
                            "command": runbook_runbook_version_tasks_task_record_details_execution_details_command,
                            "config_file": runbook_runbook_version_tasks_task_record_details_execution_details_config_file,
                            "content": {
                                "source_type": runbook_runbook_version_tasks_task_record_details_execution_details_content_source_type,
                                "bucket": runbook_runbook_version_tasks_task_record_details_execution_details_content_bucket,
                                "catalog_id": test_catalog["id"],
                                "checksum": runbook_runbook_version_tasks_task_record_details_execution_details_content_checksum,
                                "namespace": runbook_runbook_version_tasks_task_record_details_execution_details_content_namespace,
                                "object": runbook_runbook_version_tasks_task_record_details_execution_details_content_object,
                            },
                            "credentials": [{
                                "display_name": runbook_runbook_version_tasks_task_record_details_execution_details_credentials_display_name,
                                "id": runbook_runbook_version_tasks_task_record_details_execution_details_credentials_id,
                            }],
                            "endpoint": runbook_runbook_version_tasks_task_record_details_execution_details_endpoint,
                            "is_executable_content": runbook_runbook_version_tasks_task_record_details_execution_details_is_executable_content,
                            "is_locked": runbook_runbook_version_tasks_task_record_details_execution_details_is_locked,
                            "is_read_output_variable_enabled": runbook_runbook_version_tasks_task_record_details_execution_details_is_read_output_variable_enabled,
                            "system_variables": runbook_runbook_version_tasks_task_record_details_execution_details_system_variables,
                            "target_compartment_id": test_compartment["id"],
                            "variables": {
                                "input_variables": [{
                                    "description": runbook_runbook_version_tasks_task_record_details_execution_details_variables_input_variables_description,
                                    "name": runbook_runbook_version_tasks_task_record_details_execution_details_variables_input_variables_name,
                                    "type": runbook_runbook_version_tasks_task_record_details_execution_details_variables_input_variables_type,
                                }],
                                "output_variables": runbook_runbook_version_tasks_task_record_details_execution_details_variables_output_variables,
                            },
                        },
                        "is_apply_subject_task": runbook_runbook_version_tasks_task_record_details_is_apply_subject_task,
                        "is_copy_to_library_enabled": runbook_runbook_version_tasks_task_record_details_is_copy_to_library_enabled,
                        "is_discovery_output_task": runbook_runbook_version_tasks_task_record_details_is_discovery_output_task,
                        "name": runbook_runbook_version_tasks_task_record_details_name,
                        "os_type": runbook_runbook_version_tasks_task_record_details_os_type,
                        "platform": runbook_runbook_version_tasks_task_record_details_platform,
                        "properties": {
                            "num_retries": runbook_runbook_version_tasks_task_record_details_properties_num_retries,
                            "timeout_in_seconds": runbook_runbook_version_tasks_task_record_details_properties_timeout_in_seconds,
                        },
                        "task_record_id": test_task_record["id"],
                    },
                    "output_variable_mappings": [{
                        "name": runbook_runbook_version_tasks_output_variable_mappings_name,
                        "output_variable_details": {
                            "output_variable_name": runbook_runbook_version_tasks_output_variable_mappings_output_variable_details_output_variable_name,
                            "step_name": runbook_runbook_version_tasks_output_variable_mappings_output_variable_details_step_name,
                        },
                    }],
                    "step_properties": {
                        "action_on_failure": runbook_runbook_version_tasks_step_properties_action_on_failure,
                        "notification_preferences": {
                            "should_notify_on_pause": runbook_runbook_version_tasks_step_properties_notification_preferences_should_notify_on_pause,
                            "should_notify_on_task_failure": runbook_runbook_version_tasks_step_properties_notification_preferences_should_notify_on_task_failure,
                            "should_notify_on_task_success": runbook_runbook_version_tasks_step_properties_notification_preferences_should_notify_on_task_success,
                        },
                        "pause_details": {
                            "kind": runbook_runbook_version_tasks_step_properties_pause_details_kind,
                            "duration_in_minutes": runbook_runbook_version_tasks_step_properties_pause_details_duration_in_minutes,
                        },
                        "pre_condition": runbook_runbook_version_tasks_step_properties_pre_condition,
                        "run_on": {
                            "kind": runbook_runbook_version_tasks_step_properties_run_on_kind,
                            "condition": runbook_runbook_version_tasks_step_properties_run_on_condition,
                            "host": runbook_runbook_version_tasks_step_properties_run_on_host,
                            "previous_task_instance_details": [{
                                "output_variable_details": {
                                    "output_variable_name": runbook_runbook_version_tasks_step_properties_run_on_previous_task_instance_details_output_variable_details_output_variable_name,
                                    "step_name": runbook_runbook_version_tasks_step_properties_run_on_previous_task_instance_details_output_variable_details_step_name,
                                },
                                "resource_id": test_resource["id"],
                                "resource_type": runbook_runbook_version_tasks_step_properties_run_on_previous_task_instance_details_resource_type,
                            }],
                        },
                    },
                }],
                "is_latest": runbook_runbook_version_is_latest,
                "rollback_workflow_details": {
                    "scope": runbook_runbook_version_rollback_workflow_details_scope,
                    "workflows": [{
                        "group_name": test_group["name"],
                        "steps": [{
                            "type": runbook_runbook_version_rollback_workflow_details_workflow_steps_type,
                            "group_name": test_group["name"],
                            "step_name": runbook_runbook_version_rollback_workflow_details_workflow_steps_step_name,
                            "steps": runbook_runbook_version_rollback_workflow_details_workflow_steps_steps,
                        }],
                        "type": runbook_runbook_version_rollback_workflow_details_workflow_type,
                    }],
                },
                "version": runbook_runbook_version_version,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=runbook_description,
            estimated_time=runbook_estimated_time,
            freeform_tags={
                "bar-key": "value",
            },
            is_default=runbook_is_default,
            is_sudo_access_needed=runbook_is_sudo_access_needed,
            os_type=runbook_os_type,
            platform=runbook_platform)
        ```

        ## Import

        Runbooks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/runbook:Runbook test_runbook "id"
        ```

        :param str resource_name: The name of the resource.
        :param RunbookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RunbookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 estimated_time: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sudo_access_needed: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_version: Optional[pulumi.Input[Union['RunbookRunbookVersionArgs', 'RunbookRunbookVersionArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RunbookArgs.__new__(RunbookArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["estimated_time"] = estimated_time
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["is_sudo_access_needed"] = is_sudo_access_needed
            if operation is None and not opts.urn:
                raise TypeError("Missing required property 'operation'")
            __props__.__dict__["operation"] = operation
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["platform"] = platform
            if runbook_version is None and not opts.urn:
                raise TypeError("Missing required property 'runbook_version'")
            __props__.__dict__["runbook_version"] = runbook_version
            __props__.__dict__["has_draft_version"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["resource_region"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
        super(Runbook, __self__).__init__(
            'oci:FleetAppsManagement/runbook:Runbook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            estimated_time: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            has_draft_version: Optional[pulumi.Input[_builtins.bool]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            is_sudo_access_needed: Optional[pulumi.Input[_builtins.bool]] = None,
            latest_version: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            operation: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            resource_region: Optional[pulumi.Input[_builtins.str]] = None,
            runbook_version: Optional[pulumi.Input[Union['RunbookRunbookVersionArgs', 'RunbookRunbookVersionArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Runbook':
        """
        Get an existing Runbook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[_builtins.str] estimated_time: (Updatable) Estimated time to successfully complete the runbook execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] has_draft_version: Does this runbook has draft versions?
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) Is the runbook default?
        :param pulumi.Input[_builtins.bool] is_sudo_access_needed: (Updatable) Does this runbook need SUDO access to execute?
        :param pulumi.Input[_builtins.str] latest_version: Latest runbook version.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] operation: (Updatable) The lifecycle operation performed by the task.
        :param pulumi.Input[_builtins.str] os_type: (Updatable) The OS type for the runbook.
        :param pulumi.Input[_builtins.str] platform: (Updatable) The platform of the runbook.
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[Union['RunbookRunbookVersionArgs', 'RunbookRunbookVersionArgsDict']] runbook_version: Version for the runbook. Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
        :param pulumi.Input[_builtins.str] state: The current state of the runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: The type of the runbook.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RunbookState.__new__(_RunbookState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_time"] = estimated_time
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["has_draft_version"] = has_draft_version
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["is_sudo_access_needed"] = is_sudo_access_needed
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["operation"] = operation
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["platform"] = platform
        __props__.__dict__["resource_region"] = resource_region
        __props__.__dict__["runbook_version"] = runbook_version
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return Runbook(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="estimatedTime")
    def estimated_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Estimated time to successfully complete the runbook execution.
        """
        return pulumi.get(self, "estimated_time")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hasDraftVersion")
    def has_draft_version(self) -> pulumi.Output[_builtins.bool]:
        """
        Does this runbook has draft versions?
        """
        return pulumi.get(self, "has_draft_version")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Is the runbook default?
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isSudoAccessNeeded")
    def is_sudo_access_needed(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Does this runbook need SUDO access to execute?
        """
        return pulumi.get(self, "is_sudo_access_needed")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[_builtins.str]:
        """
        Latest runbook version.
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The lifecycle operation performed by the task.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> pulumi.Output[_builtins.str]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @_builtins.property
    @pulumi.getter(name="runbookVersion")
    def runbook_version(self) -> pulumi.Output['outputs.RunbookRunbookVersion']:
        """
        Version for the runbook. Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
        """
        return pulumi.get(self, "runbook_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the runbook.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")

