# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SchedulerDefinitionArgs', 'SchedulerDefinition']

@pulumi.input_type
class SchedulerDefinitionArgs:
    def __init__(__self__, *,
                 action_groups: pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]],
                 compartment_id: pulumi.Input[_builtins.str],
                 schedule: pulumi.Input['SchedulerDefinitionScheduleArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 run_books: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]] = None):
        """
        The set of arguments for constructing a SchedulerDefinition resource.
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]] action_groups: (Updatable) Action Groups associated with the Schedule.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID
        :param pulumi.Input['SchedulerDefinitionScheduleArgs'] schedule: (Updatable) Schedule Information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]] run_books: (Updatable) Runbooks.
        """
        pulumi.set(__self__, "action_groups", action_groups)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "schedule", schedule)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if run_books is not None:
            pulumi.set(__self__, "run_books", run_books)

    @_builtins.property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]:
        """
        (Updatable) Action Groups associated with the Schedule.
        """
        return pulumi.get(self, "action_groups")

    @action_groups.setter
    def action_groups(self, value: pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]):
        pulumi.set(self, "action_groups", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['SchedulerDefinitionScheduleArgs']:
        """
        (Updatable) Schedule Information.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['SchedulerDefinitionScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="runBooks")
    def run_books(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]]:
        """
        (Updatable) Runbooks.
        """
        return pulumi.get(self, "run_books")

    @run_books.setter
    def run_books(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]]):
        pulumi.set(self, "run_books", value)


@pulumi.input_type
class _SchedulerDefinitionState:
    def __init__(__self__, *,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 count_of_affected_action_groups: Optional[pulumi.Input[_builtins.int]] = None,
                 count_of_affected_resources: Optional[pulumi.Input[_builtins.int]] = None,
                 count_of_affected_targets: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 run_books: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]] = None,
                 schedule: Optional[pulumi.Input['SchedulerDefinitionScheduleArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_next_run: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SchedulerDefinition resources.
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]] action_groups: (Updatable) Action Groups associated with the Schedule.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID
        :param pulumi.Input[_builtins.int] count_of_affected_action_groups: Count of Action Groups affected by the Schedule.
        :param pulumi.Input[_builtins.int] count_of_affected_resources: Count of Resources affected by the Schedule.
        :param pulumi.Input[_builtins.int] count_of_affected_targets: Count of Targets affected by the Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] lifecycle_operations: All LifeCycle Operations that are part of the schedule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] products: All products that are part of the schedule for PRODUCT ActionGroup Type.
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]] run_books: (Updatable) Runbooks.
        :param pulumi.Input['SchedulerDefinitionScheduleArgs'] schedule: (Updatable) Schedule Information.
        :param pulumi.Input[_builtins.str] state: The current state of the SchedulerDefinition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_of_next_run: The scheduled date for the next run of the Job.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        if action_groups is not None:
            pulumi.set(__self__, "action_groups", action_groups)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if count_of_affected_action_groups is not None:
            pulumi.set(__self__, "count_of_affected_action_groups", count_of_affected_action_groups)
        if count_of_affected_resources is not None:
            pulumi.set(__self__, "count_of_affected_resources", count_of_affected_resources)
        if count_of_affected_targets is not None:
            pulumi.set(__self__, "count_of_affected_targets", count_of_affected_targets)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_operations is not None:
            pulumi.set(__self__, "lifecycle_operations", lifecycle_operations)
        if products is not None:
            pulumi.set(__self__, "products", products)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if run_books is not None:
            pulumi.set(__self__, "run_books", run_books)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_next_run is not None:
            pulumi.set(__self__, "time_of_next_run", time_of_next_run)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]]:
        """
        (Updatable) Action Groups associated with the Schedule.
        """
        return pulumi.get(self, "action_groups")

    @action_groups.setter
    def action_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]]):
        pulumi.set(self, "action_groups", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="countOfAffectedActionGroups")
    def count_of_affected_action_groups(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Count of Action Groups affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_action_groups")

    @count_of_affected_action_groups.setter
    def count_of_affected_action_groups(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "count_of_affected_action_groups", value)

    @_builtins.property
    @pulumi.getter(name="countOfAffectedResources")
    def count_of_affected_resources(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Count of Resources affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_resources")

    @count_of_affected_resources.setter
    def count_of_affected_resources(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "count_of_affected_resources", value)

    @_builtins.property
    @pulumi.getter(name="countOfAffectedTargets")
    def count_of_affected_targets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Count of Targets affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_targets")

    @count_of_affected_targets.setter
    def count_of_affected_targets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "count_of_affected_targets", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleOperations")
    def lifecycle_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        All LifeCycle Operations that are part of the schedule.
        """
        return pulumi.get(self, "lifecycle_operations")

    @lifecycle_operations.setter
    def lifecycle_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "lifecycle_operations", value)

    @_builtins.property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        All products that are part of the schedule for PRODUCT ActionGroup Type.
        """
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "products", value)

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_region", value)

    @_builtins.property
    @pulumi.getter(name="runBooks")
    def run_books(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]]:
        """
        (Updatable) Runbooks.
        """
        return pulumi.get(self, "run_books")

    @run_books.setter
    def run_books(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]]):
        pulumi.set(self, "run_books", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['SchedulerDefinitionScheduleArgs']]:
        """
        (Updatable) Schedule Information.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['SchedulerDefinitionScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the SchedulerDefinition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeOfNextRun")
    def time_of_next_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheduled date for the next run of the Job.
        """
        return pulumi.get(self, "time_of_next_run")

    @time_of_next_run.setter
    def time_of_next_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_next_run", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:FleetAppsManagement/schedulerDefinition:SchedulerDefinition")
class SchedulerDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 run_books: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduler_definition = oci.fleetappsmanagement.SchedulerDefinition("test_scheduler_definition",
            action_groups=[{
                "fleet_id": test_fleet["id"],
                "kind": scheduler_definition_action_groups_kind,
                "runbook_id": test_runbook["id"],
                "runbook_version_name": test_runbook_version["name"],
                "display_name": scheduler_definition_action_groups_display_name,
                "sequence": scheduler_definition_action_groups_sequence,
            }],
            compartment_id=compartment_id,
            schedule={
                "execution_startdate": scheduler_definition_schedule_execution_startdate,
                "type": scheduler_definition_schedule_type,
                "duration": scheduler_definition_schedule_duration,
                "maintenance_window_id": test_maintenance_window["id"],
                "recurrences": scheduler_definition_schedule_recurrences,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=scheduler_definition_description,
            display_name=scheduler_definition_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            run_books=[{
                "runbook_id": test_runbook["id"],
                "runbook_version_name": test_runbook_version["name"],
                "input_parameters": [{
                    "step_name": scheduler_definition_run_books_input_parameters_step_name,
                    "arguments": [{
                        "kind": scheduler_definition_run_books_input_parameters_arguments_kind,
                        "name": scheduler_definition_run_books_input_parameters_arguments_name,
                        "content": {
                            "bucket": scheduler_definition_run_books_input_parameters_arguments_content_bucket,
                            "checksum": scheduler_definition_run_books_input_parameters_arguments_content_checksum,
                            "namespace": scheduler_definition_run_books_input_parameters_arguments_content_namespace,
                            "object": scheduler_definition_run_books_input_parameters_arguments_content_object,
                            "source_type": scheduler_definition_run_books_input_parameters_arguments_content_source_type,
                        },
                        "value": scheduler_definition_run_books_input_parameters_arguments_value,
                    }],
                }],
            }])
        ```

        ## Import

        SchedulerDefinitions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/schedulerDefinition:SchedulerDefinition test_scheduler_definition "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]] action_groups: (Updatable) Action Groups associated with the Schedule.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]] run_books: (Updatable) Runbooks.
        :param pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']] schedule: (Updatable) Schedule Information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchedulerDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduler_definition = oci.fleetappsmanagement.SchedulerDefinition("test_scheduler_definition",
            action_groups=[{
                "fleet_id": test_fleet["id"],
                "kind": scheduler_definition_action_groups_kind,
                "runbook_id": test_runbook["id"],
                "runbook_version_name": test_runbook_version["name"],
                "display_name": scheduler_definition_action_groups_display_name,
                "sequence": scheduler_definition_action_groups_sequence,
            }],
            compartment_id=compartment_id,
            schedule={
                "execution_startdate": scheduler_definition_schedule_execution_startdate,
                "type": scheduler_definition_schedule_type,
                "duration": scheduler_definition_schedule_duration,
                "maintenance_window_id": test_maintenance_window["id"],
                "recurrences": scheduler_definition_schedule_recurrences,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=scheduler_definition_description,
            display_name=scheduler_definition_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            run_books=[{
                "runbook_id": test_runbook["id"],
                "runbook_version_name": test_runbook_version["name"],
                "input_parameters": [{
                    "step_name": scheduler_definition_run_books_input_parameters_step_name,
                    "arguments": [{
                        "kind": scheduler_definition_run_books_input_parameters_arguments_kind,
                        "name": scheduler_definition_run_books_input_parameters_arguments_name,
                        "content": {
                            "bucket": scheduler_definition_run_books_input_parameters_arguments_content_bucket,
                            "checksum": scheduler_definition_run_books_input_parameters_arguments_content_checksum,
                            "namespace": scheduler_definition_run_books_input_parameters_arguments_content_namespace,
                            "object": scheduler_definition_run_books_input_parameters_arguments_content_object,
                            "source_type": scheduler_definition_run_books_input_parameters_arguments_content_source_type,
                        },
                        "value": scheduler_definition_run_books_input_parameters_arguments_value,
                    }],
                }],
            }])
        ```

        ## Import

        SchedulerDefinitions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/schedulerDefinition:SchedulerDefinition test_scheduler_definition "id"
        ```

        :param str resource_name: The name of the resource.
        :param SchedulerDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchedulerDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 run_books: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchedulerDefinitionArgs.__new__(SchedulerDefinitionArgs)

            if action_groups is None and not opts.urn:
                raise TypeError("Missing required property 'action_groups'")
            __props__.__dict__["action_groups"] = action_groups
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["run_books"] = run_books
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["count_of_affected_action_groups"] = None
            __props__.__dict__["count_of_affected_resources"] = None
            __props__.__dict__["count_of_affected_targets"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lifecycle_operations"] = None
            __props__.__dict__["products"] = None
            __props__.__dict__["resource_region"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_next_run"] = None
            __props__.__dict__["time_updated"] = None
        super(SchedulerDefinition, __self__).__init__(
            'oci:FleetAppsManagement/schedulerDefinition:SchedulerDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            count_of_affected_action_groups: Optional[pulumi.Input[_builtins.int]] = None,
            count_of_affected_resources: Optional[pulumi.Input[_builtins.int]] = None,
            count_of_affected_targets: Optional[pulumi.Input[_builtins.int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_region: Optional[pulumi.Input[_builtins.str]] = None,
            run_books: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]]] = None,
            schedule: Optional[pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_of_next_run: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'SchedulerDefinition':
        """
        Get an existing SchedulerDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]] action_groups: (Updatable) Action Groups associated with the Schedule.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID
        :param pulumi.Input[_builtins.int] count_of_affected_action_groups: Count of Action Groups affected by the Schedule.
        :param pulumi.Input[_builtins.int] count_of_affected_resources: Count of Resources affected by the Schedule.
        :param pulumi.Input[_builtins.int] count_of_affected_targets: Count of Targets affected by the Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] lifecycle_operations: All LifeCycle Operations that are part of the schedule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] products: All products that are part of the schedule for PRODUCT ActionGroup Type.
        :param pulumi.Input[_builtins.str] resource_region: Associated region
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]] run_books: (Updatable) Runbooks.
        :param pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']] schedule: (Updatable) Schedule Information.
        :param pulumi.Input[_builtins.str] state: The current state of the SchedulerDefinition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_of_next_run: The scheduled date for the next run of the Job.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchedulerDefinitionState.__new__(_SchedulerDefinitionState)

        __props__.__dict__["action_groups"] = action_groups
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["count_of_affected_action_groups"] = count_of_affected_action_groups
        __props__.__dict__["count_of_affected_resources"] = count_of_affected_resources
        __props__.__dict__["count_of_affected_targets"] = count_of_affected_targets
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lifecycle_operations"] = lifecycle_operations
        __props__.__dict__["products"] = products
        __props__.__dict__["resource_region"] = resource_region
        __props__.__dict__["run_books"] = run_books
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_next_run"] = time_of_next_run
        __props__.__dict__["time_updated"] = time_updated
        return SchedulerDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> pulumi.Output[Sequence['outputs.SchedulerDefinitionActionGroup']]:
        """
        (Updatable) Action Groups associated with the Schedule.
        """
        return pulumi.get(self, "action_groups")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="countOfAffectedActionGroups")
    def count_of_affected_action_groups(self) -> pulumi.Output[_builtins.int]:
        """
        Count of Action Groups affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_action_groups")

    @_builtins.property
    @pulumi.getter(name="countOfAffectedResources")
    def count_of_affected_resources(self) -> pulumi.Output[_builtins.int]:
        """
        Count of Resources affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_resources")

    @_builtins.property
    @pulumi.getter(name="countOfAffectedTargets")
    def count_of_affected_targets(self) -> pulumi.Output[_builtins.int]:
        """
        Count of Targets affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_targets")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lifecycleOperations")
    def lifecycle_operations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        All LifeCycle Operations that are part of the schedule.
        """
        return pulumi.get(self, "lifecycle_operations")

    @_builtins.property
    @pulumi.getter
    def products(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        All products that are part of the schedule for PRODUCT ActionGroup Type.
        """
        return pulumi.get(self, "products")

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> pulumi.Output[_builtins.str]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @_builtins.property
    @pulumi.getter(name="runBooks")
    def run_books(self) -> pulumi.Output[Sequence['outputs.SchedulerDefinitionRunBook']]:
        """
        (Updatable) Runbooks.
        """
        return pulumi.get(self, "run_books")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.SchedulerDefinitionSchedule']:
        """
        (Updatable) Schedule Information.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the SchedulerDefinition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfNextRun")
    def time_of_next_run(self) -> pulumi.Output[_builtins.str]:
        """
        The scheduled date for the next run of the Job.
        """
        return pulumi.get(self, "time_of_next_run")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

