# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FsuCollectionArgs', 'FsuCollection']

@pulumi.input_type
class FsuCollectionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 service_type: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionComponentArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_discovery: Optional[pulumi.Input['FsuCollectionFleetDiscoveryArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_major_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FsuCollection resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        :param pulumi.Input[_builtins.str] service_type: Exadata service type for the target resource members.
        :param pulumi.Input[_builtins.str] type: Collection type. DB: Only Database entity type resources allowed. GI: CloudVMCluster and VMCluster entity type resources allowed. GUEST_OS: CloudVmCluster and VmCluster entity type resources are allowed. EXADB_STACK: CloudVmCluster and VmCluster entity type resources are allowed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['FsuCollectionComponentArgs']]] components: Details of components in an Exadata software stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Fleet Update Collection.
        :param pulumi.Input['FsuCollectionFleetDiscoveryArgs'] fleet_discovery: Fleet discovery strategies for a 'GUEST_OS' collection of Exadata VM Clusters. If specified for an UpdateCollection request, discovery for Exadata VM Clusters will be rerun.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] source_major_version: Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the Exadata Fleet Update Collection. Only Exadata VM Clusters whose 'systemVersion' is related to the major version will be added to the Exadata Fleet Update Collection. For more details, refer to [Oracle document 2075007.1](https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html)
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "service_type", service_type)
        pulumi.set(__self__, "type", type)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fleet_discovery is not None:
            pulumi.set(__self__, "fleet_discovery", fleet_discovery)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if source_major_version is not None:
            pulumi.set(__self__, "source_major_version", source_major_version)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Input[_builtins.str]:
        """
        Exadata service type for the target resource members.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Collection type. DB: Only Database entity type resources allowed. GI: CloudVMCluster and VMCluster entity type resources allowed. GUEST_OS: CloudVmCluster and VmCluster entity type resources are allowed. EXADB_STACK: CloudVmCluster and VmCluster entity type resources are allowed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionComponentArgs']]]]:
        """
        Details of components in an Exadata software stack.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The user-friendly name for the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="fleetDiscovery")
    def fleet_discovery(self) -> Optional[pulumi.Input['FsuCollectionFleetDiscoveryArgs']]:
        """
        Fleet discovery strategies for a 'GUEST_OS' collection of Exadata VM Clusters. If specified for an UpdateCollection request, discovery for Exadata VM Clusters will be rerun.
        """
        return pulumi.get(self, "fleet_discovery")

    @fleet_discovery.setter
    def fleet_discovery(self, value: Optional[pulumi.Input['FsuCollectionFleetDiscoveryArgs']]):
        pulumi.set(self, "fleet_discovery", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="sourceMajorVersion")
    def source_major_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the Exadata Fleet Update Collection. Only Exadata VM Clusters whose 'systemVersion' is related to the major version will be added to the Exadata Fleet Update Collection. For more details, refer to [Oracle document 2075007.1](https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html)
        """
        return pulumi.get(self, "source_major_version")

    @source_major_version.setter
    def source_major_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_major_version", value)


@pulumi.input_type
class _FsuCollectionState:
    def __init__(__self__, *,
                 active_fsu_cycles: Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionActiveFsuCycleArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionComponentArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_discovery: Optional[pulumi.Input['FsuCollectionFleetDiscoveryArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 last_completed_fsu_cycle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_count: Optional[pulumi.Input[_builtins.int]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FsuCollection resources.
        :param pulumi.Input[Sequence[pulumi.Input['FsuCollectionActiveFsuCycleArgs']]] active_fsu_cycles: Active Exadata Fleet Update Cycle resource for this Collection. Object would be null if there is no active Cycle.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        :param pulumi.Input[Sequence[pulumi.Input['FsuCollectionComponentArgs']]] components: Details of components in an Exadata software stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Fleet Update Collection.
        :param pulumi.Input['FsuCollectionFleetDiscoveryArgs'] fleet_discovery: Fleet discovery strategies for a 'GUEST_OS' collection of Exadata VM Clusters. If specified for an UpdateCollection request, discovery for Exadata VM Clusters will be rerun.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] last_completed_fsu_cycle_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last completed FSU Cycle.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] service_type: Exadata service type for the target resource members.
        :param pulumi.Input[_builtins.str] source_major_version: Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the Exadata Fleet Update Collection. Only Exadata VM Clusters whose 'systemVersion' is related to the major version will be added to the Exadata Fleet Update Collection. For more details, refer to [Oracle document 2075007.1](https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html)
        :param pulumi.Input[_builtins.str] state: The current state of the Exadata Fleet Update Collection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.int] target_count: Number of targets that are members of this Collection.
        :param pulumi.Input[_builtins.str] time_created: The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: Collection type. DB: Only Database entity type resources allowed. GI: CloudVMCluster and VMCluster entity type resources allowed. GUEST_OS: CloudVmCluster and VmCluster entity type resources are allowed. EXADB_STACK: CloudVmCluster and VmCluster entity type resources are allowed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if active_fsu_cycles is not None:
            pulumi.set(__self__, "active_fsu_cycles", active_fsu_cycles)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fleet_discovery is not None:
            pulumi.set(__self__, "fleet_discovery", fleet_discovery)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if last_completed_fsu_cycle_id is not None:
            pulumi.set(__self__, "last_completed_fsu_cycle_id", last_completed_fsu_cycle_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if source_major_version is not None:
            pulumi.set(__self__, "source_major_version", source_major_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_count is not None:
            pulumi.set(__self__, "target_count", target_count)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="activeFsuCycles")
    def active_fsu_cycles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionActiveFsuCycleArgs']]]]:
        """
        Active Exadata Fleet Update Cycle resource for this Collection. Object would be null if there is no active Cycle.
        """
        return pulumi.get(self, "active_fsu_cycles")

    @active_fsu_cycles.setter
    def active_fsu_cycles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionActiveFsuCycleArgs']]]]):
        pulumi.set(self, "active_fsu_cycles", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionComponentArgs']]]]:
        """
        Details of components in an Exadata software stack.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FsuCollectionComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The user-friendly name for the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="fleetDiscovery")
    def fleet_discovery(self) -> Optional[pulumi.Input['FsuCollectionFleetDiscoveryArgs']]:
        """
        Fleet discovery strategies for a 'GUEST_OS' collection of Exadata VM Clusters. If specified for an UpdateCollection request, discovery for Exadata VM Clusters will be rerun.
        """
        return pulumi.get(self, "fleet_discovery")

    @fleet_discovery.setter
    def fleet_discovery(self, value: Optional[pulumi.Input['FsuCollectionFleetDiscoveryArgs']]):
        pulumi.set(self, "fleet_discovery", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lastCompletedFsuCycleId")
    def last_completed_fsu_cycle_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last completed FSU Cycle.
        """
        return pulumi.get(self, "last_completed_fsu_cycle_id")

    @last_completed_fsu_cycle_id.setter
    def last_completed_fsu_cycle_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_completed_fsu_cycle_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Exadata service type for the target resource members.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceMajorVersion")
    def source_major_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the Exadata Fleet Update Collection. Only Exadata VM Clusters whose 'systemVersion' is related to the major version will be added to the Exadata Fleet Update Collection. For more details, refer to [Oracle document 2075007.1](https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html)
        """
        return pulumi.get(self, "source_major_version")

    @source_major_version.setter
    def source_major_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_major_version", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of targets that are members of this Collection.
        """
        return pulumi.get(self, "target_count")

    @target_count.setter
    def target_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_count", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Collection type. DB: Only Database entity type resources allowed. GI: CloudVMCluster and VMCluster entity type resources allowed. GUEST_OS: CloudVmCluster and VmCluster entity type resources are allowed. EXADB_STACK: CloudVmCluster and VmCluster entity type resources are allowed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:FleetSoftwareUpdate/fsuCollection:FsuCollection")
class FsuCollection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FsuCollectionComponentArgs', 'FsuCollectionComponentArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_discovery: Optional[pulumi.Input[Union['FsuCollectionFleetDiscoveryArgs', 'FsuCollectionFleetDiscoveryArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fsu_collection = oci.fleetsoftwareupdate.FsuCollection("test_fsu_collection",
            compartment_id=compartment_id,
            service_type=fsu_collection_service_type,
            type=fsu_collection_type,
            components=[{
                "component_type": fsu_collection_components_component_type,
                "source_major_version": fsu_collection_components_source_major_version,
                "fleet_discovery": {
                    "strategy": fsu_collection_components_fleet_discovery_strategy,
                    "filters": [{
                        "type": fsu_collection_components_fleet_discovery_filters_type,
                        "entity_type": fsu_collection_components_fleet_discovery_filters_entity_type,
                        "exadata_releases": fsu_collection_components_fleet_discovery_filters_exadata_releases,
                        "identifiers": fsu_collection_components_fleet_discovery_filters_identifiers,
                        "mode": fsu_collection_components_fleet_discovery_filters_mode,
                        "operator": fsu_collection_components_fleet_discovery_filters_operator,
                        "tags": [{
                            "key": fsu_collection_components_fleet_discovery_filters_tags_key,
                            "namespace": fsu_collection_components_fleet_discovery_filters_tags_namespace,
                            "value": fsu_collection_components_fleet_discovery_filters_tags_value,
                        }],
                        "versions": fsu_collection_components_fleet_discovery_filters_versions,
                    }],
                    "fsu_discovery_id": test_fsu_discovery["id"],
                    "query": fsu_collection_components_fleet_discovery_query,
                    "targets": fsu_collection_components_fleet_discovery_targets,
                },
            }],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=fsu_collection_display_name,
            fleet_discovery={
                "strategy": fsu_collection_fleet_discovery_strategy,
                "filters": [{
                    "type": fsu_collection_fleet_discovery_filters_type,
                    "entity_type": fsu_collection_fleet_discovery_filters_entity_type,
                    "exadata_releases": fsu_collection_fleet_discovery_filters_exadata_releases,
                    "identifiers": fsu_collection_fleet_discovery_filters_identifiers,
                    "mode": fsu_collection_fleet_discovery_filters_mode,
                    "names": fsu_collection_fleet_discovery_filters_names,
                    "operator": fsu_collection_fleet_discovery_filters_operator,
                    "tags": [{
                        "key": fsu_collection_fleet_discovery_filters_tags_key,
                        "namespace": fsu_collection_fleet_discovery_filters_tags_namespace,
                        "value": fsu_collection_fleet_discovery_filters_tags_value,
                    }],
                    "versions": fsu_collection_fleet_discovery_filters_versions,
                }],
                "fsu_discovery_id": test_fsu_discovery["id"],
                "query": fsu_collection_fleet_discovery_query,
                "targets": fsu_collection_fleet_discovery_targets,
            },
            freeform_tags={
                "bar-key": "value",
            },
            source_major_version=fsu_collection_source_major_version)
        ```

        ## Import

        FsuCollections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetSoftwareUpdate/fsuCollection:FsuCollection test_fsu_collection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FsuCollectionComponentArgs', 'FsuCollectionComponentArgsDict']]]] components: Details of components in an Exadata software stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Fleet Update Collection.
        :param pulumi.Input[Union['FsuCollectionFleetDiscoveryArgs', 'FsuCollectionFleetDiscoveryArgsDict']] fleet_discovery: Fleet discovery strategies for a 'GUEST_OS' collection of Exadata VM Clusters. If specified for an UpdateCollection request, discovery for Exadata VM Clusters will be rerun.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] service_type: Exadata service type for the target resource members.
        :param pulumi.Input[_builtins.str] source_major_version: Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the Exadata Fleet Update Collection. Only Exadata VM Clusters whose 'systemVersion' is related to the major version will be added to the Exadata Fleet Update Collection. For more details, refer to [Oracle document 2075007.1](https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html)
        :param pulumi.Input[_builtins.str] type: Collection type. DB: Only Database entity type resources allowed. GI: CloudVMCluster and VMCluster entity type resources allowed. GUEST_OS: CloudVmCluster and VmCluster entity type resources are allowed. EXADB_STACK: CloudVmCluster and VmCluster entity type resources are allowed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FsuCollectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fsu_collection = oci.fleetsoftwareupdate.FsuCollection("test_fsu_collection",
            compartment_id=compartment_id,
            service_type=fsu_collection_service_type,
            type=fsu_collection_type,
            components=[{
                "component_type": fsu_collection_components_component_type,
                "source_major_version": fsu_collection_components_source_major_version,
                "fleet_discovery": {
                    "strategy": fsu_collection_components_fleet_discovery_strategy,
                    "filters": [{
                        "type": fsu_collection_components_fleet_discovery_filters_type,
                        "entity_type": fsu_collection_components_fleet_discovery_filters_entity_type,
                        "exadata_releases": fsu_collection_components_fleet_discovery_filters_exadata_releases,
                        "identifiers": fsu_collection_components_fleet_discovery_filters_identifiers,
                        "mode": fsu_collection_components_fleet_discovery_filters_mode,
                        "operator": fsu_collection_components_fleet_discovery_filters_operator,
                        "tags": [{
                            "key": fsu_collection_components_fleet_discovery_filters_tags_key,
                            "namespace": fsu_collection_components_fleet_discovery_filters_tags_namespace,
                            "value": fsu_collection_components_fleet_discovery_filters_tags_value,
                        }],
                        "versions": fsu_collection_components_fleet_discovery_filters_versions,
                    }],
                    "fsu_discovery_id": test_fsu_discovery["id"],
                    "query": fsu_collection_components_fleet_discovery_query,
                    "targets": fsu_collection_components_fleet_discovery_targets,
                },
            }],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=fsu_collection_display_name,
            fleet_discovery={
                "strategy": fsu_collection_fleet_discovery_strategy,
                "filters": [{
                    "type": fsu_collection_fleet_discovery_filters_type,
                    "entity_type": fsu_collection_fleet_discovery_filters_entity_type,
                    "exadata_releases": fsu_collection_fleet_discovery_filters_exadata_releases,
                    "identifiers": fsu_collection_fleet_discovery_filters_identifiers,
                    "mode": fsu_collection_fleet_discovery_filters_mode,
                    "names": fsu_collection_fleet_discovery_filters_names,
                    "operator": fsu_collection_fleet_discovery_filters_operator,
                    "tags": [{
                        "key": fsu_collection_fleet_discovery_filters_tags_key,
                        "namespace": fsu_collection_fleet_discovery_filters_tags_namespace,
                        "value": fsu_collection_fleet_discovery_filters_tags_value,
                    }],
                    "versions": fsu_collection_fleet_discovery_filters_versions,
                }],
                "fsu_discovery_id": test_fsu_discovery["id"],
                "query": fsu_collection_fleet_discovery_query,
                "targets": fsu_collection_fleet_discovery_targets,
            },
            freeform_tags={
                "bar-key": "value",
            },
            source_major_version=fsu_collection_source_major_version)
        ```

        ## Import

        FsuCollections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetSoftwareUpdate/fsuCollection:FsuCollection test_fsu_collection "id"
        ```

        :param str resource_name: The name of the resource.
        :param FsuCollectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FsuCollectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FsuCollectionComponentArgs', 'FsuCollectionComponentArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_discovery: Optional[pulumi.Input[Union['FsuCollectionFleetDiscoveryArgs', 'FsuCollectionFleetDiscoveryArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FsuCollectionArgs.__new__(FsuCollectionArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["components"] = components
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["fleet_discovery"] = fleet_discovery
            __props__.__dict__["freeform_tags"] = freeform_tags
            if service_type is None and not opts.urn:
                raise TypeError("Missing required property 'service_type'")
            __props__.__dict__["service_type"] = service_type
            __props__.__dict__["source_major_version"] = source_major_version
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["active_fsu_cycles"] = None
            __props__.__dict__["last_completed_fsu_cycle_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_count"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(FsuCollection, __self__).__init__(
            'oci:FleetSoftwareUpdate/fsuCollection:FsuCollection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_fsu_cycles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FsuCollectionActiveFsuCycleArgs', 'FsuCollectionActiveFsuCycleArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FsuCollectionComponentArgs', 'FsuCollectionComponentArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            fleet_discovery: Optional[pulumi.Input[Union['FsuCollectionFleetDiscoveryArgs', 'FsuCollectionFleetDiscoveryArgsDict']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            last_completed_fsu_cycle_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            service_type: Optional[pulumi.Input[_builtins.str]] = None,
            source_major_version: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_count: Optional[pulumi.Input[_builtins.int]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'FsuCollection':
        """
        Get an existing FsuCollection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FsuCollectionActiveFsuCycleArgs', 'FsuCollectionActiveFsuCycleArgsDict']]]] active_fsu_cycles: Active Exadata Fleet Update Cycle resource for this Collection. Object would be null if there is no active Cycle.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FsuCollectionComponentArgs', 'FsuCollectionComponentArgsDict']]]] components: Details of components in an Exadata software stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Fleet Update Collection.
        :param pulumi.Input[Union['FsuCollectionFleetDiscoveryArgs', 'FsuCollectionFleetDiscoveryArgsDict']] fleet_discovery: Fleet discovery strategies for a 'GUEST_OS' collection of Exadata VM Clusters. If specified for an UpdateCollection request, discovery for Exadata VM Clusters will be rerun.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] last_completed_fsu_cycle_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last completed FSU Cycle.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] service_type: Exadata service type for the target resource members.
        :param pulumi.Input[_builtins.str] source_major_version: Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the Exadata Fleet Update Collection. Only Exadata VM Clusters whose 'systemVersion' is related to the major version will be added to the Exadata Fleet Update Collection. For more details, refer to [Oracle document 2075007.1](https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html)
        :param pulumi.Input[_builtins.str] state: The current state of the Exadata Fleet Update Collection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.int] target_count: Number of targets that are members of this Collection.
        :param pulumi.Input[_builtins.str] time_created: The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: Collection type. DB: Only Database entity type resources allowed. GI: CloudVMCluster and VMCluster entity type resources allowed. GUEST_OS: CloudVmCluster and VmCluster entity type resources are allowed. EXADB_STACK: CloudVmCluster and VmCluster entity type resources are allowed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FsuCollectionState.__new__(_FsuCollectionState)

        __props__.__dict__["active_fsu_cycles"] = active_fsu_cycles
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["components"] = components
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fleet_discovery"] = fleet_discovery
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["last_completed_fsu_cycle_id"] = last_completed_fsu_cycle_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["source_major_version"] = source_major_version
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_count"] = target_count
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return FsuCollection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activeFsuCycles")
    def active_fsu_cycles(self) -> pulumi.Output[Sequence['outputs.FsuCollectionActiveFsuCycle']]:
        """
        Active Exadata Fleet Update Cycle resource for this Collection. Object would be null if there is no active Cycle.
        """
        return pulumi.get(self, "active_fsu_cycles")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def components(self) -> pulumi.Output[Sequence['outputs.FsuCollectionComponent']]:
        """
        Details of components in an Exadata software stack.
        """
        return pulumi.get(self, "components")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The user-friendly name for the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fleetDiscovery")
    def fleet_discovery(self) -> pulumi.Output['outputs.FsuCollectionFleetDiscovery']:
        """
        Fleet discovery strategies for a 'GUEST_OS' collection of Exadata VM Clusters. If specified for an UpdateCollection request, discovery for Exadata VM Clusters will be rerun.
        """
        return pulumi.get(self, "fleet_discovery")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lastCompletedFsuCycleId")
    def last_completed_fsu_cycle_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last completed FSU Cycle.
        """
        return pulumi.get(self, "last_completed_fsu_cycle_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[_builtins.str]:
        """
        Exadata service type for the target resource members.
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter(name="sourceMajorVersion")
    def source_major_version(self) -> pulumi.Output[_builtins.str]:
        """
        Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the Exadata Fleet Update Collection. Only Exadata VM Clusters whose 'systemVersion' is related to the major version will be added to the Exadata Fleet Update Collection. For more details, refer to [Oracle document 2075007.1](https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html)
        """
        return pulumi.get(self, "source_major_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of targets that are members of this Collection.
        """
        return pulumi.get(self, "target_count")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Collection type. DB: Only Database entity type resources allowed. GI: CloudVMCluster and VMCluster entity type resources allowed. GUEST_OS: CloudVmCluster and VmCluster entity type resources are allowed. EXADB_STACK: CloudVmCluster and VmCluster entity type resources are allowed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

