# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FsuCycleArgs', 'FsuCycle']

@pulumi.input_type
class FsuCycleArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 fsu_collection_id: pulumi.Input[_builtins.str],
                 goal_version_details: pulumi.Input['FsuCycleGoalVersionDetailsArgs'],
                 type: pulumi.Input[_builtins.str],
                 apply_action_schedule: Optional[pulumi.Input['FsuCycleApplyActionScheduleArgs']] = None,
                 batching_strategy: Optional[pulumi.Input['FsuCycleBatchingStrategyArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 diagnostics_collection: Optional[pulumi.Input['FsuCycleDiagnosticsCollectionArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_ignore_missing_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_ignore_patches: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_keep_placement: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_drain_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 stage_action_schedule: Optional[pulumi.Input['FsuCycleStageActionScheduleArgs']] = None,
                 upgrade_details: Optional[pulumi.Input['FsuCycleUpgradeDetailsArgs']] = None):
        """
        The set of arguments for constructing a FsuCycle resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        :param pulumi.Input[_builtins.str] fsu_collection_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Collection which will be updated by the Exadata Fleet Update Cycle being created.
        :param pulumi.Input['FsuCycleGoalVersionDetailsArgs'] goal_version_details: (Updatable) Goal version or image details for the Exadata Fleet Update Cycle.
        :param pulumi.Input[_builtins.str] type: (Updatable) Type of Exadata Fleet Update Cycle.
        :param pulumi.Input['FsuCycleApplyActionScheduleArgs'] apply_action_schedule: Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        :param pulumi.Input['FsuCycleBatchingStrategyArgs'] batching_strategy: (Updatable) Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['FsuCycleDiagnosticsCollectionArgs'] diagnostics_collection: (Updatable) Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Fleet Update Cycle.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] is_ignore_missing_patches: (Updatable) List of identifiers of patches to ignore. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        :param pulumi.Input[_builtins.bool] is_ignore_patches: (Updatable) Ignore patch conflicts or missing patches between the source and goal homes. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        :param pulumi.Input[_builtins.bool] is_keep_placement: (Updatable) Ensure that database services are online on the same VMs before and after the maintenance update.
        :param pulumi.Input[_builtins.int] max_drain_timeout_in_seconds: (Updatable) Timeout for session draining for database services specified in seconds.
        :param pulumi.Input['FsuCycleStageActionScheduleArgs'] stage_action_schedule: Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        :param pulumi.Input['FsuCycleUpgradeDetailsArgs'] upgrade_details: (Updatable) Details of supported upgrade options for DB or GI collection.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "fsu_collection_id", fsu_collection_id)
        pulumi.set(__self__, "goal_version_details", goal_version_details)
        pulumi.set(__self__, "type", type)
        if apply_action_schedule is not None:
            pulumi.set(__self__, "apply_action_schedule", apply_action_schedule)
        if batching_strategy is not None:
            pulumi.set(__self__, "batching_strategy", batching_strategy)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if diagnostics_collection is not None:
            pulumi.set(__self__, "diagnostics_collection", diagnostics_collection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_ignore_missing_patches is not None:
            pulumi.set(__self__, "is_ignore_missing_patches", is_ignore_missing_patches)
        if is_ignore_patches is not None:
            pulumi.set(__self__, "is_ignore_patches", is_ignore_patches)
        if is_keep_placement is not None:
            pulumi.set(__self__, "is_keep_placement", is_keep_placement)
        if max_drain_timeout_in_seconds is not None:
            pulumi.set(__self__, "max_drain_timeout_in_seconds", max_drain_timeout_in_seconds)
        if stage_action_schedule is not None:
            pulumi.set(__self__, "stage_action_schedule", stage_action_schedule)
        if upgrade_details is not None:
            pulumi.set(__self__, "upgrade_details", upgrade_details)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="fsuCollectionId")
    def fsu_collection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Collection which will be updated by the Exadata Fleet Update Cycle being created.
        """
        return pulumi.get(self, "fsu_collection_id")

    @fsu_collection_id.setter
    def fsu_collection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fsu_collection_id", value)

    @_builtins.property
    @pulumi.getter(name="goalVersionDetails")
    def goal_version_details(self) -> pulumi.Input['FsuCycleGoalVersionDetailsArgs']:
        """
        (Updatable) Goal version or image details for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "goal_version_details")

    @goal_version_details.setter
    def goal_version_details(self, value: pulumi.Input['FsuCycleGoalVersionDetailsArgs']):
        pulumi.set(self, "goal_version_details", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="applyActionSchedule")
    def apply_action_schedule(self) -> Optional[pulumi.Input['FsuCycleApplyActionScheduleArgs']]:
        """
        Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "apply_action_schedule")

    @apply_action_schedule.setter
    def apply_action_schedule(self, value: Optional[pulumi.Input['FsuCycleApplyActionScheduleArgs']]):
        pulumi.set(self, "apply_action_schedule", value)

    @_builtins.property
    @pulumi.getter(name="batchingStrategy")
    def batching_strategy(self) -> Optional[pulumi.Input['FsuCycleBatchingStrategyArgs']]:
        """
        (Updatable) Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        """
        return pulumi.get(self, "batching_strategy")

    @batching_strategy.setter
    def batching_strategy(self, value: Optional[pulumi.Input['FsuCycleBatchingStrategyArgs']]):
        pulumi.set(self, "batching_strategy", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticsCollection")
    def diagnostics_collection(self) -> Optional[pulumi.Input['FsuCycleDiagnosticsCollectionArgs']]:
        """
        (Updatable) Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        """
        return pulumi.get(self, "diagnostics_collection")

    @diagnostics_collection.setter
    def diagnostics_collection(self, value: Optional[pulumi.Input['FsuCycleDiagnosticsCollectionArgs']]):
        pulumi.set(self, "diagnostics_collection", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The user-friendly name for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isIgnoreMissingPatches")
    def is_ignore_missing_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of identifiers of patches to ignore. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        """
        return pulumi.get(self, "is_ignore_missing_patches")

    @is_ignore_missing_patches.setter
    def is_ignore_missing_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "is_ignore_missing_patches", value)

    @_builtins.property
    @pulumi.getter(name="isIgnorePatches")
    def is_ignore_patches(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Ignore patch conflicts or missing patches between the source and goal homes. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        """
        return pulumi.get(self, "is_ignore_patches")

    @is_ignore_patches.setter
    def is_ignore_patches(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ignore_patches", value)

    @_builtins.property
    @pulumi.getter(name="isKeepPlacement")
    def is_keep_placement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Ensure that database services are online on the same VMs before and after the maintenance update.
        """
        return pulumi.get(self, "is_keep_placement")

    @is_keep_placement.setter
    def is_keep_placement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_keep_placement", value)

    @_builtins.property
    @pulumi.getter(name="maxDrainTimeoutInSeconds")
    def max_drain_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Timeout for session draining for database services specified in seconds.
        """
        return pulumi.get(self, "max_drain_timeout_in_seconds")

    @max_drain_timeout_in_seconds.setter
    def max_drain_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_drain_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="stageActionSchedule")
    def stage_action_schedule(self) -> Optional[pulumi.Input['FsuCycleStageActionScheduleArgs']]:
        """
        Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "stage_action_schedule")

    @stage_action_schedule.setter
    def stage_action_schedule(self, value: Optional[pulumi.Input['FsuCycleStageActionScheduleArgs']]):
        pulumi.set(self, "stage_action_schedule", value)

    @_builtins.property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> Optional[pulumi.Input['FsuCycleUpgradeDetailsArgs']]:
        """
        (Updatable) Details of supported upgrade options for DB or GI collection.
        """
        return pulumi.get(self, "upgrade_details")

    @upgrade_details.setter
    def upgrade_details(self, value: Optional[pulumi.Input['FsuCycleUpgradeDetailsArgs']]):
        pulumi.set(self, "upgrade_details", value)


@pulumi.input_type
class _FsuCycleState:
    def __init__(__self__, *,
                 apply_action_schedule: Optional[pulumi.Input['FsuCycleApplyActionScheduleArgs']] = None,
                 batching_strategy: Optional[pulumi.Input['FsuCycleBatchingStrategyArgs']] = None,
                 collection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 diagnostics_collection: Optional[pulumi.Input['FsuCycleDiagnosticsCollectionArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 executing_fsu_action_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fsu_collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 goal_version_details: Optional[pulumi.Input['FsuCycleGoalVersionDetailsArgs']] = None,
                 is_ignore_missing_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_ignore_patches: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_keep_placement: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_completed_action: Optional[pulumi.Input[_builtins.str]] = None,
                 last_completed_action_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 max_drain_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 next_action_to_executes: Optional[pulumi.Input[Sequence[pulumi.Input['FsuCycleNextActionToExecuteArgs']]]] = None,
                 rollback_cycle_state: Optional[pulumi.Input[_builtins.str]] = None,
                 stage_action_schedule: Optional[pulumi.Input['FsuCycleStageActionScheduleArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_finished: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_details: Optional[pulumi.Input['FsuCycleUpgradeDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering FsuCycle resources.
        :param pulumi.Input['FsuCycleApplyActionScheduleArgs'] apply_action_schedule: Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        :param pulumi.Input['FsuCycleBatchingStrategyArgs'] batching_strategy: (Updatable) Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        :param pulumi.Input[_builtins.str] collection_type: Type of Exadata Fleet Update collection being upgraded.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['FsuCycleDiagnosticsCollectionArgs'] diagnostics_collection: (Updatable) Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Fleet Update Cycle.
        :param pulumi.Input[_builtins.str] executing_fsu_action_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Action that is currently in progress, if applicable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] fsu_collection_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Collection which will be updated by the Exadata Fleet Update Cycle being created.
        :param pulumi.Input['FsuCycleGoalVersionDetailsArgs'] goal_version_details: (Updatable) Goal version or image details for the Exadata Fleet Update Cycle.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] is_ignore_missing_patches: (Updatable) List of identifiers of patches to ignore. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        :param pulumi.Input[_builtins.bool] is_ignore_patches: (Updatable) Ignore patch conflicts or missing patches between the source and goal homes. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        :param pulumi.Input[_builtins.bool] is_keep_placement: (Updatable) Ensure that database services are online on the same VMs before and after the maintenance update.
        :param pulumi.Input[_builtins.str] last_completed_action: The latest Action type that was completed in the Exadata Fleet Update Cycle. No value would indicate that the Cycle has not completed any Action yet.
        :param pulumi.Input[_builtins.str] last_completed_action_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the latest Action  in the Exadata Fleet Update Cycle.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.int] max_drain_timeout_in_seconds: (Updatable) Timeout for session draining for database services specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input['FsuCycleNextActionToExecuteArgs']]] next_action_to_executes: All possible Exadata Fleet Update Actions will be listed. The first element is the suggested Exadata Fleet Update Action.
        :param pulumi.Input[_builtins.str] rollback_cycle_state: Current rollback cycle state if rollback maintenance cycle action has been attempted. No value would indicate that the Cycle has not run a rollback maintenance cycle action before.
        :param pulumi.Input['FsuCycleStageActionScheduleArgs'] stage_action_schedule: Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        :param pulumi.Input[_builtins.str] state: The current state of the Exadata Fleet Update Cycle.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Exadata Fleet Update Cycle was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param pulumi.Input[_builtins.str] time_finished: The date and time the Exadata Fleet Update Cycle was finished, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Exadata Fleet Update Cycle was updated, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param pulumi.Input[_builtins.str] type: (Updatable) Type of Exadata Fleet Update Cycle.
        :param pulumi.Input['FsuCycleUpgradeDetailsArgs'] upgrade_details: (Updatable) Details of supported upgrade options for DB or GI collection.
        """
        if apply_action_schedule is not None:
            pulumi.set(__self__, "apply_action_schedule", apply_action_schedule)
        if batching_strategy is not None:
            pulumi.set(__self__, "batching_strategy", batching_strategy)
        if collection_type is not None:
            pulumi.set(__self__, "collection_type", collection_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if diagnostics_collection is not None:
            pulumi.set(__self__, "diagnostics_collection", diagnostics_collection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if executing_fsu_action_id is not None:
            pulumi.set(__self__, "executing_fsu_action_id", executing_fsu_action_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if fsu_collection_id is not None:
            pulumi.set(__self__, "fsu_collection_id", fsu_collection_id)
        if goal_version_details is not None:
            pulumi.set(__self__, "goal_version_details", goal_version_details)
        if is_ignore_missing_patches is not None:
            pulumi.set(__self__, "is_ignore_missing_patches", is_ignore_missing_patches)
        if is_ignore_patches is not None:
            pulumi.set(__self__, "is_ignore_patches", is_ignore_patches)
        if is_keep_placement is not None:
            pulumi.set(__self__, "is_keep_placement", is_keep_placement)
        if last_completed_action is not None:
            pulumi.set(__self__, "last_completed_action", last_completed_action)
        if last_completed_action_id is not None:
            pulumi.set(__self__, "last_completed_action_id", last_completed_action_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_drain_timeout_in_seconds is not None:
            pulumi.set(__self__, "max_drain_timeout_in_seconds", max_drain_timeout_in_seconds)
        if next_action_to_executes is not None:
            pulumi.set(__self__, "next_action_to_executes", next_action_to_executes)
        if rollback_cycle_state is not None:
            pulumi.set(__self__, "rollback_cycle_state", rollback_cycle_state)
        if stage_action_schedule is not None:
            pulumi.set(__self__, "stage_action_schedule", stage_action_schedule)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_finished is not None:
            pulumi.set(__self__, "time_finished", time_finished)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if upgrade_details is not None:
            pulumi.set(__self__, "upgrade_details", upgrade_details)

    @_builtins.property
    @pulumi.getter(name="applyActionSchedule")
    def apply_action_schedule(self) -> Optional[pulumi.Input['FsuCycleApplyActionScheduleArgs']]:
        """
        Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "apply_action_schedule")

    @apply_action_schedule.setter
    def apply_action_schedule(self, value: Optional[pulumi.Input['FsuCycleApplyActionScheduleArgs']]):
        pulumi.set(self, "apply_action_schedule", value)

    @_builtins.property
    @pulumi.getter(name="batchingStrategy")
    def batching_strategy(self) -> Optional[pulumi.Input['FsuCycleBatchingStrategyArgs']]:
        """
        (Updatable) Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        """
        return pulumi.get(self, "batching_strategy")

    @batching_strategy.setter
    def batching_strategy(self, value: Optional[pulumi.Input['FsuCycleBatchingStrategyArgs']]):
        pulumi.set(self, "batching_strategy", value)

    @_builtins.property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of Exadata Fleet Update collection being upgraded.
        """
        return pulumi.get(self, "collection_type")

    @collection_type.setter
    def collection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collection_type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticsCollection")
    def diagnostics_collection(self) -> Optional[pulumi.Input['FsuCycleDiagnosticsCollectionArgs']]:
        """
        (Updatable) Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        """
        return pulumi.get(self, "diagnostics_collection")

    @diagnostics_collection.setter
    def diagnostics_collection(self, value: Optional[pulumi.Input['FsuCycleDiagnosticsCollectionArgs']]):
        pulumi.set(self, "diagnostics_collection", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The user-friendly name for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="executingFsuActionId")
    def executing_fsu_action_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Action that is currently in progress, if applicable.
        """
        return pulumi.get(self, "executing_fsu_action_id")

    @executing_fsu_action_id.setter
    def executing_fsu_action_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "executing_fsu_action_id", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="fsuCollectionId")
    def fsu_collection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Collection which will be updated by the Exadata Fleet Update Cycle being created.
        """
        return pulumi.get(self, "fsu_collection_id")

    @fsu_collection_id.setter
    def fsu_collection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fsu_collection_id", value)

    @_builtins.property
    @pulumi.getter(name="goalVersionDetails")
    def goal_version_details(self) -> Optional[pulumi.Input['FsuCycleGoalVersionDetailsArgs']]:
        """
        (Updatable) Goal version or image details for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "goal_version_details")

    @goal_version_details.setter
    def goal_version_details(self, value: Optional[pulumi.Input['FsuCycleGoalVersionDetailsArgs']]):
        pulumi.set(self, "goal_version_details", value)

    @_builtins.property
    @pulumi.getter(name="isIgnoreMissingPatches")
    def is_ignore_missing_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of identifiers of patches to ignore. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        """
        return pulumi.get(self, "is_ignore_missing_patches")

    @is_ignore_missing_patches.setter
    def is_ignore_missing_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "is_ignore_missing_patches", value)

    @_builtins.property
    @pulumi.getter(name="isIgnorePatches")
    def is_ignore_patches(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Ignore patch conflicts or missing patches between the source and goal homes. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        """
        return pulumi.get(self, "is_ignore_patches")

    @is_ignore_patches.setter
    def is_ignore_patches(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ignore_patches", value)

    @_builtins.property
    @pulumi.getter(name="isKeepPlacement")
    def is_keep_placement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Ensure that database services are online on the same VMs before and after the maintenance update.
        """
        return pulumi.get(self, "is_keep_placement")

    @is_keep_placement.setter
    def is_keep_placement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_keep_placement", value)

    @_builtins.property
    @pulumi.getter(name="lastCompletedAction")
    def last_completed_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest Action type that was completed in the Exadata Fleet Update Cycle. No value would indicate that the Cycle has not completed any Action yet.
        """
        return pulumi.get(self, "last_completed_action")

    @last_completed_action.setter
    def last_completed_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_completed_action", value)

    @_builtins.property
    @pulumi.getter(name="lastCompletedActionId")
    def last_completed_action_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the latest Action  in the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "last_completed_action_id")

    @last_completed_action_id.setter
    def last_completed_action_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_completed_action_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="maxDrainTimeoutInSeconds")
    def max_drain_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Timeout for session draining for database services specified in seconds.
        """
        return pulumi.get(self, "max_drain_timeout_in_seconds")

    @max_drain_timeout_in_seconds.setter
    def max_drain_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_drain_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="nextActionToExecutes")
    def next_action_to_executes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FsuCycleNextActionToExecuteArgs']]]]:
        """
        All possible Exadata Fleet Update Actions will be listed. The first element is the suggested Exadata Fleet Update Action.
        """
        return pulumi.get(self, "next_action_to_executes")

    @next_action_to_executes.setter
    def next_action_to_executes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FsuCycleNextActionToExecuteArgs']]]]):
        pulumi.set(self, "next_action_to_executes", value)

    @_builtins.property
    @pulumi.getter(name="rollbackCycleState")
    def rollback_cycle_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current rollback cycle state if rollback maintenance cycle action has been attempted. No value would indicate that the Cycle has not run a rollback maintenance cycle action before.
        """
        return pulumi.get(self, "rollback_cycle_state")

    @rollback_cycle_state.setter
    def rollback_cycle_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rollback_cycle_state", value)

    @_builtins.property
    @pulumi.getter(name="stageActionSchedule")
    def stage_action_schedule(self) -> Optional[pulumi.Input['FsuCycleStageActionScheduleArgs']]:
        """
        Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "stage_action_schedule")

    @stage_action_schedule.setter
    def stage_action_schedule(self, value: Optional[pulumi.Input['FsuCycleStageActionScheduleArgs']]):
        pulumi.set(self, "stage_action_schedule", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Exadata Fleet Update Cycle was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Exadata Fleet Update Cycle was finished, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_finished", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Exadata Fleet Update Cycle was updated, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> Optional[pulumi.Input['FsuCycleUpgradeDetailsArgs']]:
        """
        (Updatable) Details of supported upgrade options for DB or GI collection.
        """
        return pulumi.get(self, "upgrade_details")

    @upgrade_details.setter
    def upgrade_details(self, value: Optional[pulumi.Input['FsuCycleUpgradeDetailsArgs']]):
        pulumi.set(self, "upgrade_details", value)


@pulumi.type_token("oci:FleetSoftwareUpdate/fsuCycle:FsuCycle")
class FsuCycle(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_action_schedule: Optional[pulumi.Input[Union['FsuCycleApplyActionScheduleArgs', 'FsuCycleApplyActionScheduleArgsDict']]] = None,
                 batching_strategy: Optional[pulumi.Input[Union['FsuCycleBatchingStrategyArgs', 'FsuCycleBatchingStrategyArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 diagnostics_collection: Optional[pulumi.Input[Union['FsuCycleDiagnosticsCollectionArgs', 'FsuCycleDiagnosticsCollectionArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fsu_collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 goal_version_details: Optional[pulumi.Input[Union['FsuCycleGoalVersionDetailsArgs', 'FsuCycleGoalVersionDetailsArgsDict']]] = None,
                 is_ignore_missing_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_ignore_patches: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_keep_placement: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_drain_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 stage_action_schedule: Optional[pulumi.Input[Union['FsuCycleStageActionScheduleArgs', 'FsuCycleStageActionScheduleArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_details: Optional[pulumi.Input[Union['FsuCycleUpgradeDetailsArgs', 'FsuCycleUpgradeDetailsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fsu_cycle = oci.fleetsoftwareupdate.FsuCycle("test_fsu_cycle",
            compartment_id=compartment_id,
            fsu_collection_id=test_fsu_collection["id"],
            goal_version_details={
                "type": fsu_cycle_goal_version_details_type,
                "components": [{
                    "component_type": fsu_cycle_goal_version_details_components_component_type,
                    "goal_version_details": {
                        "goal_software_image_id": test_image["id"],
                        "goal_type": fsu_cycle_goal_version_details_components_goal_version_details_goal_type,
                        "goal_version": fsu_cycle_goal_version_details_components_goal_version_details_goal_version,
                    },
                    "home_policy": fsu_cycle_goal_version_details_components_home_policy,
                    "new_home_prefix": fsu_cycle_goal_version_details_components_new_home_prefix,
                }],
                "home_policy": fsu_cycle_goal_version_details_home_policy,
                "new_home_prefix": fsu_cycle_goal_version_details_new_home_prefix,
                "software_image_id": test_image["id"],
                "version": fsu_cycle_goal_version_details_version,
            },
            type=fsu_cycle_type,
            apply_action_schedule={
                "time_to_start": fsu_cycle_apply_action_schedule_time_to_start,
                "type": fsu_cycle_apply_action_schedule_type,
            },
            batching_strategy={
                "is_force_rolling": fsu_cycle_batching_strategy_is_force_rolling,
                "is_wait_for_batch_resume": fsu_cycle_batching_strategy_is_wait_for_batch_resume,
                "percentage": fsu_cycle_batching_strategy_percentage,
                "type": fsu_cycle_batching_strategy_type,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            diagnostics_collection={
                "log_collection_mode": fsu_cycle_diagnostics_collection_log_collection_mode,
            },
            display_name=fsu_cycle_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            is_ignore_missing_patches=fsu_cycle_is_ignore_missing_patches,
            is_ignore_patches=fsu_cycle_is_ignore_patches,
            is_keep_placement=fsu_cycle_is_keep_placement,
            max_drain_timeout_in_seconds=fsu_cycle_max_drain_timeout_in_seconds,
            stage_action_schedule={
                "time_to_start": fsu_cycle_stage_action_schedule_time_to_start,
                "type": fsu_cycle_stage_action_schedule_type,
            },
            upgrade_details={
                "collection_type": fsu_cycle_upgrade_details_collection_type,
                "is_ignore_post_upgrade_errors": fsu_cycle_upgrade_details_is_ignore_post_upgrade_errors,
                "is_ignore_prerequisites": fsu_cycle_upgrade_details_is_ignore_prerequisites,
                "is_recompile_invalid_objects": fsu_cycle_upgrade_details_is_recompile_invalid_objects,
                "is_time_zone_upgrade": fsu_cycle_upgrade_details_is_time_zone_upgrade,
                "max_drain_timeout_in_seconds": fsu_cycle_upgrade_details_max_drain_timeout_in_seconds,
            })
        ```

        ## Import

        FsuCycles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetSoftwareUpdate/fsuCycle:FsuCycle test_fsu_cycle "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FsuCycleApplyActionScheduleArgs', 'FsuCycleApplyActionScheduleArgsDict']] apply_action_schedule: Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        :param pulumi.Input[Union['FsuCycleBatchingStrategyArgs', 'FsuCycleBatchingStrategyArgsDict']] batching_strategy: (Updatable) Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Union['FsuCycleDiagnosticsCollectionArgs', 'FsuCycleDiagnosticsCollectionArgsDict']] diagnostics_collection: (Updatable) Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Fleet Update Cycle.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] fsu_collection_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Collection which will be updated by the Exadata Fleet Update Cycle being created.
        :param pulumi.Input[Union['FsuCycleGoalVersionDetailsArgs', 'FsuCycleGoalVersionDetailsArgsDict']] goal_version_details: (Updatable) Goal version or image details for the Exadata Fleet Update Cycle.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] is_ignore_missing_patches: (Updatable) List of identifiers of patches to ignore. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        :param pulumi.Input[_builtins.bool] is_ignore_patches: (Updatable) Ignore patch conflicts or missing patches between the source and goal homes. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        :param pulumi.Input[_builtins.bool] is_keep_placement: (Updatable) Ensure that database services are online on the same VMs before and after the maintenance update.
        :param pulumi.Input[_builtins.int] max_drain_timeout_in_seconds: (Updatable) Timeout for session draining for database services specified in seconds.
        :param pulumi.Input[Union['FsuCycleStageActionScheduleArgs', 'FsuCycleStageActionScheduleArgsDict']] stage_action_schedule: Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        :param pulumi.Input[_builtins.str] type: (Updatable) Type of Exadata Fleet Update Cycle.
        :param pulumi.Input[Union['FsuCycleUpgradeDetailsArgs', 'FsuCycleUpgradeDetailsArgsDict']] upgrade_details: (Updatable) Details of supported upgrade options for DB or GI collection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FsuCycleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fsu_cycle = oci.fleetsoftwareupdate.FsuCycle("test_fsu_cycle",
            compartment_id=compartment_id,
            fsu_collection_id=test_fsu_collection["id"],
            goal_version_details={
                "type": fsu_cycle_goal_version_details_type,
                "components": [{
                    "component_type": fsu_cycle_goal_version_details_components_component_type,
                    "goal_version_details": {
                        "goal_software_image_id": test_image["id"],
                        "goal_type": fsu_cycle_goal_version_details_components_goal_version_details_goal_type,
                        "goal_version": fsu_cycle_goal_version_details_components_goal_version_details_goal_version,
                    },
                    "home_policy": fsu_cycle_goal_version_details_components_home_policy,
                    "new_home_prefix": fsu_cycle_goal_version_details_components_new_home_prefix,
                }],
                "home_policy": fsu_cycle_goal_version_details_home_policy,
                "new_home_prefix": fsu_cycle_goal_version_details_new_home_prefix,
                "software_image_id": test_image["id"],
                "version": fsu_cycle_goal_version_details_version,
            },
            type=fsu_cycle_type,
            apply_action_schedule={
                "time_to_start": fsu_cycle_apply_action_schedule_time_to_start,
                "type": fsu_cycle_apply_action_schedule_type,
            },
            batching_strategy={
                "is_force_rolling": fsu_cycle_batching_strategy_is_force_rolling,
                "is_wait_for_batch_resume": fsu_cycle_batching_strategy_is_wait_for_batch_resume,
                "percentage": fsu_cycle_batching_strategy_percentage,
                "type": fsu_cycle_batching_strategy_type,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            diagnostics_collection={
                "log_collection_mode": fsu_cycle_diagnostics_collection_log_collection_mode,
            },
            display_name=fsu_cycle_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            is_ignore_missing_patches=fsu_cycle_is_ignore_missing_patches,
            is_ignore_patches=fsu_cycle_is_ignore_patches,
            is_keep_placement=fsu_cycle_is_keep_placement,
            max_drain_timeout_in_seconds=fsu_cycle_max_drain_timeout_in_seconds,
            stage_action_schedule={
                "time_to_start": fsu_cycle_stage_action_schedule_time_to_start,
                "type": fsu_cycle_stage_action_schedule_type,
            },
            upgrade_details={
                "collection_type": fsu_cycle_upgrade_details_collection_type,
                "is_ignore_post_upgrade_errors": fsu_cycle_upgrade_details_is_ignore_post_upgrade_errors,
                "is_ignore_prerequisites": fsu_cycle_upgrade_details_is_ignore_prerequisites,
                "is_recompile_invalid_objects": fsu_cycle_upgrade_details_is_recompile_invalid_objects,
                "is_time_zone_upgrade": fsu_cycle_upgrade_details_is_time_zone_upgrade,
                "max_drain_timeout_in_seconds": fsu_cycle_upgrade_details_max_drain_timeout_in_seconds,
            })
        ```

        ## Import

        FsuCycles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetSoftwareUpdate/fsuCycle:FsuCycle test_fsu_cycle "id"
        ```

        :param str resource_name: The name of the resource.
        :param FsuCycleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FsuCycleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_action_schedule: Optional[pulumi.Input[Union['FsuCycleApplyActionScheduleArgs', 'FsuCycleApplyActionScheduleArgsDict']]] = None,
                 batching_strategy: Optional[pulumi.Input[Union['FsuCycleBatchingStrategyArgs', 'FsuCycleBatchingStrategyArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 diagnostics_collection: Optional[pulumi.Input[Union['FsuCycleDiagnosticsCollectionArgs', 'FsuCycleDiagnosticsCollectionArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fsu_collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 goal_version_details: Optional[pulumi.Input[Union['FsuCycleGoalVersionDetailsArgs', 'FsuCycleGoalVersionDetailsArgsDict']]] = None,
                 is_ignore_missing_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_ignore_patches: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_keep_placement: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_drain_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 stage_action_schedule: Optional[pulumi.Input[Union['FsuCycleStageActionScheduleArgs', 'FsuCycleStageActionScheduleArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_details: Optional[pulumi.Input[Union['FsuCycleUpgradeDetailsArgs', 'FsuCycleUpgradeDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FsuCycleArgs.__new__(FsuCycleArgs)

            __props__.__dict__["apply_action_schedule"] = apply_action_schedule
            __props__.__dict__["batching_strategy"] = batching_strategy
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["diagnostics_collection"] = diagnostics_collection
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if fsu_collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'fsu_collection_id'")
            __props__.__dict__["fsu_collection_id"] = fsu_collection_id
            if goal_version_details is None and not opts.urn:
                raise TypeError("Missing required property 'goal_version_details'")
            __props__.__dict__["goal_version_details"] = goal_version_details
            __props__.__dict__["is_ignore_missing_patches"] = is_ignore_missing_patches
            __props__.__dict__["is_ignore_patches"] = is_ignore_patches
            __props__.__dict__["is_keep_placement"] = is_keep_placement
            __props__.__dict__["max_drain_timeout_in_seconds"] = max_drain_timeout_in_seconds
            __props__.__dict__["stage_action_schedule"] = stage_action_schedule
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["upgrade_details"] = upgrade_details
            __props__.__dict__["collection_type"] = None
            __props__.__dict__["executing_fsu_action_id"] = None
            __props__.__dict__["last_completed_action"] = None
            __props__.__dict__["last_completed_action_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["next_action_to_executes"] = None
            __props__.__dict__["rollback_cycle_state"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_updated"] = None
        super(FsuCycle, __self__).__init__(
            'oci:FleetSoftwareUpdate/fsuCycle:FsuCycle',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_action_schedule: Optional[pulumi.Input[Union['FsuCycleApplyActionScheduleArgs', 'FsuCycleApplyActionScheduleArgsDict']]] = None,
            batching_strategy: Optional[pulumi.Input[Union['FsuCycleBatchingStrategyArgs', 'FsuCycleBatchingStrategyArgsDict']]] = None,
            collection_type: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            diagnostics_collection: Optional[pulumi.Input[Union['FsuCycleDiagnosticsCollectionArgs', 'FsuCycleDiagnosticsCollectionArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            executing_fsu_action_id: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            fsu_collection_id: Optional[pulumi.Input[_builtins.str]] = None,
            goal_version_details: Optional[pulumi.Input[Union['FsuCycleGoalVersionDetailsArgs', 'FsuCycleGoalVersionDetailsArgsDict']]] = None,
            is_ignore_missing_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_ignore_patches: Optional[pulumi.Input[_builtins.bool]] = None,
            is_keep_placement: Optional[pulumi.Input[_builtins.bool]] = None,
            last_completed_action: Optional[pulumi.Input[_builtins.str]] = None,
            last_completed_action_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            max_drain_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            next_action_to_executes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FsuCycleNextActionToExecuteArgs', 'FsuCycleNextActionToExecuteArgsDict']]]]] = None,
            rollback_cycle_state: Optional[pulumi.Input[_builtins.str]] = None,
            stage_action_schedule: Optional[pulumi.Input[Union['FsuCycleStageActionScheduleArgs', 'FsuCycleStageActionScheduleArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_finished: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_details: Optional[pulumi.Input[Union['FsuCycleUpgradeDetailsArgs', 'FsuCycleUpgradeDetailsArgsDict']]] = None) -> 'FsuCycle':
        """
        Get an existing FsuCycle resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FsuCycleApplyActionScheduleArgs', 'FsuCycleApplyActionScheduleArgsDict']] apply_action_schedule: Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        :param pulumi.Input[Union['FsuCycleBatchingStrategyArgs', 'FsuCycleBatchingStrategyArgsDict']] batching_strategy: (Updatable) Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        :param pulumi.Input[_builtins.str] collection_type: Type of Exadata Fleet Update collection being upgraded.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Union['FsuCycleDiagnosticsCollectionArgs', 'FsuCycleDiagnosticsCollectionArgsDict']] diagnostics_collection: (Updatable) Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Fleet Update Cycle.
        :param pulumi.Input[_builtins.str] executing_fsu_action_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Action that is currently in progress, if applicable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] fsu_collection_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Collection which will be updated by the Exadata Fleet Update Cycle being created.
        :param pulumi.Input[Union['FsuCycleGoalVersionDetailsArgs', 'FsuCycleGoalVersionDetailsArgsDict']] goal_version_details: (Updatable) Goal version or image details for the Exadata Fleet Update Cycle.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] is_ignore_missing_patches: (Updatable) List of identifiers of patches to ignore. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        :param pulumi.Input[_builtins.bool] is_ignore_patches: (Updatable) Ignore patch conflicts or missing patches between the source and goal homes. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        :param pulumi.Input[_builtins.bool] is_keep_placement: (Updatable) Ensure that database services are online on the same VMs before and after the maintenance update.
        :param pulumi.Input[_builtins.str] last_completed_action: The latest Action type that was completed in the Exadata Fleet Update Cycle. No value would indicate that the Cycle has not completed any Action yet.
        :param pulumi.Input[_builtins.str] last_completed_action_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the latest Action  in the Exadata Fleet Update Cycle.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.int] max_drain_timeout_in_seconds: (Updatable) Timeout for session draining for database services specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FsuCycleNextActionToExecuteArgs', 'FsuCycleNextActionToExecuteArgsDict']]]] next_action_to_executes: All possible Exadata Fleet Update Actions will be listed. The first element is the suggested Exadata Fleet Update Action.
        :param pulumi.Input[_builtins.str] rollback_cycle_state: Current rollback cycle state if rollback maintenance cycle action has been attempted. No value would indicate that the Cycle has not run a rollback maintenance cycle action before.
        :param pulumi.Input[Union['FsuCycleStageActionScheduleArgs', 'FsuCycleStageActionScheduleArgsDict']] stage_action_schedule: Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        :param pulumi.Input[_builtins.str] state: The current state of the Exadata Fleet Update Cycle.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Exadata Fleet Update Cycle was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param pulumi.Input[_builtins.str] time_finished: The date and time the Exadata Fleet Update Cycle was finished, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Exadata Fleet Update Cycle was updated, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param pulumi.Input[_builtins.str] type: (Updatable) Type of Exadata Fleet Update Cycle.
        :param pulumi.Input[Union['FsuCycleUpgradeDetailsArgs', 'FsuCycleUpgradeDetailsArgsDict']] upgrade_details: (Updatable) Details of supported upgrade options for DB or GI collection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FsuCycleState.__new__(_FsuCycleState)

        __props__.__dict__["apply_action_schedule"] = apply_action_schedule
        __props__.__dict__["batching_strategy"] = batching_strategy
        __props__.__dict__["collection_type"] = collection_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["diagnostics_collection"] = diagnostics_collection
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["executing_fsu_action_id"] = executing_fsu_action_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["fsu_collection_id"] = fsu_collection_id
        __props__.__dict__["goal_version_details"] = goal_version_details
        __props__.__dict__["is_ignore_missing_patches"] = is_ignore_missing_patches
        __props__.__dict__["is_ignore_patches"] = is_ignore_patches
        __props__.__dict__["is_keep_placement"] = is_keep_placement
        __props__.__dict__["last_completed_action"] = last_completed_action
        __props__.__dict__["last_completed_action_id"] = last_completed_action_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["max_drain_timeout_in_seconds"] = max_drain_timeout_in_seconds
        __props__.__dict__["next_action_to_executes"] = next_action_to_executes
        __props__.__dict__["rollback_cycle_state"] = rollback_cycle_state
        __props__.__dict__["stage_action_schedule"] = stage_action_schedule
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["upgrade_details"] = upgrade_details
        return FsuCycle(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applyActionSchedule")
    def apply_action_schedule(self) -> pulumi.Output['outputs.FsuCycleApplyActionSchedule']:
        """
        Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "apply_action_schedule")

    @_builtins.property
    @pulumi.getter(name="batchingStrategy")
    def batching_strategy(self) -> pulumi.Output['outputs.FsuCycleBatchingStrategy']:
        """
        (Updatable) Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        """
        return pulumi.get(self, "batching_strategy")

    @_builtins.property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of Exadata Fleet Update collection being upgraded.
        """
        return pulumi.get(self, "collection_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="diagnosticsCollection")
    def diagnostics_collection(self) -> pulumi.Output['outputs.FsuCycleDiagnosticsCollection']:
        """
        (Updatable) Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        """
        return pulumi.get(self, "diagnostics_collection")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The user-friendly name for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="executingFsuActionId")
    def executing_fsu_action_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Action that is currently in progress, if applicable.
        """
        return pulumi.get(self, "executing_fsu_action_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="fsuCollectionId")
    def fsu_collection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Collection which will be updated by the Exadata Fleet Update Cycle being created.
        """
        return pulumi.get(self, "fsu_collection_id")

    @_builtins.property
    @pulumi.getter(name="goalVersionDetails")
    def goal_version_details(self) -> pulumi.Output['outputs.FsuCycleGoalVersionDetails']:
        """
        (Updatable) Goal version or image details for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "goal_version_details")

    @_builtins.property
    @pulumi.getter(name="isIgnoreMissingPatches")
    def is_ignore_missing_patches(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of identifiers of patches to ignore. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        """
        return pulumi.get(self, "is_ignore_missing_patches")

    @_builtins.property
    @pulumi.getter(name="isIgnorePatches")
    def is_ignore_patches(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Ignore patch conflicts or missing patches between the source and goal homes. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        """
        return pulumi.get(self, "is_ignore_patches")

    @_builtins.property
    @pulumi.getter(name="isKeepPlacement")
    def is_keep_placement(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Ensure that database services are online on the same VMs before and after the maintenance update.
        """
        return pulumi.get(self, "is_keep_placement")

    @_builtins.property
    @pulumi.getter(name="lastCompletedAction")
    def last_completed_action(self) -> pulumi.Output[_builtins.str]:
        """
        The latest Action type that was completed in the Exadata Fleet Update Cycle. No value would indicate that the Cycle has not completed any Action yet.
        """
        return pulumi.get(self, "last_completed_action")

    @_builtins.property
    @pulumi.getter(name="lastCompletedActionId")
    def last_completed_action_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the latest Action  in the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "last_completed_action_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maxDrainTimeoutInSeconds")
    def max_drain_timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Timeout for session draining for database services specified in seconds.
        """
        return pulumi.get(self, "max_drain_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="nextActionToExecutes")
    def next_action_to_executes(self) -> pulumi.Output[Sequence['outputs.FsuCycleNextActionToExecute']]:
        """
        All possible Exadata Fleet Update Actions will be listed. The first element is the suggested Exadata Fleet Update Action.
        """
        return pulumi.get(self, "next_action_to_executes")

    @_builtins.property
    @pulumi.getter(name="rollbackCycleState")
    def rollback_cycle_state(self) -> pulumi.Output[_builtins.str]:
        """
        Current rollback cycle state if rollback maintenance cycle action has been attempted. No value would indicate that the Cycle has not run a rollback maintenance cycle action before.
        """
        return pulumi.get(self, "rollback_cycle_state")

    @_builtins.property
    @pulumi.getter(name="stageActionSchedule")
    def stage_action_schedule(self) -> pulumi.Output['outputs.FsuCycleStageActionSchedule']:
        """
        Scheduling related details for the Exadata Fleet Update Action during create operations. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails for Stage and Apply Actions in Exadata Fleet Update Cycle creation would not create Actions. Null scheduleDetails for CreateAction would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "stage_action_schedule")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Exadata Fleet Update Cycle was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Exadata Fleet Update Cycle was finished, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Exadata Fleet Update Cycle was updated, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> pulumi.Output['outputs.FsuCycleUpgradeDetails']:
        """
        (Updatable) Details of supported upgrade options for DB or GI collection.
        """
        return pulumi.get(self, "upgrade_details")

